/*
 * Decompiled with CFR 0.152.
 */
package eu.hoefel.chemistry;

import eu.hoefel.chemistry.Element;
import eu.hoefel.chemistry.Isotope;
import eu.hoefel.chemistry.Nuclide;
import eu.hoefel.utils.IOs;
import eu.hoefel.utils.Maths;
import eu.hoefel.utils.Strings;
import java.io.File;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class IsotopeUpdater {
    private static final Pattern NEW_ELEMENT_PATTERN = Pattern.compile("\\d+\\s+\\w+\\s+\\d+\\s+\\d+\\.\\d+.*");
    private static final Pattern NEW_ELEMENT_NUMBER = Pattern.compile("(\\d+)(?=\\s+\\w+\\s+\\d+\\s+\\d+\\.\\d+.*)");
    private static final Pattern NEW_NAME = Pattern.compile("(\\w+)(?=\\s+\\d+\\s+\\d+\\.\\d+.*)");
    private static final Pattern NEW_ISOTOPE = Pattern.compile("(\\d+)(?=\\s+\\d+\\.\\d+.*)");
    private static final Pattern NEW_ISOTOPE_MASS = Pattern.compile("(\\d+.\\d+)(?=\\(\\d+#*\\))");
    private static final Pattern NEW_NAME_PATTERN = Pattern.compile("\\w+\\s+\\d+\\s+\\d+\\.\\d+.*");
    private static final Pattern NEW_ISOTOPE_PATTERN = Pattern.compile("\\d+\\s+\\d+\\.\\d+.*");
    private static final String LB = "\n";

    IsotopeUpdater() {
    }

    public static void main(String[] args) {
        IsotopeUpdater.createIsotopeClasses(IOs.getStringFromResources((String)"/isotope_2019_11_26.txt", IsotopeUpdater.class), new File("src/main/java/" + IsotopeUpdater.class.getPackage().getName()).getAbsolutePath().replace(".", "/") + "/");
    }

    private static void createIsotopeClasses(String input, String targetFolder) {
        String[] lines = input.split("\r\n|\n");
        Map<Integer, Map<String, Map<Integer, Double>>> data = IsotopeUpdater.parseData(lines);
        IOs.writeToFile((File)new File(targetFolder + "Isotope.java"), (String)IsotopeUpdater.constructIsotope(data));
        IOs.writeToFile((File)new File(targetFolder + "Isotopes.java"), (String)IsotopeUpdater.constructIsotopeUtils(data));
    }

    private static String constructIsotope(Map<Integer, Map<String, Map<Integer, Double>>> data) {
        StringBuilder sb = new StringBuilder();
        sb.append("package " + IsotopeUpdater.class.getPackage().getName() + ";\n");
        sb.append(LB);
        if (!Element.class.getPackage().getName().equals(IsotopeUpdater.class.getPackage().getName())) {
            sb.append("import " + Element.class.getPackage().getName() + "." + Element.class.getSimpleName() + ";\n");
            sb.append(LB);
        }
        sb.append(String.format(Locale.ENGLISH, "import java.util.ArrayList;\nimport java.util.List;\nimport java.util.Set;\n\n/**\n * All known isotopes.\n * Based on <a href=\"https://www.nist.gov/pml/atomic-weights-and-isotopic-compositions-relative-atomic-masses\">NIST data</a>.\n *\n * @see %s\n * @see %s\n */\npublic sealed interface Isotope extends %s {\n", Element.class.getSimpleName(), Nuclide.class.getSimpleName(), Nuclide.class.getSimpleName()));
        EnumSet<Element> elements = EnumSet.noneOf(Element.class);
        for (Map.Entry<Integer, Map<String, Map<Integer, Double>>> entry : data.entrySet()) {
            Element elem = Element.withAtomicNumber(entry.getKey());
            elements.add(elem);
            for (Map.Entry<String, Map<Integer, Double>> innerEntry : entry.getValue().entrySet()) {
                if (!elem.name().equalsIgnoreCase(innerEntry.getKey())) continue;
                sb.append(LB);
                sb.append("    /** " + Strings.capitalize((String)elem.fullName()) + " (cf. {@link " + Element.class.getSimpleName() + "#" + elem.name() + "}) isotopes. */\n");
                sb.append("    public enum " + elem.name() + " implements Isotope {\n");
                double minStandardIsotopes = Double.MAX_VALUE;
                double maxStandardIsotopes = Double.MIN_VALUE;
                for (Map.Entry<String, Map<Integer, Double>> entry2 : entry.getValue().entrySet()) {
                    if (!elem.name().equalsIgnoreCase(entry2.getKey())) continue;
                    for (Map.Entry<Integer, Double> entry3 : entry2.getValue().entrySet()) {
                        minStandardIsotopes = Math.min(minStandardIsotopes, (double)entry3.getKey().intValue());
                        maxStandardIsotopes = Math.max(maxStandardIsotopes, (double)entry3.getKey().intValue());
                    }
                }
                for (Map.Entry<String, Map<Integer, Double>> entry4 : entry.getValue().entrySet()) {
                    if (elem.name().equalsIgnoreCase(entry4.getKey())) break;
                    for (Map.Entry<Integer, Double> entry5 : entry4.getValue().entrySet()) {
                        if (!(minStandardIsotopes > entry5.getValue())) continue;
                        sb.append(LB);
                        Object javadoc = "";
                        String name = "";
                        if ("D".equals(entry4.getKey())) {
                            javadoc = "Deuterium";
                            name = "D";
                        } else if ("T".equals(entry4.getKey())) {
                            javadoc = "Tritium";
                            name = "T";
                        } else {
                            javadoc = entry4.getKey() + String.valueOf(entry5.getKey());
                            name = entry5.getKey().toString();
                        }
                        sb.append(String.format(Locale.ENGLISH, "%-24s", "        /** " + (String)javadoc + " */"));
                        if (Maths.isInteger((String)name)) {
                            sb.append(String.format(Locale.ENGLISH, "%5s", elem.name() + name));
                        } else {
                            sb.append(String.format(Locale.ENGLISH, "%5s", name));
                        }
                        sb.append("(");
                        sb.append(String.format(Locale.ENGLISH, "%19.15f", entry5.getValue()));
                        sb.append("),");
                    }
                }
                for (Map.Entry<Object, Object> entry6 : innerEntry.getValue().entrySet()) {
                    sb.append(LB);
                    sb.append(String.format(Locale.ENGLISH, "%-24s", "        /** " + Strings.capitalize((String)elem.fullName()) + " " + String.valueOf(entry6.getKey()) + " */"));
                    sb.append(String.format(Locale.ENGLISH, "%5s", elem.name() + String.valueOf(entry6.getKey())));
                    sb.append("(");
                    sb.append(String.format(Locale.ENGLISH, "%19.15f", entry6.getValue()));
                    sb.append("),");
                }
                for (Map.Entry<Object, Object> entry7 : entry.getValue().entrySet()) {
                    if (elem.name().equalsIgnoreCase((String)entry7.getKey())) continue;
                    for (Map.Entry<Integer, Double> entry8 : ((Map)entry7.getValue()).entrySet()) {
                        if (!(maxStandardIsotopes < entry8.getValue())) continue;
                        sb.append(LB);
                        Object name = "";
                        if ("Uup".equals(entry7.getKey())) {
                            firstLetter = Element.Mc.fullName().substring(0, 1).toUpperCase(Locale.ENGLISH);
                            name = firstLetter + Element.Mc.fullName().substring(1) + " " + String.valueOf(entry8.getKey());
                        } else if ("Uus".equals(entry7.getKey())) {
                            firstLetter = Element.Ts.fullName().substring(0, 1).toUpperCase(Locale.ENGLISH);
                            name = firstLetter + Element.Ts.fullName().substring(1) + " " + String.valueOf(entry8.getKey());
                        } else {
                            name = (String)entry7.getKey() + String.valueOf(entry8.getKey());
                        }
                        sb.append(String.format(Locale.ENGLISH, "%-24s", "        /** " + (String)name + " */"));
                        sb.append(String.format(Locale.ENGLISH, "%5s", elem.name() + String.valueOf(entry8.getKey())));
                        sb.append("(");
                        sb.append(String.format(Locale.ENGLISH, "%19.15f", entry8.getValue()));
                        sb.append("),");
                    }
                }
                sb.append(";");
                sb.append("\n\n        private double atomicMass;\n\n        %s(double avgAtomicMass) { atomicMass = avgAtomicMass; }\n\n        @Override public double mass() { return atomicMass; }\n        @Override public %s element() { return %s.%s; }\n        @Override public Set<Nuclide> nuclides() { return Set.of(this); }\n    }\n".formatted(elem.name(), Element.class.getSimpleName(), Element.class.getSimpleName(), elem.name()));
            }
        }
        sb.append(LB);
        sb.append(String.format(Locale.ENGLISH, "    @Override default boolean isIsotope() { return true; }\n\n    /**\n     * Gets the isotopes for the requested element.\n     *\n     * @param elem the element for which the isotopes are requested\n     * @return the isotopes of elem\n     */\n    public static List<Isotope> ofElement(%s elem) {\n        List<Isotope> correspondingIsotopes = new ArrayList<>();\n        for (Isotope isotope : Isotope.values()) {\n            if (isotope.element() == elem) correspondingIsotopes.add(isotope);\n        }\n        return correspondingIsotopes;\n    }\n\n    /**\n     * Gets all isotopes.\n     *\n     * @return all isotopes\n     */\n    public static Isotope[] values() {\n        return Isotopes.values(); // we know that all elements are enum, so shallow copying should be fine\n    }\n\n    /**\n     * Checks whether an isotope with the given name exists.\n     *\n     * @param name the name, e.g. \"He3\"\n     * @return true if such a named isotope exists\n     */\n    public static boolean isIsotope(String name) {\n        return parseName(name) != null;\n    }\n\n    /**\n     * Gets the isotope from the given name.\n     *\n     * @param name the name, e.g. \"He3\"\n     * @return the corresponding isotope\n     */\n    public static Isotope named(String name) {\n        Isotope isotope = parseName(name);\n\n        if (isotope == null) {\n            throw new IllegalArgumentException(\"Found no isotope named '\" + name + \"'\");\n        }\n\n        return isotope;\n    }\n\n    /**\n     * Parses the given name and returns the matching element, if found.\n     *\n     * @param name the name, e.g. \"He3\"\n     * @return the corresponding isotope or null if no matching isotope has been\n     *         found\n     */\n    public static Isotope parseName(String name) {\n        for (Isotope isotope : values()) {\n            if (isotope.toString().equalsIgnoreCase(name)) {\n                return isotope;\n            }\n        }\n\n        // special cases\n        if (\"deuterium\".equalsIgnoreCase(name)) return H.D;\n        if (\"tritium\".equalsIgnoreCase(name)) return H.T;\n\n        return null;\n    }\n}\n", Element.class.getSimpleName()));
        return sb.toString();
    }

    private static final String constructIsotopeUtils(Map<Integer, Map<String, Map<Integer, Double>>> data) {
        EnumSet<Element> elements = EnumSet.noneOf(Element.class);
        for (Map.Entry<Integer, Map<String, Map<Integer, Double>>> entry : data.entrySet()) {
            Element elem = Element.withAtomicNumber(entry.getKey());
            elements.add(elem);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("package " + IsotopeUpdater.class.getPackage().getName() + ";\n");
        sb.append(LB);
        sb.append("import java.util.stream.Stream;\n");
        sb.append(LB);
        if (!Element.class.getPackage().getName().equals(IsotopeUpdater.class.getPackage().getName())) {
            sb.append("import " + Element.class.getPackage().getName() + "." + Element.class.getSimpleName() + ";\n");
            sb.append(LB);
        }
        for (Element e : elements) {
            sb.append("import " + Element.class.getPackage().getName() + "." + Isotope.class.getSimpleName() + "." + e.name() + ";\n");
        }
        sb.append(LB);
        StringBuilder stringBuilder = new StringBuilder();
        int counter = 1;
        int stringLength = 2;
        for (Element elem : elements) {
            stringBuilder.append(String.format(Locale.ENGLISH, "%" + stringLength + "s.values()", elem.name()) + (counter == elements.size() ? " " : ","));
            if (counter++ % 10 == 0) {
                stringBuilder.append("\n            ");
                stringLength = 2;
                continue;
            }
            stringLength = 3;
        }
        sb.append("/**\n * Utility methods for the {@link Isotope isotopes}.\n *\n * @see %s\n */\nfinal class Isotopes {\n\n    /** Represents all isotopes. */\n    private static final Isotope[] values;\n\n    static {\n        Isotope[][] isotopes = {\n            %s\n        };\n\n        values = Stream.of(isotopes).flatMap(Stream::of).toArray(Isotope[]::new);\n    }\n\n    private Isotopes() {\n        throw new IllegalStateException(\"Utility class\");\n    }\n\n    /**\n     * Gets all isotopes.\n     *\n     * @return all isotopes\n     */\n    public static final Isotope[] values() {\n        return values.clone();\n    }\n".formatted(Isotope.class.getSimpleName(), stringBuilder.toString()));
        sb.append("}");
        return sb.toString();
    }

    private static Map<Integer, Map<String, Map<Integer, Double>>> parseData(String[] lines) {
        LinkedHashMap<Integer, Map<String, Map<Integer, Double>>> data = new LinkedHashMap<Integer, Map<String, Map<Integer, Double>>>();
        int currentElementNumber = 0;
        String currentName = "";
        for (String line : lines) {
            Map nameInfo;
            LinkedHashMap<Integer, Double> isotopeMass;
            Matcher newElementIsotopeAtomicMass;
            Matcher newElementIsotope;
            Matcher newElementName;
            if ((line = line.trim()).isEmpty()) continue;
            Matcher newElement = NEW_ELEMENT_PATTERN.matcher(line);
            Matcher newName = NEW_NAME_PATTERN.matcher(line);
            Matcher newIsotope = NEW_ISOTOPE_PATTERN.matcher(line);
            if (newElement.matches()) {
                Matcher newElementNumber = NEW_ELEMENT_NUMBER.matcher(line);
                newElementNumber.find();
                currentElementNumber = Integer.parseInt(newElementNumber.group());
                newElementName = NEW_NAME.matcher(line);
                newElementName.find();
                currentName = newElementName.group();
                newElementIsotope = NEW_ISOTOPE.matcher(line);
                newElementIsotope.find();
                newElementIsotopeAtomicMass = NEW_ISOTOPE_MASS.matcher(line);
                newElementIsotopeAtomicMass.find();
                isotopeMass = new LinkedHashMap();
                isotopeMass.put(Integer.parseInt(newElementIsotope.group()), Double.parseDouble(newElementIsotopeAtomicMass.group()));
                LinkedHashMap<String, LinkedHashMap<Integer, Double>> nameInfo2 = new LinkedHashMap<String, LinkedHashMap<Integer, Double>>();
                nameInfo2.put(currentName, isotopeMass);
                data.put(currentElementNumber, nameInfo2);
                continue;
            }
            if (newName.matches()) {
                LinkedHashMap copy;
                nameInfo = (Map)data.get(currentElementNumber);
                newElementName = NEW_NAME.matcher(line);
                newElementName.find();
                currentName = newElementName.group();
                newElementIsotope = NEW_ISOTOPE.matcher(line);
                newElementIsotope.find();
                newElementIsotopeAtomicMass = NEW_ISOTOPE_MASS.matcher(line);
                newElementIsotopeAtomicMass.find();
                isotopeMass = new LinkedHashMap<Integer, Double>();
                isotopeMass.put(Integer.parseInt(newElementIsotope.group()), Double.parseDouble(newElementIsotopeAtomicMass.group()));
                if ("D".equals(currentName)) {
                    copy = new LinkedHashMap(nameInfo);
                    nameInfo.clear();
                    nameInfo.put(currentName, isotopeMass);
                    nameInfo.putAll(copy);
                    continue;
                }
                if ("T".equals(currentName)) {
                    copy = new LinkedHashMap(nameInfo);
                    nameInfo.clear();
                    nameInfo.put("D", (Map)copy.get("D"));
                    nameInfo.put(currentName, isotopeMass);
                    nameInfo.put("H", (Map)copy.get("H"));
                    continue;
                }
                nameInfo.put(currentName, isotopeMass);
                continue;
            }
            if (!newIsotope.matches()) continue;
            nameInfo = (Map)data.get(currentElementNumber);
            Map isotopeMass2 = (Map)nameInfo.get(currentName);
            newElementIsotope = NEW_ISOTOPE.matcher(line);
            newElementIsotope.find();
            newElementIsotopeAtomicMass = NEW_ISOTOPE_MASS.matcher(line);
            newElementIsotopeAtomicMass.find();
            isotopeMass2.put(Integer.parseInt(newElementIsotope.group()), Double.parseDouble(newElementIsotopeAtomicMass.group()));
        }
        return data;
    }
}

