/*
 * Decompiled with CFR 0.152.
 */
package eu.hoefel.chemistry;

import eu.hoefel.chemistry.Element;
import eu.hoefel.chemistry.Isotopes;
import eu.hoefel.chemistry.Nuclide;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Isotope
extends Nuclide {
    @Override
    default public boolean isIsotope() {
        return true;
    }

    public static List<Isotope> ofElement(Element elem) {
        ArrayList<Isotope> correspondingIsotopes = new ArrayList<Isotope>();
        for (Isotope isotope : Isotope.values()) {
            if (isotope.element() != elem) continue;
            correspondingIsotopes.add(isotope);
        }
        return correspondingIsotopes;
    }

    public static Isotope[] values() {
        return Isotopes.values();
    }

    public static boolean isIsotope(String name) {
        return Isotope.parseName(name) != null;
    }

    public static Isotope named(String name) {
        Isotope isotope = Isotope.parseName(name);
        if (isotope == null) {
            throw new IllegalArgumentException("Found no isotope named '" + name + "'");
        }
        return isotope;
    }

    public static Isotope parseName(String name) {
        for (Isotope isotope : Isotope.values()) {
            if (!isotope.toString().equalsIgnoreCase(name)) continue;
            return isotope;
        }
        if ("deuterium".equalsIgnoreCase(name)) {
            return H.D;
        }
        if ("tritium".equalsIgnoreCase(name)) {
            return H.T;
        }
        return null;
    }

    public static enum H implements Isotope
    {
        D(2.01410177812),
        T(3.0160492779),
        H4(4.02643),
        H5(5.035311),
        H6(6.04496),
        H7(7.0527);

        private double atomicMass;

        private H(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.H;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Og implements Isotope
    {
        Og293(293.21356),
        Og294(294.21392),
        Og295(295.21624);

        private double atomicMass;

        private Og(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Og;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ts implements Isotope
    {
        Ts291(291.20553),
        Ts292(292.20746),
        Ts293(293.20824),
        Ts294(294.21046);

        private double atomicMass;

        private Ts(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ts;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Lv implements Isotope
    {
        Lv289(289.19816),
        Lv290(290.19864),
        Lv291(291.20108),
        Lv292(292.20174),
        Lv293(293.20449);

        private double atomicMass;

        private Lv(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Lv;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Mc implements Isotope
    {
        Mc287(287.1907),
        Mc288(288.19274),
        Mc289(289.19363),
        Mc290(290.19598),
        Mc291(291.19707);

        private double atomicMass;

        private Mc(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Mc;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Fl implements Isotope
    {
        Fl285(285.18364),
        Fl286(286.18423),
        Fl287(287.18678),
        Fl288(288.18757),
        Fl289(289.19042);

        private double atomicMass;

        private Fl(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Fl;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Nh implements Isotope
    {
        Nh278(278.17058),
        Nh279(279.17095),
        Nh280(280.17293),
        Nh281(281.17348),
        Nh282(282.17567),
        Nh283(283.17657),
        Nh284(284.17873),
        Nh285(285.17973),
        Nh286(286.18221),
        Nh287(287.18339);

        private double atomicMass;

        private Nh(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Nh;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cn implements Isotope
    {
        Cn276(276.16141),
        Cn277(277.16364),
        Cn278(278.16416),
        Cn279(279.16654),
        Cn280(280.16715),
        Cn281(281.16975),
        Cn282(282.1705),
        Cn283(283.17327),
        Cn284(284.17416),
        Cn285(285.17712);

        private double atomicMass;

        private Cn(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cn;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Rg implements Isotope
    {
        Rg272(272.15327),
        Rg273(273.15313),
        Rg274(274.15525),
        Rg275(275.15594),
        Rg276(276.15833),
        Rg277(277.15907),
        Rg278(278.16149),
        Rg279(279.16272),
        Rg280(280.16514),
        Rg281(281.16636),
        Rg282(282.16912),
        Rg283(283.17054);

        private double atomicMass;

        private Rg(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Rg;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ds implements Isotope
    {
        Ds267(267.14377),
        Ds268(268.14348),
        Ds269(269.144752),
        Ds270(270.144584),
        Ds271(271.14595),
        Ds272(272.14602),
        Ds273(273.14856),
        Ds274(274.14941),
        Ds275(275.15203),
        Ds276(276.15303),
        Ds277(277.15591),
        Ds278(278.15704),
        Ds279(279.1601),
        Ds280(280.16131),
        Ds281(281.16451);

        private double atomicMass;

        private Ds(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ds;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Mt implements Isotope
    {
        Mt265(265.136),
        Mt266(266.13737),
        Mt267(267.13719),
        Mt268(268.13865),
        Mt269(269.13882),
        Mt270(270.14033),
        Mt271(271.14074),
        Mt272(272.14341),
        Mt273(273.1444),
        Mt274(274.14724),
        Mt275(275.14882),
        Mt276(276.15159),
        Mt277(277.15327),
        Mt278(278.15631),
        Mt279(279.15808);

        private double atomicMass;

        private Mt(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Mt;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Hs implements Isotope
    {
        Hs263(263.12852),
        Hs264(264.128357),
        Hs265(265.129793),
        Hs266(266.130046),
        Hs267(267.13167),
        Hs268(268.13186),
        Hs269(269.13375),
        Hs270(270.13429),
        Hs271(271.13717),
        Hs272(272.1385),
        Hs273(273.14168),
        Hs274(274.1433),
        Hs275(275.14667),
        Hs276(276.14846),
        Hs277(277.1519);

        private double atomicMass;

        private Hs(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Hs;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Bh implements Isotope
    {
        Bh260(260.12166),
        Bh261(261.12145),
        Bh262(262.12297),
        Bh263(263.12292),
        Bh264(264.12459),
        Bh265(265.12491),
        Bh266(266.12679),
        Bh267(267.1275),
        Bh268(268.12969),
        Bh269(269.13042),
        Bh270(270.13336),
        Bh271(271.13526),
        Bh272(272.13826),
        Bh273(273.14024),
        Bh274(274.14355),
        Bh275(275.14567);

        private double atomicMass;

        private Bh(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Bh;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Sg implements Isotope
    {
        Sg258(258.11298),
        Sg259(259.1144),
        Sg260(260.114384),
        Sg261(261.115949),
        Sg262(262.116337),
        Sg263(263.11829),
        Sg264(264.11893),
        Sg265(265.12109),
        Sg266(266.12198),
        Sg267(267.12436),
        Sg268(268.12539),
        Sg269(269.12863),
        Sg270(270.13043),
        Sg271(271.13393),
        Sg272(272.13589),
        Sg273(273.13958);

        private double atomicMass;

        private Sg(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Sg;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Db implements Isotope
    {
        Db255(255.10707),
        Db256(256.10789),
        Db257(257.10758),
        Db258(258.10928),
        Db259(259.109492),
        Db260(260.1113),
        Db261(261.11192),
        Db262(262.11407),
        Db263(263.11499),
        Db264(264.11741),
        Db265(265.11861),
        Db266(266.12103),
        Db267(267.12247),
        Db268(268.12567),
        Db269(269.12791),
        Db270(270.13136);

        private double atomicMass;

        private Db(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Db;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Rf implements Isotope
    {
        Rf253(253.10044),
        Rf254(254.10005),
        Rf255(255.10127),
        Rf256(256.101152),
        Rf257(257.102918),
        Rf258(258.103428),
        Rf259(259.105596),
        Rf260(260.10644),
        Rf261(261.108773),
        Rf262(262.10992),
        Rf263(263.11249),
        Rf264(264.11388),
        Rf265(265.11668),
        Rf266(266.11817),
        Rf267(267.12179),
        Rf268(268.12397);

        private double atomicMass;

        private Rf(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Rf;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Lr implements Isotope
    {
        Lr251(251.09418),
        Lr252(252.09526),
        Lr253(253.09509),
        Lr254(254.09648),
        Lr255(255.096562),
        Lr256(256.098494),
        Lr257(257.099418),
        Lr258(258.10176),
        Lr259(259.102902),
        Lr260(260.1055),
        Lr261(261.10688),
        Lr262(262.10961),
        Lr263(263.11136),
        Lr264(264.1142),
        Lr265(265.11619),
        Lr266(266.11983);

        private double atomicMass;

        private Lr(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Lr;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum No implements Isotope
    {
        No248(248.08655),
        No249(249.0878),
        No250(250.08756),
        No251(251.08894),
        No252(252.088967),
        No253(253.0905641),
        No254(254.090956),
        No255(255.093191),
        No256(256.0942829),
        No257(257.0968878),
        No258(258.09821),
        No259(259.10103),
        No260(260.10264),
        No261(261.1057),
        No262(262.10746),
        No263(263.11071),
        No264(264.11273);

        private double atomicMass;

        private No(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.No;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Md implements Isotope
    {
        Md245(245.08081),
        Md246(246.08171),
        Md247(247.08152),
        Md248(248.08282),
        Md249(249.08291),
        Md250(250.08441),
        Md251(251.084774),
        Md252(252.08643),
        Md253(253.087144),
        Md254(254.08959),
        Md255(255.0910841),
        Md256(256.09389),
        Md257(257.0955424),
        Md258(258.0984315),
        Md259(259.10051),
        Md260(260.10365),
        Md261(261.10583),
        Md262(262.1091);

        private double atomicMass;

        private Md(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Md;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Fm implements Isotope
    {
        Fm241(241.07421),
        Fm242(242.07343),
        Fm243(243.07446),
        Fm244(244.07404),
        Fm245(245.07535),
        Fm246(246.07535),
        Fm247(247.07694),
        Fm248(248.0771865),
        Fm249(249.0789275),
        Fm250(250.079521),
        Fm251(251.08154),
        Fm252(252.0824671),
        Fm253(253.0851846),
        Fm254(254.0868544),
        Fm255(255.089964),
        Fm256(256.0917745),
        Fm257(257.0951061),
        Fm258(258.09708),
        Fm259(259.1006),
        Fm260(260.10281);

        private double atomicMass;

        private Fm(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Fm;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Es implements Isotope
    {
        Es239(239.06823),
        Es240(240.06892),
        Es241(241.06856),
        Es242(242.06957),
        Es243(243.06951),
        Es244(244.07088),
        Es245(245.07125),
        Es246(246.0729),
        Es247(247.073622),
        Es248(248.075471),
        Es249(249.076411),
        Es250(250.07861),
        Es251(251.0799936),
        Es252(252.08298),
        Es253(253.0848257),
        Es254(254.0880222),
        Es255(255.090275),
        Es256(256.0936),
        Es257(257.09598),
        Es258(258.09952);

        private double atomicMass;

        private Es(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Es;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cf implements Isotope
    {
        Cf237(237.062198),
        Cf238(238.06149),
        Cf239(239.06253),
        Cf240(240.062256),
        Cf241(241.06369),
        Cf242(242.063754),
        Cf243(243.06548),
        Cf244(244.0660008),
        Cf245(245.0680487),
        Cf246(246.0688055),
        Cf247(247.070965),
        Cf248(248.0721851),
        Cf249(249.0748539),
        Cf250(250.0764062),
        Cf251(251.0795886),
        Cf252(252.0816272),
        Cf253(253.0851345),
        Cf254(254.087324),
        Cf255(255.09105),
        Cf256(256.09344);

        private double atomicMass;

        private Cf(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cf;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Bk implements Isotope
    {
        Bk234(234.05727),
        Bk235(235.05658),
        Bk236(236.05748),
        Bk237(237.0571),
        Bk238(238.0582),
        Bk239(239.05824),
        Bk240(240.05976),
        Bk241(241.06016),
        Bk242(242.06198),
        Bk243(243.0630078),
        Bk244(244.065181),
        Bk245(245.0663618),
        Bk246(246.068673),
        Bk247(247.0703073),
        Bk248(248.073088),
        Bk249(249.0749877),
        Bk250(250.0783167),
        Bk251(251.080762),
        Bk252(252.08431),
        Bk253(253.08688),
        Bk254(254.0906);

        private double atomicMass;

        private Bk(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Bk;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cm implements Isotope
    {
        Cm232(232.04982),
        Cm233(233.05077),
        Cm234(234.05016),
        Cm235(235.05154),
        Cm236(236.051374),
        Cm237(237.052869),
        Cm238(238.053081),
        Cm239(239.05491),
        Cm240(240.0555297),
        Cm241(241.0576532),
        Cm242(242.058836),
        Cm243(243.0613893),
        Cm244(244.0627528),
        Cm245(245.0654915),
        Cm246(246.0672238),
        Cm247(247.0703541),
        Cm248(248.0723499),
        Cm249(249.0759548),
        Cm250(250.078358),
        Cm251(251.082286),
        Cm252(252.08487);

        private double atomicMass;

        private Cm(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cm;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Am implements Isotope
    {
        Am230(230.04609),
        Am231(231.04556),
        Am232(232.04645),
        Am233(233.04644),
        Am234(234.04773),
        Am235(235.047908),
        Am236(236.04943),
        Am237(237.049996),
        Am238(238.051985),
        Am239(239.0530247),
        Am240(240.0553),
        Am241(241.0568293),
        Am242(242.0595494),
        Am243(243.0613813),
        Am244(244.0642851),
        Am245(245.0664548),
        Am246(246.069775),
        Am247(247.07209),
        Am248(248.07575),
        Am249(249.07848);

        private double atomicMass;

        private Am(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Am;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Pu implements Isotope
    {
        Pu228(228.038732),
        Pu229(229.040144),
        Pu230(230.03965),
        Pu231(231.041102),
        Pu232(232.041185),
        Pu233(233.042998),
        Pu234(234.0433174),
        Pu235(235.045286),
        Pu236(236.0460581),
        Pu237(237.0484098),
        Pu238(238.0495601),
        Pu239(239.0521636),
        Pu240(240.0538138),
        Pu241(241.0568517),
        Pu242(242.0587428),
        Pu243(243.0620036),
        Pu244(244.0642053),
        Pu245(245.067826),
        Pu246(246.070205),
        Pu247(247.07419);

        private double atomicMass;

        private Pu(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Pu;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Np implements Isotope
    {
        Np219(219.03143),
        Np220(220.03254),
        Np221(221.03204),
        Np222(222.0333),
        Np223(223.03285),
        Np224(224.03422),
        Np225(225.033911),
        Np226(226.035188),
        Np227(227.034957),
        Np228(228.036067),
        Np229(229.036264),
        Np230(230.037828),
        Np231(231.038245),
        Np232(232.04011),
        Np233(233.040741),
        Np234(234.0428953),
        Np235(235.0440635),
        Np236(236.04657),
        Np237(237.0481736),
        Np238(238.0509466),
        Np239(239.0529392),
        Np240(240.056165),
        Np241(241.058253),
        Np242(242.06164),
        Np243(243.06428),
        Np244(244.06785),
        Np245(245.0708);

        private double atomicMass;

        private Np(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Np;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum U implements Isotope
    {
        U217(217.02466),
        U218(218.023523),
        U219(219.024999),
        U220(220.02462),
        U221(221.02628),
        U222(222.026),
        U223(223.027739),
        U224(224.027605),
        U225(225.029391),
        U226(226.029339),
        U227(227.031157),
        U228(228.031371),
        U229(229.0335063),
        U230(230.0339401),
        U231(231.0362939),
        U232(232.0371563),
        U233(233.0396355),
        U234(234.0409523),
        U235(235.0439301),
        U236(236.0455682),
        U237(237.0487304),
        U238(238.0507884),
        U239(239.0542935),
        U240(240.0565934),
        U241(241.06033),
        U242(242.06293),
        U243(243.06699);

        private double atomicMass;

        private U(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.U;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Pa implements Isotope
    {
        Pa212(212.023203),
        Pa213(213.021109),
        Pa214(214.020918),
        Pa215(215.019183),
        Pa216(216.019109),
        Pa217(217.018325),
        Pa218(218.020059),
        Pa219(219.019904),
        Pa220(220.021705),
        Pa221(221.021875),
        Pa222(222.023784),
        Pa223(223.023963),
        Pa224(224.0256176),
        Pa225(225.026131),
        Pa226(226.027948),
        Pa227(227.0288054),
        Pa228(228.0310517),
        Pa229(229.0320972),
        Pa230(230.034541),
        Pa231(231.0358842),
        Pa232(232.0385917),
        Pa233(233.0402472),
        Pa234(234.0433072),
        Pa235(235.045399),
        Pa236(236.048668),
        Pa237(237.051023),
        Pa238(238.054637),
        Pa239(239.05726),
        Pa240(240.06098),
        Pa241(241.06408);

        private double atomicMass;

        private Pa(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Pa;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Th implements Isotope
    {
        Th208(208.0179),
        Th209(209.017753),
        Th210(210.015094),
        Th211(211.014929),
        Th212(212.012988),
        Th213(213.013009),
        Th214(214.0115),
        Th215(215.0117248),
        Th216(216.011056),
        Th217(217.013117),
        Th218(218.013276),
        Th219(219.015537),
        Th220(220.015748),
        Th221(221.018184),
        Th222(222.018469),
        Th223(223.0208119),
        Th224(224.021464),
        Th225(225.0239514),
        Th226(226.0249034),
        Th227(227.0277042),
        Th228(228.0287413),
        Th229(229.0317627),
        Th230(230.0331341),
        Th231(231.0363046),
        Th232(232.0380558),
        Th233(233.0415823),
        Th234(234.0436014),
        Th235(235.047255),
        Th236(236.049657),
        Th237(237.053629),
        Th238(238.0565),
        Th239(239.06077);

        private double atomicMass;

        private Th(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Th;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ac implements Isotope
    {
        Ac206(206.014452),
        Ac207(207.011966),
        Ac208(208.01155),
        Ac209(209.009495),
        Ac210(210.009436),
        Ac211(211.007732),
        Ac212(212.007813),
        Ac213(213.006609),
        Ac214(214.006918),
        Ac215(215.006475),
        Ac216(216.008743),
        Ac217(217.009344),
        Ac218(218.011642),
        Ac219(219.012421),
        Ac220(220.0147549),
        Ac221(221.015592),
        Ac222(222.0178442),
        Ac223(223.0191377),
        Ac224(224.0217232),
        Ac225(225.02323),
        Ac226(226.0260984),
        Ac227(227.0277523),
        Ac228(228.0310215),
        Ac229(229.032956),
        Ac230(230.036327),
        Ac231(231.038393),
        Ac232(232.042034),
        Ac233(233.044346),
        Ac234(234.048139),
        Ac235(235.05084),
        Ac236(236.054988),
        Ac237(237.05827);

        private double atomicMass;

        private Ac(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ac;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ra implements Isotope
    {
        Ra201(201.01271),
        Ra202(202.00976),
        Ra203(203.009304),
        Ra204(204.006492),
        Ra205(205.006268),
        Ra206(206.003828),
        Ra207(207.003799),
        Ra208(208.001841),
        Ra209(209.00199),
        Ra210(210.000494),
        Ra211(211.0008932),
        Ra212(211.999787),
        Ra213(213.000384),
        Ra214(214.0000997),
        Ra215(215.0027204),
        Ra216(216.0035334),
        Ra217(217.0063207),
        Ra218(218.007141),
        Ra219(219.0100855),
        Ra220(220.0110259),
        Ra221(221.0139177),
        Ra222(222.0153748),
        Ra223(223.0185023),
        Ra224(224.020212),
        Ra225(225.0236119),
        Ra226(226.0254103),
        Ra227(227.0291783),
        Ra228(228.0310707),
        Ra229(229.034942),
        Ra230(230.037055),
        Ra231(231.041027),
        Ra232(232.0434753),
        Ra233(233.047582),
        Ra234(234.050342),
        Ra235(235.05497);

        private double atomicMass;

        private Ra(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ra;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Fr implements Isotope
    {
        Fr199(199.007259),
        Fr200(200.006586),
        Fr201(201.003867),
        Fr202(202.00332),
        Fr203(203.0009407),
        Fr204(204.000652),
        Fr205(204.9985939),
        Fr206(205.998666),
        Fr207(206.996946),
        Fr208(207.997138),
        Fr209(208.995955),
        Fr210(209.996422),
        Fr211(210.995556),
        Fr212(211.9962257),
        Fr213(212.996186),
        Fr214(213.9989713),
        Fr215(215.0003418),
        Fr216(216.0031899),
        Fr217(217.0046323),
        Fr218(218.0075787),
        Fr219(219.0092524),
        Fr220(220.0123277),
        Fr221(221.0142552),
        Fr222(222.017552),
        Fr223(223.019736),
        Fr224(224.023398),
        Fr225(225.025573),
        Fr226(226.029566),
        Fr227(227.031869),
        Fr228(228.035823),
        Fr229(229.038298),
        Fr230(230.042416),
        Fr231(231.045158),
        Fr232(232.04937),
        Fr233(233.05264);

        private double atomicMass;

        private Fr(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Fr;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Rn implements Isotope
    {
        Rn193(193.009708),
        Rn194(194.006144),
        Rn195(195.005422),
        Rn196(196.002116),
        Rn197(197.001585),
        Rn198(197.998679),
        Rn199(198.99839),
        Rn200(199.99569),
        Rn201(200.995628),
        Rn202(201.993264),
        Rn203(202.993388),
        Rn204(203.99143),
        Rn205(204.991719),
        Rn206(205.990214),
        Rn207(206.9907303),
        Rn208(207.989635),
        Rn209(208.990415),
        Rn210(209.9896891),
        Rn211(210.9906011),
        Rn212(211.9907039),
        Rn213(212.9938831),
        Rn214(213.995363),
        Rn215(214.9987459),
        Rn216(216.0002719),
        Rn217(217.003928),
        Rn218(218.0056016),
        Rn219(219.0094804),
        Rn220(220.0113941),
        Rn221(221.0155371),
        Rn222(222.0175782),
        Rn223(223.0218893),
        Rn224(224.024096),
        Rn225(225.028486),
        Rn226(226.030861),
        Rn227(227.035304),
        Rn228(228.037835),
        Rn229(229.042257),
        Rn230(230.04514),
        Rn231(231.04987);

        private double atomicMass;

        private Rn(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Rn;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum At implements Isotope
    {
        At191(191.004148),
        At192(192.003152),
        At193(192.999927),
        At194(193.999236),
        At195(194.9962685),
        At196(195.9958),
        At197(196.993189),
        At198(197.992784),
        At199(198.9905277),
        At200(199.990351),
        At201(200.9884171),
        At202(201.98863),
        At203(202.986943),
        At204(203.987251),
        At205(204.986076),
        At206(205.986657),
        At207(206.9858),
        At208(207.9866133),
        At209(208.9861702),
        At210(209.9871479),
        At211(210.9874966),
        At212(211.9907377),
        At213(212.992937),
        At214(213.9963721),
        At215(214.9986528),
        At216(216.0024236),
        At217(217.0047192),
        At218(218.008695),
        At219(219.0111618),
        At220(220.015433),
        At221(221.018017),
        At222(222.022494),
        At223(223.025151),
        At224(224.029749),
        At225(225.03263),
        At226(226.03716),
        At227(227.04024),
        At228(228.04475),
        At229(229.04812);

        private double atomicMass;

        private At(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.At;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Po implements Isotope
    {
        Po186(186.004393),
        Po187(187.003041),
        Po188(187.999416),
        Po189(188.998473),
        Po190(189.995101),
        Po191(190.9945585),
        Po192(191.991336),
        Po193(192.991026),
        Po194(193.988186),
        Po195(194.988126),
        Po196(195.985526),
        Po197(196.98566),
        Po198(197.983389),
        Po199(198.983667),
        Po200(199.981799),
        Po201(200.9822598),
        Po202(201.980758),
        Po203(202.9814161),
        Po204(203.98031),
        Po205(204.981203),
        Po206(205.980474),
        Po207(206.9815938),
        Po208(207.9812461),
        Po209(208.9824308),
        Po210(209.9828741),
        Po211(210.9866536),
        Po212(211.9888684),
        Po213(212.9928576),
        Po214(213.9952017),
        Po215(214.9994201),
        Po216(216.0019152),
        Po217(217.0063182),
        Po218(218.0089735),
        Po219(219.013614),
        Po220(220.016386),
        Po221(221.021228),
        Po222(222.02414),
        Po223(223.02907),
        Po224(224.03211),
        Po225(225.03707),
        Po226(226.04031),
        Po227(227.04539);

        private double atomicMass;

        private Po(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Po;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Bi implements Isotope
    {
        Bi184(184.001275),
        Bi185(184.9976),
        Bi186(185.996644),
        Bi187(186.993147),
        Bi188(187.992287),
        Bi189(188.989195),
        Bi190(189.988622),
        Bi191(190.9857866),
        Bi192(191.985469),
        Bi193(192.98296),
        Bi194(193.982785),
        Bi195(194.9806488),
        Bi196(195.980667),
        Bi197(196.9788651),
        Bi198(197.979206),
        Bi199(198.977673),
        Bi200(199.978131),
        Bi201(200.97701),
        Bi202(201.977734),
        Bi203(202.976893),
        Bi204(203.9778361),
        Bi205(204.9773867),
        Bi206(205.9784993),
        Bi207(206.978471),
        Bi208(207.9797425),
        Bi209(208.9803991),
        Bi210(209.9841207),
        Bi211(210.9872697),
        Bi212(211.991286),
        Bi213(212.9943851),
        Bi214(213.998712),
        Bi215(215.00177),
        Bi216(216.006306),
        Bi217(217.009372),
        Bi218(218.014188),
        Bi219(219.01748),
        Bi220(220.02235),
        Bi221(221.02587),
        Bi222(222.03078),
        Bi223(223.0345),
        Bi224(224.03947);

        private double atomicMass;

        private Bi(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Bi;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Pb implements Isotope
    {
        Pb178(178.003831),
        Pb179(179.002201),
        Pb180(179.997928),
        Pb181(180.996653),
        Pb182(181.992672),
        Pb183(182.991872),
        Pb184(183.988136),
        Pb185(184.98761),
        Pb186(185.984238),
        Pb187(186.9839109),
        Pb188(187.980875),
        Pb189(188.980807),
        Pb190(189.978082),
        Pb191(190.978276),
        Pb192(191.975775),
        Pb193(192.976173),
        Pb194(193.974012),
        Pb195(194.974543),
        Pb196(195.972774),
        Pb197(196.9734312),
        Pb198(197.972034),
        Pb199(198.972913),
        Pb200(199.971819),
        Pb201(200.972883),
        Pb202(201.972152),
        Pb203(202.9733911),
        Pb204(203.973044),
        Pb205(204.9744822),
        Pb206(205.9744657),
        Pb207(206.9758973),
        Pb208(207.9766525),
        Pb209(208.9810905),
        Pb210(209.9841889),
        Pb211(210.9887371),
        Pb212(211.9918977),
        Pb213(212.9965629),
        Pb214(213.9998059),
        Pb215(215.00474),
        Pb216(216.00803),
        Pb217(217.01314),
        Pb218(218.01659),
        Pb219(219.02177),
        Pb220(220.02541);

        private double atomicMass;

        private Pb(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Pb;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Tl implements Isotope
    {
        Tl176(176.000624),
        Tl177(176.996431),
        Tl178(177.99485),
        Tl179(178.991111),
        Tl180(179.990057),
        Tl181(180.98626),
        Tl182(181.985713),
        Tl183(182.982193),
        Tl184(183.981886),
        Tl185(184.978789),
        Tl186(185.978651),
        Tl187(186.9759063),
        Tl188(187.976021),
        Tl189(188.973588),
        Tl190(189.973828),
        Tl191(190.9717842),
        Tl192(191.972225),
        Tl193(192.970502),
        Tl194(193.971081),
        Tl195(194.969774),
        Tl196(195.970481),
        Tl197(196.969576),
        Tl198(197.970483),
        Tl199(198.969877),
        Tl200(199.9709633),
        Tl201(200.970822),
        Tl202(201.972102),
        Tl203(202.9723446),
        Tl204(203.9738639),
        Tl205(204.9744278),
        Tl206(205.9761106),
        Tl207(206.9774197),
        Tl208(207.982019),
        Tl209(208.9853594),
        Tl210(209.990074),
        Tl211(210.993475),
        Tl212(211.99834),
        Tl213(213.001915),
        Tl214(214.00694),
        Tl215(215.01064),
        Tl216(216.0158),
        Tl217(217.01966),
        Tl218(218.02479);

        private double atomicMass;

        private Tl(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Tl;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Hg implements Isotope
    {
        Hg171(171.00353),
        Hg172(171.99881),
        Hg173(172.99709),
        Hg174(173.992865),
        Hg175(174.991441),
        Hg176(175.987361),
        Hg177(176.986277),
        Hg178(177.982484),
        Hg179(178.981831),
        Hg180(179.97826),
        Hg181(180.977819),
        Hg182(181.974689),
        Hg183(182.9744448),
        Hg184(183.971714),
        Hg185(184.971899),
        Hg186(185.969362),
        Hg187(186.969814),
        Hg188(187.967567),
        Hg189(188.968195),
        Hg190(189.966323),
        Hg191(190.967157),
        Hg192(191.965635),
        Hg193(192.966653),
        Hg194(193.9654491),
        Hg195(194.966721),
        Hg196(195.9658326),
        Hg197(196.9672128),
        Hg198(197.9667686),
        Hg199(198.96828064),
        Hg200(199.96832659),
        Hg201(200.97030284),
        Hg202(201.9706434),
        Hg203(202.9728728),
        Hg204(203.97349398),
        Hg205(204.9760734),
        Hg206(205.977514),
        Hg207(206.9823),
        Hg208(207.985759),
        Hg209(208.99072),
        Hg210(209.99424),
        Hg211(210.99933),
        Hg212(212.00296),
        Hg213(213.00823),
        Hg214(214.012),
        Hg215(215.0174),
        Hg216(216.02132);

        private double atomicMass;

        private Hg(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Hg;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Au implements Isotope
    {
        Au169(168.99808),
        Au170(169.99597),
        Au171(170.991876),
        Au172(171.989942),
        Au173(172.986241),
        Au174(173.984717),
        Au175(174.981304),
        Au176(175.98025),
        Au177(176.97687),
        Au178(177.976032),
        Au179(178.973174),
        Au180(179.972523),
        Au181(180.970079),
        Au182(181.969618),
        Au183(182.967591),
        Au184(183.967452),
        Au185(184.96579),
        Au186(185.965953),
        Au187(186.964543),
        Au188(187.965349),
        Au189(188.963948),
        Au190(189.964698),
        Au191(190.963702),
        Au192(191.964814),
        Au193(192.9641373),
        Au194(193.9654178),
        Au195(194.9650352),
        Au196(195.9665699),
        Au197(196.96656879),
        Au198(197.96824242),
        Au199(198.96876528),
        Au200(199.970756),
        Au201(200.9716575),
        Au202(201.973856),
        Au203(202.9751544),
        Au204(203.97783),
        Au205(204.97985),
        Au206(205.98474),
        Au207(206.9884),
        Au208(207.99345),
        Au209(208.99735),
        Au210(210.0025);

        private double atomicMass;

        private Au(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Au;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Pt implements Isotope
    {
        Pt166(165.99486),
        Pt167(166.99269),
        Pt168(167.98813),
        Pt169(168.98657),
        Pt170(169.982496),
        Pt171(170.981245),
        Pt172(171.977351),
        Pt173(172.976443),
        Pt174(173.97282),
        Pt175(174.97241),
        Pt176(175.968938),
        Pt177(176.96847),
        Pt178(177.96565),
        Pt179(178.965359),
        Pt180(179.963032),
        Pt181(180.963098),
        Pt182(181.961172),
        Pt183(182.961597),
        Pt184(183.959915),
        Pt185(184.960614),
        Pt186(185.959351),
        Pt187(186.960617),
        Pt188(187.9593889),
        Pt189(188.960831),
        Pt190(189.9599297),
        Pt191(190.9616729),
        Pt192(191.9610387),
        Pt193(192.9629824),
        Pt194(193.9626809),
        Pt195(194.9647917),
        Pt196(195.96495209),
        Pt197(196.96734069),
        Pt198(197.9678949),
        Pt199(198.9705952),
        Pt200(199.971443),
        Pt201(200.974513),
        Pt202(201.975639),
        Pt203(202.97893),
        Pt204(203.98076),
        Pt205(204.98608),
        Pt206(205.98966);

        private double atomicMass;

        private Pt(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Pt;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ir implements Isotope
    {
        Ir164(163.99191),
        Ir165(164.9875),
        Ir166(165.98566),
        Ir167(166.981666),
        Ir168(167.979907),
        Ir169(168.976298),
        Ir170(169.974922),
        Ir171(170.97164),
        Ir172(171.970607),
        Ir173(172.967506),
        Ir174(173.966861),
        Ir175(174.96415),
        Ir176(175.96365),
        Ir177(176.961301),
        Ir178(177.961082),
        Ir179(178.95912),
        Ir180(179.959229),
        Ir181(180.957625),
        Ir182(181.958076),
        Ir183(182.95684),
        Ir184(183.957476),
        Ir185(184.956698),
        Ir186(185.957944),
        Ir187(186.957542),
        Ir188(187.958828),
        Ir189(188.958715),
        Ir190(189.9605412),
        Ir191(190.9605893),
        Ir192(191.9626002),
        Ir193(192.9629216),
        Ir194(193.9650735),
        Ir195(194.9659747),
        Ir196(195.968397),
        Ir197(196.969655),
        Ir198(197.97228),
        Ir199(198.973805),
        Ir200(199.9768),
        Ir201(200.97864),
        Ir202(201.98199),
        Ir203(202.98423),
        Ir204(203.9896);

        private double atomicMass;

        private Ir(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ir;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Os implements Isotope
    {
        Os161(160.98903),
        Os162(161.98443),
        Os163(162.98241),
        Os164(163.97802),
        Os165(164.9766),
        Os166(165.972692),
        Os167(166.971549),
        Os168(167.967808),
        Os169(168.967018),
        Os170(169.963578),
        Os171(170.963174),
        Os172(171.960017),
        Os173(172.959808),
        Os174(173.957064),
        Os175(174.956945),
        Os176(175.954806),
        Os177(176.954966),
        Os178(177.953254),
        Os179(178.953817),
        Os180(179.952375),
        Os181(180.953247),
        Os182(181.95211),
        Os183(182.953125),
        Os184(183.9524885),
        Os185(184.9540417),
        Os186(185.953835),
        Os187(186.9557474),
        Os188(187.9558352),
        Os189(188.9581442),
        Os190(189.9584437),
        Os191(190.9609264),
        Os192(191.961477),
        Os193(192.9641479),
        Os194(193.9651772),
        Os195(194.968318),
        Os196(195.969641),
        Os197(196.97283),
        Os198(197.97441),
        Os199(198.97801),
        Os200(199.97984),
        Os201(200.98364),
        Os202(201.98595);

        private double atomicMass;

        private Os(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Os;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Re implements Isotope
    {
        Re159(158.98418),
        Re160(159.98182),
        Re161(160.97757),
        Re162(161.97584),
        Re163(162.97208),
        Re164(163.970453),
        Re165(164.967103),
        Re166(165.965761),
        Re167(166.962595),
        Re168(167.961573),
        Re169(168.958766),
        Re170(169.95822),
        Re171(170.955716),
        Re172(171.95542),
        Re173(172.953243),
        Re174(173.953115),
        Re175(174.951381),
        Re176(175.951623),
        Re177(176.950328),
        Re178(177.950989),
        Re179(178.949989),
        Re180(179.950792),
        Re181(180.950058),
        Re182(181.95121),
        Re183(182.9508196),
        Re184(183.9525228),
        Re185(184.9529545),
        Re186(185.9549856),
        Re187(186.9557501),
        Re188(187.9581115),
        Re189(188.959226),
        Re190(189.961744),
        Re191(190.963122),
        Re192(191.966088),
        Re193(192.967541),
        Re194(193.97076),
        Re195(194.97254),
        Re196(195.9758),
        Re197(196.97799),
        Re198(197.9816);

        private double atomicMass;

        private Re(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Re;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum W implements Isotope
    {
        W157(156.97884),
        W158(157.97456),
        W159(158.97264),
        W160(159.96846),
        W161(160.9672),
        W162(161.963499),
        W163(162.962524),
        W164(163.958961),
        W165(164.958281),
        W166(165.955031),
        W167(166.954805),
        W168(167.951806),
        W169(168.951779),
        W170(169.949232),
        W171(170.949451),
        W172(171.947292),
        W173(172.947689),
        W174(173.946079),
        W175(174.946717),
        W176(175.945634),
        W177(176.946643),
        W178(177.945883),
        W179(178.947077),
        W180(179.9467108),
        W181(180.9481978),
        W182(181.94820394),
        W183(182.95022275),
        W184(183.95093092),
        W185(184.95341897),
        W186(185.9543628),
        W187(186.9571588),
        W188(187.9584862),
        W189(188.961763),
        W190(189.963091),
        W191(190.966531),
        W192(191.96817),
        W193(192.97178),
        W194(193.97367);

        private double atomicMass;

        private W(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.W;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ta implements Isotope
    {
        Ta155(154.97424),
        Ta156(155.97203),
        Ta157(156.96818),
        Ta158(157.96654),
        Ta159(158.963023),
        Ta160(159.961488),
        Ta161(160.958452),
        Ta162(161.957294),
        Ta163(162.954337),
        Ta164(163.953534),
        Ta165(164.950781),
        Ta166(165.950512),
        Ta167(166.948093),
        Ta168(167.948047),
        Ta169(168.946011),
        Ta170(169.946175),
        Ta171(170.944476),
        Ta172(171.944895),
        Ta173(172.94375),
        Ta174(173.944454),
        Ta175(174.943737),
        Ta176(175.944857),
        Ta177(176.9444795),
        Ta178(177.945678),
        Ta179(178.9459366),
        Ta180(179.9474648),
        Ta181(180.9479958),
        Ta182(181.9501519),
        Ta183(182.9513726),
        Ta184(183.954008),
        Ta185(184.955559),
        Ta186(185.958551),
        Ta187(186.960386),
        Ta188(187.963916),
        Ta189(188.96583),
        Ta190(189.96939),
        Ta191(190.97156),
        Ta192(191.97514);

        private double atomicMass;

        private Ta(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ta;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Hf implements Isotope
    {
        Hf153(152.97069),
        Hf154(153.96486),
        Hf155(154.96311),
        Hf156(155.95935),
        Hf157(156.95824),
        Hf158(157.954801),
        Hf159(158.953996),
        Hf160(159.950691),
        Hf161(160.950278),
        Hf162(161.9472148),
        Hf163(162.947113),
        Hf164(163.944371),
        Hf165(164.944567),
        Hf166(165.94218),
        Hf167(166.9426),
        Hf168(167.940568),
        Hf169(168.941259),
        Hf170(169.939609),
        Hf171(170.940492),
        Hf172(171.93945),
        Hf173(172.940513),
        Hf174(173.9400461),
        Hf175(174.9415092),
        Hf176(175.9414076),
        Hf177(176.9432277),
        Hf178(177.9437058),
        Hf179(178.9458232),
        Hf180(179.946557),
        Hf181(180.9491083),
        Hf182(181.9505612),
        Hf183(182.95353),
        Hf184(183.955446),
        Hf185(184.958862),
        Hf186(185.960897),
        Hf187(186.96477),
        Hf188(187.96685),
        Hf189(188.97084);

        private double atomicMass;

        private Hf(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Hf;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Lu implements Isotope
    {
        Lu150(149.97355),
        Lu151(150.96768),
        Lu152(151.96412),
        Lu153(152.95875),
        Lu154(153.95736),
        Lu155(154.954321),
        Lu156(155.953033),
        Lu157(156.950127),
        Lu158(157.949316),
        Lu159(158.946636),
        Lu160(159.946033),
        Lu161(160.943572),
        Lu162(161.943283),
        Lu163(162.941179),
        Lu164(163.941339),
        Lu165(164.939407),
        Lu166(165.939859),
        Lu167(166.93827),
        Lu168(167.938736),
        Lu169(168.9376441),
        Lu170(169.938478),
        Lu171(170.937917),
        Lu172(171.9390891),
        Lu173(172.938934),
        Lu174(173.9403409),
        Lu175(174.9407752),
        Lu176(175.9426897),
        Lu177(176.9437615),
        Lu178(177.945958),
        Lu179(178.9473309),
        Lu180(179.949888),
        Lu181(180.95191),
        Lu182(181.95504),
        Lu183(182.957363),
        Lu184(183.96091),
        Lu185(184.96362);

        private double atomicMass;

        private Lu(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Lu;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Yb implements Isotope
    {
        Yb148(147.96758),
        Yb149(148.96436),
        Yb150(149.95852),
        Yb151(150.9554),
        Yb152(151.95027),
        Yb153(152.94932),
        Yb154(153.946396),
        Yb155(154.945783),
        Yb156(155.942825),
        Yb157(156.942645),
        Yb158(157.9398705),
        Yb159(158.940055),
        Yb160(159.937557),
        Yb161(160.937907),
        Yb162(161.935774),
        Yb163(162.93634),
        Yb164(163.934495),
        Yb165(164.93527),
        Yb166(165.9338747),
        Yb167(166.934953),
        Yb168(167.9338896),
        Yb169(168.9351825),
        Yb170(169.9347664),
        Yb171(170.9363302),
        Yb172(171.9363859),
        Yb173(172.9382151),
        Yb174(173.9388664),
        Yb175(174.9412808),
        Yb176(175.9425764),
        Yb177(176.9452656),
        Yb178(177.946651),
        Yb179(178.95004),
        Yb180(179.95212),
        Yb181(180.95589);

        private double atomicMass;

        private Yb(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Yb;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Tm implements Isotope
    {
        Tm144(143.97628),
        Tm145(144.97039),
        Tm146(145.96684),
        Tm147(146.9613799),
        Tm148(147.958384),
        Tm149(148.95289),
        Tm150(149.95009),
        Tm151(150.945488),
        Tm152(151.944422),
        Tm153(152.94204),
        Tm154(153.94157),
        Tm155(154.93921),
        Tm156(155.938992),
        Tm157(156.936944),
        Tm158(157.93698),
        Tm159(158.934975),
        Tm160(159.935263),
        Tm161(160.933549),
        Tm162(161.934002),
        Tm163(162.9326592),
        Tm164(163.933544),
        Tm165(164.9324431),
        Tm166(165.933561),
        Tm167(166.9328562),
        Tm168(167.9341774),
        Tm169(168.9342179),
        Tm170(169.935806),
        Tm171(170.9364339),
        Tm172(171.9384055),
        Tm173(172.9396084),
        Tm174(173.942173),
        Tm175(174.943841),
        Tm176(175.947),
        Tm177(176.94904),
        Tm178(177.95264),
        Tm179(178.95534);

        private double atomicMass;

        private Tm(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Tm;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Er implements Isotope
    {
        Er142(141.9701),
        Er143(142.96662),
        Er144(143.9607),
        Er145(144.95805),
        Er146(145.9524184),
        Er147(146.949964),
        Er148(147.944735),
        Er149(148.942306),
        Er150(149.937916),
        Er151(150.937449),
        Er152(151.935057),
        Er153(152.93508),
        Er154(153.9327908),
        Er155(154.9332159),
        Er156(155.931067),
        Er157(156.931949),
        Er158(157.929893),
        Er159(158.9306918),
        Er160(159.929077),
        Er161(160.9300046),
        Er162(161.9287884),
        Er163(162.9300408),
        Er164(163.9292088),
        Er165(164.9307345),
        Er166(165.9302995),
        Er167(166.9320546),
        Er168(167.9323767),
        Er169(168.9345968),
        Er170(169.9354702),
        Er171(170.9380357),
        Er172(171.9393619),
        Er173(172.9424),
        Er174(173.94423),
        Er175(174.94777),
        Er176(175.94994),
        Er177(176.95399);

        private double atomicMass;

        private Er(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Er;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ho implements Isotope
    {
        Ho140(139.96859),
        Ho141(140.96311),
        Ho142(141.96001),
        Ho143(142.95486),
        Ho144(143.9521097),
        Ho145(144.9472674),
        Ho146(145.9449935),
        Ho147(146.9401423),
        Ho148(147.937744),
        Ho149(148.933803),
        Ho150(149.933498),
        Ho151(150.9316983),
        Ho152(151.931724),
        Ho153(152.9302064),
        Ho154(153.9306068),
        Ho155(154.929104),
        Ho156(155.929706),
        Ho157(156.928254),
        Ho158(157.928946),
        Ho159(158.9277197),
        Ho160(159.928737),
        Ho161(160.9278615),
        Ho162(161.9291023),
        Ho163(162.928741),
        Ho164(163.9302403),
        Ho165(164.9303288),
        Ho166(165.9322909),
        Ho167(166.9331385),
        Ho168(167.935522),
        Ho169(168.936878),
        Ho170(169.939625),
        Ho171(170.94147),
        Ho172(171.94473),
        Ho173(172.94702),
        Ho174(173.95095),
        Ho175(174.95362);

        private double atomicMass;

        private Ho(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ho;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Dy implements Isotope
    {
        Dy138(137.9625),
        Dy139(138.95959),
        Dy140(139.95402),
        Dy141(140.95128),
        Dy142(141.94619),
        Dy143(142.943994),
        Dy144(143.9392695),
        Dy145(144.937474),
        Dy146(145.9328445),
        Dy147(146.9310827),
        Dy148(147.927157),
        Dy149(148.927322),
        Dy150(149.9255933),
        Dy151(150.9261916),
        Dy152(151.9247253),
        Dy153(152.9257724),
        Dy154(153.9244293),
        Dy155(154.925759),
        Dy156(155.9242847),
        Dy157(156.9254707),
        Dy158(157.9244159),
        Dy159(158.925747),
        Dy160(159.9252046),
        Dy161(160.9269405),
        Dy162(161.9268056),
        Dy163(162.9287383),
        Dy164(163.9291819),
        Dy165(164.9317105),
        Dy166(165.9328139),
        Dy167(166.935661),
        Dy168(167.93713),
        Dy169(168.94031),
        Dy170(169.94239),
        Dy171(170.94612),
        Dy172(171.94846),
        Dy173(172.95283);

        private double atomicMass;

        private Dy(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Dy;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Tb implements Isotope
    {
        Tb135(134.96476),
        Tb136(135.96129),
        Tb137(136.95602),
        Tb138(137.95312),
        Tb139(138.94833),
        Tb140(139.94581),
        Tb141(140.94145),
        Tb142(141.93928),
        Tb143(142.935137),
        Tb144(143.933045),
        Tb145(144.92882),
        Tb146(145.927253),
        Tb147(146.9240548),
        Tb148(147.924282),
        Tb149(148.9232535),
        Tb150(149.9236649),
        Tb151(150.9231096),
        Tb152(151.924083),
        Tb153(152.9234424),
        Tb154(153.924685),
        Tb155(154.923511),
        Tb156(155.9247552),
        Tb157(156.924033),
        Tb158(157.9254209),
        Tb159(158.9253547),
        Tb160(159.9271756),
        Tb161(160.9275778),
        Tb162(161.929495),
        Tb163(162.9306547),
        Tb164(163.93336),
        Tb165(164.93498),
        Tb166(165.93786),
        Tb167(166.93996),
        Tb168(167.9434),
        Tb169(168.94597),
        Tb170(169.94984),
        Tb171(170.95273);

        private double atomicMass;

        private Tb(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Tb;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Gd implements Isotope
    {
        Gd133(132.96133),
        Gd134(133.95566),
        Gd135(134.95245),
        Gd136(135.9473),
        Gd137(136.94502),
        Gd138(137.94025),
        Gd139(138.93813),
        Gd140(139.933674),
        Gd141(140.932126),
        Gd142(141.928116),
        Gd143(142.92675),
        Gd144(143.922963),
        Gd145(144.921713),
        Gd146(145.9183188),
        Gd147(146.9191014),
        Gd148(147.9181215),
        Gd149(148.9193481),
        Gd150(149.9186644),
        Gd151(150.920356),
        Gd152(151.9197995),
        Gd153(152.921758),
        Gd154(153.9208741),
        Gd155(154.9226305),
        Gd156(155.9221312),
        Gd157(156.9239686),
        Gd158(157.9241123),
        Gd159(158.926397),
        Gd160(159.9270624),
        Gd161(160.9296775),
        Gd162(161.930993),
        Gd163(162.9341769),
        Gd164(163.93583),
        Gd165(164.93936),
        Gd166(165.94146),
        Gd167(166.94545),
        Gd168(167.94808),
        Gd169(168.9526);

        private double atomicMass;

        private Gd(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Gd;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Eu implements Isotope
    {
        Eu130(129.96369),
        Eu131(130.95784),
        Eu132(131.95467),
        Eu133(132.94929),
        Eu134(133.9464),
        Eu135(134.94187),
        Eu136(135.93962),
        Eu137(136.93546),
        Eu138(137.933709),
        Eu139(138.929792),
        Eu140(139.928088),
        Eu141(140.924932),
        Eu142(141.923442),
        Eu143(142.920299),
        Eu144(143.91882),
        Eu145(144.9162726),
        Eu146(145.917211),
        Eu147(146.9167527),
        Eu148(147.918089),
        Eu149(148.9179378),
        Eu150(149.9197077),
        Eu151(150.9198578),
        Eu152(151.9217522),
        Eu153(152.921238),
        Eu154(153.922987),
        Eu155(154.9229011),
        Eu156(155.9247605),
        Eu157(156.9254334),
        Eu158(157.927799),
        Eu159(158.9291001),
        Eu160(159.931851),
        Eu161(160.933664),
        Eu162(161.936989),
        Eu163(162.939196),
        Eu164(163.94274),
        Eu165(164.94559),
        Eu166(165.94962),
        Eu167(166.95289);

        private double atomicMass;

        private Eu(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Eu;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Sm implements Isotope
    {
        Sm128(127.95842),
        Sm129(128.95476),
        Sm130(129.949),
        Sm131(130.94618),
        Sm132(131.94087),
        Sm133(132.93856),
        Sm134(133.93411),
        Sm135(134.93252),
        Sm136(135.928276),
        Sm137(136.926971),
        Sm138(137.923244),
        Sm139(138.922297),
        Sm140(139.918995),
        Sm141(140.9184816),
        Sm142(141.9152044),
        Sm143(142.9146353),
        Sm144(143.9120065),
        Sm145(144.9134173),
        Sm146(145.913047),
        Sm147(146.9149044),
        Sm148(147.9148292),
        Sm149(148.9171921),
        Sm150(149.9172829),
        Sm151(150.9199398),
        Sm152(151.9197397),
        Sm153(152.9221047),
        Sm154(153.9222169),
        Sm155(154.9246477),
        Sm156(155.925536),
        Sm157(156.9284187),
        Sm158(157.929951),
        Sm159(158.9332172),
        Sm160(159.9353353),
        Sm161(160.9391602),
        Sm162(161.94146),
        Sm163(162.94555),
        Sm164(163.94836),
        Sm165(164.95297);

        private double atomicMass;

        private Sm(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Sm;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Pm implements Isotope
    {
        Pm126(125.95792),
        Pm127(126.95192),
        Pm128(127.9487),
        Pm129(128.94323),
        Pm130(129.94053),
        Pm131(130.93567),
        Pm132(131.93384),
        Pm133(132.929782),
        Pm134(133.928353),
        Pm135(134.924823),
        Pm136(135.923585),
        Pm137(136.92048),
        Pm138(137.919548),
        Pm139(138.9168),
        Pm140(139.91604),
        Pm141(140.913555),
        Pm142(141.91289),
        Pm143(142.9109383),
        Pm144(143.9125964),
        Pm145(144.9127559),
        Pm146(145.9147024),
        Pm147(146.915145),
        Pm148(147.9174819),
        Pm149(148.9183423),
        Pm150(149.920991),
        Pm151(150.9212175),
        Pm152(151.923506),
        Pm153(152.9241567),
        Pm154(153.926472),
        Pm155(154.928137),
        Pm156(155.9311175),
        Pm157(156.9331214),
        Pm158(157.936565),
        Pm159(158.939287),
        Pm160(159.9431),
        Pm161(160.94607),
        Pm162(161.95022),
        Pm163(162.95357);

        private double atomicMass;

        private Pm(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Pm;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Nd implements Isotope
    {
        Nd124(123.9522),
        Nd125(124.9489),
        Nd126(125.94311),
        Nd127(126.94038),
        Nd128(127.93525),
        Nd129(128.9331),
        Nd130(129.928506),
        Nd131(130.927248),
        Nd132(131.923321),
        Nd133(132.922348),
        Nd134(133.91879),
        Nd135(134.918181),
        Nd136(135.914976),
        Nd137(136.914562),
        Nd138(137.91195),
        Nd139(138.911954),
        Nd140(139.90955),
        Nd141(140.9096147),
        Nd142(141.907729),
        Nd143(142.90982),
        Nd144(143.910093),
        Nd145(144.9125793),
        Nd146(145.9131226),
        Nd147(146.9161061),
        Nd148(147.9168993),
        Nd149(148.9201548),
        Nd150(149.9209022),
        Nd151(150.9238403),
        Nd152(151.924692),
        Nd153(152.927718),
        Nd154(153.92948),
        Nd155(154.9331357),
        Nd156(155.93508),
        Nd157(156.939386),
        Nd158(157.94197),
        Nd159(158.94653),
        Nd160(159.9494),
        Nd161(160.95428);

        private double atomicMass;

        private Nd(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Nd;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Pr implements Isotope
    {
        Pr121(120.95532),
        Pr122(121.95175),
        Pr123(122.94596),
        Pr124(123.94294),
        Pr125(124.9377),
        Pr126(125.93524),
        Pr127(126.93071),
        Pr128(127.928791),
        Pr129(128.925095),
        Pr130(129.92359),
        Pr131(130.920235),
        Pr132(131.919255),
        Pr133(132.916331),
        Pr134(133.915697),
        Pr135(134.913112),
        Pr136(135.912677),
        Pr137(136.9106792),
        Pr138(137.910754),
        Pr139(138.9089408),
        Pr140(139.9090803),
        Pr141(140.9076576),
        Pr142(141.9100496),
        Pr143(142.9108228),
        Pr144(143.9133109),
        Pr145(144.9145182),
        Pr146(145.91768),
        Pr147(146.919008),
        Pr148(147.92213),
        Pr149(148.923736),
        Pr150(149.9266765),
        Pr151(150.928309),
        Pr152(151.931553),
        Pr153(152.933904),
        Pr154(153.93753),
        Pr155(154.940509),
        Pr156(155.94464),
        Pr157(156.94789),
        Pr158(157.95241),
        Pr159(158.95589);

        private double atomicMass;

        private Pr(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Pr;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ce implements Isotope
    {
        Ce119(118.95271),
        Ce120(119.94654),
        Ce121(120.94335),
        Ce122(121.93787),
        Ce123(122.93528),
        Ce124(123.93031),
        Ce125(124.92844),
        Ce126(125.923971),
        Ce127(126.922727),
        Ce128(127.918911),
        Ce129(128.918102),
        Ce130(129.914736),
        Ce131(130.914429),
        Ce132(131.911464),
        Ce133(132.91152),
        Ce134(133.908928),
        Ce135(134.909161),
        Ce136(135.90712921),
        Ce137(136.90776236),
        Ce138(137.905991),
        Ce139(138.9066551),
        Ce140(139.9054431),
        Ce141(140.9082807),
        Ce142(141.9092504),
        Ce143(142.9123921),
        Ce144(143.9136529),
        Ce145(144.917265),
        Ce146(145.918802),
        Ce147(146.9226899),
        Ce148(147.924424),
        Ce149(148.928427),
        Ce150(149.930384),
        Ce151(150.934272),
        Ce152(151.9366),
        Ce153(152.94093),
        Ce154(153.9438),
        Ce155(154.94855),
        Ce156(155.95183),
        Ce157(156.95705);

        private double atomicMass;

        private Ce(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ce;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum La implements Isotope
    {
        La116(115.9563),
        La117(116.94999),
        La118(117.94673),
        La119(118.94099),
        La120(119.93807),
        La121(120.93315),
        La122(121.93071),
        La123(122.9263),
        La124(123.924574),
        La125(124.920816),
        La126(125.919513),
        La127(126.916375),
        La128(127.915592),
        La129(128.912694),
        La130(129.912369),
        La131(130.91007),
        La132(131.910119),
        La133(132.908218),
        La134(133.908514),
        La135(134.906984),
        La136(135.907635),
        La137(136.9064504),
        La138(137.9071149),
        La139(138.9063563),
        La140(139.9094806),
        La141(140.910966),
        La142(141.9140909),
        La143(142.9160795),
        La144(143.919646),
        La145(144.921808),
        La146(145.925875),
        La147(146.928418),
        La148(147.932679),
        La149(148.93535),
        La150(149.93947),
        La151(150.94232),
        La152(151.94682),
        La153(152.95036),
        La154(153.95517),
        La155(154.95901);

        private double atomicMass;

        private La(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.La;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ba implements Isotope
    {
        Ba114(113.95066),
        Ba115(114.94737),
        Ba116(115.94128),
        Ba117(116.93814),
        Ba118(117.93306),
        Ba119(118.93066),
        Ba120(119.92605),
        Ba121(120.92405),
        Ba122(121.919904),
        Ba123(122.918781),
        Ba124(123.915094),
        Ba125(124.914472),
        Ba126(125.91125),
        Ba127(126.911091),
        Ba128(127.908342),
        Ba129(128.908681),
        Ba130(129.9063207),
        Ba131(130.906941),
        Ba132(131.9050611),
        Ba133(132.9060074),
        Ba134(133.90450818),
        Ba135(134.90568838),
        Ba136(135.90457573),
        Ba137(136.90582714),
        Ba138(137.905247),
        Ba139(138.9088411),
        Ba140(139.9106057),
        Ba141(140.9144033),
        Ba142(141.9164324),
        Ba143(142.9206253),
        Ba144(143.9229549),
        Ba145(144.9275184),
        Ba146(145.930284),
        Ba147(146.935304),
        Ba148(147.938171),
        Ba149(148.94308),
        Ba150(149.94605),
        Ba151(150.95127),
        Ba152(151.95481),
        Ba153(152.96036);

        private double atomicMass;

        private Ba(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ba;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cs implements Isotope
    {
        Cs112(111.950309),
        Cs113(112.9444291),
        Cs114(113.941296),
        Cs115(114.93591),
        Cs116(115.93337),
        Cs117(116.928617),
        Cs118(117.92656),
        Cs119(118.922377),
        Cs120(119.920677),
        Cs121(120.917227),
        Cs122(121.916108),
        Cs123(122.912996),
        Cs124(123.9122578),
        Cs125(124.909728),
        Cs126(125.909446),
        Cs127(126.9074174),
        Cs128(127.9077487),
        Cs129(128.9060657),
        Cs130(129.9067093),
        Cs131(130.9054649),
        Cs132(131.9064339),
        Cs133(132.905451961),
        Cs134(133.906718503),
        Cs135(134.905977),
        Cs136(135.9073114),
        Cs137(136.90708923),
        Cs138(137.9110171),
        Cs139(138.9133638),
        Cs140(139.9172831),
        Cs141(140.9200455),
        Cs142(141.924296),
        Cs143(142.927349),
        Cs144(143.932076),
        Cs145(144.935527),
        Cs146(145.940344),
        Cs147(146.944156),
        Cs148(147.94923),
        Cs149(148.95302),
        Cs150(149.95833),
        Cs151(150.96258);

        private double atomicMass;

        private Cs(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cs;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Xe implements Isotope
    {
        Xe109(108.95043),
        Xe110(109.94426),
        Xe111(110.941607),
        Xe112(111.935559),
        Xe113(112.9332217),
        Xe114(113.92798),
        Xe115(114.926294),
        Xe116(115.921581),
        Xe117(116.920359),
        Xe118(117.916179),
        Xe119(118.915411),
        Xe120(119.911784),
        Xe121(120.911453),
        Xe122(121.908368),
        Xe123(122.908482),
        Xe124(123.905892),
        Xe125(124.9063944),
        Xe126(125.9042983),
        Xe127(126.9051829),
        Xe128(127.903531),
        Xe129(128.9047808611),
        Xe130(129.903509349),
        Xe131(130.90508406),
        Xe132(131.9041550856),
        Xe133(132.9059108),
        Xe134(133.90539466),
        Xe135(134.9072278),
        Xe136(135.907214484),
        Xe137(136.91155778),
        Xe138(137.9141463),
        Xe139(138.9187922),
        Xe140(139.9216458),
        Xe141(140.9267872),
        Xe142(141.9299731),
        Xe143(142.9353696),
        Xe144(143.9389451),
        Xe145(144.94472),
        Xe146(145.948518),
        Xe147(146.95426),
        Xe148(147.95813);

        private double atomicMass;

        private Xe(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Xe;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum I implements Isotope
    {
        I107(106.94678),
        I108(107.94348),
        I109(108.9380853),
        I110(109.935089),
        I111(110.9302692),
        I112(111.928005),
        I113(112.9236501),
        I114(113.92185),
        I115(114.918048),
        I116(115.91681),
        I117(116.913648),
        I118(117.913074),
        I119(118.910074),
        I120(119.910087),
        I121(120.9074051),
        I122(121.9075888),
        I123(122.9055885),
        I124(123.906209),
        I125(124.9046294),
        I126(125.9056233),
        I127(126.9044719),
        I128(127.9058086),
        I129(128.9049837),
        I130(129.9066702),
        I131(130.9061263),
        I132(131.9079935),
        I133(132.907797),
        I134(133.9097588),
        I135(134.9100488),
        I136(135.914604),
        I137(136.9180282),
        I138(137.9227264),
        I139(138.926506),
        I140(139.93173),
        I141(140.93569),
        I142(141.9412),
        I143(142.94565),
        I144(143.95139),
        I145(144.95605);

        private double atomicMass;

        private I(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.I;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Te implements Isotope
    {
        Te105(104.9433),
        Te106(105.9375),
        Te107(106.935012),
        Te108(107.9293805),
        Te109(108.9273045),
        Te110(109.9224581),
        Te111(110.9210006),
        Te112(111.9167279),
        Te113(112.915891),
        Te114(113.912089),
        Te115(114.911902),
        Te116(115.90846),
        Te117(116.908646),
        Te118(117.905854),
        Te119(118.9064071),
        Te120(119.9040593),
        Te121(120.904944),
        Te122(121.9030435),
        Te123(122.9042698),
        Te124(123.9028171),
        Te125(124.9044299),
        Te126(125.9033109),
        Te127(126.9052257),
        Te128(127.90446128),
        Te129(128.90659646),
        Te130(129.906222748),
        Te131(130.908522213),
        Te132(131.9085467),
        Te133(132.9109688),
        Te134(133.911394),
        Te135(134.9165557),
        Te136(135.9201006),
        Te137(136.9255989),
        Te138(137.9294722),
        Te139(138.9353672),
        Te140(139.939499),
        Te141(140.9458),
        Te142(141.95022),
        Te143(142.95676);

        private double atomicMass;

        private Te(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Te;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Sb implements Isotope
    {
        Sb103(102.93969),
        Sb104(103.93648),
        Sb105(104.931276),
        Sb106(105.928638),
        Sb107(106.9241506),
        Sb108(107.9222267),
        Sb109(108.9181411),
        Sb110(109.9168543),
        Sb111(110.9132182),
        Sb112(111.9124),
        Sb113(112.909375),
        Sb114(113.90929),
        Sb115(114.906598),
        Sb116(115.9067931),
        Sb117(116.9048415),
        Sb118(117.9055321),
        Sb119(118.9039455),
        Sb120(119.9050794),
        Sb121(120.903812),
        Sb122(121.9051699),
        Sb123(122.9042132),
        Sb124(123.905935),
        Sb125(124.905253),
        Sb126(125.907253),
        Sb127(126.9069243),
        Sb128(127.909146),
        Sb129(128.909147),
        Sb130(129.911662),
        Sb131(130.9119888),
        Sb132(131.9145077),
        Sb133(132.9152732),
        Sb134(133.9205357),
        Sb135(134.9251851),
        Sb136(135.9307459),
        Sb137(136.93555),
        Sb138(137.94145),
        Sb139(138.94655),
        Sb140(139.95283);

        private double atomicMass;

        private Sb(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Sb;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Sn implements Isotope
    {
        Sn99(98.94853),
        Sn100(99.9385),
        Sn101(100.93526),
        Sn102(101.93029),
        Sn103(102.928105),
        Sn104(103.9231052),
        Sn105(104.9212684),
        Sn106(105.9169574),
        Sn107(106.9157137),
        Sn108(107.9118943),
        Sn109(108.9112921),
        Sn110(109.907845),
        Sn111(110.9077401),
        Sn112(111.90482387),
        Sn113(112.9051757),
        Sn114(113.9027827),
        Sn115(114.903344699),
        Sn116(115.9017428),
        Sn117(116.90295398),
        Sn118(117.90160657),
        Sn119(118.90331117),
        Sn120(119.90220163),
        Sn121(120.9042426),
        Sn122(121.9034438),
        Sn123(122.9057252),
        Sn124(123.9052766),
        Sn125(124.9077864),
        Sn126(125.907659),
        Sn127(126.91039),
        Sn128(127.910507),
        Sn129(128.913465),
        Sn130(129.9139738),
        Sn131(130.917045),
        Sn132(131.9178267),
        Sn133(132.9239134),
        Sn134(133.9286821),
        Sn135(134.9349086),
        Sn136(135.93999),
        Sn137(136.94655),
        Sn138(137.95184);

        private double atomicMass;

        private Sn(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Sn;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum In implements Isotope
    {
        In97(96.94934),
        In98(97.94214),
        In99(98.93411),
        In100(99.93096),
        In101(100.92634),
        In102(101.9241071),
        In103(102.9198819),
        In104(103.9182145),
        In105(104.914502),
        In106(105.913464),
        In107(106.91029),
        In108(107.9096935),
        In109(108.9071514),
        In110(109.90717),
        In111(110.9051085),
        In112(111.9055377),
        In113(112.90406184),
        In114(113.90491791),
        In115(114.903878776),
        In116(115.90525999),
        In117(116.9045157),
        In118(117.9063566),
        In119(118.9058507),
        In120(119.907967),
        In121(120.907851),
        In122(121.910281),
        In123(122.910434),
        In124(123.913182),
        In125(124.913605),
        In126(125.916507),
        In127(126.917446),
        In128(127.9204),
        In129(128.9218053),
        In130(129.924977),
        In131(130.9269715),
        In132(131.933001),
        In133(132.93831),
        In134(133.94454),
        In135(134.95005);

        private double atomicMass;

        private In(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.In;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cd implements Isotope
    {
        Cd95(94.94994),
        Cd96(95.94034),
        Cd97(96.9351),
        Cd98(97.927389),
        Cd99(98.9249258),
        Cd100(99.9203488),
        Cd101(100.9185862),
        Cd102(101.914482),
        Cd103(102.9134165),
        Cd104(103.9098564),
        Cd105(104.9094639),
        Cd106(105.9064599),
        Cd107(106.9066121),
        Cd108(107.9041834),
        Cd109(108.9049867),
        Cd110(109.90300661),
        Cd111(110.90418287),
        Cd112(111.90276287),
        Cd113(112.90440813),
        Cd114(113.90336509),
        Cd115(114.90543751),
        Cd116(115.90476315),
        Cd117(116.907226),
        Cd118(117.906922),
        Cd119(118.909847),
        Cd120(119.9098681),
        Cd121(120.9129637),
        Cd122(121.9134591),
        Cd123(122.9168925),
        Cd124(123.9176574),
        Cd125(124.9212576),
        Cd126(125.9224291),
        Cd127(126.926472),
        Cd128(127.9278129),
        Cd129(128.93182),
        Cd130(129.93394),
        Cd131(130.9406),
        Cd132(131.94604),
        Cd133(132.95285);

        private double atomicMass;

        private Cd(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cd;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ag implements Isotope
    {
        Ag93(92.95033),
        Ag94(93.94373),
        Ag95(94.93602),
        Ag96(95.930744),
        Ag97(96.92397),
        Ag98(97.92156),
        Ag99(98.9176458),
        Ag100(99.9161154),
        Ag101(100.912684),
        Ag102(101.9117047),
        Ag103(102.9089631),
        Ag104(103.9086239),
        Ag105(104.9065256),
        Ag106(105.9066636),
        Ag107(106.9050916),
        Ag108(107.9059503),
        Ag109(108.9047553),
        Ag110(109.9061102),
        Ag111(110.9052959),
        Ag112(111.9070486),
        Ag113(112.906573),
        Ag114(113.908823),
        Ag115(114.908767),
        Ag116(115.9113868),
        Ag117(116.911774),
        Ag118(117.9145955),
        Ag119(118.91557),
        Ag120(119.9187848),
        Ag121(120.920125),
        Ag122(121.923664),
        Ag123(122.925337),
        Ag124(123.92893),
        Ag125(124.93105),
        Ag126(125.93475),
        Ag127(126.93711),
        Ag128(127.94106),
        Ag129(128.94395),
        Ag130(129.9507);

        private double atomicMass;

        private Ag(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ag;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Pd implements Isotope
    {
        Pd91(90.95032),
        Pd92(91.94088),
        Pd93(92.93651),
        Pd94(93.9290376),
        Pd95(94.9248898),
        Pd96(95.9182151),
        Pd97(96.916472),
        Pd98(97.9126983),
        Pd99(98.9117748),
        Pd100(99.908505),
        Pd101(100.9082864),
        Pd102(101.9056022),
        Pd103(102.9060809),
        Pd104(103.9040305),
        Pd105(104.9050796),
        Pd106(105.9034804),
        Pd107(106.9051282),
        Pd108(107.9038916),
        Pd109(108.9059504),
        Pd110(109.9051722),
        Pd111(110.90768968),
        Pd112(111.9073297),
        Pd113(112.910261),
        Pd114(113.9103686),
        Pd115(114.913659),
        Pd116(115.914297),
        Pd117(116.9179547),
        Pd118(117.9190667),
        Pd119(118.9233402),
        Pd120(119.9245511),
        Pd121(120.9289503),
        Pd122(121.930632),
        Pd123(122.93514),
        Pd124(123.93714),
        Pd125(124.94179),
        Pd126(125.94416),
        Pd127(126.94907),
        Pd128(127.95183);

        private double atomicMass;

        private Pd(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Pd;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Rh implements Isotope
    {
        Rh89(88.95058),
        Rh90(89.94422),
        Rh91(90.93688),
        Rh92(91.9323677),
        Rh93(92.9259128),
        Rh94(93.9217305),
        Rh95(94.9158979),
        Rh96(95.914453),
        Rh97(96.911329),
        Rh98(97.910708),
        Rh99(98.9081282),
        Rh100(99.908117),
        Rh101(100.9061606),
        Rh102(101.9068374),
        Rh103(102.905498),
        Rh104(103.9066492),
        Rh105(104.9056885),
        Rh106(105.9072868),
        Rh107(106.906748),
        Rh108(107.908714),
        Rh109(108.9087488),
        Rh110(109.911079),
        Rh111(110.9116423),
        Rh112(111.914403),
        Rh113(112.9154393),
        Rh114(113.918718),
        Rh115(114.9203116),
        Rh116(115.924059),
        Rh117(116.9260354),
        Rh118(117.93034),
        Rh119(118.932557),
        Rh120(119.93686),
        Rh121(120.93942),
        Rh122(121.94399),
        Rh123(122.94685),
        Rh124(123.95151),
        Rh125(124.95469),
        Rh126(125.95946);

        private double atomicMass;

        private Rh(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Rh;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ru implements Isotope
    {
        Ru87(86.95069),
        Ru88(87.9416),
        Ru89(88.93762),
        Ru90(89.9303444),
        Ru91(90.9267419),
        Ru92(91.9202344),
        Ru93(92.9171044),
        Ru94(93.9113429),
        Ru95(94.910406),
        Ru96(95.90759025),
        Ru97(96.9075471),
        Ru98(97.9052868),
        Ru99(98.9059341),
        Ru100(99.9042143),
        Ru101(100.9055769),
        Ru102(101.9043441),
        Ru103(102.9063186),
        Ru104(103.9054275),
        Ru105(104.9077476),
        Ru106(105.9073291),
        Ru107(106.909972),
        Ru108(107.910188),
        Ru109(108.913326),
        Ru110(109.9140407),
        Ru111(110.91757),
        Ru112(111.918809),
        Ru113(112.922844),
        Ru114(113.9246136),
        Ru115(114.92882),
        Ru116(115.9312192),
        Ru117(116.9361),
        Ru118(117.93853),
        Ru119(118.94357),
        Ru120(119.94631),
        Ru121(120.95164),
        Ru122(121.95447),
        Ru123(122.95989),
        Ru124(123.96305);

        private double atomicMass;

        private Ru(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ru;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Tc implements Isotope
    {
        Tc85(84.95058),
        Tc86(85.94493),
        Tc87(86.9380672),
        Tc88(87.93378),
        Tc89(88.9276487),
        Tc90(89.9240739),
        Tc91(90.9184254),
        Tc92(91.9152698),
        Tc93(92.910246),
        Tc94(93.9096536),
        Tc95(94.9076536),
        Tc96(95.907868),
        Tc97(96.9063667),
        Tc98(97.9072124),
        Tc99(98.9062508),
        Tc100(99.9076539),
        Tc101(100.907309),
        Tc102(101.9092097),
        Tc103(102.909176),
        Tc104(103.911425),
        Tc105(104.911655),
        Tc106(105.914358),
        Tc107(106.9154606),
        Tc108(107.9184957),
        Tc109(108.920256),
        Tc110(109.923744),
        Tc111(110.925901),
        Tc112(111.9299458),
        Tc113(112.932569),
        Tc114(113.93691),
        Tc115(114.93998),
        Tc116(115.94476),
        Tc117(116.94806),
        Tc118(117.95299),
        Tc119(118.95666),
        Tc120(119.96187);

        private double atomicMass;

        private Tc(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Tc;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Mo implements Isotope
    {
        Mo83(82.94988),
        Mo84(83.94149),
        Mo85(84.938261),
        Mo86(85.9311748),
        Mo87(86.9281962),
        Mo88(87.9219678),
        Mo89(88.9194682),
        Mo90(89.9139309),
        Mo91(90.9117453),
        Mo92(91.90680796),
        Mo93(92.90680958),
        Mo94(93.9050849),
        Mo95(94.90583877),
        Mo96(95.90467612),
        Mo97(96.90601812),
        Mo98(97.90540482),
        Mo99(98.90770851),
        Mo100(99.9074718),
        Mo101(100.9103414),
        Mo102(101.9102834),
        Mo103(102.913079),
        Mo104(103.9137344),
        Mo105(104.916969),
        Mo106(105.918259),
        Mo107(106.922106),
        Mo108(107.924033),
        Mo109(108.928424),
        Mo110(109.930704),
        Mo111(110.935654),
        Mo112(111.93831),
        Mo113(112.94335),
        Mo114(113.94653),
        Mo115(114.95196),
        Mo116(115.95545),
        Mo117(116.96117);

        private double atomicMass;

        private Mo(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Mo;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Nb implements Isotope
    {
        Nb81(80.9496),
        Nb82(81.94396),
        Nb83(82.93729),
        Nb84(83.93449),
        Nb85(84.9288458),
        Nb86(85.9257828),
        Nb87(86.9206937),
        Nb88(87.918222),
        Nb89(88.913445),
        Nb90(89.9112584),
        Nb91(90.9069897),
        Nb92(91.9071881),
        Nb93(92.906373),
        Nb94(93.9072788),
        Nb95(94.9068324),
        Nb96(95.9080973),
        Nb97(96.9080959),
        Nb98(97.9103265),
        Nb99(98.911613),
        Nb100(99.9143276),
        Nb101(100.9153103),
        Nb102(101.9180772),
        Nb103(102.9194572),
        Nb104(103.9228925),
        Nb105(104.9249465),
        Nb106(105.9289317),
        Nb107(106.9315937),
        Nb108(107.9360748),
        Nb109(108.93922),
        Nb110(109.94403),
        Nb111(110.94753),
        Nb112(111.95247),
        Nb113(112.95651),
        Nb114(113.96201),
        Nb115(114.96634);

        private double atomicMass;

        private Nb(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Nb;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Zr implements Isotope
    {
        Zr78(77.95566),
        Zr79(78.94948),
        Zr80(79.9404),
        Zr81(80.93731),
        Zr82(81.93135),
        Zr83(82.9292421),
        Zr84(83.9233269),
        Zr85(84.9214444),
        Zr86(85.9162972),
        Zr87(86.914818),
        Zr88(87.9102213),
        Zr89(88.9088814),
        Zr90(89.9046977),
        Zr91(90.9056396),
        Zr92(91.9050347),
        Zr93(92.9064699),
        Zr94(93.9063108),
        Zr95(94.9080385),
        Zr96(95.9082714),
        Zr97(96.9109512),
        Zr98(97.9127289),
        Zr99(98.916667),
        Zr100(99.9180006),
        Zr101(100.921448),
        Zr102(101.9231409),
        Zr103(102.927191),
        Zr104(103.929436),
        Zr105(104.934008),
        Zr106(105.93676),
        Zr107(106.94174),
        Zr108(107.94487),
        Zr109(108.95041),
        Zr110(109.95396),
        Zr111(110.95968),
        Zr112(111.9637);

        private double atomicMass;

        private Zr(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Zr;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Y implements Isotope
    {
        Y76(75.95856),
        Y77(76.949781),
        Y78(77.94361),
        Y79(78.93735),
        Y80(79.9343561),
        Y81(80.9294556),
        Y82(81.9269314),
        Y83(82.922485),
        Y84(83.9206721),
        Y85(84.916433),
        Y86(85.914886),
        Y87(86.9108761),
        Y88(87.9095016),
        Y89(88.9058403),
        Y90(89.9071439),
        Y91(90.9072974),
        Y92(91.9089451),
        Y93(92.909578),
        Y94(93.9115906),
        Y95(94.9128161),
        Y96(95.9158968),
        Y97(96.9182741),
        Y98(97.9223821),
        Y99(98.924148),
        Y100(99.927715),
        Y101(100.9301477),
        Y102(101.9343277),
        Y103(102.937243),
        Y104(103.94196),
        Y105(104.94544),
        Y106(105.95056),
        Y107(106.95452),
        Y108(107.95996),
        Y109(108.96436);

        private double atomicMass;

        private Y(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Y;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Sr implements Isotope
    {
        Sr73(72.9657),
        Sr74(73.95617),
        Sr75(74.94995),
        Sr76(75.941763),
        Sr77(76.9379455),
        Sr78(77.93218),
        Sr79(78.9297077),
        Sr80(79.9245175),
        Sr81(80.9232114),
        Sr82(81.9183999),
        Sr83(82.9175544),
        Sr84(83.9134191),
        Sr85(84.912932),
        Sr86(85.9092606),
        Sr87(86.9088775),
        Sr88(87.9056125),
        Sr89(88.9074511),
        Sr90(89.90773),
        Sr91(90.9101954),
        Sr92(91.9110382),
        Sr93(92.9140242),
        Sr94(93.9153556),
        Sr95(94.9193529),
        Sr96(95.9217066),
        Sr97(96.926374),
        Sr98(97.9286888),
        Sr99(98.9328907),
        Sr100(99.93577),
        Sr101(100.940352),
        Sr102(101.943791),
        Sr103(102.94909),
        Sr104(103.95265),
        Sr105(104.95855),
        Sr106(105.96265),
        Sr107(106.96897);

        private double atomicMass;

        private Sr(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Sr;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Rb implements Isotope
    {
        Rb71(70.96532),
        Rb72(71.95908),
        Rb73(72.95053),
        Rb74(73.9442659),
        Rb75(74.9385732),
        Rb76(75.935073),
        Rb77(76.9304016),
        Rb78(77.9281419),
        Rb79(78.9239899),
        Rb80(79.9225164),
        Rb81(80.9189939),
        Rb82(81.918209),
        Rb83(82.9151142),
        Rb84(83.9143752),
        Rb85(84.9117897379),
        Rb86(85.91116743),
        Rb87(86.909180531),
        Rb88(87.91131559),
        Rb89(88.9122783),
        Rb90(89.9147985),
        Rb91(90.9165372),
        Rb92(91.9197284),
        Rb93(92.9220393),
        Rb94(93.9263948),
        Rb95(94.92926),
        Rb96(95.9341334),
        Rb97(96.9371771),
        Rb98(97.9416869),
        Rb99(98.94503),
        Rb100(99.95003),
        Rb101(100.95404),
        Rb102(101.95952),
        Rb103(102.96392);

        private double atomicMass;

        private Rb(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Rb;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Kr implements Isotope
    {
        Kr69(68.96518),
        Kr70(69.95604),
        Kr71(70.95027),
        Kr72(71.9420924),
        Kr73(72.9392892),
        Kr74(73.933084),
        Kr75(74.9309457),
        Kr76(75.9259103),
        Kr77(76.92467),
        Kr78(77.92036494),
        Kr79(78.9200829),
        Kr80(79.91637808),
        Kr81(80.9165912),
        Kr82(81.91348273),
        Kr83(82.91412716),
        Kr84(83.9114977282),
        Kr85(84.9125273),
        Kr86(85.9106106269),
        Kr87(86.91335476),
        Kr88(87.9144479),
        Kr89(88.9178355),
        Kr90(89.9195279),
        Kr91(90.9238063),
        Kr92(91.9261731),
        Kr93(92.9311472),
        Kr94(93.93414),
        Kr95(94.939711),
        Kr96(95.943017),
        Kr97(96.94909),
        Kr98(97.95243),
        Kr99(98.95839),
        Kr100(99.96237),
        Kr101(100.96873);

        private double atomicMass;

        private Kr(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Kr;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Br implements Isotope
    {
        Br67(66.96465),
        Br68(67.95873),
        Br69(68.950497),
        Br70(69.944792),
        Br71(70.9393422),
        Br72(71.9365886),
        Br73(72.9316715),
        Br74(73.9299102),
        Br75(74.9258105),
        Br76(75.924542),
        Br77(76.9213792),
        Br78(77.9211459),
        Br79(78.9183376),
        Br80(79.9185298),
        Br81(80.9162897),
        Br82(81.9168032),
        Br83(82.9151756),
        Br84(83.916496),
        Br85(84.9156458),
        Br86(85.9188054),
        Br87(86.920674),
        Br88(87.9240833),
        Br89(88.9267046),
        Br90(89.9312928),
        Br91(90.9343986),
        Br92(91.9396316),
        Br93(92.94313),
        Br94(93.9489),
        Br95(94.95301),
        Br96(95.95903),
        Br97(96.96344),
        Br98(97.96946);

        private double atomicMass;

        private Br(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Br;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Se implements Isotope
    {
        Se64(63.97109),
        Se65(64.9644),
        Se66(65.95559),
        Se67(66.949994),
        Se68(67.94182524),
        Se69(68.9394148),
        Se70(69.9335155),
        Se71(70.9322094),
        Se72(71.9271405),
        Se73(72.9267549),
        Se74(73.922475934),
        Se75(74.92252287),
        Se76(75.919213704),
        Se77(76.919914154),
        Se78(77.91730928),
        Se79(78.91849929),
        Se80(79.9165218),
        Se81(80.917993),
        Se82(81.9166995),
        Se83(82.9191186),
        Se84(83.9184668),
        Se85(84.9222608),
        Se86(85.9243117),
        Se87(86.9286886),
        Se88(87.9314175),
        Se89(88.9366691),
        Se90(89.9401),
        Se91(90.94596),
        Se92(91.94984),
        Se93(92.95629),
        Se94(93.96049),
        Se95(94.9673);

        private double atomicMass;

        private Se(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Se;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum As implements Isotope
    {
        As60(59.99388),
        As61(60.98112),
        As62(61.97361),
        As63(62.9639),
        As64(63.95743),
        As65(64.949611),
        As66(65.9441488),
        As67(66.93925111),
        As68(67.9367741),
        As69(68.932246),
        As70(69.930926),
        As71(70.9271138),
        As72(71.9267523),
        As73(72.9238291),
        As74(73.9239286),
        As75(74.92159457),
        As76(75.92239202),
        As77(76.9206476),
        As78(77.921828),
        As79(78.9209484),
        As80(79.9224746),
        As81(80.9221323),
        As82(81.9247412),
        As83(82.9252069),
        As84(83.9293033),
        As85(84.9321637),
        As86(85.9367015),
        As87(86.9402917),
        As88(87.94555),
        As89(88.94976),
        As90(89.95563),
        As91(90.96039),
        As92(91.96674);

        private double atomicMass;

        private As(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.As;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ge implements Isotope
    {
        Ge58(57.99172),
        Ge59(58.98249),
        Ge60(59.97036),
        Ge61(60.96379),
        Ge62(61.95502),
        Ge63(62.949628),
        Ge64(63.9416899),
        Ge65(64.9393681),
        Ge66(65.9338621),
        Ge67(66.9327339),
        Ge68(67.9280953),
        Ge69(68.9279645),
        Ge70(69.92424875),
        Ge71(70.92495233),
        Ge72(71.922075826),
        Ge73(72.923458956),
        Ge74(73.921177761),
        Ge75(74.92285837),
        Ge76(75.921402726),
        Ge77(76.923549843),
        Ge78(77.9228529),
        Ge79(78.92536),
        Ge80(79.9253508),
        Ge81(80.9288329),
        Ge82(81.929774),
        Ge83(82.9345391),
        Ge84(83.9375751),
        Ge85(84.9429697),
        Ge86(85.94658),
        Ge87(86.95268),
        Ge88(87.95691),
        Ge89(88.96379),
        Ge90(89.96863);

        private double atomicMass;

        private Ge(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ge;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ga implements Isotope
    {
        Ga56(55.99536),
        Ga57(56.9832),
        Ga58(57.97478),
        Ga59(58.96353),
        Ga60(59.95729),
        Ga61(60.949399),
        Ga62(61.94419025),
        Ga63(62.9392942),
        Ga64(63.9368404),
        Ga65(64.93273459),
        Ga66(65.9315894),
        Ga67(66.9282025),
        Ga68(67.9279805),
        Ga69(68.9255735),
        Ga70(69.9260219),
        Ga71(70.92470258),
        Ga72(71.92636747),
        Ga73(72.9251747),
        Ga74(73.9269457),
        Ga75(74.9265002),
        Ga76(75.9288276),
        Ga77(76.9291543),
        Ga78(77.9316088),
        Ga79(78.9328523),
        Ga80(79.9364208),
        Ga81(80.9381338),
        Ga82(81.9431765),
        Ga83(82.9471203),
        Ga84(83.95246),
        Ga85(84.95699),
        Ga86(85.96301),
        Ga87(86.96824);

        private double atomicMass;

        private Ga(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ga;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Zn implements Isotope
    {
        Zn54(53.99204),
        Zn55(54.98398),
        Zn56(55.97254),
        Zn57(56.96506),
        Zn58(57.954591),
        Zn59(58.94931266),
        Zn60(59.9418421),
        Zn61(60.939507),
        Zn62(61.93433397),
        Zn63(62.9332115),
        Zn64(63.92914201),
        Zn65(64.92924077),
        Zn66(65.92603381),
        Zn67(66.92712775),
        Zn68(67.92484455),
        Zn69(68.9265507),
        Zn70(69.9253192),
        Zn71(70.9277196),
        Zn72(71.9268428),
        Zn73(72.9295826),
        Zn74(73.9294073),
        Zn75(74.9328402),
        Zn76(75.933115),
        Zn77(76.9368872),
        Zn78(77.9382892),
        Zn79(78.9426381),
        Zn80(79.9445529),
        Zn81(80.9504026),
        Zn82(81.95426),
        Zn83(82.96056),
        Zn84(83.96521),
        Zn85(84.97226);

        private double atomicMass;

        private Zn(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Zn;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cu implements Isotope
    {
        Cu52(51.99671),
        Cu53(52.98459),
        Cu54(53.97666),
        Cu55(54.96604),
        Cu56(55.95895),
        Cu57(56.9492125),
        Cu58(57.94453305),
        Cu59(58.93949748),
        Cu60(59.9373645),
        Cu61(60.9334576),
        Cu62(61.93259541),
        Cu63(62.92959772),
        Cu64(63.92976434),
        Cu65(64.9277897),
        Cu66(65.92886903),
        Cu67(66.9277303),
        Cu68(67.9296109),
        Cu69(68.9294293),
        Cu70(69.9323921),
        Cu71(70.9326768),
        Cu72(71.9358203),
        Cu73(72.9366744),
        Cu74(73.9398749),
        Cu75(74.9415226),
        Cu76(75.945275),
        Cu77(76.94792),
        Cu78(77.95223),
        Cu79(78.95502),
        Cu80(79.96089),
        Cu81(80.96587),
        Cu82(81.97244);

        private double atomicMass;

        private Cu(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cu;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ni implements Isotope
    {
        Ni48(48.01769),
        Ni49(49.0077),
        Ni50(49.99474),
        Ni51(50.98611),
        Ni52(51.9748),
        Ni53(52.96819),
        Ni54(53.957892),
        Ni55(54.95133063),
        Ni56(55.94212855),
        Ni57(56.93979218),
        Ni58(57.93534241),
        Ni59(58.9343462),
        Ni60(59.93078588),
        Ni61(60.93105557),
        Ni62(61.92834537),
        Ni63(62.92966963),
        Ni64(63.92796682),
        Ni65(64.93008517),
        Ni66(65.9291393),
        Ni67(66.9315694),
        Ni68(67.9318688),
        Ni69(68.9356103),
        Ni70(69.9364313),
        Ni71(70.940519),
        Ni72(71.9417859),
        Ni73(72.9462067),
        Ni74(73.94798),
        Ni75(74.9525),
        Ni76(75.95533),
        Ni77(76.96055),
        Ni78(77.96336),
        Ni79(78.97025);

        private double atomicMass;

        private Ni(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ni;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Co implements Isotope
    {
        Co47(47.01057),
        Co48(48.00093),
        Co49(48.98891),
        Co50(49.98091),
        Co51(50.970647),
        Co52(51.96351),
        Co53(52.9542041),
        Co54(53.94845987),
        Co55(54.9419972),
        Co56(55.9398388),
        Co57(56.93629057),
        Co58(57.9357521),
        Co59(58.93319429),
        Co60(59.9338163),
        Co61(60.93247662),
        Co62(61.934059),
        Co63(62.9336),
        Co64(63.935811),
        Co65(64.9364621),
        Co66(65.939443),
        Co67(66.9406096),
        Co68(67.94426),
        Co69(68.94614),
        Co70(69.94963),
        Co71(70.95237),
        Co72(71.95729),
        Co73(72.96039),
        Co74(73.96515),
        Co75(74.96876),
        Co76(75.97413);

        private double atomicMass;

        private Co(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Co;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Fe implements Isotope
    {
        Fe45(45.01442),
        Fe46(46.00063),
        Fe47(46.99185),
        Fe48(47.98023),
        Fe49(48.973429),
        Fe50(49.962975),
        Fe51(50.956841),
        Fe52(51.9481131),
        Fe53(52.9453064),
        Fe54(53.93960899),
        Fe55(54.93829199),
        Fe56(55.93493633),
        Fe57(56.93539284),
        Fe58(57.93327443),
        Fe59(58.93487434),
        Fe60(59.9340711),
        Fe61(60.9367462),
        Fe62(61.9367918),
        Fe63(62.9402727),
        Fe64(63.9409878),
        Fe65(64.9450115),
        Fe66(65.94625),
        Fe67(66.95054),
        Fe68(67.95295),
        Fe69(68.95807),
        Fe70(69.96102),
        Fe71(70.96672),
        Fe72(71.96983),
        Fe73(72.97572),
        Fe74(73.97935);

        private double atomicMass;

        private Fe(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Fe;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Mn implements Isotope
    {
        Mn44(44.00715),
        Mn45(44.99449),
        Mn46(45.98609),
        Mn47(46.975775),
        Mn48(47.96852),
        Mn49(48.959595),
        Mn50(49.95423778),
        Mn51(50.94820847),
        Mn52(51.9455639),
        Mn53(52.94128889),
        Mn54(53.9403576),
        Mn55(54.93804391),
        Mn56(55.93890369),
        Mn57(56.9382861),
        Mn58(57.9400666),
        Mn59(58.9403911),
        Mn60(59.9431366),
        Mn61(60.9444525),
        Mn62(61.94795),
        Mn63(62.9496647),
        Mn64(63.9538494),
        Mn65(64.9560198),
        Mn66(65.960547),
        Mn67(66.96424),
        Mn68(67.96962),
        Mn69(68.97366),
        Mn70(69.97937),
        Mn71(70.98368);

        private double atomicMass;

        private Mn(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Mn;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cr implements Isotope
    {
        Cr42(42.0067),
        Cr43(42.99753),
        Cr44(43.98536),
        Cr45(44.97905),
        Cr46(45.968359),
        Cr47(46.9628974),
        Cr48(47.9540291),
        Cr49(48.9513333),
        Cr50(49.94604183),
        Cr51(50.94476502),
        Cr52(51.94050623),
        Cr53(52.94064815),
        Cr54(53.93887916),
        Cr55(54.94083843),
        Cr56(55.9406531),
        Cr57(56.943613),
        Cr58(57.94435),
        Cr59(58.94859),
        Cr60(59.95008),
        Cr61(60.95442),
        Cr62(61.9561),
        Cr63(62.96165),
        Cr64(63.96408),
        Cr65(64.96996),
        Cr66(65.97366),
        Cr67(66.98016),
        Cr68(67.98403);

        private double atomicMass;

        private Cr(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cr;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum V implements Isotope
    {
        V40(40.01276),
        V41(41.00021),
        V42(41.99182),
        V43(42.980766),
        V44(43.97411),
        V45(44.9657748),
        V46(45.96019878),
        V47(46.95490491),
        V48(47.9522522),
        V49(48.9485118),
        V50(49.94715601),
        V51(50.94395704),
        V52(51.94477301),
        V53(52.9443367),
        V54(53.946439),
        V55(54.94724),
        V56(55.95048),
        V57(56.95252),
        V58(57.95672),
        V59(58.95939),
        V60(59.96431),
        V61(60.96725),
        V62(61.97265),
        V63(62.97639),
        V64(63.98264),
        V65(64.9875),
        V66(65.99398);

        private double atomicMass;

        private V(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.V;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ti implements Isotope
    {
        Ti38(38.01145),
        Ti39(39.00236),
        Ti40(39.9905),
        Ti41(40.983148),
        Ti42(41.97304903),
        Ti43(42.9685225),
        Ti44(43.95968995),
        Ti45(44.95812198),
        Ti46(45.95262772),
        Ti47(46.95175879),
        Ti48(47.94794198),
        Ti49(48.94786568),
        Ti50(49.94478689),
        Ti51(50.94661065),
        Ti52(51.946893),
        Ti53(52.94973),
        Ti54(53.95105),
        Ti55(54.95527),
        Ti56(55.95791),
        Ti57(56.96364),
        Ti58(57.9666),
        Ti59(58.97247),
        Ti60(59.97603),
        Ti61(60.98245),
        Ti62(61.98651),
        Ti63(62.99375);

        private double atomicMass;

        private Ti(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ti;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Sc implements Isotope
    {
        Sc36(36.01648),
        Sc37(37.00374),
        Sc38(37.99512),
        Sc39(38.984785),
        Sc40(39.9779673),
        Sc41(40.969251105),
        Sc42(41.96551653),
        Sc43(42.9611505),
        Sc44(43.9594029),
        Sc45(44.95590828),
        Sc46(45.95516826),
        Sc47(46.9524037),
        Sc48(47.9522236),
        Sc49(48.9500146),
        Sc50(49.952176),
        Sc51(50.953592),
        Sc52(51.95688),
        Sc53(52.95909),
        Sc54(53.96393),
        Sc55(54.96782),
        Sc56(55.97345),
        Sc57(56.97777),
        Sc58(57.98403),
        Sc59(58.98894),
        Sc60(59.99565),
        Sc61(61.001);

        private double atomicMass;

        private Sc(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Sc;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ca implements Isotope
    {
        Ca34(34.01487),
        Ca35(35.00514),
        Ca36(35.993074),
        Ca37(36.98589785),
        Ca38(37.97631922),
        Ca39(38.97071081),
        Ca40(39.962590863),
        Ca41(40.96227792),
        Ca42(41.95861783),
        Ca43(42.95876644),
        Ca44(43.95548156),
        Ca45(44.95618635),
        Ca46(45.953689),
        Ca47(46.9545424),
        Ca48(47.95252276),
        Ca49(48.95566274),
        Ca50(49.9574992),
        Ca51(50.960989),
        Ca52(51.963217),
        Ca53(52.96945),
        Ca54(53.9734),
        Ca55(54.9803),
        Ca56(55.98508),
        Ca57(56.99262),
        Ca58(57.99794);

        private double atomicMass;

        private Ca(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ca;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum K implements Isotope
    {
        K32(32.02265),
        K33(33.00756),
        K34(33.99869),
        K35(34.98800541),
        K36(35.98130201),
        K37(36.97337589),
        K38(37.96908112),
        K39(38.9637064864),
        K40(39.963998166),
        K41(40.9618252579),
        K42(41.96240231),
        K43(42.9607347),
        K44(43.96158699),
        K45(44.96069149),
        K46(45.96198159),
        K47(46.9616616),
        K48(47.96534119),
        K49(48.96821075),
        K50(49.97238),
        K51(50.975828),
        K52(51.98224),
        K53(52.98746),
        K54(53.99463),
        K55(55.00076),
        K56(56.00851);

        private double atomicMass;

        private K(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.K;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ar implements Isotope
    {
        Ar30(30.02307),
        Ar31(31.01212),
        Ar32(31.9976378),
        Ar33(32.98992555),
        Ar34(33.98027009),
        Ar35(34.97525759),
        Ar36(35.967545105),
        Ar37(36.96677633),
        Ar38(37.96273211),
        Ar39(38.964313),
        Ar40(39.9623831237),
        Ar41(40.96450057),
        Ar42(41.9630457),
        Ar43(42.9656361),
        Ar44(43.9649238),
        Ar45(44.96803973),
        Ar46(45.968083),
        Ar47(46.972935),
        Ar48(47.97591),
        Ar49(48.9819),
        Ar50(49.98613),
        Ar51(50.9937),
        Ar52(51.99896),
        Ar53(53.00729);

        private double atomicMass;

        private Ar(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ar;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Cl implements Isotope
    {
        Cl28(28.02954),
        Cl29(29.01478),
        Cl30(30.00477),
        Cl31(30.992414),
        Cl32(31.98568464),
        Cl33(32.97745199),
        Cl34(33.973762485),
        Cl35(34.968852682),
        Cl36(35.968306809),
        Cl37(36.965902602),
        Cl38(37.96801044),
        Cl39(38.9680082),
        Cl40(39.970415),
        Cl41(40.970685),
        Cl42(41.97325),
        Cl43(42.97389),
        Cl44(43.97787),
        Cl45(44.98029),
        Cl46(45.98517),
        Cl47(46.98916),
        Cl48(47.99564),
        Cl49(49.00123),
        Cl50(50.00905),
        Cl51(51.01554);

        private double atomicMass;

        private Cl(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Cl;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum S implements Isotope
    {
        S26(26.02907),
        S27(27.01828),
        S28(28.00437),
        S29(28.996611),
        S30(29.98490703),
        S31(30.97955701),
        S32(31.9720711744),
        S33(32.9714589098),
        S34(33.967867004),
        S35(34.96903231),
        S36(35.96708071),
        S37(36.97112551),
        S38(37.9711633),
        S39(38.975134),
        S40(39.9754826),
        S41(40.9795935),
        S42(41.9810651),
        S43(42.9869076),
        S44(43.9901188),
        S45(44.99572),
        S46(46.00004),
        S47(47.00795),
        S48(48.0137),
        S49(49.02276);

        private double atomicMass;

        private S(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.S;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum P implements Isotope
    {
        P24(24.03577),
        P25(25.02119),
        P26(26.01178),
        P27(26.999224),
        P28(27.9923266),
        P29(28.98180079),
        P30(29.97831375),
        P31(30.97376199842),
        P32(31.973907643),
        P33(32.9717257),
        P34(33.97364589),
        P35(34.9733141),
        P36(35.97826),
        P37(36.979607),
        P38(37.984252),
        P39(38.986227),
        P40(39.99133),
        P41(40.994654),
        P42(42.00108),
        P43(43.00502),
        P44(44.01121),
        P45(45.01645),
        P46(46.02446),
        P47(47.03139);

        private double atomicMass;

        private P(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.P;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Si implements Isotope
    {
        Si22(22.03579),
        Si23(23.02544),
        Si24(24.011535),
        Si25(25.004109),
        Si26(25.99233384),
        Si27(26.98670481),
        Si28(27.97692653465),
        Si29(28.9764946649),
        Si30(29.973770136),
        Si31(30.975363194),
        Si32(31.97415154),
        Si33(32.97797696),
        Si34(33.978576),
        Si35(34.984583),
        Si36(35.986695),
        Si37(36.992921),
        Si38(37.995523),
        Si39(39.002491),
        Si40(40.00583),
        Si41(41.01301),
        Si42(42.01778),
        Si43(43.0248),
        Si44(44.03061),
        Si45(45.03995);

        private double atomicMass;

        private Si(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Si;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Al implements Isotope
    {
        Al21(21.02897),
        Al22(22.01954),
        Al23(23.00724435),
        Al24(23.9999489),
        Al25(24.9904281),
        Al26(25.986891904),
        Al27(26.98153853),
        Al28(27.98191021),
        Al29(28.9804565),
        Al30(29.98296),
        Al31(30.983945),
        Al32(31.988085),
        Al33(32.990909),
        Al34(33.996705),
        Al35(34.999764),
        Al36(36.00639),
        Al37(37.01053),
        Al38(38.0174),
        Al39(39.02254),
        Al40(40.03003),
        Al41(41.03638),
        Al42(42.04384),
        Al43(43.05147);

        private double atomicMass;

        private Al(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Al;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Mg implements Isotope
    {
        Mg19(19.034169),
        Mg20(20.01885),
        Mg21(21.011716),
        Mg22(21.99957065),
        Mg23(22.99412421),
        Mg24(23.985041697),
        Mg25(24.985836976),
        Mg26(25.982592968),
        Mg27(26.984340624),
        Mg28(27.9838767),
        Mg29(28.988617),
        Mg30(29.9904629),
        Mg31(30.996648),
        Mg32(31.9991102),
        Mg33(33.0053271),
        Mg34(34.008935),
        Mg35(35.01679),
        Mg36(36.02188),
        Mg37(37.03037),
        Mg38(38.03658),
        Mg39(39.04538),
        Mg40(40.05218);

        private double atomicMass;

        private Mg(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Mg;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Na implements Isotope
    {
        Na18(18.02688),
        Na19(19.01388),
        Na20(20.0073544),
        Na21(20.99765469),
        Na22(21.99443741),
        Na23(22.989769282),
        Na24(23.99096295),
        Na25(24.989954),
        Na26(25.9926346),
        Na27(26.9940765),
        Na28(27.998939),
        Na29(29.0028771),
        Na30(30.0090979),
        Na31(31.013163),
        Na32(32.02019),
        Na33(33.02573),
        Na34(34.03359),
        Na35(35.04062),
        Na36(36.04929),
        Na37(37.05705);

        private double atomicMass;

        private Na(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Na;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Ne implements Isotope
    {
        Ne16(16.02575),
        Ne17(17.01771396),
        Ne18(18.0057087),
        Ne19(19.00188091),
        Ne20(19.9924401762),
        Ne21(20.993846685),
        Ne22(21.991385114),
        Ne23(22.99446691),
        Ne24(23.99361065),
        Ne25(24.997789),
        Ne26(26.000515),
        Ne27(27.007553),
        Ne28(28.01212),
        Ne29(29.01975),
        Ne30(30.02473),
        Ne31(31.0331),
        Ne32(32.03972),
        Ne33(33.04938),
        Ne34(34.05673);

        private double atomicMass;

        private Ne(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Ne;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum F implements Isotope
    {
        F14(14.034315),
        F15(15.018043),
        F16(16.0114657),
        F17(17.00209524),
        F18(18.00093733),
        F19(18.99840316273),
        F20(19.999981252),
        F21(20.9999489),
        F22(22.002999),
        F23(23.003557),
        F24(24.008115),
        F25(25.012199),
        F26(26.020038),
        F27(27.02644),
        F28(28.03534),
        F29(29.04254),
        F30(30.05165),
        F31(31.05971);

        private double atomicMass;

        private F(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.F;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum O implements Isotope
    {
        O12(12.034262),
        O13(13.024815),
        O14(14.00859636),
        O15(15.00306562),
        O16(15.99491461957),
        O17(16.9991317565),
        O18(17.99915961286),
        O19(19.003578),
        O20(20.00407535),
        O21(21.008655),
        O22(22.009966),
        O23(23.015696),
        O24(24.01986),
        O25(25.02936),
        O26(26.03729),
        O27(27.04772),
        O28(28.05591);

        private double atomicMass;

        private O(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.O;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum N implements Isotope
    {
        N10(10.04165),
        N11(11.026091),
        N12(12.0186132),
        N13(13.00573861),
        N14(14.00307400443),
        N15(15.00010889888),
        N16(16.0061019),
        N17(17.008449),
        N18(18.014078),
        N19(19.017022),
        N20(20.023366),
        N21(21.02711),
        N22(22.03439),
        N23(23.04114),
        N24(24.05039),
        N25(25.0601);

        private double atomicMass;

        private N(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.N;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum C implements Isotope
    {
        C8(8.037643),
        C9(9.0310372),
        C10(10.01685331),
        C11(11.0114336),
        C12(12.0),
        C13(13.00335483507),
        C14(14.0032419884),
        C15(15.01059926),
        C16(16.0147013),
        C17(17.022577),
        C18(18.026751),
        C19(19.0348),
        C20(20.04032),
        C21(21.049),
        C22(22.05753),
        C23(23.0689);

        private double atomicMass;

        private C(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.C;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum B implements Isotope
    {
        B6(6.0508),
        B7(7.029712),
        B8(8.0246073),
        B9(9.01332965),
        B10(10.01293695),
        B11(11.00930536),
        B12(12.0143527),
        B13(13.0177802),
        B14(14.025404),
        B15(15.031088),
        B16(16.039842),
        B17(17.04699),
        B18(18.05566),
        B19(19.0631),
        B20(20.07207),
        B21(21.08129);

        private double atomicMass;

        private B(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.B;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Be implements Isotope
    {
        Be5(5.0399),
        Be6(6.0197264),
        Be7(7.016928717),
        Be8(8.005305102),
        Be9(9.012183065),
        Be10(10.013534695),
        Be11(11.02166108),
        Be12(12.0269221),
        Be13(13.036135),
        Be14(14.04289),
        Be15(15.05342),
        Be16(16.06167);

        private double atomicMass;

        private Be(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Be;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum Li implements Isotope
    {
        Li3(3.0308),
        Li4(4.02719),
        Li5(5.012538),
        Li6(6.0151228874),
        Li7(7.0160034366),
        Li8(8.022486246),
        Li9(9.02679019),
        Li10(10.035483),
        Li11(11.04372358),
        Li12(12.052517),
        Li13(13.06263);

        private double atomicMass;

        private Li(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.Li;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }

    public static enum He implements Isotope
    {
        He3(3.0160293201),
        He4(4.00260325413),
        He5(5.012057),
        He6(6.018885891),
        He7(7.0279907),
        He8(8.03393439),
        He9(9.043946),
        He10(10.05279);

        private double atomicMass;

        private He(double avgAtomicMass) {
            this.atomicMass = avgAtomicMass;
        }

        @Override
        public double mass() {
            return this.atomicMass;
        }

        @Override
        public Element element() {
            return Element.He;
        }

        @Override
        public Set<Nuclide> nuclides() {
            return Set.of(this);
        }
    }
}

