/*
 * Decompiled with CFR 0.152.
 */
package eu.hoefel.chemistry;

import eu.hoefel.chemistry.ElementCategory;
import eu.hoefel.chemistry.Isotope;
import eu.hoefel.chemistry.NaturalOccurence;
import eu.hoefel.chemistry.Nuclide;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public enum Element implements Nuclide
{
    H("hydrogen", 1.0, 1, 1.00794, 31.0, 120.0, 2.1, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    He("helium", 18.0, 1, 4.0026, 28.0, 140.0, 0.0, ElementCategory.NOBLE_GAS, NaturalOccurence.PRIMORDIAL),
    Li("lithium", 1.0, 2, 6.941, 128.0, 182.0, 0.98, ElementCategory.ALKALI_METAL, NaturalOccurence.PRIMORDIAL),
    Be("beryllium", 2.0, 2, 9.01218, 96.0, 153.0, 1.57, ElementCategory.ALKALINE_EARTH_METAL, NaturalOccurence.PRIMORDIAL),
    B("boron", 13.0, 2, 10.811, 84.0, 192.0, 2.04, ElementCategory.METALLOID, NaturalOccurence.PRIMORDIAL),
    C("carbon", 14.0, 2, 12.011, 76.0, 170.0, 2.55, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    N("nitrogen", 15.0, 2, 14.0067, 71.0, 155.0, 3.04, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    O("oxygen", 16.0, 2, 15.9994, 66.0, 152.0, 3.44, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    F("fluorine", 17.0, 2, 18.9984, 57.0, 147.0, 3.98, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    Ne("neon", 18.0, 2, 20.1797, 58.0, 154.0, 0.0, ElementCategory.NOBLE_GAS, NaturalOccurence.PRIMORDIAL),
    Na("sodium", 1.0, 3, 22.98977, 166.0, 227.0, 0.93, ElementCategory.ALKALI_METAL, NaturalOccurence.PRIMORDIAL),
    Mg("magnesium", 2.0, 3, 24.305, 141.0, 173.0, 1.31, ElementCategory.ALKALINE_EARTH_METAL, NaturalOccurence.PRIMORDIAL),
    Al("aluminium", 13.0, 3, 26.9815384, 121.0, 184.0, 1.61, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Si("silicon", 14.0, 3, 28.0855, 111.0, 210.0, 1.9, ElementCategory.METALLOID, NaturalOccurence.PRIMORDIAL),
    P("phosphorus", 15.0, 3, 30.97376, 107.0, 180.0, 2.19, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    S("sulfur", 16.0, 3, 32.066, 105.0, 180.0, 2.58, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    Cl("chlorine", 17.0, 3, 35.4527, 102.0, 175.0, 3.16, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    Ar("argon", 18.0, 3, 39.948, 106.0, 188.0, 0.0, ElementCategory.NOBLE_GAS, NaturalOccurence.PRIMORDIAL),
    K("potassium", 1.0, 4, 39.0983, 203.0, 275.0, 0.82, ElementCategory.ALKALI_METAL, NaturalOccurence.PRIMORDIAL),
    Ca("calcium", 2.0, 4, 40.078, 176.0, 231.0, 1.0, ElementCategory.ALKALINE_EARTH_METAL, NaturalOccurence.PRIMORDIAL),
    Sc("scandium", 3.0, 4, 44.9559, 170.0, 211.0, 1.36, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Ti("titanium", 4.0, 4, 47.88, 160.0, Double.NaN, 1.54, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    V("vanadium", 5.0, 4, 50.9415, 153.0, Double.NaN, 1.63, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Cr("chromium", 6.0, 4, 51.996, 139.0, Double.NaN, 1.66, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Mn("manganese", 7.0, 4, 54.938043, 139.0, Double.NaN, 1.55, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Fe("iron", 8.0, 4, 55.847, 132.0, Double.NaN, 1.83, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Co("cobalt", 9.0, 4, 58.933194, 126.0, Double.NaN, 1.88, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Ni("nickel", 10.0, 4, 58.6934, 124.0, 163.0, 1.91, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Cu("copper", 11.0, 4, 63.546, 132.0, 140.0, 1.9, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Zn("zinc", 12.0, 4, 65.39, 122.0, 139.0, 1.65, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Ga("gallium", 13.0, 4, 69.723, 122.0, 187.0, 1.81, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Ge("germanium", 14.0, 4, 72.61, 120.0, 211.0, 2.01, ElementCategory.METALLOID, NaturalOccurence.PRIMORDIAL),
    As("arsenic", 15.0, 4, 74.9216, 119.0, 185.0, 2.18, ElementCategory.METALLOID, NaturalOccurence.PRIMORDIAL),
    Se("selenium", 16.0, 4, 78.96, 120.0, 190.0, 2.55, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    Br("bromine", 17.0, 4, 79.904, 120.0, 185.0, 2.96, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    Kr("krypton", 18.0, 4, 83.8, 116.0, 202.0, 0.0, ElementCategory.NOBLE_GAS, NaturalOccurence.PRIMORDIAL),
    Rb("rubidium", 1.0, 5, 85.4678, 220.0, 303.0, 0.82, ElementCategory.ALKALI_METAL, NaturalOccurence.PRIMORDIAL),
    Sr("strontium", 2.0, 5, 87.62, 195.0, 249.0, 0.95, ElementCategory.ALKALINE_EARTH_METAL, NaturalOccurence.PRIMORDIAL),
    Y("yttrium", 3.0, 5, 88.9059, 190.0, Double.NaN, 1.22, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Zr("zirconium", 4.0, 5, 91.224, 175.0, Double.NaN, 1.33, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Nb("niobium", 5.0, 5, 92.90637, 164.0, Double.NaN, 1.6, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Mo("molybdenum", 6.0, 5, 95.94, 154.0, Double.NaN, 2.16, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Tc("technetium", 7.0, 5, 98.0, 147.0, Double.NaN, 1.9, ElementCategory.TRANSITION_METAL, NaturalOccurence.FROM_DECAY),
    Ru("ruthenium", 8.0, 5, 101.07, 146.0, Double.NaN, 2.2, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Rh("rhodium", 9.0, 5, 102.9055, 142.0, Double.NaN, 2.28, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Pd("palladium", 10.0, 5, 106.42, 139.0, 163.0, 2.2, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Ag("silver", 11.0, 5, 107.868, 145.0, 172.0, 1.93, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Cd("cadmium", 12.0, 5, 112.41, 144.0, 158.0, 1.69, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    In("indium", 13.0, 5, 114.82, 142.0, 193.0, 1.78, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Sn("tin", 14.0, 5, 118.71, 139.0, 217.0, 1.96, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Sb("antimony", 15.0, 5, 121.757, 139.0, 206.0, 2.05, ElementCategory.METALLOID, NaturalOccurence.PRIMORDIAL),
    Te("tellurium", 16.0, 5, 127.6, 138.0, 206.0, 2.1, ElementCategory.METALLOID, NaturalOccurence.PRIMORDIAL),
    I("iodine", 17.0, 5, 126.9045, 139.0, 198.0, 2.66, ElementCategory.REACTIVE_NONMETAL, NaturalOccurence.PRIMORDIAL),
    Xe("xenon", 18.0, 5, 131.29, 140.0, 216.0, 2.6, ElementCategory.NOBLE_GAS, NaturalOccurence.PRIMORDIAL),
    Cs("caesium", 1.0, 6, 132.9054, 244.0, 343.0, 0.79, ElementCategory.ALKALI_METAL, NaturalOccurence.PRIMORDIAL),
    Ba("barium", 2.0, 6, 137.33, 215.0, 268.0, 0.89, ElementCategory.ALKALINE_EARTH_METAL, NaturalOccurence.PRIMORDIAL),
    La("lanthanum", 3.0, 6, 138.9055, 207.0, Double.NaN, 1.1, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Ce("cerium", Double.NaN, 6, 140.12, 204.0, Double.NaN, 1.12, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Pr("praseodymium", Double.NaN, 6, 140.9077, 203.0, Double.NaN, 1.13, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Nd("neodymium", Double.NaN, 6, 144.24, 201.0, Double.NaN, 1.14, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Pm("promethium", Double.NaN, 6, 145.0, 199.0, Double.NaN, 1.13, ElementCategory.LANTHANOIDE, NaturalOccurence.FROM_DECAY),
    Sm("samarium", Double.NaN, 6, 150.36, 198.0, Double.NaN, 1.17, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Eu("europium", Double.NaN, 6, 151.965, 198.0, Double.NaN, 1.2, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Gd("gadolinium", Double.NaN, 6, 157.25, 196.0, Double.NaN, 1.2, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Tb("terbium", Double.NaN, 6, 158.9253, 194.0, Double.NaN, 1.1, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Dy("dysprosium", Double.NaN, 6, 162.5, 192.0, Double.NaN, 1.22, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Ho("holmium", Double.NaN, 6, 164.930328, 192.0, Double.NaN, 1.23, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Er("erbium", Double.NaN, 6, 167.26, 189.0, Double.NaN, 1.24, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Tm("thulium", Double.NaN, 6, 168.9342, 190.0, Double.NaN, 1.25, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Yb("ytterbium", Double.NaN, 6, 173.04, 187.0, Double.NaN, 1.1, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Lu("lutetium", Double.NaN, 6, 174.967, 175.0, Double.NaN, 1.27, ElementCategory.LANTHANOIDE, NaturalOccurence.PRIMORDIAL),
    Hf("hafnium", 4.0, 6, 178.49, 187.0, Double.NaN, 1.3, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Ta("tantalum", 5.0, 6, 180.9479, 170.0, Double.NaN, 1.5, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    W("tungsten", 6.0, 6, 183.85, 162.0, Double.NaN, 2.36, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Re("rhenium", 7.0, 6, 186.207, 151.0, Double.NaN, 1.9, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Os("osmium", 8.0, 6, 190.2, 144.0, Double.NaN, 2.2, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Ir("iridium", 9.0, 6, 192.217, 141.0, Double.NaN, 2.2, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Pt("platinum", 10.0, 6, 195.08, 136.0, 175.0, 2.28, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Au("gold", 11.0, 6, 196.96657, 136.0, 166.0, 2.54, ElementCategory.TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Hg("mercury", 12.0, 6, (double)200.59f, 132.0, 155.0, 2.0, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Tl("thallium", 13.0, 6, 204.383, 145.0, 196.0, 2.04, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Pb("lead", 14.0, 6, 207.2, 146.0, 202.0, 2.33, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Bi("bismuth", 15.0, 6, 208.9804, 148.0, 207.0, 2.02, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.PRIMORDIAL),
    Po("polonium", 16.0, 6, 209.0, 140.0, 197.0, 2.0, ElementCategory.POST_TRANSITION_METAL, NaturalOccurence.FROM_DECAY),
    At("astatine", 17.0, 6, 210.0, 150.0, 202.0, 2.2, ElementCategory.METALLOID, NaturalOccurence.FROM_DECAY),
    Rn("radon", 18.0, 6, 222.0, 150.0, 220.0, 0.0, ElementCategory.NOBLE_GAS, NaturalOccurence.FROM_DECAY),
    Fr("francium", 1.0, 7, 223.0, 260.0, 348.0, 0.7, ElementCategory.ALKALI_METAL, NaturalOccurence.FROM_DECAY),
    Ra("radium", 2.0, 7, 226.0254, 221.0, 283.0, 0.89, ElementCategory.ALKALINE_EARTH_METAL, NaturalOccurence.FROM_DECAY),
    Ac("actinium", 3.0, 7, 227.0, 215.0, Double.NaN, 1.1, ElementCategory.ACTINOIDE, NaturalOccurence.FROM_DECAY),
    Th("thorium", Double.NaN, 7, 232.0381, 206.0, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.PRIMORDIAL),
    Pa("protactinium", Double.NaN, 7, 231.0359, 200.0, Double.NaN, 1.5, ElementCategory.ACTINOIDE, NaturalOccurence.FROM_DECAY),
    U("uranium", Double.NaN, 7, 238.029, 196.0, 186.0, 1.38, ElementCategory.ACTINOIDE, NaturalOccurence.PRIMORDIAL),
    Np("neptunium", Double.NaN, 7, 237.0482, 190.0, Double.NaN, 1.36, ElementCategory.ACTINOIDE, NaturalOccurence.FROM_DECAY),
    Pu("plutonium", Double.NaN, 7, 244.0, 187.0, Double.NaN, 1.28, ElementCategory.ACTINOIDE, NaturalOccurence.FROM_DECAY),
    Am("americium", Double.NaN, 7, 243.0, 180.0, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Cm("curium", Double.NaN, 7, 247.0, 169.0, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Bk("berkelium", Double.NaN, 7, 247.0, Double.NaN, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Cf("californium", Double.NaN, 7, 251.0, Double.NaN, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Es("einsteinium", Double.NaN, 7, 252.0, Double.NaN, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Fm("fermium", Double.NaN, 7, 257.0, Double.NaN, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Md("mendelevium", Double.NaN, 7, 258.0, Double.NaN, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    No("nobelium", Double.NaN, 7, 259.0, Double.NaN, Double.NaN, 1.3, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Lr("lawrencium", Double.NaN, 7, 266.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.ACTINOIDE, NaturalOccurence.SYNTHETIC),
    Rf("rutherfordium", 4.0, 7, 267.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.TRANSITION_METAL, NaturalOccurence.SYNTHETIC),
    Db("dubnium", 5.0, 7, 268.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.TRANSITION_METAL, NaturalOccurence.SYNTHETIC),
    Sg("seaborgium", 6.0, 7, 269.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.TRANSITION_METAL, NaturalOccurence.SYNTHETIC),
    Bh("bohrium", 7.0, 7, 270.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.TRANSITION_METAL, NaturalOccurence.SYNTHETIC),
    Hs("hassium", 8.0, 7, 270.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.TRANSITION_METAL, NaturalOccurence.SYNTHETIC),
    Mt("meitnerium", 9.0, 7, 278.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Ds("darmstadtium", 10.0, 7, 281.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Rg("roentgenium", 11.0, 7, 282.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Cn("copernicium", 12.0, 7, 285.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Nh("nihonium", 13.0, 7, 286.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Fl("flerovium", 14.0, 7, 289.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Mc("moscovium", 15.0, 7, 290.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Lv("livermorium", 16.0, 7, 293.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Ts("tennessine", 17.0, 7, 294.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC),
    Og("oganesson", 18.0, 7, 294.0, Double.NaN, Double.NaN, Double.NaN, ElementCategory.UNKNOWN, NaturalOccurence.SYNTHETIC);

    private String name;
    private double group;
    private int period;
    private double avgAtomicMass;
    private double covalentRadius;
    private double vdWRadius;
    private double electroNegativity;
    private ElementCategory prop;
    private NaturalOccurence occurence;
    private List<Isotope> isotopes;

    private Element(String name, double group, int period, double avgAtomicMass, double covalentRadius, double vdWRadius, double electroNegativity, ElementCategory prop, NaturalOccurence occurence) {
        this.name = name;
        this.group = group;
        this.period = period;
        this.avgAtomicMass = avgAtomicMass;
        this.covalentRadius = covalentRadius;
        this.vdWRadius = vdWRadius;
        this.electroNegativity = electroNegativity;
        this.prop = prop;
        this.occurence = occurence;
    }

    public String fullName() {
        return this.name;
    }

    public double group() {
        return this.group;
    }

    public int period() {
        return this.period;
    }

    @Override
    public double mass() {
        return this.avgAtomicMass;
    }

    public double covalentRadius() {
        return this.covalentRadius;
    }

    public double vanderWaalsRadius() {
        return this.vdWRadius;
    }

    public double electronegativity() {
        return this.electroNegativity;
    }

    public ElementCategory category() {
        return this.prop;
    }

    public NaturalOccurence occurence() {
        return this.occurence;
    }

    public int atomicNumber() {
        return this.ordinal() + 1;
    }

    public static final Element withAtomicNumber(int atomicNumber) {
        for (Element element : Element.values()) {
            if (element.atomicNumber() != atomicNumber) continue;
            return element;
        }
        throw new IllegalArgumentException("Found no element with an atomic number of " + atomicNumber);
    }

    public static final boolean isElement(String name) {
        return name != null && Element.parseName(name) != null;
    }

    public static final Element named(String name) {
        Objects.requireNonNull(name);
        Element e = Element.parseName(name);
        if (e == null) {
            throw new IllegalArgumentException("Found no element named '" + name + "'");
        }
        return e;
    }

    static final Element parseName(String name) {
        for (Element element : Element.values()) {
            if (!element.name().equals(name) && !element.fullName().equalsIgnoreCase(name)) continue;
            return element;
        }
        if ("aluminum".equalsIgnoreCase(name)) {
            return Al;
        }
        if ("sulphur".equalsIgnoreCase(name)) {
            return S;
        }
        if ("cesium".equalsIgnoreCase(name)) {
            return Cs;
        }
        if ("plumbum".equalsIgnoreCase(name)) {
            return Pb;
        }
        return null;
    }

    public static List<Element> get(ElementCategory prop) {
        ArrayList<Element> ret = new ArrayList<Element>();
        for (Element elem : Element.values()) {
            if (elem.category() != prop) continue;
            ret.add(elem);
        }
        return ret;
    }

    public static List<Element> get(NaturalOccurence occurrence) {
        ArrayList<Element> ret = new ArrayList<Element>();
        for (Element elem : Element.values()) {
            if (elem.occurence() != occurrence) continue;
            ret.add(elem);
        }
        return ret;
    }

    public List<Isotope> isotopes() {
        if (this.isotopes == null) {
            this.isotopes = Isotope.ofElement(this);
        }
        return this.isotopes;
    }

    @Override
    public Element element() {
        return this;
    }

    @Override
    public boolean isIsotope() {
        return false;
    }

    @Override
    public Set<Nuclide> nuclides() {
        return Set.of(this);
    }
}

