/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.propertiesdecrypter;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.salt.SaltGenerator;
import org.jasypt.salt.ZeroSaltGenerator;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class DecryptingPropertiesApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    static final String PASSWORD_PROPERTY = "propertyDecryption.password";
    public static final String DEFAULT_ALGORITHM = "PBEWithMD5AndDES";
    public static final String PREFIX_KEY = "propertyDecryption.prefix";
    private String prefix;
    private StandardPBEStringEncryptor encrypter = new StandardPBEStringEncryptor();

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        this.initializeEncrypter((Environment)environment);
        this.prefix = environment.getProperty(PREFIX_KEY, "{encrypted}");
        MutablePropertySources propertySources = environment.getPropertySources();
        List<String> encryptedKeys = this.getKeysOfEncryptedPropertyValues((Environment)environment, propertySources);
        this.addDecryptedValues((Environment)environment, propertySources, encryptedKeys);
    }

    private void initializeEncrypter(Environment environment) {
        this.encrypter.setAlgorithm(environment.getProperty("propertyDecryption.algorithm", DEFAULT_ALGORITHM));
        this.encrypter.setSaltGenerator((SaltGenerator)new ZeroSaltGenerator());
        this.encrypter.setPassword(environment.getRequiredProperty(PASSWORD_PROPERTY));
    }

    private List<String> getKeysOfEncryptedPropertyValues(Environment environment, MutablePropertySources propertySources) {
        Stream<PropertySource<?>> stream = this.getPropertySourceStream(propertySources);
        return stream.filter(source -> source instanceof EnumerablePropertySource).map(source -> (EnumerablePropertySource)source).flatMap(source -> Arrays.asList(source.getPropertyNames()).stream()).filter(key -> !PREFIX_KEY.equals(key)).filter(key -> this.isEncrypted(environment.getProperty(key))).collect(Collectors.toList());
    }

    private Stream<PropertySource<?>> getPropertySourceStream(MutablePropertySources propertySources) {
        Iterator iterator = propertySources.iterator();
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private void addDecryptedValues(Environment environment, MutablePropertySources propertySources, List<String> encryptedKeys) {
        Properties decryptedValues = new Properties();
        encryptedKeys.stream().forEach(key -> {
            String value = environment.getProperty(key);
            decryptedValues.put(key, this.decryptPropertyValue(value));
        });
        propertySources.addFirst((PropertySource)new PropertiesPropertySource("decryptedValues", decryptedValues));
    }

    private String decryptPropertyValue(String encryptedPropertyValue) {
        String cypher = this.getCypher(encryptedPropertyValue);
        try {
            return this.encrypter.decrypt(cypher);
        }
        catch (EncryptionOperationNotPossibleException e) {
            throw new RuntimeException("Unable to decrypt property value '" + encryptedPropertyValue + "'", e);
        }
    }

    private boolean isEncrypted(Object propertyValue) {
        return propertyValue != null && propertyValue instanceof String && ((String)propertyValue).startsWith(this.prefix);
    }

    private String getCypher(String encryptedPropertyValue) {
        return encryptedPropertyValue.substring(this.prefix.length());
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

