/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.logging;

import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.logging.LoggingApplicationListener;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;

public class ExtendedLoggingPropertiesListener
extends LoggingApplicationListener {
    private static final String KEY_PREFIX = "logging.properties.";

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            this.addLoggingProperties((ApplicationEnvironmentPreparedEvent)event);
        }
        super.onApplicationEvent(event);
    }

    public void addLoggingProperties(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        new RelaxedPropertyResolver((PropertyResolver)environment).getSubProperties(KEY_PREFIX).entrySet().stream().forEach(entry -> System.setProperty((String)entry.getKey(), entry.getValue().toString()));
    }

    public int getOrder() {
        return -2147483636;
    }
}

