/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.logging;

import java.util.Map;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;

public class ExtendedLoggingPropertiesListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final String KEY_PREFIX = "logging.properties.";
    private static final String PROPERTY_PREFIX = "LOGGING_";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        new RelaxedPropertyResolver((PropertyResolver)environment).getSubProperties(KEY_PREFIX).entrySet().stream().forEach(this::setSystemProperty);
    }

    private String setSystemProperty(Map.Entry<String, Object> entry) {
        String loggingKey = this.createLoggingKey(entry.getKey());
        String value = entry.getValue().toString();
        return System.setProperty(loggingKey, value);
    }

    private String createLoggingKey(String key) {
        return PROPERTY_PREFIX + key.toUpperCase().replace(".", "_");
    }

    public int getOrder() {
        return -2147483637;
    }
}

