/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.metric;

import eu.hinsch.spring.boot.actuator.metric.ExecutionMetric;
import eu.hinsch.spring.boot.actuator.metric.ExecutionMetricFactory;
import eu.hinsch.spring.boot.actuator.metric.SupplierMetric;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;

@Aspect
public class ExecutionMetricAspect {
    private Map<String, SupplierMetric<Object>> store = new ConcurrentHashMap<String, SupplierMetric<Object>>();
    private final ExecutionMetricFactory factory;

    @Autowired
    public ExecutionMetricAspect(GaugeService gaugeService, CounterService counterService) {
        this.factory = new ExecutionMetricFactory(counterService, gaugeService);
    }

    @Around(value="@annotation(eu.hinsch.spring.boot.actuator.metric.ExecutionMetric)")
    public Object measure(ProceedingJoinPoint joinPoint) throws Throwable {
        ExecutionMetric executionMetric = this.getExecutionMetric(joinPoint);
        Logger targetLogger = LoggerFactory.getLogger((Class)this.getClassForLogger(joinPoint));
        String metricName = executionMetric.value();
        SupplierMetric supplierMetric = this.store.computeIfAbsent(metricName, name -> this.factory.supplierMetric((String)name, targetLogger, executionMetric.loglevel()));
        return supplierMetric.measure(() -> {
            try {
                return joinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new RuntimeException("error invoking method", throwable);
            }
        });
    }

    private Class getClassForLogger(ProceedingJoinPoint joinPoint) throws Exception {
        Class loggerClass = AopUtils.getTargetClass((Object)joinPoint.getTarget());
        if (loggerClass.getName().contains("$$EnhancerBySpringCGLIB$$")) {
            loggerClass = loggerClass.getSuperclass();
        }
        return loggerClass;
    }

    private ExecutionMetric getExecutionMetric(ProceedingJoinPoint joinPoint) throws NoSuchMethodException {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ExecutionMetric executionMetric = method.getAnnotation(ExecutionMetric.class);
        if (executionMetric == null && method.getDeclaringClass().isInterface()) {
            String methodName = signature.getName();
            Method implementationMethod = joinPoint.getTarget().getClass().getDeclaredMethod(methodName, new Class[0]);
            executionMetric = implementationMethod.getAnnotation(ExecutionMetric.class);
        }
        return executionMetric;
    }
}

