/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.metric;

public class Histogram {
    private long count;
    private double average;
    private Long max;
    private Long min;

    public synchronized void addValue(long value) {
        this.calculateAverage(value);
        this.calculateMax(value);
        this.calculateMin(value);
        ++this.count;
    }

    private void calculateAverage(long value) {
        this.average = (this.getTotal() + (double)value) / (double)(this.count + 1L);
    }

    private void calculateMin(long value) {
        this.min = this.min != null ? Long.valueOf(Math.min(this.min, value)) : Long.valueOf(value);
    }

    private void calculateMax(long value) {
        this.max = this.max != null ? Long.valueOf(Math.max(this.max, value)) : Long.valueOf(value);
    }

    private double getTotal() {
        return this.average * (double)this.count;
    }

    public double getAverage() {
        return this.average;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }
}

