/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.metric;

import eu.hinsch.spring.boot.actuator.metric.ExecutorMetric;
import eu.hinsch.spring.boot.actuator.metric.SupplierMetric;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.logging.LogLevel;

public class ExecutionMetricFactory {
    private final CounterService counterService;
    private final GaugeService gaugeService;

    @Autowired
    public ExecutionMetricFactory(CounterService counterService, GaugeService gaugeService) {
        this.counterService = counterService;
        this.gaugeService = gaugeService;
    }

    public <T> SupplierMetric<T> supplierMetric(String name, Logger logger, LogLevel logLevel) {
        return new SupplierMetric(this.gaugeService, this.counterService, name, logger, logLevel);
    }

    public <T> SupplierMetric<T> supplierMetric(String name, Logger logger) {
        return new SupplierMetric(this.gaugeService, this.counterService, name, logger);
    }

    public <T> SupplierMetric<T> supplierMetric(String name) {
        return new SupplierMetric(this.gaugeService, this.counterService, name);
    }

    public ExecutorMetric executorMetric(String name, Logger logger) {
        return new ExecutorMetric(this.gaugeService, this.counterService, name, logger);
    }

    public ExecutorMetric executorMetric(String name, Logger logger, LogLevel logLevel) {
        return new ExecutorMetric(this.gaugeService, this.counterService, name, logger, logLevel);
    }

    public ExecutorMetric executorMetric(String name) {
        return new ExecutorMetric(this.gaugeService, this.counterService, name);
    }
}

