/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.metric;

import eu.hinsch.spring.boot.actuator.metric.Histogram;
import org.slf4j.Logger;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.StopWatch;

public abstract class AbstractExecutionMetric {
    private final GaugeService gaugeService;
    private final CounterService counterService;
    protected final String name;
    private final Logger logger;
    private LogLevel logLevel;
    private Histogram histogram;

    public AbstractExecutionMetric(GaugeService gaugeService, CounterService counterService, String name) {
        this(gaugeService, counterService, name, null);
    }

    public AbstractExecutionMetric(GaugeService gaugeService, CounterService counterService, String name, Logger logger, LogLevel logLevel) {
        this.gaugeService = gaugeService;
        this.counterService = counterService;
        this.name = name;
        this.logger = logger;
        this.logLevel = logLevel;
        this.histogram = new Histogram();
    }

    public AbstractExecutionMetric(GaugeService gaugeService, CounterService counterService, String name, Logger logger) {
        this(gaugeService, counterService, name, logger, LogLevel.OFF);
    }

    protected StopWatch start() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    protected void finish(StopWatch stopWatch) {
        stopWatch.stop();
        long duration = stopWatch.getLastTaskTimeMillis();
        if (this.logger != null && this.logLevel != LogLevel.OFF) {
            String msg = "Executing {} took {}ms";
            switch (this.logLevel) {
                case TRACE: {
                    this.logger.trace(msg, (Object)this.name, (Object)duration);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(msg, (Object)this.name, (Object)duration);
                    break;
                }
                case INFO: {
                    this.logger.info(msg, (Object)this.name, (Object)duration);
                    break;
                }
                case WARN: {
                    this.logger.warn(msg, (Object)this.name, (Object)duration);
                    break;
                }
                case ERROR: {
                    this.logger.error(msg, (Object)this.name, (Object)duration);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported loglevel: " + this.logLevel);
                }
            }
        }
        this.submit(duration);
    }

    protected synchronized void submit(long duration) {
        this.histogram.addValue(duration);
        this.gaugeService.submit(this.name + ".last", (double)duration);
        this.gaugeService.submit(this.name + ".average", (double)Double.valueOf(this.histogram.getAverage()).longValue());
        this.gaugeService.submit(this.name + ".max", (double)this.histogram.getMax());
        this.gaugeService.submit(this.name + ".min", (double)this.histogram.getMin());
        this.counterService.increment(this.name);
    }
}

