/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.useragent;

import eu.hinsch.spring.boot.actuator.useragent.UserAgentMetricFilterConfiguration;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class UserAgentMetricFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(UserAgentMetricFilter.class);
    private static final String METRIC_NAME = "user-agent";
    private final MeterRegistry meterRegistry;
    private final UserAgentMetricFilterConfiguration configuration;
    private UserAgentAnalyzer userAgentAnalyzer;
    private List<Pattern> excludePatterns;

    @PostConstruct
    public void initialize() {
        UserAgentAnalyzer.UserAgentAnalyzerBuilder builder = (UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(this.configuration.getCacheSize()).withFields((String[])this.configuration.getTags().toArray(String[]::new));
        if (this.configuration.isInitOnStartup()) {
            builder.preheat();
        }
        this.userAgentAnalyzer = builder.build();
        this.excludePatterns = this.configuration.getExcludePatterns().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        String userAgentString = request.getHeader("User-Agent");
        if (StringUtils.hasText((String)userAgentString)) {
            if (log.isDebugEnabled()) {
                log.debug("User agent: " + userAgentString);
            }
            UserAgent agent = this.userAgentAnalyzer.parse(userAgentString);
            List tags = this.configuration.getTags().stream().map(tag -> Tag.of((String)tag, (String)agent.getValue(tag))).collect(Collectors.toList());
            this.meterRegistry.counter(METRIC_NAME, tags).increment();
        }
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        return this.excludePatterns.stream().anyMatch(pattern -> pattern.matcher(request.getRequestURI()).matches());
    }

    public UserAgentMetricFilter(MeterRegistry meterRegistry, UserAgentMetricFilterConfiguration configuration) {
        this.meterRegistry = meterRegistry;
        this.configuration = configuration;
    }
}

