/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.useragent;

import eu.hinsch.spring.boot.actuator.useragent.UserAgentMetricFilterConfiguration;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class UserAgentMetricFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(UserAgentMetricFilter.class);
    private static final String METRIC_NAME = "user-agent";
    private final MeterRegistry meterRegistry;
    private final UserAgentMetricFilterConfiguration configuration;
    private UserAgentAnalyzer uaa;

    @PostConstruct
    public void buildAnalyzer() {
        this.uaa = ((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().hideMatcherLoadStats()).withCache(this.configuration.getCacheSize()).build();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        String userAgentString = request.getHeader("User-Agent");
        if (StringUtils.hasText((String)userAgentString)) {
            log.debug("User agent: " + userAgentString);
            UserAgent agent = this.uaa.parse(userAgentString);
            List tags = this.configuration.getTags().stream().map(tag -> Tag.of((String)tag, (String)agent.getValue(tag))).collect(Collectors.toList());
            this.meterRegistry.counter(METRIC_NAME, tags).increment();
        }
    }

    public UserAgentMetricFilter(MeterRegistry meterRegistry, UserAgentMetricFilterConfiguration configuration) {
        this.meterRegistry = meterRegistry;
        this.configuration = configuration;
    }
}

