/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.useragent;

import net.sf.uadetector.ReadableUserAgent;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.service.UADetectorServiceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"user-agent-metric.enabled"}, havingValue="true")
@Component
public class UserAgentParser {
    private final UserAgentStringParser resourceModuleParser = UADetectorServiceFactory.getResourceModuleParser();

    @Cacheable(value={"user-agent-parser"})
    public ReadableUserAgent parseUserAgentString(String userAgentString) {
        return this.resourceModuleParser.parse(userAgentString);
    }
}

