/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.useragent;

import eu.hinsch.spring.boot.actuator.useragent.UserAgentMetricFilter;
import eu.hinsch.spring.boot.actuator.useragent.UserAgentMetricFilterConfiguration;
import eu.hinsch.spring.boot.actuator.useragent.UserAgentParser;
import io.micrometer.core.instrument.MeterRegistry;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackageClasses={UserAgentMetricFilterAutoConfiguration.class})
public class UserAgentMetricFilterAutoConfiguration {
    @ConditionalOnProperty(value={"user-agent-metric.enabled"}, havingValue="true")
    @Bean
    FilterRegistrationBean<UserAgentMetricFilter> userAgentMetricFilterRegistrationBean(UserAgentMetricFilter userAgentMetricFilter, UserAgentMetricFilterConfiguration configuration) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)userAgentMetricFilter);
        if (!configuration.getUrlPatterns().isEmpty()) {
            bean.setUrlPatterns(configuration.getUrlPatterns());
        }
        return bean;
    }

    @ConditionalOnProperty(value={"user-agent-metric.enabled"}, havingValue="true")
    @Bean
    UserAgentMetricFilter userAgentMetricFilter(MeterRegistry meterRegistry, BeanFactory beanFactory, UserAgentParser userAgentParser, UserAgentMetricFilterConfiguration configuration) {
        return new UserAgentMetricFilter(meterRegistry, beanFactory, configuration, userAgentParser);
    }
}

