/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.useragent;

import eu.hinsch.spring.boot.actuator.useragent.UserAgentMetricFilterConfiguration;
import eu.hinsch.spring.boot.actuator.useragent.UserAgentParser;
import eu.hinsch.spring.boot.actuator.useragent.WithCurrentRequestBeanFactoryResolver;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.uadetector.ReadableUserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class UserAgentMetricFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(UserAgentMetricFilter.class);
    private static final String METRIC_NAME = "user-agent";
    private final MeterRegistry meterRegistry;
    private final BeanFactory beanFactory;
    private final UserAgentMetricFilterConfiguration configuration;
    private final UserAgentParser userAgentParser;
    private final SpelExpressionParser parser = new SpelExpressionParser();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        String userAgentString = request.getHeader("User-Agent");
        if (StringUtils.hasText((String)userAgentString)) {
            log.debug("User agent: " + userAgentString);
            ReadableUserAgent userAgent = this.userAgentParser.parseUserAgentString(userAgentString);
            List tags = this.configuration.getTags().entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)this.evaluatePattern(userAgent, (String)entry.getValue(), request))).collect(Collectors.toList());
            this.meterRegistry.counter(METRIC_NAME, tags).increment();
        }
    }

    private String evaluatePattern(ReadableUserAgent userAgent, String pattern, HttpServletRequest request) {
        Expression expression = this.parser.parseExpression(pattern);
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new WithCurrentRequestBeanFactoryResolver(this.beanFactory, request));
        context.setRootObject((Object)userAgent);
        return String.valueOf(expression.getValue((EvaluationContext)context));
    }

    public UserAgentMetricFilter(MeterRegistry meterRegistry, BeanFactory beanFactory, UserAgentMetricFilterConfiguration configuration, UserAgentParser userAgentParser) {
        this.meterRegistry = meterRegistry;
        this.beanFactory = beanFactory;
        this.configuration = configuration;
        this.userAgentParser = userAgentParser;
    }
}

