/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.boot.actuator.useragent;

import eu.hinsch.spring.boot.actuator.useragent.UserAgentMetricFilterConfiguration;
import eu.hinsch.spring.boot.actuator.useragent.WithCurrentRequestBeanFactoryResolver;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.sf.uadetector.ReadableUserAgent;
import net.sf.uadetector.service.UADetectorServiceFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class UserAgentMetricFilter
implements Filter {
    private static final String DEFAULT_KEY = "#this.name + '.' + #this.versionNumber.major";
    private final CounterService counterService;
    private final BeanFactory beanFactory;
    private final List<String> keys;
    private final SpelExpressionParser parser = new SpelExpressionParser();

    @Autowired
    public UserAgentMetricFilter(CounterService counterService, BeanFactory beanFactory, UserAgentMetricFilterConfiguration configuration) {
        this.counterService = counterService;
        this.beanFactory = beanFactory;
        this.keys = !configuration.getKeys().isEmpty() ? configuration.getKeys() : Arrays.asList(DEFAULT_KEY);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            String userAgentString = httpServletRequest.getHeader("User-Agent");
            ReadableUserAgent userAgent = UADetectorServiceFactory.getResourceModuleParser().parse(userAgentString);
            this.keys.stream().map(key -> this.evaluatePattern(userAgent, (String)key, httpServletRequest)).map(this::formatKey).forEach(arg_0 -> ((CounterService)this.counterService).increment(arg_0));
        }
    }

    private String evaluatePattern(ReadableUserAgent userAgent, String pattern, HttpServletRequest request) {
        Expression expression = this.parser.parseExpression(pattern);
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new WithCurrentRequestBeanFactoryResolver(this.beanFactory, request));
        context.setRootObject((Object)userAgent);
        return String.valueOf(expression.getValue((EvaluationContext)context));
    }

    private String formatKey(String name) {
        return name.replace(" ", "-").toLowerCase();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

