/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.angular.cache;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class UrlRewritingRequestWrapper
extends HttpServletRequestWrapper {
    private final HttpServletRequest request;
    private String url;
    private Map<String, String> headers;

    public UrlRewritingRequestWrapper(HttpServletRequest request, String url, Map<String, String> headers) {
        super(request);
        this.request = request;
        this.url = url;
        this.headers = headers;
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath();
    }

    public StringBuffer getRequestURL() {
        StringBuffer originalRequestURL = this.request.getRequestURL();
        String prefix = originalRequestURL.substring(0, originalRequestURL.length() - this.request.getServletPath().length());
        return new StringBuffer(prefix + this.getServletPath());
    }

    public String getServletPath() {
        return this.url.startsWith("/") ? this.url : "/" + this.url;
    }

    public int getIntHeader(String name) {
        if (this.headers.containsKey(name)) {
            return Integer.parseInt(this.headers.get(name));
        }
        return super.getIntHeader(name);
    }

    public String getHeader(String name) {
        return this.headers.getOrDefault(name, super.getHeader(name));
    }

    public Enumeration<String> getHeaders(String name) {
        HashSet values = new HashSet(Collections.list(super.getHeaders(name)));
        values.add(this.headers.get(name));
        return Collections.enumeration(values);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet names = new HashSet(Collections.list(super.getHeaderNames()));
        names.addAll(this.headers.keySet());
        return Collections.enumeration(names);
    }

    public String getContentType() {
        return this.headers.getOrDefault("Content-Type", super.getContentType());
    }
}

