/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.spring.angular.cache;

import eu.hinsch.spring.angular.cache.AngularRestCachePreloadConfiguration;
import eu.hinsch.spring.angular.cache.ContentBufferingResponse;
import eu.hinsch.spring.angular.cache.UrlRewritingRequestWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.io.Resource;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.ResourceTransformerSupport;
import org.springframework.web.servlet.resource.TransformedResource;

@Component
public class AngularRestCachePreloadTransformer
extends ResourceTransformerSupport {
    private AngularRestCachePreloadConfiguration config;
    private DispatcherServlet dispatcherServlet;
    private final Configuration freemarkerConfig;
    private final SpelExpressionParser expressionParser;
    private final StandardEvaluationContext evaluationContext;

    @Autowired
    public AngularRestCachePreloadTransformer(AngularRestCachePreloadConfiguration config, DispatcherServlet dispatcherServlet, BeanFactory beanFactory) {
        this.config = config;
        this.dispatcherServlet = dispatcherServlet;
        this.expressionParser = new SpelExpressionParser();
        this.evaluationContext = new StandardEvaluationContext();
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        this.freemarkerConfig = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.freemarkerConfig.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "/templates");
    }

    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        Resource transformedResource = transformerChain.transform(request, resource);
        String content = IOUtils.toString((InputStream)transformedResource.getInputStream());
        Map<String, String> cache = this.createCache(request);
        String script = this.createScript(cache);
        content = content.replace(this.config.getPlaceholder(), script);
        return new TransformedResource(transformedResource, content.getBytes("UTF-8"));
    }

    private Map<String, String> createCache(HttpServletRequest request) {
        HashMap<String, String> cache = new HashMap<String, String>();
        this.config.getCachedUrls().stream().map(this::replaceParameters).forEach(url -> this.doRequestAndAddToCache(request, (Map<String, String>)cache, (String)url));
        return cache;
    }

    private String replaceParameters(AngularRestCachePreloadConfiguration.CachedUrl cachedUrl) {
        String url = cachedUrl.getUrl();
        for (Map.Entry<String, String> parameter : cachedUrl.getParameters().entrySet()) {
            url = url.replace("{" + parameter.getKey() + "}", this.getParameterValue(parameter.getValue()));
        }
        return url;
    }

    private String getParameterValue(String value) {
        Expression expression = this.expressionParser.parseExpression(value);
        return String.valueOf(expression.getValue((EvaluationContext)this.evaluationContext));
    }

    private void doRequestAndAddToCache(HttpServletRequest request, Map<String, String> cache, String url) {
        ContentBufferingResponse response = new ContentBufferingResponse();
        try {
            this.dispatcherServlet.service((ServletRequest)new UrlRewritingRequestWrapper(request, url), (ServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("error caching request " + url, e);
        }
        String controllerResponse = response.getResponseContent();
        cache.put(url, controllerResponse);
    }

    private String createScript(Map<String, String> cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("module", this.config.getAngularModule());
        model.put("caches", cache.entrySet());
        try {
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)this.freemarkerConfig.getTemplate("preload-cache.html.ftl"), model);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException("error processing template", e);
        }
    }
}

