/*
 * Decompiled with CFR 0.152.
 */
package eu.hinsch.cew;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.MultiTypeParameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import eu.hinsch.cew.CheckedExceptionWrapperGeneratorPluginExtension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class GenerateCheckedExceptionWrappersTask
extends DefaultTask {
    private static final String JAVA = ".java";
    private static final String CONFIGURATION = "checkedExceptionWrapperGenerator";
    private final CheckedExceptionWrapperGeneratorPluginExtension extension = (CheckedExceptionWrapperGeneratorPluginExtension)this.getProject().getExtensions().getByName("checkedExceptionWrapperGenerator");

    @TaskAction
    public void generate() throws ParseException {
        this.extension.getClasses().forEach(this::generateClassWrapper);
    }

    private void generateClassWrapper(String className) {
        CompilationUnit cu;
        InputStream inputStream = this.getSource(className);
        try {
            cu = JavaParser.parse((InputStream)inputStream);
        }
        catch (ParseException e) {
            throw new GradleException("cannot parse source " + className, (Throwable)e);
        }
        this.enhanceSource(cu);
        this.saveSource(className, cu);
        this.getLogger().info("Created " + this.getTargetClassName(className) + JAVA);
    }

    private String getTargetClassName(String className) {
        return this.getPackage(className) + this.getTargetSimpleClassName(className);
    }

    private String getTargetSimpleClassName(String className) {
        return this.extension.getGeneratedClassNamePrefix() + this.getSimpleClassName(className) + this.extension.getGeneratedClassNameSuffix();
    }

    private String getSimpleClassName(String className) {
        return className.substring(className.lastIndexOf("/") + 1);
    }

    private String getPackage(String className) {
        return className.substring(0, className.lastIndexOf("/") + 1);
    }

    private InputStream getSource(String className) {
        return this.getProject().getConfigurations().getByName(CONFIGURATION).resolve().stream().map(jar -> this.zipEntryInputStream((File)jar, className)).filter(stream -> stream != null).findFirst().orElseThrow(() -> new GradleException("cannot find source for " + className));
    }

    private InputStream zipEntryInputStream(File jar, String className) {
        try {
            ZipFile zip = new ZipFile(jar);
            ZipEntry entry = zip.getEntry(className + JAVA);
            if (entry != null) {
                return zip.getInputStream(entry);
            }
            return null;
        }
        catch (IOException e) {
            throw new GradleException("Cannot read zip entry " + className + " in " + jar, (Throwable)e);
        }
    }

    private void enhanceSource(CompilationUnit cu) {
        String prefix = this.extension.getGeneratedClassNamePrefix();
        String suffix = this.extension.getGeneratedClassNameSuffix();
        List types = cu.getTypes();
        for (TypeDeclaration type : types) {
            String newClassName = prefix + type.getName() + suffix;
            type.setName(newClassName);
            List members = type.getMembers();
            members.stream().filter(member -> member instanceof MethodDeclaration).map(member -> (MethodDeclaration)member).filter(methodDeclaration -> CollectionUtils.isNotEmpty((Collection)methodDeclaration.getThrows())).forEach(this::convertMethod);
            members.stream().filter(member -> member instanceof ConstructorDeclaration).map(member -> (ConstructorDeclaration)member).forEach(constructor -> constructor.setName(newClassName));
        }
    }

    private void convertMethod(MethodDeclaration method) {
        method.setThrows(null);
        BlockStmt body = method.getBody();
        List originalStatements = body.getStmts();
        body.setStmts(new ArrayList());
        BlockStmt tryBlock = new BlockStmt(originalStatements);
        CatchClause catchClause = new CatchClause(this.createCatchExceptionParameter(), this.createCatchBlock());
        TryStmt tryStmt = new TryStmt(tryBlock, Collections.singletonList(catchClause), new BlockStmt());
        tryStmt.setResources(Collections.emptyList());
        body.getStmts().add(tryStmt);
    }

    private BlockStmt createCatchBlock() {
        StringLiteralExpr errorMessage = new StringLiteralExpr(this.extension.getExceptionMessage());
        NameExpr exceptionParameter = new NameExpr("e");
        ObjectCreationExpr newRuntimeException = new ObjectCreationExpr(null, new ClassOrInterfaceType(this.extension.getRuntimeExceptionClass()), Arrays.asList(errorMessage, exceptionParameter));
        ThrowStmt throwStmt = new ThrowStmt();
        throwStmt.setExpr((Expression)newRuntimeException);
        BlockStmt catchBlock = new BlockStmt();
        catchBlock.setStmts(Collections.singletonList(throwStmt));
        return catchBlock;
    }

    private MultiTypeParameter createCatchExceptionParameter() {
        return new MultiTypeParameter(0, Collections.emptyList(), Collections.singletonList(new ClassOrInterfaceType("Exception")), new VariableDeclaratorId("e"));
    }

    private void saveSource(String className, CompilationUnit cu) {
        Paths.get(this.extension.getOutputFolder(), className).getParent().toFile().mkdirs();
        String outputFile = this.extension.getOutputFolder() + File.separator + this.getTargetClassName(className) + JAVA;
        try {
            FileUtils.writeStringToFile((File)new File(outputFile), (String)cu.toString());
        }
        catch (IOException e) {
            throw new GradleException("cannot write file " + outputFile, (Throwable)e);
        }
    }
}

