package eu.hassels.divera.java.api.model;

import java.util.List;
import java.util.Objects;

/**
 * @author Fabian Hassels
 * <p>
 * In diesem TO finden sich alle Parameter, die Divera annehmen kann.
 */
public class DiveraTO {
    /**
     * Sonderrechte.
     */
    private boolean priority;

    /**
     * Stichwort.
     */
    private String type;

    /**
     * Meldung.
     */
    private String text;

    /**
     * Adresse, inklusive Stadt (und Stadtteil).
     */
    private String address;

    /**
     * Breitengrad.
     */
    private Double lng;

    /**
     * Längengrad.
     */
    private Double lat;

    /**
     * RIC.
     */
    private String ric;

    /**
     * Die alarmierten Fahrzeuge.
     */

    private List<String> fahrzeuge;

    /**
     * Verzögerung.
     */
    private Integer delay;

    /**
     * Der Divera-Alarm-Key
     */
    private String diveraAlarmKey;

    public boolean isPriority() {
        return priority;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Double getLng() {
        return lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public String getRic() {
        return ric;
    }

    public void setRic(String ric) {
        this.ric = ric;
    }

    public List<String> getFahrzeuge() {
        return fahrzeuge;
    }

    public void setFahrzeuge(List<String> fahrzeuge) {
        this.fahrzeuge = fahrzeuge;
    }

    public Integer getDelay() {
        return delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public String getDiveraAlarmKey() {
        return diveraAlarmKey;
    }

    public void setDiveraAlarmKey(String diveraAlarmKey) {
        this.diveraAlarmKey = diveraAlarmKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DiveraTO diveraTO = (DiveraTO) o;
        return priority == diveraTO.priority &&
                Objects.equals(type, diveraTO.type) &&
                Objects.equals(text, diveraTO.text) &&
                Objects.equals(address, diveraTO.address) &&
                Objects.equals(lng, diveraTO.lng) &&
                Objects.equals(lat, diveraTO.lat) &&
                Objects.equals(ric, diveraTO.ric) &&
                Objects.equals(fahrzeuge, diveraTO.fahrzeuge) &&
                Objects.equals(delay, diveraTO.delay) &&
                Objects.equals(diveraAlarmKey, diveraTO.diveraAlarmKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(priority, type, text, address, lng, lat, ric, fahrzeuge, delay, diveraAlarmKey);
    }
}
