package eu.hassels.divera.java.api.client;

import eu.hassels.divera.java.api.model.DiveraTO;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

/**
 * @author Fabian Hassels
 */
public class DiveraAlarmierungClient {
    private String urlEndpoint = "https://www.divera247.com/api/alarm";

    private RestTemplate restTemplate = new RestTemplate();

    /**
     * Schickt die Alarmierung an Divera.
     *
     * @param diveraTO das TO mit allen Daten, die an Divera geschickt werden sollen.
     * @return true, wenn die Alarmierung erfolgreich ist, false, wenn sie nicht erfolgreich ist.
     */
    public boolean alarmiere(DiveraTO diveraTO) {
        ResponseEntity<String> responseEntity =
                restTemplate.postForEntity(urlEndpoint, diveraTO, String.class);

        return responseEntity.getStatusCode().is2xxSuccessful();
    }
}
