/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.observables;

import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.MapChangeEvt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ObservableMap<K, V>
implements Map<K, V>,
Cloneable {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final HashMap<K, V> map;
    private Map<EvtType, List<EvtObserver<MapChangeEvt<K, V>>>> observers;

    public ObservableMap() {
        this(16, 0.75f);
    }

    public ObservableMap(int capacity) {
        this(capacity, 0.75f);
    }

    public ObservableMap(int capacity, float loadFactor) {
        this.map = new HashMap(capacity, loadFactor);
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<MapChangeEvt<K, V>>>>();
    }

    public ObservableMap(Map<? extends K, ? extends V> map) {
        this.map = new HashMap<K, V>(map);
        this.observers = new ConcurrentHashMap<EvtType, List<EvtObserver<MapChangeEvt<K, V>>>>();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.map.containsKey(key)) {
            V result = this.map.put(key, value);
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, value)), List.of()));
            return result;
        }
        V result = this.map.put(key, value);
        this.fireMapChangeEvt(new MapChangeEvt<K, V>(this, MapChangeEvt.ADDED, List.of(Map.entry(key, value)), List.of(), List.of()));
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.entrySet().forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
    }

    @Override
    public V remove(Object key) {
        V result;
        if (this.map.containsKey(key)) {
            Map.Entry<Object, V> removedEntry = Map.entry(key, this.map.get(key));
            result = this.map.remove(key);
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.REMOVED, List.of(), List.of(), List.of(removedEntry)));
        } else {
            result = this.map.remove(key);
        }
        return result;
    }

    @Override
    public void clear() {
        ArrayList<Map.Entry<K, V>> removedEntries = new ArrayList<Map.Entry<K, V>>(this.entrySet());
        this.map.clear();
        this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.REMOVED, List.of(), List.of(), removedEntries));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.getOrDefault(key, defaultValue);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V result = this.map.putIfAbsent(key, value);
        if (null == result) {
            this.fireMapChangeEvt(new MapChangeEvt<K, V>(this, MapChangeEvt.ADDED, List.of(Map.entry(key, value)), List.of(), List.of()));
        } else {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, result)), List.of()));
        }
        return result;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result = this.map.remove(key, value);
        if (result) {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.REMOVED, List.of(), List.of(), List.of(Map.entry(key, value))));
        }
        return result;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean result = this.map.replace(key, oldValue, newValue);
        if (result) {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, newValue)), List.of()));
        }
        return result;
    }

    @Override
    public V replace(K key, V value) {
        V result = this.map.replace(key, value);
        if (this.map.containsKey(key)) {
            this.fireMapChangeEvt(new MapChangeEvt(this, MapChangeEvt.MODIFIED, List.of(), List.of(Map.entry(key, value)), List.of()));
        }
        return result;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
    }

    public ObservableMap<K, V> clone() {
        try {
            ObservableMap clone = (ObservableMap)super.clone();
            clone.putAll(this.map);
            return clone;
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    public void addMapChangeObserver(EvtType type, EvtObserver<MapChangeEvt<K, V>> observer) {
        if (!this.observers.containsKey(type)) {
            this.observers.put(type, new CopyOnWriteArrayList());
        }
        if (this.observers.get(type).contains(observer)) {
            return;
        }
        this.observers.get(type).add(observer);
    }

    public void removeMapChangeObserver(EvtType type, EvtObserver<MapChangeEvt<K, V>> observer) {
        if (this.observers.containsKey(type) && this.observers.get(type).contains(observer)) {
            this.observers.get(type).remove(observer);
        }
    }

    public void removeAllMapChangeObservers() {
        this.observers.clear();
    }

    public void fireMapChangeEvt(MapChangeEvt<K, V> evt) {
        EvtType<MapChangeEvt<K, V>> type = evt.getEvtType();
        this.observers.entrySet().stream().filter(entry -> ((EvtType)entry.getKey()).equals(MapChangeEvt.ANY)).forEach((? super T entry) -> ((List)entry.getValue()).forEach((? super T observer) -> observer.handle(evt)));
        if (this.observers.containsKey(type) && !type.equals(MapChangeEvt.ANY)) {
            this.observers.get(type).forEach((? super T observer) -> observer.handle(evt));
        }
    }
}

