/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.evt.type;

import eu.hansolo.toolbox.evt.EvtPriority;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolbox.evt.type.ChangeEvt;
import eu.hansolo.toolbox.observables.ObservableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListChangeEvt<T>
extends ChangeEvt {
    public static final EvtType<ListChangeEvt> ANY = new EvtType<ChangeEvt>(ChangeEvt.ANY, "ANY");
    public static final EvtType<ListChangeEvt> CHANGED = new EvtType<ListChangeEvt>(ANY, "CHANGED");
    public static final EvtType<ListChangeEvt> ADDED = new EvtType<ListChangeEvt>(ANY, "ADDED");
    public static final EvtType<ListChangeEvt> REMOVED = new EvtType<ListChangeEvt>(ANY, "REMOVED");
    private final List<T> addedItems;
    private final List<T> removedItems;

    public ListChangeEvt(ObservableList<T> src, EvtType<ListChangeEvt> evtType, List<T> addedItems, List<T> removedItems) {
        super((Object)src, (EvtType<? extends ChangeEvt>)evtType);
        this.addedItems = null == addedItems ? List.of() : new ArrayList<T>(addedItems);
        this.removedItems = null == removedItems ? List.of() : new ArrayList<T>(removedItems);
    }

    public ListChangeEvt(ObservableList<T> src, EvtType<? extends ListChangeEvt<T>> evtType, EvtPriority priority, List<T> addedItems, List<T> removedItems) {
        super((Object)src, (EvtType<? extends ChangeEvt>)evtType, priority);
        this.addedItems = null == addedItems ? List.of() : new ArrayList<T>(addedItems);
        this.removedItems = null == removedItems ? List.of() : new ArrayList<T>(removedItems);
    }

    public EvtType<? extends ListChangeEvt<T>> getEvtType() {
        return super.getEvtType();
    }

    public List<T> getAddedItems() {
        return this.addedItems;
    }

    public List<T> getRemovedItems() {
        return this.removedItems;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListChangeEvt that = (ListChangeEvt)o;
        return Objects.equals(this.addedItems, that.addedItems) && Objects.equals(this.removedItems, that.removedItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.addedItems, this.removedItems);
    }
}

