/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.properties;

import eu.hansolo.properties.ChangeEvent;
import eu.hansolo.properties.ReadOnlyShortProperty;

public class ShortProperty
extends ReadOnlyShortProperty {
    protected ReadOnlyShortProperty propertyBoundTo = null;
    protected boolean bound = false;

    public ShortProperty() {
        this((Object)null, (String)null, 0);
    }

    public ShortProperty(short value) {
        this((Object)null, (String)null, value);
    }

    public ShortProperty(String name, short value) {
        this((Object)null, name, value);
    }

    public ShortProperty(Object bean, String name, short value) {
        super(bean, name, value);
    }

    public void setValue(Short value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(short value) {
        this.setValue(value);
    }

    protected void setValue(short value, ShortProperty property) {
        this.willChange((Short)this.value, value);
        Short oldValue = (Short)this.value;
        this.value = value;
        if (null == property && null != this.propertyToUpdate) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new ChangeEvent<Short>(this, oldValue, (Short)this.value));
        this.didChange(oldValue, (Short)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Short)this.getInitialValue());
    }

    public void setInitialValue(Short initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyShortProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(ShortProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(ShortProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

