/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.properties;

import eu.hansolo.properties.ChangeEvent;
import eu.hansolo.properties.ReadOnlyLongProperty;

public class LongProperty
extends ReadOnlyLongProperty {
    protected ReadOnlyLongProperty propertyBoundTo = null;
    protected boolean bound = false;

    public LongProperty() {
        this((Object)null, (String)null, 0L);
    }

    public LongProperty(long value) {
        this((Object)null, (String)null, value);
    }

    public LongProperty(String name, long value) {
        this((Object)null, name, value);
    }

    public LongProperty(Object bean, String name, long value) {
        super(bean, name, value);
    }

    public void setValue(Long value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(long value) {
        this.setValue(value);
    }

    protected void setValue(Long value, LongProperty property) {
        this.willChange((Long)this.value, value);
        Long oldValue = (Long)this.value;
        this.value = value;
        if (null == property && null != this.propertyToUpdate) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new ChangeEvent<Long>(this, oldValue, (Long)this.value));
        this.didChange(oldValue, (Long)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Long)this.getInitialValue());
    }

    public void setInitialValue(Long initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(ReadOnlyLongProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(LongProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.unsetPropertyToUpdate();
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.unsetPropertyToUpdate();
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(LongProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

