/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.properties;

import eu.hansolo.properties.BooleanProperty;
import eu.hansolo.properties.ChangeEvent;
import eu.hansolo.properties.ChangeListener;
import eu.hansolo.properties.DoubleProperty;
import eu.hansolo.properties.IntegerProperty;
import eu.hansolo.properties.ObjectProperty;
import eu.hansolo.properties.ReadOnlyBooleanProperty;
import eu.hansolo.properties.ReadOnlyDoubleProperty;

public class Demo {
    private PoJo pojo = new PoJo();
    private DoubleProperty doubleProperty;
    private ObjectProperty<String> objectProperty;
    private IntegerProperty integerProperty;
    private DoubleProperty doubleProperty1;
    private ReadOnlyDoubleProperty readOnlyDoubleProperty;

    public Demo() {
        this.pojo.valueProperty().addListener(evt -> System.out.println("Value changed from " + evt.getOldValue() + " to " + evt.getValue()));
        ChangeListener<ChangeEvent> doubleChangeListener = e -> System.out.println(e.getOldValue() + " -> " + e.getValue());
        this.doubleProperty = new DoubleProperty(){

            @Override
            protected void willChange(Double oldValue, Double newValue) {
                System.out.println("\nDoubleProperty will change from " + oldValue + " to " + newValue + "\n");
            }

            @Override
            protected void didChange(Double oldValue, Double newValue) {
                System.out.println("\nDoubleProperty changed from " + oldValue + " to " + newValue + "\n");
            }
        };
        this.doubleProperty.addOnChange(doubleChangeListener);
        this.doubleProperty.removeListener(doubleChangeListener);
        this.doubleProperty.removeAllListeners();
        this.objectProperty = new ObjectProperty();
        this.integerProperty = new IntegerProperty(10){

            @Override
            public void set(int VALUE) {
                super.set(VALUE);
            }

            @Override
            public int get() {
                return super.get();
            }

            @Override
            protected void didChange(Integer oldValue, Integer newValue) {
                System.out.println("Color changed to: " + newValue);
            }

            @Override
            public Object getBean() {
                return Demo.this;
            }

            @Override
            public String getName() {
                return "color";
            }
        };
        this.doubleProperty1 = new DoubleProperty((Object)this, "oldValue", 10.0);
        this.readOnlyDoubleProperty = new ReadOnlyDoubleProperty(5.0);
        this.pojo.doubleValueProperty().addOnChange(e -> System.out.println(e.getOldValue() + " -> " + e.getValue()));
        this.doubleProperty.addListener(e -> System.out.println(e.getOldValue() + " -> " + e.getValue()));
        this.objectProperty.addListener(e -> System.out.println(e.getOldValue() + " -> " + e.getValue()));
        this.pojo.setDoubleValue(7.0);
        this.pojo.setValue(5.0);
        this.pojo.valueProperty().set(8.0);
        this.doubleProperty.set(20.0);
        this.objectProperty.set(new String("Hallo"));
        this.objectProperty.set(new String("Test"));
        this.objectProperty.set("Bla");
        System.out.println("\n\n---------- Unidirectional Binding ------------");
        DoubleProperty propertyA = new DoubleProperty(5.0);
        DoubleProperty propertyB = new DoubleProperty(10.0);
        System.out.println("Property A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyA.bind(propertyB)");
        propertyA.bind(propertyB);
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyB.set(5)");
        propertyB.set(5.0);
        System.out.println("\npropertyB = " + propertyB.get());
        System.out.println("propertyA = " + propertyA.get());
        System.out.println("\npropertyA.set(20)");
        try {
            propertyA.set(20.0);
        }
        catch (IllegalArgumentException e2) {
            System.out.println("Error, a bound value cannot be set.");
        }
        System.out.println("\npropertyA.unbind()");
        propertyA.unbind();
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\npropertyB.set(15)");
        propertyB.set(15.0);
        System.out.println("\nProperty A: " + propertyA.get() + " is bound: " + propertyA.isBound());
        System.out.println("Property B: " + propertyB.get() + " is bound: " + propertyB.isBound());
        System.out.println("\nReadOnlyDoubleProperty: " + this.readOnlyDoubleProperty.getValue());
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("Bind DoubleProperty -> ReadOnlyDoubleProperty");
        this.doubleProperty.bind(this.readOnlyDoubleProperty);
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("Unbind DoubleProperty -> ReadOnlyDoubleProperty");
        this.doubleProperty.unbind();
        System.out.println("Set DoubleProperty -> 13");
        this.doubleProperty.set(13.0);
        System.out.println("DoubleProperty        : " + this.doubleProperty.getValue());
        System.out.println("\n\n---------- Bidirectional Binding ------------");
        DoubleProperty propertyC = new DoubleProperty(0.0);
        DoubleProperty propertyD = new DoubleProperty(25.0);
        System.out.println("Property C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyC.bindBidirectional(propertyD)");
        propertyC.bindBidirectional(propertyD);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyD.set(5)");
        propertyD.set(5.0);
        System.out.println("\npropertyC = " + propertyC.get());
        System.out.println("propertyD = " + propertyD.get());
        System.out.println("\npropertyC.set(20)");
        propertyC.set(20.0);
        System.out.println("\npropertyC = " + propertyC.get());
        System.out.println("propertyD = " + propertyD.get());
        System.out.println("\npropertyD.unbind()");
        propertyD.unbind();
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyD.set(5)");
        propertyD.set(5.0);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
        System.out.println("\npropertyC.set(10)");
        propertyC.set(10.0);
        System.out.println("\nProperty C: " + propertyC.get() + " is bound bidirectional: " + propertyC.isBoundBidirectional());
        System.out.println("Property D: " + propertyD.get() + " is bound bidirectional: " + propertyD.isBoundBidirectional());
    }

    public static void main(String[] args) {
        new Demo();
    }

    public class PoJo {
        private double _value = 0.0;
        private DoubleProperty value;
        private DoubleProperty doubleValue = new DoubleProperty(3.0);
        private BooleanProperty booleanValue = new BooleanProperty(true);

        public double getValue() {
            return null == this.value ? this._value : this.value.get();
        }

        public void setValue(double value) {
            if (null == this.value) {
                this._value = value;
            } else {
                this.value.set(value);
            }
        }

        public DoubleProperty valueProperty() {
            if (null == this.value) {
                this.value = new DoubleProperty(this._value){

                    @Override
                    protected void willChange(Double oldValue, Double newValue) {
                        System.out.println("\nValue will change from " + oldValue + " to " + newValue + "\n");
                    }

                    @Override
                    protected void didChange(Double oldValue, Double newValue) {
                        System.out.println("\nValue changed from " + oldValue + " to " + newValue + "\n");
                    }
                };
            }
            return this.value;
        }

        public double getDoubleValue() {
            return this.doubleValue.get();
        }

        public void setDoubleValue(double value) {
            this.doubleValue.set(value);
        }

        public DoubleProperty doubleValueProperty() {
            return this.doubleValue;
        }

        public boolean isBooleanValue() {
            return this.booleanValue.get();
        }

        public ReadOnlyBooleanProperty booleanValueProperty() {
            return this.booleanValue;
        }
    }
}

