/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.properties;

import eu.hansolo.properties.ChangeEvent;
import eu.hansolo.properties.ReadOnlyStringProperty;

public class StringProperty
extends ReadOnlyStringProperty {
    protected StringProperty propertyToUpdate = null;
    protected StringProperty propertyBoundTo = null;
    protected boolean bound = false;
    protected boolean bidirectional = false;

    public StringProperty() {
        this((Object)null, (String)null, "");
    }

    public StringProperty(String value) {
        this((Object)null, (String)null, value);
    }

    public StringProperty(String name, String value) {
        this((Object)null, name, value);
    }

    public StringProperty(Object bean, String name, String value) {
        super(bean, name, value);
    }

    public void setValue(String value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(String value) {
        this.setValue(value);
    }

    protected void setValue(String value, StringProperty property) {
        this.willChange((String)this.value, value);
        String oldValue = (String)this.value;
        this.value = value;
        if (null == property && null != this.propertyToUpdate) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new ChangeEvent<String>(this, oldValue, (String)this.value));
        this.didChange(oldValue, (String)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((String)this.getInitialValue());
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(StringProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(StringProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.setPropertyToUpdate(null);
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.setPropertyToUpdate(null);
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(StringProperty property) {
        this.setPropertyToUpdate(property, false);
    }

    protected void setPropertyToUpdate(StringProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

