/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.properties;

import eu.hansolo.properties.ChangeEvent;
import eu.hansolo.properties.ChangeListener;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ReadOnlyProperty<T> {
    protected CopyOnWriteArrayList<ChangeListener> changeListeners;
    protected Object bean;
    protected String name;
    protected T initialValue;
    protected T value;

    public ReadOnlyProperty() {
        this(null, null, null, null);
    }

    public ReadOnlyProperty(T value) {
        this(null, null, value, value);
    }

    public ReadOnlyProperty(Object bean, String name, T value) {
        this(bean, name, value, value);
    }

    public ReadOnlyProperty(Object bean, String name, T value, T initialValue) {
        this.bean = bean;
        this.name = name;
        this.value = value;
        this.initialValue = initialValue;
    }

    public final T getValue() {
        return this.value;
    }

    public final T getInitialValue() {
        return this.initialValue;
    }

    public final boolean isSet() {
        return Objects.equals(this.getValue(), this.getInitialValue());
    }

    protected void willChange(T oldValue, T newValue) {
    }

    protected void didChange(T oldValue, T newValue) {
    }

    protected void invalidated() {
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.name;
    }

    public void addOnChange(ChangeListener listener) {
        this.addListener(listener);
    }

    public void addListener(ChangeListener listener) {
        if (null == listener) {
            return;
        }
        if (null == this.changeListeners) {
            this.changeListeners = new CopyOnWriteArrayList();
        }
        if (this.changeListeners.contains(listener)) {
            return;
        }
        this.changeListeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        if (null == this.changeListeners || null == listener) {
            return;
        }
        if (this.changeListeners.contains(listener)) {
            this.changeListeners.remove(listener);
        }
    }

    public void removeAllListeners() {
        if (null == this.changeListeners) {
            return;
        }
        this.changeListeners.clear();
    }

    public void fireEvent(ChangeEvent event) {
        if (null == this.changeListeners || null == event) {
            return;
        }
        this.changeListeners.forEach(listener -> listener.onEvent(event));
    }
}

