/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.properties;

import eu.hansolo.properties.ChangeEvent;
import eu.hansolo.properties.ReadOnlyIntegerProperty;

public class IntegerProperty
extends ReadOnlyIntegerProperty {
    protected IntegerProperty propertyToUpdate = null;
    protected IntegerProperty propertyBoundTo = null;
    protected boolean bound = false;
    protected boolean bidirectional = false;

    public IntegerProperty() {
        this((Object)null, (String)null, 0);
    }

    public IntegerProperty(int value) {
        this((Object)null, (String)null, value);
    }

    public IntegerProperty(String name, int value) {
        this((Object)null, name, value);
    }

    public IntegerProperty(Object bean, String name, int value) {
        super(bean, name, value);
    }

    public void setValue(Integer value) {
        if (this.bound && !this.bidirectional) {
            throw new IllegalArgumentException("A bound value cannot be set.");
        }
        this.setValue(value, null);
    }

    public void set(int value) {
        this.setValue(value);
    }

    protected void setValue(Integer value, IntegerProperty property) {
        this.willChange((Integer)this.value, value);
        Integer oldValue = (Integer)this.value;
        this.value = value;
        if (null == property && null != this.propertyToUpdate) {
            this.propertyToUpdate.setValue(value, this);
        }
        this.fireEvent(new ChangeEvent<Integer>(this, oldValue, (Integer)this.value));
        this.didChange(oldValue, (Integer)this.value);
        this.invalidated();
    }

    public void unset() {
        this.setValue((Integer)this.getInitialValue());
    }

    public void setInitialValue(Integer initialValue) {
        this.initialValue = initialValue;
    }

    public void bind(IntegerProperty property) {
        this.propertyBoundTo = property;
        this.value = this.propertyBoundTo.getValue();
        this.propertyBoundTo.setPropertyToUpdate(this);
        this.propertyToUpdate = null;
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void bindBidirectional(IntegerProperty property) {
        this.setPropertyToUpdate(property, true);
        property.setPropertyToUpdate(this, true);
        this.propertyBoundTo = property;
        this.bound = true;
    }

    public boolean isBoundBidirectional() {
        return this.bidirectional;
    }

    public void unbind() {
        if (null != this.propertyToUpdate) {
            this.propertyToUpdate.setPropertyToUpdate(null);
            this.propertyToUpdate.unbind();
            this.propertyToUpdate = null;
        }
        if (null != this.propertyBoundTo) {
            this.propertyBoundTo.setPropertyToUpdate(null);
            this.propertyBoundTo = null;
        }
        this.bound = false;
        this.bidirectional = false;
    }

    protected void setPropertyToUpdate(IntegerProperty property) {
        this.setPropertyToUpdate(property, false);
    }

    protected void setPropertyToUpdate(IntegerProperty property, boolean bidirectional) {
        this.propertyToUpdate = property;
        if (null == property) {
            this.bidirectional = false;
        } else {
            this.value = property.getValue();
            this.bidirectional = bidirectional;
        }
    }
}

