/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class SimpleSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double START_ANGLE = 315.0;
    private double ANGLE_RANGE = 270.0;
    private double size;
    private Pane pane;
    private Canvas sectionsCanvas;
    private GraphicsContext sectionsCtx;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private LineTo needleLineTo5;
    private LineTo needleLineTo6;
    private CubicCurveTo needleCubicCurveTo7;
    private ClosePath needleClosePath8;
    private Rotate needleRotate;
    private Text valueText;
    private Text titleText;
    private double angleStep;
    private String formatString;
    private List<Section> sections;
    private boolean highlightSections;
    private double minValue;
    private double maxValue;

    public SimpleSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleStep = this.ANGLE_RANGE / (gauge.getMaxValue() - gauge.getMinValue());
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.sections = gauge.getSections();
        this.highlightSections = gauge.isHighlightSections();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.sectionsCanvas = new Canvas(250.0, 250.0);
        this.sectionsCtx = this.sectionsCanvas.getGraphicsContext2D();
        this.needleRotate = new Rotate(180.0 - this.START_ANGLE);
        this.angleStep = this.ANGLE_RANGE / ((Gauge)this.getSkinnable()).getRange();
        double targetAngle = 180.0 - this.START_ANGLE + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle).doubleValue());
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleLineTo5 = new LineTo();
        this.needleLineTo6 = new LineTo();
        this.needleCubicCurveTo7 = new CubicCurveTo();
        this.needleClosePath8 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleLineTo5, this.needleLineTo6, this.needleCubicCurveTo7, this.needleClosePath8});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.needle.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.needle.setStrokeLineCap(StrokeLineCap.ROUND);
        this.needle.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        this.valueText = new Text(String.format(Locale.US, this.formatString, ((Gauge)this.getSkinnable()).getMinValue()) + ((Gauge)this.getSkinnable()).getUnit());
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.pane = new Pane(new Node[]{this.sectionsCanvas, this.needle, this.valueText, this.titleText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).getSections().addListener(change -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(event -> this.handleEvents(event.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(e -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            if (((Gauge)this.getSkinnable()).getCheckSectionsForValue()) {
                double currentValue = ((Gauge)this.getSkinnable()).getCurrentValue();
                int listSize = this.sections.size();
                for (int i = 0; i < listSize; ++i) {
                    this.sections.get(i).checkForValue(currentValue);
                }
            }
            if (this.highlightSections) {
                this.drawSections();
            }
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            this.angleStep = this.ANGLE_RANGE / ((Gauge)this.getSkinnable()).getRange();
            this.needleRotate.setAngle(180.0 - this.START_ANGLE + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep);
            this.resize();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.highlightSections = ((Gauge)this.getSkinnable()).isHighlightSections();
            this.resize();
            this.redraw();
        }
    }

    private void rotateNeedle(double VALUE) {
        double targetAngle = 180.0 - this.START_ANGLE + (VALUE - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle).doubleValue());
        this.valueText.setText(String.format(Locale.US, this.formatString, VALUE) + ((Gauge)this.getSkinnable()).getUnit());
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        if (this.valueText.getLayoutBounds().getWidth() > 0.395 * this.size) {
            this.resizeText();
        }
    }

    private void drawSections() {
        this.sectionsCtx.clearRect(0.0, 0.0, this.size, this.size);
        double value = ((Gauge)this.getSkinnable()).getCurrentValue();
        boolean sectionTextVisible = ((Gauge)this.getSkinnable()).isSectionTextVisible();
        boolean sectionIconVisible = ((Gauge)this.getSkinnable()).getSectionIconsVisible();
        double offset = this.START_ANGLE - 90.0;
        int listSize = this.sections.size();
        double sectionsOffset = this.size * 0.015;
        double sectionsSize = this.size - this.size * 0.03;
        this.angleStep = this.ANGLE_RANGE / ((Gauge)this.getSkinnable()).getRange();
        for (int i = 0; i < listSize; ++i) {
            Image icon;
            double cosValue;
            double sinValue;
            Section section = this.sections.get(i);
            if (section.getStart() > this.maxValue || section.getStop() < this.minValue) continue;
            double SECTION_START_ANGLE = section.getStart() < this.minValue && section.getStop() < this.maxValue ? 0.0 : (section.getStart() - this.minValue) * this.angleStep;
            double SECTION_ANGLE_EXTEND = section.getStop() > this.maxValue ? (this.maxValue - section.getStart()) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep;
            this.sectionsCtx.save();
            if (this.highlightSections) {
                this.sectionsCtx.setFill((Paint)(section.contains(value) ? section.getHighlightColor() : section.getColor()));
            } else {
                this.sectionsCtx.setFill((Paint)section.getColor());
            }
            this.sectionsCtx.fillArc(sectionsOffset, sectionsOffset, sectionsSize, sectionsSize, offset - SECTION_START_ANGLE, -SECTION_ANGLE_EXTEND, ArcType.ROUND);
            if (sectionTextVisible) {
                sinValue = -Math.sin(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                cosValue = -Math.cos(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                Point2D textPoint = new Point2D(this.size * 0.5 + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                this.sectionsCtx.setFont(Fonts.robotoMedium(0.08 * this.size));
                this.sectionsCtx.setTextAlign(TextAlignment.CENTER);
                this.sectionsCtx.setTextBaseline(VPos.CENTER);
                this.sectionsCtx.setFill((Paint)section.getTextColor());
                this.sectionsCtx.fillText(section.getText(), textPoint.getX(), textPoint.getY(), 0.2 * this.size);
            } else if (this.size > 0.0 && sectionIconVisible && null != (icon = section.getImage())) {
                sinValue = -Math.sin(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                cosValue = -Math.cos(Math.toRadians(offset - 90.0 - SECTION_START_ANGLE - SECTION_ANGLE_EXTEND * 0.5));
                Point2D iconPoint = new Point2D(this.size * 0.5 + this.size * 0.365 * sinValue, this.size * 0.5 + this.size * 0.365 * cosValue);
                this.sectionsCtx.drawImage(icon, iconPoint.getX() - this.size * 0.06, iconPoint.getY() - this.size * 0.06, this.size * 0.12, this.size * 0.12);
            }
            this.sectionsCtx.restore();
        }
        this.sectionsCtx.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.sectionsCtx.setLineWidth(this.size * 0.025);
        this.sectionsCtx.strokeArc(sectionsOffset, sectionsOffset, sectionsSize, sectionsSize, offset + 90.0, this.ANGLE_RANGE, ArcType.ROUND);
    }

    private void resizeText() {
        double fontSize = this.size * 0.145;
        this.valueText.setFont(Fonts.robotoMedium(fontSize));
        double maxWidth = 0.395 * this.size;
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setTranslateY(this.size * (this.titleText.getText().isEmpty() ? 0.5 : 0.48));
        fontSize = this.size * 0.045;
        this.titleText.setFont(Fonts.robotoMedium(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.setTranslateX((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setTranslateY(this.size * 0.5 + this.valueText.getFont().getSize() * 0.7);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.sectionsCanvas.setCache(false);
            this.sectionsCanvas.setWidth(this.size);
            this.sectionsCanvas.setHeight(this.size);
            this.drawSections();
            this.sectionsCanvas.setCache(true);
            this.sectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.needle.setCache(false);
            this.needleMoveTo1.setX(0.275 * this.size);
            this.needleMoveTo1.setY(0.5 * this.size);
            this.needleCubicCurveTo2.setControlX1(0.275 * this.size);
            this.needleCubicCurveTo2.setControlY1(0.62426575 * this.size);
            this.needleCubicCurveTo2.setControlX2(0.37573425 * this.size);
            this.needleCubicCurveTo2.setControlY2(0.725 * this.size);
            this.needleCubicCurveTo2.setX(0.5 * this.size);
            this.needleCubicCurveTo2.setY(0.725 * this.size);
            this.needleCubicCurveTo3.setControlX1(0.62426575 * this.size);
            this.needleCubicCurveTo3.setControlY1(0.725 * this.size);
            this.needleCubicCurveTo3.setControlX2(0.725 * this.size);
            this.needleCubicCurveTo3.setControlY2(0.62426575 * this.size);
            this.needleCubicCurveTo3.setX(0.725 * this.size);
            this.needleCubicCurveTo3.setY(0.5 * this.size);
            this.needleCubicCurveTo4.setControlX1(0.725 * this.size);
            this.needleCubicCurveTo4.setControlY1(0.3891265 * this.size);
            this.needleCubicCurveTo4.setControlX2(0.6448105 * this.size);
            this.needleCubicCurveTo4.setControlY2(0.296985 * this.size);
            this.needleCubicCurveTo4.setX(0.5392625 * this.size);
            this.needleCubicCurveTo4.setY(0.2784125 * this.size);
            this.needleLineTo5.setX(0.5 * this.size);
            this.needleLineTo5.setY(0.0225 * this.size);
            this.needleLineTo6.setX(0.4607375 * this.size);
            this.needleLineTo6.setY(0.2784125 * this.size);
            this.needleCubicCurveTo7.setControlX1(0.3551895 * this.size);
            this.needleCubicCurveTo7.setControlY1(0.296985 * this.size);
            this.needleCubicCurveTo7.setControlX2(0.275 * this.size);
            this.needleCubicCurveTo7.setControlY2(0.3891265 * this.size);
            this.needleCubicCurveTo7.setX(0.275 * this.size);
            this.needleCubicCurveTo7.setY(0.5 * this.size);
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            this.needle.setStrokeWidth(this.size * 0.025);
            this.needle.relocate(this.needle.getLayoutBounds().getMinX(), this.needle.getLayoutBounds().getMinY());
            this.needleRotate.setPivotX(this.size * 0.5);
            this.needleRotate.setPivotY(this.size * 0.5);
            double currentValue = (this.needleRotate.getAngle() + this.START_ANGLE - 180.0) / this.angleStep + ((Gauge)this.getSkinnable()).getMinValue();
            this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", currentValue) + ((Gauge)this.getSkinnable()).getUnit());
            this.valueText.setVisible(((Gauge)this.getSkinnable()).isValueVisible());
            this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
            this.resizeText();
        }
    }

    private void redraw() {
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.needle.setStroke(((Gauge)this.getSkinnable()).getBorderPaint());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.resizeText();
    }
}

