/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.tools;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelLocation;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.TickMarkType;
import eu.hansolo.medusa.TimeSection;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class Helper {
    public static final <T extends Number> T clamp(T MIN, T MAX, T VALUE) {
        if (VALUE.doubleValue() < MIN.doubleValue()) {
            return MIN;
        }
        if (VALUE.doubleValue() > MAX.doubleValue()) {
            return MAX;
        }
        return VALUE;
    }

    public static final double[] calcAutoScale(double MIN_VALUE, double MAX_VALUE) {
        double maxNoOfMajorTicks = 10.0;
        double maxNoOfMinorTicks = 10.0;
        double niceRange = Helper.calcNiceNumber(MAX_VALUE - MIN_VALUE, false);
        double majorTickSpace = Helper.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true);
        double niceMinValue = Math.floor(MIN_VALUE / majorTickSpace) * majorTickSpace;
        double niceMaxValue = Math.ceil(MAX_VALUE / majorTickSpace) * majorTickSpace;
        double minorTickSpace = Helper.calcNiceNumber(majorTickSpace / (maxNoOfMinorTicks - 1.0), true);
        return new double[]{niceMinValue, niceMaxValue, majorTickSpace, minorTickSpace};
    }

    public static final double calcNiceNumber(double RANGE, boolean ROUND) {
        double exponent = Math.floor(Math.log10(RANGE));
        double fraction = RANGE / Math.pow(10.0, exponent);
        double niceFraction = ROUND ? (Double.compare(fraction, 1.5) < 0 ? 1.0 : (Double.compare(fraction, 3.0) < 0 ? 2.0 : (Double.compare(fraction, 7.0) < 0 ? 5.0 : 10.0))) : (Double.compare(fraction, 1.0) <= 0 ? 1.0 : (Double.compare(fraction, 2.0) <= 0 ? 2.0 : (Double.compare(fraction, 5.0) <= 0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public static final Color getColorOfSection(List<Section> SECTIONS, double VALUE, Color DEFAULT_COLOR) {
        for (Section section : SECTIONS) {
            if (!section.contains(VALUE)) continue;
            return section.getColor();
        }
        return DEFAULT_COLOR;
    }

    public static final void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double ANGLE, TickLabelOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case ORTHOGONAL: {
                if ((360.0 - START_ANGLE - ANGLE) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE) % 360.0 < 270.0) {
                    CTX.rotate((180.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((360.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
            case TANGENT: {
                if ((360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 < 270.0) {
                    CTX.rotate((90.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((270.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
        }
    }

    public static final void adjustTextSize(Text TEXT, double MAX_WIDTH, double fontSize) {
        String FONT_NAME = TEXT.getFont().getName();
        while (TEXT.getLayoutBounds().getWidth() > MAX_WIDTH && fontSize > 0.0) {
            TEXT.setFont(new Font(FONT_NAME, fontSize -= 0.005));
        }
    }

    public static final String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    public static final ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    public static final void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    public static final ImagePattern createCarbonPattern() {
        double SIZE = 12.0;
        Canvas CANVAS = new Canvas(12.0, 12.0);
        GraphicsContext CTX = CANVAS.getGraphicsContext2D();
        CTX.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 6.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)35, (int)35, (int)35)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))}));
        CTX.fillRect(0.0, 0.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 4.999992, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)30, (int)30, (int)30))}));
        CTX.fillRect(0.9999960000000001, 0.0, 3.999996, 4.999992);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.0, 0.0, 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)35, (int)35, (int)35)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))}));
        CTX.fillRect(6.0, 6.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.0, 0.0, 10.999991999999999, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)30, (int)30, (int)30))}));
        CTX.fillRect(6.999995999999999, 6.0, 3.999996, 4.999992);
        CTX.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 6.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)48, (int)48, (int)48)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
        CTX.fillRect(6.0, 0.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 0.9999960000000001, 0.0, 6.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)53, (int)53, (int)53)), new Stop(1.0, Color.rgb((int)45, (int)45, (int)45))}));
        CTX.fillRect(6.999995999999999, 0.9999960000000001, 3.999996, 4.999992);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.0, 0.0, 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)48, (int)48, (int)48)), new Stop(1.0, Color.rgb((int)40, (int)40, (int)40))}));
        CTX.fillRect(0.0, 6.0, 6.0, 6.0);
        CTX.setFill((Paint)new LinearGradient(0.0, 6.999995999999999, 0.0, 12.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)53, (int)53, (int)53)), new Stop(1.0, Color.rgb((int)45, (int)45, (int)45))}));
        CTX.fillRect(0.9999960000000001, 6.999995999999999, 3.999996, 4.999992);
        WritableImage PATTERN_IMAGE = CANVAS.snapshot(new SnapshotParameters(), null);
        ImagePattern PATTERN = new ImagePattern((Image)PATTERN_IMAGE, 0.0, 0.0, 12.0, 12.0, false);
        return PATTERN;
    }

    public static void drawTriangle(GraphicsContext CTX, double PI1X, double PI1Y, double PI2X, double PI2Y, double PO1X, double PO1Y, double PO2X, double PO2Y) {
        CTX.beginPath();
        CTX.moveTo(PI2X, PI2Y);
        CTX.lineTo(PI1X, PI1Y);
        CTX.lineTo(PO1X, PO1Y);
        CTX.lineTo(PO2X, PO2Y);
        CTX.closePath();
        CTX.fill();
    }

    public static void drawDot(GraphicsContext CTX, double CENTER_X, double CENTER_Y, double SIZE) {
        CTX.fillOval(CENTER_X, CENTER_Y, SIZE, SIZE);
    }

    public static void drawLine(GraphicsContext CTX, double P1X, double P1Y, double P2X, double P2Y) {
        CTX.strokeLine(P1X, P1Y, P2X, P2Y);
    }

    public static boolean isMonochrome(Color COLOR) {
        return Double.compare(COLOR.getRed(), COLOR.getGreen()) == 0 && Double.compare(COLOR.getGreen(), COLOR.getBlue()) == 0;
    }

    public static double colorDistance(Color COLOR_1, Color COLOR_2) {
        double DELTA_R = COLOR_2.getRed() - COLOR_1.getRed();
        double DELTA_G = COLOR_2.getGreen() - COLOR_1.getGreen();
        double DELTA_B = COLOR_2.getBlue() - COLOR_1.getBlue();
        return Math.sqrt(DELTA_R * DELTA_R + DELTA_G * DELTA_G + DELTA_B * DELTA_B);
    }

    public static boolean isBright(Color COLOR) {
        return !Helper.isDark(COLOR);
    }

    public static boolean isDark(Color COLOR) {
        double DISTANCE_TO_WHITE = Helper.colorDistance(COLOR, Color.WHITE);
        double DISTANCE_TO_BLACK = Helper.colorDistance(COLOR, Color.BLACK);
        return DISTANCE_TO_BLACK < DISTANCE_TO_WHITE;
    }

    public static void drawRadialTickMarks(Gauge GAUGE, GraphicsContext CTX, double MIN_VALUE, double MAX_VALUE, double START_ANGLE, double ANGLE_RANGE, double ANGLE_STEP, double CENTER_X, double CENTER_Y, double SIZE) {
        double minorHalfDotSize;
        double minorDotSize;
        double mediumHalfDotSize;
        double mediumDotSize;
        double majorHalfDotSize;
        double majorDotSize;
        double orthTextFactor;
        double textDisplacementFactor;
        List<String> customTickLabels;
        double centerX = CENTER_X;
        double centerY = CENTER_Y;
        int tickLabelDecimals = GAUGE.getTickLabelDecimals();
        String tickLabelFormatString = "%." + tickLabelDecimals + "f";
        double minorTickSpace = GAUGE.getMinorTickSpace();
        double tmpAngleStep = ANGLE_STEP * minorTickSpace;
        TickLabelOrientation tickLabelOrientation = GAUGE.getTickLabelOrientation();
        TickLabelLocation tickLabelLocation = GAUGE.getTickLabelLocation();
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(GAUGE.getMajorTickSpace());
        BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
        BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
        BigDecimal counterBD = BigDecimal.valueOf(MIN_VALUE);
        double counter = MIN_VALUE;
        ObservableList<Section> tickMarkSections = GAUGE.getTickMarkSections();
        ObservableList<Section> tickLabelSections = GAUGE.getTickLabelSections();
        Color tickMarkColor = GAUGE.getTickMarkColor();
        Color majorTickMarkColor = GAUGE.getMajorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : GAUGE.getMajorTickMarkColor();
        Color mediumTickMarkColor = GAUGE.getMediumTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : GAUGE.getMediumTickMarkColor();
        Color minorTickMarkColor = GAUGE.getMinorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : GAUGE.getMinorTickMarkColor();
        Color tickLabelColor = GAUGE.getTickLabelColor();
        Color zeroColor = GAUGE.getZeroColor();
        boolean isNotZero = true;
        TickMarkType majorTickMarkType = GAUGE.getMajorTickMarkType();
        TickMarkType mediumTickMarkType = GAUGE.getMediumTickMarkType();
        TickMarkType minorTickMarkType = GAUGE.getMinorTickMarkType();
        boolean tickMarkSectionsVisible = GAUGE.getTickMarkSectionsVisible();
        boolean tickLabelSectionsVisible = GAUGE.getTickLabelSectionsVisible();
        boolean majorTickMarksVisible = GAUGE.getMajorTickMarksVisible();
        boolean mediumTickMarksVisible = GAUGE.getMediumTickMarksVisible();
        boolean minorTickMarksVisible = GAUGE.getMinorTickMarksVisible();
        boolean tickLabelsVisible = GAUGE.getTickLabelsVisible();
        boolean onlyFirstAndLastLabelVisible = GAUGE.isOnlyFirstAndLastTickLabelVisible();
        boolean customTickLabelsEnabled = GAUGE.getCustomTickLabelsEnabled();
        List<String> list = customTickLabels = customTickLabelsEnabled ? GAUGE.getCustomTickLabels() : null;
        double d = majorTickMarkType == TickMarkType.DOT ? (TickLabelLocation.OUTSIDE == tickLabelLocation ? 0.95 : 1.05) : (textDisplacementFactor = 1.0);
        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
            orthTextFactor = TickLabelOrientation.ORTHOGONAL == tickLabelOrientation ? 0.45 * textDisplacementFactor : 0.45 * textDisplacementFactor;
            majorDotSize = 0.02 * SIZE;
            majorHalfDotSize = majorDotSize * 0.5;
            mediumDotSize = 0.01375 * SIZE;
            mediumHalfDotSize = mediumDotSize * 0.5;
            minorDotSize = 0.0075 * SIZE;
            minorHalfDotSize = minorDotSize * 0.5;
        } else {
            orthTextFactor = TickLabelOrientation.ORTHOGONAL == tickLabelOrientation ? 0.38 * textDisplacementFactor : 0.37 * textDisplacementFactor;
            majorDotSize = 0.025 * SIZE;
            majorHalfDotSize = majorDotSize * 0.5;
            mediumDotSize = 0.01875 * SIZE;
            mediumHalfDotSize = mediumDotSize * 0.5;
            minorDotSize = 0.0125 * SIZE;
            minorHalfDotSize = minorDotSize * 0.5;
        }
        double customFontSizeFactor = GAUGE.getCustomTickLabelFontSize() / 400.0;
        boolean fullRange = MIN_VALUE < 0.0 && MAX_VALUE > 0.0;
        double tickLabelFontSize = tickLabelDecimals == 0 ? 0.054 * SIZE : 0.051 * SIZE;
        tickLabelFontSize = GAUGE.getCustomTickLabelsEnabled() ? customFontSizeFactor * SIZE : tickLabelFontSize;
        double tickMarkFontSize = tickLabelDecimals == 0 ? 0.047 * SIZE : 0.044 * SIZE;
        double tickLabelOrientationFactor = TickLabelOrientation.HORIZONTAL == tickLabelOrientation ? 0.9 : 1.0;
        Font tickLabelFont = Fonts.robotoCondensedRegular(tickLabelFontSize * tickLabelOrientationFactor);
        Font tickMarkFont = Fonts.robotoCondensedRegular(tickMarkFontSize * tickLabelOrientationFactor);
        Font tickLabelZeroFont = fullRange ? Fonts.robotoCondensedBold(tickLabelFontSize * tickLabelOrientationFactor) : tickLabelFont;
        Font tickMarkZeroFont = fullRange ? Fonts.robotoCondensedBold(tickMarkFontSize * tickLabelOrientationFactor) : tickMarkFont;
        Gauge.ScaleDirection scaleDirection = GAUGE.getScaleDirection();
        BigDecimal tmpStepBD = new BigDecimal(tmpAngleStep);
        tmpStepBD = tmpStepBD.setScale(3, 4);
        double tmpStep = tmpStepBD.doubleValue();
        double angle = 0.0;
        int customTickLabelCounter = 0;
        double i = 0.0;
        while (Double.compare(-ANGLE_RANGE - tmpStep, i) <= 0) {
            double triangleMinorOuterPoint2Y;
            double triangleMinorOuterPoint2X;
            double triangleMinorOuterPoint1Y;
            double triangleMinorOuterPoint1X;
            double triangleMinorInnerPoint2Y;
            double triangleMinorInnerPoint2X;
            double triangleMinorInnerPoint1Y;
            double triangleMinorInnerPoint1X;
            double triangleMediumOuterPoint2Y;
            double triangleMediumOuterPoint2X;
            double triangleMediumOuterPoint1Y;
            double triangleMediumOuterPoint1X;
            double triangleMediumInnerPoint2Y;
            double triangleMediumInnerPoint2X;
            double triangleMediumInnerPoint1Y;
            double triangleMediumInnerPoint1X;
            double triangleMajorOuterPoint2Y;
            double triangleMajorOuterPoint2X;
            double triangleMajorOuterPoint1Y;
            double triangleMajorOuterPoint1X;
            double triangleMajorInnerPoint2Y;
            double triangleMajorInnerPoint2X;
            double triangleMajorInnerPoint1Y;
            double triangleMajorInnerPoint1X;
            double tickLabelTickMarkY;
            double tickLabelTickMarkX;
            double dotMinorCenterY;
            double dotMinorCenterX;
            double dotMediumCenterY;
            double dotMediumCenterX;
            double dotCenterY;
            double dotCenterX;
            double textPointY;
            double textPointX;
            double outerMinorPointY;
            double outerMinorPointX;
            double outerMediumPointY;
            double outerMediumPointX;
            double outerPointY;
            double outerPointX;
            double innerMinorPointY;
            double innerMinorPointX;
            double innerMediumPointY;
            double innerMediumPointX;
            double innerPointY;
            double innerPointX;
            double sinValue = Math.sin(Math.toRadians(angle + START_ANGLE));
            double cosValue = Math.cos(Math.toRadians(angle + START_ANGLE));
            switch (tickLabelLocation) {
                case OUTSIDE: {
                    innerPointX = centerX + SIZE * 0.3585 * sinValue;
                    innerPointY = centerY + SIZE * 0.3585 * cosValue;
                    innerMediumPointX = centerX + SIZE * 0.3585 * sinValue;
                    innerMediumPointY = centerY + SIZE * 0.3585 * cosValue;
                    innerMinorPointX = centerX + SIZE * 0.3585 * sinValue;
                    innerMinorPointY = centerY + SIZE * 0.3585 * cosValue;
                    outerPointX = centerX + SIZE * 0.4105 * sinValue;
                    outerPointY = centerY + SIZE * 0.4105 * cosValue;
                    outerMediumPointX = centerX + SIZE * 0.4045 * sinValue;
                    outerMediumPointY = centerY + SIZE * 0.4045 * cosValue;
                    outerMinorPointX = centerX + SIZE * 0.3975 * sinValue;
                    outerMinorPointY = centerY + SIZE * 0.3975 * cosValue;
                    textPointX = centerX + SIZE * orthTextFactor * sinValue;
                    textPointY = centerY + SIZE * orthTextFactor * cosValue;
                    dotCenterX = centerX + SIZE * 0.3685 * sinValue;
                    dotCenterY = centerY + SIZE * 0.3685 * cosValue;
                    dotMediumCenterX = centerX + SIZE * 0.365375 * sinValue;
                    dotMediumCenterY = centerY + SIZE * 0.365375 * cosValue;
                    dotMinorCenterX = centerX + SIZE * 0.36225 * sinValue;
                    dotMinorCenterY = centerY + SIZE * 0.36225 * cosValue;
                    tickLabelTickMarkX = centerX + SIZE * 0.3805 * sinValue;
                    tickLabelTickMarkY = centerY + SIZE * 0.3805 * cosValue;
                    double triangleMajorInnerAngle1 = Math.toRadians(angle - 1.2 + START_ANGLE);
                    double triangleMajorInnerAngle2 = Math.toRadians(angle + 1.2 + START_ANGLE);
                    double triangleMajorOuterAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double triangleMajorOuterAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    triangleMajorInnerPoint1X = centerX + SIZE * 0.3585 * Math.sin(triangleMajorInnerAngle1);
                    triangleMajorInnerPoint1Y = centerY + SIZE * 0.3585 * Math.cos(triangleMajorInnerAngle1);
                    triangleMajorInnerPoint2X = centerX + SIZE * 0.3585 * Math.sin(triangleMajorInnerAngle2);
                    triangleMajorInnerPoint2Y = centerY + SIZE * 0.3585 * Math.cos(triangleMajorInnerAngle2);
                    triangleMajorOuterPoint1X = centerX + SIZE * 0.4105 * Math.sin(triangleMajorOuterAngle1);
                    triangleMajorOuterPoint1Y = centerY + SIZE * 0.4105 * Math.cos(triangleMajorOuterAngle1);
                    triangleMajorOuterPoint2X = centerX + SIZE * 0.4105 * Math.sin(triangleMajorOuterAngle2);
                    triangleMajorOuterPoint2Y = centerY + SIZE * 0.4105 * Math.cos(triangleMajorOuterAngle2);
                    double triangleMediumInnerAngle1 = Math.toRadians(angle - 1.0 + START_ANGLE);
                    double triangleMediumInnerAngle2 = Math.toRadians(angle + 1.0 + START_ANGLE);
                    double triangleMediumOuterAngle1 = Math.toRadians(angle - 0.7 + START_ANGLE);
                    double triangleMediumOuterAngle2 = Math.toRadians(angle + 0.7 + START_ANGLE);
                    triangleMediumInnerPoint1X = centerX + SIZE * 0.3585 * Math.sin(triangleMediumInnerAngle1);
                    triangleMediumInnerPoint1Y = centerY + SIZE * 0.3585 * Math.cos(triangleMediumInnerAngle1);
                    triangleMediumInnerPoint2X = centerX + SIZE * 0.3585 * Math.sin(triangleMediumInnerAngle2);
                    triangleMediumInnerPoint2Y = centerY + SIZE * 0.3585 * Math.cos(triangleMediumInnerAngle2);
                    triangleMediumOuterPoint1X = centerX + SIZE * 0.3985 * Math.sin(triangleMajorOuterAngle1);
                    triangleMediumOuterPoint1Y = centerY + SIZE * 0.3985 * Math.cos(triangleMediumOuterAngle1);
                    triangleMediumOuterPoint2X = centerX + SIZE * 0.3985 * Math.sin(triangleMediumOuterAngle2);
                    triangleMediumOuterPoint2Y = centerY + SIZE * 0.3985 * Math.cos(triangleMediumOuterAngle2);
                    double triangleMinorInnerAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double triangleMinorInnerAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    double triangleMinorOuterAngle1 = Math.toRadians(angle - 0.6 + START_ANGLE);
                    double triangleMinorOuterAngle2 = Math.toRadians(angle + 0.6 + START_ANGLE);
                    triangleMinorInnerPoint1X = centerX + SIZE * 0.3585 * Math.sin(triangleMinorInnerAngle1);
                    triangleMinorInnerPoint1Y = centerY + SIZE * 0.3585 * Math.cos(triangleMinorInnerAngle1);
                    triangleMinorInnerPoint2X = centerX + SIZE * 0.3585 * Math.sin(triangleMinorInnerAngle2);
                    triangleMinorInnerPoint2Y = centerY + SIZE * 0.3585 * Math.cos(triangleMinorInnerAngle2);
                    triangleMinorOuterPoint1X = centerX + SIZE * 0.3975 * Math.sin(triangleMinorOuterAngle1);
                    triangleMinorOuterPoint1Y = centerY + SIZE * 0.3975 * Math.cos(triangleMinorOuterAngle1);
                    triangleMinorOuterPoint2X = centerX + SIZE * 0.3975 * Math.sin(triangleMinorOuterAngle2);
                    triangleMinorOuterPoint2Y = centerY + SIZE * 0.3975 * Math.cos(triangleMinorOuterAngle2);
                    break;
                }
                default: {
                    innerPointX = centerX + SIZE * 0.423 * sinValue;
                    innerPointY = centerY + SIZE * 0.423 * cosValue;
                    innerMediumPointX = centerX + SIZE * 0.43 * sinValue;
                    innerMediumPointY = centerY + SIZE * 0.43 * cosValue;
                    innerMinorPointX = centerX + SIZE * 0.436 * sinValue;
                    innerMinorPointY = centerY + SIZE * 0.436 * cosValue;
                    outerPointX = centerX + SIZE * 0.475 * sinValue;
                    outerPointY = centerY + SIZE * 0.475 * cosValue;
                    outerMediumPointX = centerX + SIZE * 0.475 * sinValue;
                    outerMediumPointY = centerY + SIZE * 0.475 * cosValue;
                    outerMinorPointX = centerX + SIZE * 0.475 * sinValue;
                    outerMinorPointY = centerY + SIZE * 0.475 * cosValue;
                    textPointX = centerX + SIZE * orthTextFactor * sinValue;
                    textPointY = centerY + SIZE * orthTextFactor * cosValue;
                    dotCenterX = centerX + SIZE * 0.4625 * sinValue;
                    dotCenterY = centerY + SIZE * 0.4625 * cosValue;
                    dotMediumCenterX = centerX + SIZE * 0.465625 * sinValue;
                    dotMediumCenterY = centerY + SIZE * 0.465625 * cosValue;
                    dotMinorCenterX = centerX + SIZE * 0.46875 * sinValue;
                    dotMinorCenterY = centerY + SIZE * 0.46875 * cosValue;
                    tickLabelTickMarkX = centerX + SIZE * 0.445 * sinValue;
                    tickLabelTickMarkY = centerY + SIZE * 0.445 * cosValue;
                    double triangleMajorInnerAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double triangleMajorInnerAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    double triangleMajorOuterAngle1 = Math.toRadians(angle - 1.2 + START_ANGLE);
                    double triangleMajorOuterAngle2 = Math.toRadians(angle + 1.2 + START_ANGLE);
                    triangleMajorInnerPoint1X = centerX + SIZE * 0.423 * Math.sin(triangleMajorInnerAngle1);
                    triangleMajorInnerPoint1Y = centerY + SIZE * 0.423 * Math.cos(triangleMajorInnerAngle1);
                    triangleMajorInnerPoint2X = centerX + SIZE * 0.423 * Math.sin(triangleMajorInnerAngle2);
                    triangleMajorInnerPoint2Y = centerY + SIZE * 0.423 * Math.cos(triangleMajorInnerAngle2);
                    triangleMajorOuterPoint1X = centerX + SIZE * 0.475 * Math.sin(triangleMajorOuterAngle1);
                    triangleMajorOuterPoint1Y = centerY + SIZE * 0.475 * Math.cos(triangleMajorOuterAngle1);
                    triangleMajorOuterPoint2X = centerX + SIZE * 0.475 * Math.sin(triangleMajorOuterAngle2);
                    triangleMajorOuterPoint2Y = centerY + SIZE * 0.475 * Math.cos(triangleMajorOuterAngle2);
                    double triangleMediumInnerAngle1 = Math.toRadians(angle - 0.7 + START_ANGLE);
                    double triangleMediumInnerAngle2 = Math.toRadians(angle + 0.7 + START_ANGLE);
                    double triangleMediumOuterAngle1 = Math.toRadians(angle - 1.0 + START_ANGLE);
                    double triangleMediumOuterAngle2 = Math.toRadians(angle + 1.0 + START_ANGLE);
                    triangleMediumInnerPoint1X = centerX + SIZE * 0.435 * Math.sin(triangleMediumInnerAngle1);
                    triangleMediumInnerPoint1Y = centerY + SIZE * 0.435 * Math.cos(triangleMediumInnerAngle1);
                    triangleMediumInnerPoint2X = centerX + SIZE * 0.435 * Math.sin(triangleMediumInnerAngle2);
                    triangleMediumInnerPoint2Y = centerY + SIZE * 0.435 * Math.cos(triangleMediumInnerAngle2);
                    triangleMediumOuterPoint1X = centerX + SIZE * 0.475 * Math.sin(triangleMajorOuterAngle1);
                    triangleMediumOuterPoint1Y = centerY + SIZE * 0.475 * Math.cos(triangleMediumOuterAngle1);
                    triangleMediumOuterPoint2X = centerX + SIZE * 0.475 * Math.sin(triangleMediumOuterAngle2);
                    triangleMediumOuterPoint2Y = centerY + SIZE * 0.475 * Math.cos(triangleMediumOuterAngle2);
                    double triangleMinorInnerAngle1 = Math.toRadians(angle - 0.6 + START_ANGLE);
                    double triangleMinorInnerAngle2 = Math.toRadians(angle + 0.6 + START_ANGLE);
                    double triangleMinorOuterAngle1 = Math.toRadians(angle - 0.8 + START_ANGLE);
                    double triangleMinorOuterAngle2 = Math.toRadians(angle + 0.8 + START_ANGLE);
                    triangleMinorInnerPoint1X = centerX + SIZE * 0.44 * Math.sin(triangleMinorInnerAngle1);
                    triangleMinorInnerPoint1Y = centerY + SIZE * 0.44 * Math.cos(triangleMinorInnerAngle1);
                    triangleMinorInnerPoint2X = centerX + SIZE * 0.44 * Math.sin(triangleMinorInnerAngle2);
                    triangleMinorInnerPoint2Y = centerY + SIZE * 0.44 * Math.cos(triangleMinorInnerAngle2);
                    triangleMinorOuterPoint1X = centerX + SIZE * 0.475 * Math.sin(triangleMinorOuterAngle1);
                    triangleMinorOuterPoint1Y = centerY + SIZE * 0.475 * Math.cos(triangleMinorOuterAngle1);
                    triangleMinorOuterPoint2X = centerX + SIZE * 0.475 * Math.sin(triangleMinorOuterAngle2);
                    triangleMinorOuterPoint2Y = centerY + SIZE * 0.475 * Math.cos(triangleMinorOuterAngle2);
                }
            }
            CTX.setStroke((Paint)tickMarkColor);
            CTX.setFill((Paint)tickMarkColor);
            CTX.setLineCap(StrokeLineCap.BUTT);
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                isNotZero = Double.compare(0.0, counter) != 0;
                TickMarkType tickMarkType = null;
                if (majorTickMarksVisible) {
                    tickMarkType = majorTickMarkType;
                    CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, majorTickMarkColor) : majorTickMarkColor));
                    CTX.setLineWidth(SIZE * (TickMarkType.BOX == tickMarkType || TickMarkType.PILL == tickMarkType ? 0.016 : 0.0055));
                    CTX.setLineCap(TickMarkType.PILL == tickMarkType ? StrokeLineCap.ROUND : StrokeLineCap.BUTT);
                } else if (minorTickMarksVisible) {
                    tickMarkType = minorTickMarkType;
                    CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                    CTX.setLineWidth(SIZE * (TickMarkType.BOX == tickMarkType || TickMarkType.PILL == tickMarkType ? 0.007 : 0.00225));
                    CTX.setLineCap(TickMarkType.PILL == tickMarkType ? StrokeLineCap.ROUND : StrokeLineCap.BUTT);
                }
                if (fullRange && !isNotZero) {
                    CTX.setFill((Paint)zeroColor);
                    CTX.setStroke((Paint)zeroColor);
                }
                if (null != tickMarkType) {
                    switch (tickMarkType) {
                        case TRIANGLE: {
                            if (majorTickMarksVisible) {
                                Helper.drawTriangle(CTX, triangleMajorInnerPoint1X, triangleMajorInnerPoint1Y, triangleMajorInnerPoint2X, triangleMajorInnerPoint2Y, triangleMajorOuterPoint1X, triangleMajorOuterPoint1Y, triangleMajorOuterPoint2X, triangleMajorOuterPoint2Y);
                                break;
                            }
                            if (!minorTickMarksVisible) break;
                            Helper.drawTriangle(CTX, triangleMinorInnerPoint1X, triangleMinorInnerPoint1Y, triangleMinorInnerPoint2X, triangleMinorInnerPoint2Y, triangleMinorOuterPoint1X, triangleMinorOuterPoint1Y, triangleMinorOuterPoint2X, triangleMinorOuterPoint2Y);
                            break;
                        }
                        case DOT: {
                            if (majorTickMarksVisible) {
                                Helper.drawDot(CTX, dotCenterX - majorHalfDotSize, dotCenterY - majorHalfDotSize, majorDotSize);
                                break;
                            }
                            if (!minorTickMarksVisible) break;
                            Helper.drawDot(CTX, dotMinorCenterX - minorHalfDotSize, dotMinorCenterY - minorHalfDotSize, minorDotSize);
                            break;
                        }
                        case TICK_LABEL: {
                            if (!majorTickMarksVisible) break;
                            CTX.save();
                            CTX.translate(tickLabelTickMarkX, tickLabelTickMarkY);
                            Helper.rotateContextForText(CTX, START_ANGLE, angle, tickLabelOrientation);
                            CTX.setFont(isNotZero ? tickMarkFont : tickMarkZeroFont);
                            CTX.setTextAlign(TextAlignment.CENTER);
                            CTX.setTextBaseline(VPos.CENTER);
                            CTX.fillText(String.format(Locale.US, tickLabelFormatString, counter), 0.0, 0.0);
                            CTX.restore();
                            break;
                        }
                        default: {
                            if (majorTickMarksVisible) {
                                Helper.drawLine(CTX, innerPointX, innerPointY, outerPointX, outerPointY);
                                break;
                            }
                            if (!minorTickMarksVisible) break;
                            if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                                Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                                break;
                            }
                            Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                        }
                    }
                }
                if (tickLabelsVisible) {
                    CTX.save();
                    CTX.translate(textPointX, textPointY);
                    Helper.rotateContextForText(CTX, START_ANGLE, angle, tickLabelOrientation);
                    CTX.setFont(isNotZero ? tickLabelFont : tickLabelZeroFont);
                    CTX.setTextAlign(TextAlignment.CENTER);
                    CTX.setTextBaseline(VPos.CENTER);
                    if (!onlyFirstAndLastLabelVisible) {
                        if (isNotZero) {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                        } else {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : (fullRange ? zeroColor : tickLabelColor)));
                        }
                    } else if (Double.compare(counter, MIN_VALUE) == 0 || Double.compare(counter, MAX_VALUE) == 0) {
                        if (isNotZero) {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : tickLabelColor));
                        } else {
                            CTX.setFill((Paint)(tickLabelSectionsVisible ? Helper.getColorOfSection(tickLabelSections, counter, tickLabelColor) : (fullRange ? zeroColor : tickLabelColor)));
                        }
                    } else {
                        CTX.setFill((Paint)Color.TRANSPARENT);
                    }
                    if (customTickLabelsEnabled) {
                        if (customTickLabelCounter >= 0) {
                            CTX.fillText(customTickLabels.get(customTickLabelCounter), 0.0, 0.0);
                            ++customTickLabelCounter;
                        }
                        if (customTickLabelCounter > customTickLabels.size() - 1) {
                            customTickLabelCounter = -1;
                        }
                    } else {
                        CTX.fillText(String.format(Locale.US, tickLabelFormatString, counter), 0.0, 0.0);
                    }
                    CTX.restore();
                }
            } else if (mediumTickMarksVisible && (double)Double.compare(minorTickSpaceBD.remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, mediumTickMarkColor) : mediumTickMarkColor));
                CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, mediumTickMarkColor) : mediumTickMarkColor));
                switch (mediumTickMarkType) {
                    case TRIANGLE: {
                        Helper.drawTriangle(CTX, triangleMediumInnerPoint1X, triangleMediumInnerPoint1Y, triangleMediumInnerPoint2X, triangleMediumInnerPoint2Y, triangleMediumOuterPoint1X, triangleMediumOuterPoint1Y, triangleMediumOuterPoint2X, triangleMediumOuterPoint2Y);
                        break;
                    }
                    case DOT: {
                        Helper.drawDot(CTX, dotMediumCenterX - mediumHalfDotSize, dotMediumCenterY - mediumHalfDotSize, mediumDotSize);
                        break;
                    }
                    case BOX: {
                        CTX.setLineWidth(SIZE * 0.009);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                    case PILL: {
                        CTX.setLineCap(StrokeLineCap.ROUND);
                        CTX.setLineWidth(SIZE * 0.009);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                    default: {
                        CTX.setLineWidth(SIZE * 0.0035);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMediumPointX, outerMediumPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMediumPointX, innerMediumPointY, outerPointX, outerPointY);
                        break;
                    }
                }
            } else if (minorTickMarksVisible && Double.compare(counterBD.remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0 && TickMarkType.TICK_LABEL != majorTickMarkType) {
                CTX.setFill((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                CTX.setStroke((Paint)(tickMarkSectionsVisible ? Helper.getColorOfSection(tickMarkSections, counter, minorTickMarkColor) : minorTickMarkColor));
                switch (minorTickMarkType) {
                    case TRIANGLE: {
                        Helper.drawTriangle(CTX, triangleMinorInnerPoint1X, triangleMinorInnerPoint1Y, triangleMinorInnerPoint2X, triangleMinorInnerPoint2Y, triangleMinorOuterPoint1X, triangleMinorOuterPoint1Y, triangleMinorOuterPoint2X, triangleMinorOuterPoint2Y);
                        break;
                    }
                    case DOT: {
                        Helper.drawDot(CTX, dotMinorCenterX - minorHalfDotSize, dotMinorCenterY - minorHalfDotSize, minorDotSize);
                        break;
                    }
                    case BOX: {
                        CTX.setLineWidth(SIZE * 0.007);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                        break;
                    }
                    case PILL: {
                        CTX.setLineCap(StrokeLineCap.ROUND);
                        CTX.setLineWidth(SIZE * 0.007);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                        break;
                    }
                    default: {
                        CTX.setLineWidth(SIZE * 0.00225);
                        if (TickLabelLocation.OUTSIDE == tickLabelLocation) {
                            Helper.drawLine(CTX, innerPointX, innerPointY, outerMinorPointX, outerMinorPointY);
                            break;
                        }
                        Helper.drawLine(CTX, innerMinorPointX, innerMinorPointY, outerPointX, outerPointY);
                    }
                }
            }
            counterBD = counterBD.add(minorTickSpaceBD);
            counter = counterBD.doubleValue();
            if (counter > MAX_VALUE) break;
            angle = Gauge.ScaleDirection.CLOCKWISE == scaleDirection ? angle - tmpAngleStep : angle + tmpAngleStep;
            i -= tmpStep;
        }
    }

    public static Image createNoiseImage(double WIDTH, double HEIGHT, Color DARK_COLOR, Color BRIGHT_COLOR, double ALPHA_VARIATION_IN_PERCENT) {
        if (Double.compare(WIDTH, 0.0) <= 0 || Double.compare(HEIGHT, 0.0) <= 0) {
            return null;
        }
        int width = (int)WIDTH;
        int height = (int)HEIGHT;
        double alphaVariationInPercent = Helper.clamp(0.0, 100.0, ALPHA_VARIATION_IN_PERCENT);
        WritableImage IMAGE = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = IMAGE.getPixelWriter();
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        double ALPHA_START = alphaVariationInPercent / 100.0 / 2.0;
        double ALPHA_VARIATION = alphaVariationInPercent / 100.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color NOISE_COLOR = BW_RND.nextBoolean() ? BRIGHT_COLOR : DARK_COLOR;
                double NOISE_ALPHA = Helper.clamp(0.0, 1.0, ALPHA_START + ALPHA_RND.nextDouble() * ALPHA_VARIATION);
                PIXEL_WRITER.setColor(x, y, Color.color((double)NOISE_COLOR.getRed(), (double)NOISE_COLOR.getGreen(), (double)NOISE_COLOR.getBlue(), (double)NOISE_ALPHA));
            }
        }
        return IMAGE;
    }

    public static void drawTimeSections(Clock CLOCK, GraphicsContext CTX, List<TimeSection> SECTIONS, double SIZE, double XY_INSIDE, double XY_OUTSIDE, double WH_INSIDE, double WH_OUTSIDE, double LINE_WIDTH) {
        if (SECTIONS.isEmpty()) {
            return;
        }
        TickLabelLocation tickLabelLocation = CLOCK.getTickLabelLocation();
        double xy = TickLabelLocation.INSIDE == tickLabelLocation ? XY_INSIDE * SIZE : XY_OUTSIDE * SIZE;
        double wh = TickLabelLocation.INSIDE == tickLabelLocation ? WH_INSIDE * SIZE : WH_OUTSIDE * SIZE;
        double offset = 90.0;
        int listSize = SECTIONS.size();
        double angleStep = 6.0;
        for (int i = 0; i < listSize; ++i) {
            TimeSection section = SECTIONS.get(i);
            LocalTime start = section.getStart();
            LocalTime stop = section.getStop();
            double sectionStartAngle = ((double)(start.getHour() % 12) * 5.0 + (double)start.getMinute() / 12.0 + (double)start.getSecond() / 300.0) * angleStep + 180.0;
            double sectionAngleExtend = ((double)((stop.getHour() - start.getHour()) % 12) * 5.0 + (double)(stop.getMinute() - start.getMinute()) / 12.0 + (double)(stop.getSecond() - start.getSecond()) / 300.0) * angleStep;
            CTX.save();
            CTX.setStroke((Paint)section.getColor());
            CTX.setLineWidth(SIZE * LINE_WIDTH);
            CTX.setLineCap(StrokeLineCap.BUTT);
            CTX.strokeArc(xy, xy, wh, wh, -(offset + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
            CTX.restore();
        }
    }

    public static void drawTimeAreas(Clock CLOCK, GraphicsContext CTX, List<TimeSection> AREAS, double SIZE, double XY_INSIDE, double XY_OUTSIDE, double WH_INSIDE, double WH_OUTSIDE) {
        if (AREAS.isEmpty()) {
            return;
        }
        TickLabelLocation tickLabelLocation = CLOCK.getTickLabelLocation();
        double xy = TickLabelLocation.OUTSIDE == tickLabelLocation ? XY_OUTSIDE * SIZE : XY_INSIDE * SIZE;
        double wh = TickLabelLocation.OUTSIDE == tickLabelLocation ? WH_OUTSIDE * SIZE : WH_INSIDE * SIZE;
        double offset = 90.0;
        double angleStep = 6.0;
        int listSize = AREAS.size();
        for (int i = 0; i < listSize; ++i) {
            TimeSection area = AREAS.get(i);
            LocalTime start = area.getStart();
            LocalTime stop = area.getStop();
            double areaStartAngle = ((double)(start.getHour() % 12) * 5.0 + (double)start.getMinute() / 12.0 + (double)start.getSecond() / 300.0) * angleStep + 180.0;
            double areaAngleExtend = ((double)((stop.getHour() - start.getHour()) % 12) * 5.0 + (double)(stop.getMinute() - start.getMinute()) / 12.0 + (double)(stop.getSecond() - start.getSecond()) / 300.0) * angleStep;
            CTX.save();
            CTX.setFill((Paint)area.getColor());
            CTX.fillArc(xy, xy, wh, wh, -(offset + areaStartAngle), -areaAngleExtend, ArcType.ROUND);
            CTX.restore();
        }
    }
}

