/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.AngleConicalGradient;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class TinySkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ANGLE_RANGE = 270.0;
    private double size;
    private double oldValue;
    private Arc barBackground;
    private Canvas sectionCanvas;
    private GraphicsContext sectionCtx;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private CubicCurveTo needleCubicCurveTo5;
    private ClosePath needleClosePath6;
    private MoveTo needleMoveTo7;
    private CubicCurveTo needleCubicCurveTo8;
    private CubicCurveTo needleCubicCurveTo9;
    private CubicCurveTo needleCubicCurveTo10;
    private CubicCurveTo needleCubicCurveTo11;
    private ClosePath needleClosePath12;
    private Rotate needleRotate;
    private Pane pane;
    private double minValue;
    private double maxValue;
    private double range;
    private double angleStep;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private List<Section> sections;
    private Tooltip needleTooltip;
    private String formatString;

    public TinySkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.range = gauge.getRange();
        this.angleStep = 270.0 / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sections = gauge.getSections();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.rotateNeedle(gauge.getCurrentValue());
        this.redraw();
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, 225.0, -270.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.sectionCanvas = new Canvas(250.0, 250.0);
        this.sectionCtx = this.sectionCanvas.getGraphicsContext2D();
        this.needleRotate = new Rotate((((Gauge)this.getSkinnable()).getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleCubicCurveTo5 = new CubicCurveTo();
        this.needleClosePath6 = new ClosePath();
        this.needleMoveTo7 = new MoveTo();
        this.needleCubicCurveTo8 = new CubicCurveTo();
        this.needleCubicCurveTo9 = new CubicCurveTo();
        this.needleCubicCurveTo10 = new CubicCurveTo();
        this.needleCubicCurveTo11 = new CubicCurveTo();
        this.needleClosePath12 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleCubicCurveTo5, this.needleClosePath6, this.needleMoveTo7, this.needleCubicCurveTo8, this.needleCubicCurveTo9, this.needleCubicCurveTo10, this.needleCubicCurveTo11, this.needleClosePath12});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.needle.setStrokeType(StrokeType.INSIDE);
        this.needle.setStrokeWidth(1.0);
        this.needle.setStroke(((Gauge)this.getSkinnable()).getBackgroundPaint());
        this.needleTooltip = new Tooltip(String.format(Locale.US, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        this.needleTooltip.setTextAlignment(TextAlignment.CENTER);
        Tooltip.install((Node)this.needle, (Tooltip)this.needleTooltip);
        this.pane = new Pane(new Node[]{this.barBackground, this.sectionCanvas, this.needle});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(26.0))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.maxValue = ((Gauge)this.getSkinnable()).getMaxValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.angleStep = 270.0 / this.range;
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            this.needleTooltip.setText(String.format(Locale.US, this.formatString, ((Gauge)this.getSkinnable()).getValue()));
        }
    }

    private void rotateNeedle(double VALUE) {
        double needleStartAngle = 135.0;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + 270.0, targetAngle);
        this.needleRotate.setAngle(targetAngle);
    }

    private void drawSections() {
        if (this.sections.isEmpty()) {
            return;
        }
        this.sectionCtx.clearRect(0.0, 0.0, this.size, this.size);
        double xy = this.size * 0.1875;
        double wh = this.size * 0.625;
        double offset = -225.0;
        int listSize = this.sections.size();
        for (int i = 0; i < listSize; ++i) {
            Section section = this.sections.get(i);
            if (Double.compare(section.getStart(), this.maxValue) > 0 || Double.compare(section.getStop(), this.minValue) < 0) continue;
            double sectionStartAngle = Double.compare(section.getStart(), this.minValue) < 0 && Double.compare(section.getStop(), this.maxValue) < 0 ? 0.0 : (section.getStart() - this.minValue) * this.angleStep;
            double sectionAngleExtend = Double.compare(section.getStop(), this.maxValue) > 0 ? (this.maxValue - section.getStart()) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep;
            this.sectionCtx.save();
            this.sectionCtx.setStroke((Paint)section.getColor());
            this.sectionCtx.setLineWidth(this.size * 0.18382353);
            this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
            this.sectionCtx.strokeArc(xy, xy, wh, wh, -(offset + sectionStartAngle), -sectionAngleExtend, ArcType.OPEN);
            this.sectionCtx.restore();
        }
    }

    private void drawGradientBar() {
        double xy = this.size * 0.1875;
        double wh = this.size * 0.625;
        double offset = -225.0;
        double startAngle = 315.0;
        List<Stop> stops = ((Gauge)this.getSkinnable()).getGradientBarStops();
        HashMap<Double, Color> stopAngleMap = new HashMap<Double, Color>(stops.size());
        for (Stop stop : stops) {
            stopAngleMap.put(stop.getOffset() * 270.0, stop.getColor());
        }
        double offsetFactor = startAngle - 90.0;
        AngleConicalGradient gradient = new AngleConicalGradient(this.size * 0.5, this.size * 0.5, offsetFactor, stopAngleMap, Gauge.ScaleDirection.CLOCKWISE);
        double barStartAngle = 0.0;
        double barAngleExtend = 270.0;
        this.sectionCtx.save();
        this.sectionCtx.setStroke((Paint)gradient.getImagePattern(new Rectangle(xy - 0.09191176 * this.size, xy - 0.09191176 * this.size, wh + 0.18382353 * this.size, wh + 0.18382353 * this.size)));
        this.sectionCtx.setLineWidth(this.size * 0.18382353);
        this.sectionCtx.setLineCap(StrokeLineCap.BUTT);
        this.sectionCtx.strokeArc(xy, xy, wh, wh, -(offset + barStartAngle), -barAngleExtend, ArcType.OPEN);
        this.sectionCtx.restore();
    }

    private void drawTickMarks() {
        double centerX = this.size * 0.5;
        double centerY = this.size * 0.5;
        double minorTickSpace = ((Gauge)this.getSkinnable()).getMinorTickSpace();
        double tmpAngleStep = this.angleStep * minorTickSpace;
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMajorTickSpace());
        BigDecimal counterBD = BigDecimal.valueOf(this.minValue);
        double counter = this.minValue;
        Color tickMarkColor = ((Gauge)this.getSkinnable()).getTickMarkColor();
        Color majorTickMarkColor = ((Gauge)this.getSkinnable()).getMajorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : ((Gauge)this.getSkinnable()).getMajorTickMarkColor();
        double majorDotSize = 0.025 * this.size;
        double majorHalfDotSize = majorDotSize * 0.5;
        BigDecimal tmpStepBD = new BigDecimal(tmpAngleStep);
        tmpStepBD = tmpStepBD.setScale(3, 4);
        double tmpStep = tmpStepBD.doubleValue();
        double angle = 0.0;
        double startAngle = -45.0;
        double i = 0.0;
        while (Double.compare(-270.0 - tmpStep, i) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            double dotCenterX = centerX + this.size * 0.3125 * sinValue;
            double dotCenterY = centerY + this.size * 0.3125 * cosValue;
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                if (Double.compare(counter, this.minValue) == 0 || Double.compare(counter, this.maxValue) == 0) {
                    this.sectionCtx.setFill((Paint)Color.TRANSPARENT);
                } else {
                    this.sectionCtx.setFill((Paint)majorTickMarkColor);
                }
                Helper.drawDot(this.sectionCtx, dotCenterX - majorHalfDotSize, dotCenterY - majorHalfDotSize, majorDotSize);
            }
            if ((counter = (counterBD = counterBD.add(minorTickSpaceBD)).doubleValue()) > this.maxValue) break;
            angle -= tmpAngleStep;
            i -= tmpStep;
        }
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.colorGradientEnabled = ((Gauge)this.getSkinnable()).isGradientBarEnabled();
        this.noOfGradientStops = ((Gauge)this.getSkinnable()).getGradientBarStops().size();
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.sectionCanvas.setCache(false);
        this.sectionCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (((Gauge)this.getSkinnable()).isGradientBarEnabled() && ((Gauge)this.getSkinnable()).getGradientLookup() != null) {
            this.drawGradientBar();
            if (((Gauge)this.getSkinnable()).getMajorTickMarksVisible()) {
                this.drawTickMarks();
            }
        } else if (((Gauge)this.getSkinnable()).getSectionsVisible()) {
            this.drawSections();
            if (((Gauge)this.getSkinnable()).getMajorTickMarksVisible()) {
                this.drawTickMarks();
            }
        }
        this.sectionCanvas.setCache(true);
        this.sectionCanvas.setCacheHint(CacheHint.QUALITY);
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0 && this.size > 0.0) {
            double centerX = this.size * 0.5;
            double centerY = this.size * 0.5;
            double barRadius = this.size * 0.3125;
            double barWidth = this.size * 0.18382353;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - width) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - height) * 0.5);
            this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(0.09558824 * this.size))}));
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY);
            this.barBackground.setRadiusX(barRadius);
            this.barBackground.setRadiusY(barRadius);
            this.barBackground.setStrokeWidth(barWidth);
            this.barBackground.setStartAngle(225.0);
            this.barBackground.setLength(-270.0);
            this.sectionCanvas.setWidth(this.size);
            this.sectionCanvas.setHeight(this.size);
            this.sectionCanvas.setCache(false);
            this.sectionCtx.clearRect(0.0, 0.0, this.size, this.size);
            if (((Gauge)this.getSkinnable()).isGradientBarEnabled() && ((Gauge)this.getSkinnable()).getGradientLookup() != null) {
                this.drawGradientBar();
                if (((Gauge)this.getSkinnable()).getMajorTickMarksVisible()) {
                    this.drawTickMarks();
                }
            } else if (((Gauge)this.getSkinnable()).getSectionsVisible()) {
                this.drawSections();
                if (((Gauge)this.getSkinnable()).getMajorTickMarksVisible()) {
                    this.drawTickMarks();
                }
            }
            this.sectionCanvas.setCache(true);
            this.sectionCanvas.setCacheHint(CacheHint.QUALITY);
            double needleWidth = this.size * 0.26470588;
            double needleHeight = this.size * 0.47426471;
            this.needleMoveTo1.setX(0.277777777777778 * needleWidth);
            this.needleMoveTo1.setY(0.720930232558139 * needleHeight);
            this.needleCubicCurveTo2.setControlX1(0.277777777777778 * needleWidth);
            this.needleCubicCurveTo2.setControlY1(0.652428682170543 * needleHeight);
            this.needleCubicCurveTo2.setControlX2(0.377268055555556 * needleWidth);
            this.needleCubicCurveTo2.setControlY2(0.596899224806202 * needleHeight);
            this.needleCubicCurveTo2.setX(0.5 * needleWidth);
            this.needleCubicCurveTo2.setY(0.596899224806202 * needleHeight);
            this.needleCubicCurveTo3.setControlX1(0.622731944444444 * needleWidth);
            this.needleCubicCurveTo3.setControlY1(0.596899224806202 * needleHeight);
            this.needleCubicCurveTo3.setControlX2(0.722222222222222 * needleWidth);
            this.needleCubicCurveTo3.setControlY2(0.652428682170543 * needleHeight);
            this.needleCubicCurveTo3.setX(0.722222222222222 * needleWidth);
            this.needleCubicCurveTo3.setY(0.720930232558139 * needleHeight);
            this.needleCubicCurveTo4.setControlX1(0.722222222222222 * needleWidth);
            this.needleCubicCurveTo4.setControlY1(0.789431782945736 * needleHeight);
            this.needleCubicCurveTo4.setControlX2(0.622731944444444 * needleWidth);
            this.needleCubicCurveTo4.setControlY2(0.844961240310077 * needleHeight);
            this.needleCubicCurveTo4.setX(0.5 * needleWidth);
            this.needleCubicCurveTo4.setY(0.844961240310077 * needleHeight);
            this.needleCubicCurveTo5.setControlX1(0.377268055555556 * needleWidth);
            this.needleCubicCurveTo5.setControlY1(0.844961240310077 * needleHeight);
            this.needleCubicCurveTo5.setControlX2(0.277777777777778 * needleWidth);
            this.needleCubicCurveTo5.setControlY2(0.789431782945736 * needleHeight);
            this.needleCubicCurveTo5.setX(0.277777777777778 * needleWidth);
            this.needleCubicCurveTo5.setY(0.720930232558139 * needleHeight);
            this.needleMoveTo7.setX(0.0);
            this.needleMoveTo7.setY(0.720930232558139 * needleHeight);
            this.needleCubicCurveTo8.setControlX1(0.0);
            this.needleCubicCurveTo8.setControlY1(0.875058139534884 * needleHeight);
            this.needleCubicCurveTo8.setControlX2(0.223854166666667 * needleWidth);
            this.needleCubicCurveTo8.setControlY2(needleHeight);
            this.needleCubicCurveTo8.setX(0.5 * needleWidth);
            this.needleCubicCurveTo8.setY(needleHeight);
            this.needleCubicCurveTo9.setControlX1(0.776145833333333 * needleWidth);
            this.needleCubicCurveTo9.setControlY1(needleHeight);
            this.needleCubicCurveTo9.setControlX2(needleWidth);
            this.needleCubicCurveTo9.setControlY2(0.875058139534884 * needleHeight);
            this.needleCubicCurveTo9.setX(needleWidth);
            this.needleCubicCurveTo9.setY(0.720930232558139 * needleHeight);
            this.needleCubicCurveTo10.setControlX1(needleWidth);
            this.needleCubicCurveTo10.setControlY1(0.566860465116279 * needleHeight);
            this.needleCubicCurveTo10.setControlX2(0.5 * needleWidth);
            this.needleCubicCurveTo10.setControlY2(0.0);
            this.needleCubicCurveTo10.setX(0.5 * needleWidth);
            this.needleCubicCurveTo10.setY(0.0);
            this.needleCubicCurveTo11.setControlX1(0.5 * needleWidth);
            this.needleCubicCurveTo11.setControlY1(0.0);
            this.needleCubicCurveTo11.setControlX2(0.0);
            this.needleCubicCurveTo11.setControlY2(0.566860465116279 * needleHeight);
            this.needleCubicCurveTo11.setX(0.0);
            this.needleCubicCurveTo11.setY(0.720930232558139 * needleHeight);
            this.needle.relocate((this.size - this.needle.getLayoutBounds().getWidth()) * 0.5, centerY - this.needle.getLayoutBounds().getHeight() + this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getWidth() * 0.5);
        }
    }
}

