/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;

public class SlimSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ANGLE_RANGE = 360.0;
    private double size;
    private Arc barBackground;
    private Arc bar;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private double minValue;
    private double range;
    private double angleStep;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private boolean sectionsVisible;
    private List<Section> sections;
    private String formatString;

    public SlimSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = 360.0 / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.barBackground = new Arc(125.0, 125.0, 121.47556499999999, 121.47556499999999, 90.0, 360.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.ROUND);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 121.47556499999999, 121.47556499999999, 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.bar.setStrokeWidth(14.097745);
        this.bar.setStrokeLineCap(StrokeLineCap.ROUND);
        this.bar.setFill(null);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText = new Text(String.format(Locale.US, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
        this.pane = new Pane(new Node[]{this.barBackground, this.bar, this.titleText, this.valueText, this.unitText});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.setBar(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = 360.0 / this.range;
            this.sections = ((Gauge)this.getSkinnable()).getSections();
            this.redraw();
        }
    }

    private void setBar(double VALUE) {
        if (this.minValue > 0.0) {
            this.bar.setLength((this.minValue - VALUE) * this.angleStep);
        } else {
            this.bar.setLength(-VALUE * this.angleStep);
        }
        this.setBarColor(VALUE);
        this.valueText.setText(String.format(Locale.US, this.formatString, VALUE));
        this.resizeValueText();
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.bar.setStroke((Paint)((Gauge)this.getSkinnable()).getGradientLookup().getColorAt((VALUE - this.minValue) / this.range));
        } else {
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.colorGradientEnabled = ((Gauge)this.getSkinnable()).isGradientBarEnabled();
        this.noOfGradientStops = ((Gauge)this.getSkinnable()).getGradientBarStops().size();
        this.sectionsVisible = ((Gauge)this.getSkinnable()).getSectionsVisible();
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarBackgroundColor());
        this.setBarColor(((Gauge)this.getSkinnable()).getCurrentValue());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.unitText.setFill((Paint)((Gauge)this.getSkinnable()).getUnitColor());
    }

    private void resizeValueText() {
        double maxWidth = this.size * 0.86466165;
        double fontSize = this.size * 0.2556391;
        this.valueText.setFont(Fonts.latoLight(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.69548872;
        double fontSize = this.size * 0.08082707;
        this.titleText.setFont(Fonts.latoBold(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.22180451);
        this.unitText.setFont(Fonts.latoBold(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.68984962);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.barBackground.setCenterX(this.size * 0.5);
            this.barBackground.setCenterY(this.size * 0.5);
            this.barBackground.setRadiusX(this.size * 0.48590226);
            this.barBackground.setRadiusY(this.size * 0.48590226);
            this.barBackground.setStrokeWidth(this.size * 0.02819549);
            this.bar.setCenterX(this.size * 0.5);
            this.bar.setCenterY(this.size * 0.5);
            this.bar.setRadiusX(this.size * 0.48590226);
            this.bar.setRadiusY(this.size * 0.48590226);
            this.bar.setStrokeWidth(this.size * 0.02819549);
            this.resizeStaticText();
            this.resizeValueText();
        }
    }
}

