/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.tools.Helper;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class KpiSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double oldValue;
    private Arc barBackground;
    private Arc thresholdBar;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private CubicCurveTo needleCubicCurveTo5;
    private LineTo needleLineTo6;
    private CubicCurveTo needleCubicCurveTo7;
    private CubicCurveTo needleCubicCurveTo8;
    private ClosePath needleClosePath9;
    private Rotate needleRotate;
    private Text titleText;
    private Text valueText;
    private Text minValueText;
    private Text maxValueText;
    private Text thresholdText;
    private Pane pane;
    private double startAngle = 26.0;
    private double angleRange = 128.0;
    private double minValue;
    private double range;
    private double angleStep;
    private String formatString;

    public KpiSkin(Gauge gauge) {
        super((Control)gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleRange = Helper.clamp(90.0, 180.0, gauge.getAngleRange());
        this.startAngle = this.getStartAngle();
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = this.angleRange / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.rotateNeedle(gauge.getCurrentValue());
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.thresholdBar = new Arc(125.0, 174.0, 68.75, 68.75, -this.angleRange * 0.5 + 90.0, 0.0);
        this.thresholdBar.setType(ArcType.OPEN);
        this.thresholdBar.setStroke((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
        this.thresholdBar.setStrokeWidth(14.097745);
        this.thresholdBar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.thresholdBar.setFill(null);
        this.needleRotate = new Rotate((((Gauge)this.getSkinnable()).getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleCubicCurveTo5 = new CubicCurveTo();
        this.needleLineTo6 = new LineTo();
        this.needleCubicCurveTo7 = new CubicCurveTo();
        this.needleCubicCurveTo8 = new CubicCurveTo();
        this.needleClosePath9 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleCubicCurveTo5, this.needleLineTo6, this.needleCubicCurveTo7, this.needleCubicCurveTo8, this.needleClosePath9});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.needle.setStrokeWidth(0.0);
        this.needle.setStroke((Paint)Color.TRANSPARENT);
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText = new Text(String.format(Locale.US, this.formatString, ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.minValueText = new Text(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMinValue()));
        this.minValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.maxValueText = new Text(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxValue()));
        this.maxValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.thresholdText = new Text(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getThreshold()));
        this.thresholdText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.thresholdText.setVisible(Double.compare(((Gauge)this.getSkinnable()).getThreshold(), ((Gauge)this.getSkinnable()).getMinValue()) != 0 && Double.compare(((Gauge)this.getSkinnable()).getThreshold(), ((Gauge)this.getSkinnable()).getMaxValue()) != 0);
        this.pane = new Pane(new Node[]{this.barBackground, this.thresholdBar, this.needle, this.titleText, this.valueText, this.minValueText, this.maxValueText, this.thresholdText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Gauge)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(1.0))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Gauge)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(o -> this.rotateNeedle(((Gauge)this.getSkinnable()).getCurrentValue()));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.angleRange = Helper.clamp(90.0, 180.0, ((Gauge)this.getSkinnable()).getAngleRange());
            this.startAngle = this.getStartAngle();
            this.minValue = ((Gauge)this.getSkinnable()).getMinValue();
            this.range = ((Gauge)this.getSkinnable()).getRange();
            this.angleStep = this.angleRange / this.range;
            this.redraw();
        }
    }

    private double getStartAngle() {
        Gauge.ScaleDirection scaleDirection = ((Gauge)this.getSkinnable()).getScaleDirection();
        switch (scaleDirection) {
            default: 
        }
        return 180.0 + this.angleRange * 0.5;
    }

    private void rotateNeedle(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.valueText.setText(String.format(Locale.US, this.formatString, VALUE));
        this.resizeValueText();
    }

    private void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Gauge)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.formatString = "%." + Integer.toString(((Gauge)this.getSkinnable()).getDecimals()) + "f";
        this.titleText.setText(((Gauge)this.getSkinnable()).getTitle());
        this.minValueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMinValue()));
        this.maxValueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxValue()));
        this.thresholdText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getTickLabelDecimals() + "f", ((Gauge)this.getSkinnable()).getThreshold()));
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)((Gauge)this.getSkinnable()).getBarColor());
        this.thresholdBar.setStroke((Paint)((Gauge)this.getSkinnable()).getThresholdColor());
        this.needle.setFill((Paint)((Gauge)this.getSkinnable()).getNeedleColor());
        this.titleText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.minValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.maxValueText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.thresholdText.setFill((Paint)((Gauge)this.getSkinnable()).getTitleColor());
        this.valueText.setFill((Paint)((Gauge)this.getSkinnable()).getValueColor());
        this.thresholdText.setVisible(Double.compare(((Gauge)this.getSkinnable()).getThreshold(), ((Gauge)this.getSkinnable()).getMinValue()) != 0 && Double.compare(((Gauge)this.getSkinnable()).getThreshold(), ((Gauge)this.getSkinnable()).getMaxValue()) != 0);
    }

    private void resizeValueText() {
        double maxWidth = 0.86466165 * this.size;
        double fontSize = 0.192 * this.size;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.744);
    }

    private void resizeStaticText() {
        double maxWidth = 0.98 * this.size;
        double fontSize = this.size * 0.104;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.02, this.size * 0.02);
        maxWidth = this.size * 0.144;
        fontSize = this.size * 0.048;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        double textRadius = this.size * 0.45;
        double sinValue = Math.sin(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double cosValue = Math.cos(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double textX = this.size * 0.5 + textRadius * sinValue;
        double textY = this.size * 0.672 + textRadius * cosValue;
        this.maxValueText.setTranslateX(-this.maxValueText.getLayoutBounds().getWidth() * 0.5);
        this.maxValueText.setTranslateY(-this.maxValueText.getLayoutBounds().getHeight() * 0.5);
        this.maxValueText.relocate(textX, textY);
        this.minValueText.setFont(Fonts.latoRegular(this.maxValueText.getFont().getSize()));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        sinValue = Math.sin(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        cosValue = Math.cos(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        textX = this.size * 0.5 + textRadius * sinValue;
        textY = this.size * 0.672 + textRadius * cosValue;
        this.minValueText.setTranslateX(-this.minValueText.getLayoutBounds().getWidth() * 0.5);
        this.minValueText.setTranslateY(-this.minValueText.getLayoutBounds().getHeight() * 0.5);
        this.minValueText.relocate(textX, textY);
        fontSize = this.size * 0.08;
        this.thresholdText.setFont(Fonts.latoRegular(fontSize));
        if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
        }
        textRadius = this.size * 0.5;
        double textAngle = ((Gauge)this.getSkinnable()).getThreshold() * this.angleStep;
        sinValue = Math.sin(Math.toRadians(180.0 + this.angleRange * 0.5 - textAngle));
        cosValue = Math.cos(Math.toRadians(180.0 + this.angleRange * 0.5 - textAngle));
        textX = this.size * 0.5 + textRadius * sinValue;
        textY = this.size * 0.72 + textRadius * cosValue;
        this.thresholdText.setTranslateX(-this.thresholdText.getLayoutBounds().getWidth() * 0.5);
        this.thresholdText.setTranslateY(-this.thresholdText.getLayoutBounds().getHeight() * 0.5);
        this.thresholdText.relocate(textX, textY);
    }

    private void resize() {
        double height;
        double width = ((Gauge)this.getSkinnable()).getWidth() - ((Gauge)this.getSkinnable()).getInsets().getLeft() - ((Gauge)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Gauge)this.getSkinnable()).getHeight() - ((Gauge)this.getSkinnable()).getInsets().getTop() - ((Gauge)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            double centerX = this.size * 0.5;
            double centerY = this.size * 0.696;
            double barRadius = this.size * 0.275;
            double barWidth = this.size * 0.216;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY - this.size * 0.008);
            this.barBackground.setRadiusX(barRadius);
            this.barBackground.setRadiusY(barRadius);
            this.barBackground.setStrokeWidth(barWidth);
            this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.barBackground.setLength(-this.angleRange);
            this.thresholdBar.setCenterX(centerX);
            this.thresholdBar.setCenterY(centerY - this.size * 0.008);
            this.thresholdBar.setRadiusX(barRadius);
            this.thresholdBar.setRadiusY(barRadius);
            this.thresholdBar.setStrokeWidth(barWidth);
            this.thresholdBar.setStartAngle(90.0 - this.angleRange * 0.5);
            this.thresholdBar.setLength((((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getThreshold()) * this.angleStep);
            double needleWidth = this.size * 0.064;
            double needleHeight = this.size * 0.42;
            this.needleMoveTo1.setX(0.0625 * needleWidth);
            this.needleMoveTo1.setY(0.923809523809524 * needleHeight);
            this.needleCubicCurveTo2.setControlX1(0.0625 * needleWidth);
            this.needleCubicCurveTo2.setControlY1(0.961904761904762 * needleHeight);
            this.needleCubicCurveTo2.setControlX2(0.25 * needleWidth);
            this.needleCubicCurveTo2.setControlY2(0.990476190476191 * needleHeight);
            this.needleCubicCurveTo2.setX(0.5 * needleWidth);
            this.needleCubicCurveTo2.setY(0.990476190476191 * needleHeight);
            this.needleCubicCurveTo3.setControlX1(0.75 * needleWidth);
            this.needleCubicCurveTo3.setControlY1(0.990476190476191 * needleHeight);
            this.needleCubicCurveTo3.setControlX2(0.9375 * needleWidth);
            this.needleCubicCurveTo3.setControlY2(0.961904761904762 * needleHeight);
            this.needleCubicCurveTo3.setX(0.9375 * needleWidth);
            this.needleCubicCurveTo3.setY(0.923809523809524 * needleHeight);
            this.needleCubicCurveTo4.setControlX1(0.9375 * needleWidth);
            this.needleCubicCurveTo4.setControlY1(0.904761904761905 * needleHeight);
            this.needleCubicCurveTo4.setControlX2(0.875 * needleWidth);
            this.needleCubicCurveTo4.setControlY2(0.885714285714286 * needleHeight);
            this.needleCubicCurveTo4.setX(0.8125 * needleWidth);
            this.needleCubicCurveTo4.setY(0.876190476190476 * needleHeight);
            this.needleCubicCurveTo5.setControlX1(0.8125 * needleWidth);
            this.needleCubicCurveTo5.setControlY1(0.876190476190476 * needleHeight);
            this.needleCubicCurveTo5.setControlX2(0.8125 * needleWidth);
            this.needleCubicCurveTo5.setControlY2(0.0);
            this.needleCubicCurveTo5.setX(0.8125 * needleWidth);
            this.needleCubicCurveTo5.setY(0.0);
            this.needleLineTo6.setX(0.1875 * needleWidth);
            this.needleLineTo6.setY(0.0);
            this.needleCubicCurveTo7.setControlX1(0.1875 * needleWidth);
            this.needleCubicCurveTo7.setControlY1(0.0);
            this.needleCubicCurveTo7.setControlX2(0.1875 * needleWidth);
            this.needleCubicCurveTo7.setControlY2(0.876190476190476 * needleHeight);
            this.needleCubicCurveTo7.setX(0.1875 * needleWidth);
            this.needleCubicCurveTo7.setY(0.876190476190476 * needleHeight);
            this.needleCubicCurveTo8.setControlX1(0.125 * needleWidth);
            this.needleCubicCurveTo8.setControlY1(0.885714285714286 * needleHeight);
            this.needleCubicCurveTo8.setControlX2(0.0625 * needleWidth);
            this.needleCubicCurveTo8.setControlY2(0.904761904761905 * needleHeight);
            this.needleCubicCurveTo8.setX(0.0625 * needleWidth);
            this.needleCubicCurveTo8.setY(0.923809523809524 * needleHeight);
            this.needle.relocate((this.size - this.needle.getLayoutBounds().getWidth()) * 0.5, centerY - this.needle.getLayoutBounds().getHeight());
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getHeight() * 0.07619048);
            this.resizeStaticText();
            this.resizeValueText();
        }
    }
}

