/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.TimeSection;
import eu.hansolo.medusa.tools.Helper;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class FatClockSkin
extends SkinBase<Clock>
implements Skin<Clock> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DateTimeFormatter DATE_FORMATER = DateTimeFormatter.ofPattern("EE d");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private double size;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Path hour;
    private Path minute;
    private Text title;
    private Text dateText;
    private Text text;
    private Pane pane;
    private Rotate hourRotate;
    private Rotate minuteRotate = new Rotate();
    private Group shadowGroup;
    private DropShadow dropShadow;
    private List<TimeSection> sections;
    private List<TimeSection> areas;

    public FatClockSkin(Clock clock) {
        super((Control)clock);
        this.hourRotate = new Rotate();
        this.sections = clock.getSections();
        this.areas = clock.getAreas();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((Clock)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Clock)this.getSkinnable()).getPrefWidth() < 0.0 && ((Clock)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Clock)this.getSkinnable()).setPrefSize(250.0, 250.0);
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Clock)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Clock)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Clock)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.ticksAndSectionsCanvas = new Canvas(250.0, 250.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.hour = new Path();
        this.hour.setFillRule(FillRule.EVEN_ODD);
        this.hour.setStroke(null);
        this.hour.setFill((Paint)((Clock)this.getSkinnable()).getHourNeedleColor());
        this.hour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.minute = new Path();
        this.minute.setFillRule(FillRule.EVEN_ODD);
        this.minute.setStroke(null);
        this.minute.setFill((Paint)((Clock)this.getSkinnable()).getMinuteNeedleColor());
        this.minute.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroup = new Group(new Node[]{this.hour, this.minute});
        this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.title = new Text("");
        this.title.setVisible(((Clock)this.getSkinnable()).isTitleVisible());
        this.title.setManaged(((Clock)this.getSkinnable()).isTitleVisible());
        this.dateText = new Text("");
        this.dateText.setVisible(((Clock)this.getSkinnable()).isDateVisible());
        this.dateText.setManaged(((Clock)this.getSkinnable()).isDateVisible());
        this.text = new Text("");
        this.text.setVisible(((Clock)this.getSkinnable()).isTextVisible());
        this.text.setManaged(((Clock)this.getSkinnable()).isTextVisible());
        this.pane = new Pane();
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.getChildren().addAll((Object[])new Node[]{this.ticksAndSectionsCanvas, this.title, this.dateText, this.text, this.shadowGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Clock)this.getSkinnable()).widthProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).heightProperty().addListener(o -> this.handleEvents("RESIZE"));
        ((Clock)this.getSkinnable()).setOnUpdate(e -> this.handleEvents(e.eventType.name()));
        ((Clock)this.getSkinnable()).currentTimeProperty().addListener(o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(((Clock)this.getSkinnable()).getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId()))));
    }

    private void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.title.setVisible(((Clock)this.getSkinnable()).isTitleVisible());
            this.title.setManaged(((Clock)this.getSkinnable()).isTitleVisible());
            this.text.setVisible(((Clock)this.getSkinnable()).isTextVisible());
            this.text.setManaged(((Clock)this.getSkinnable()).isTextVisible());
            this.dateText.setVisible(((Clock)this.getSkinnable()).isDateVisible());
            this.dateText.setManaged(((Clock)this.getSkinnable()).isDateVisible());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = ((Clock)this.getSkinnable()).getSections();
            this.areas = ((Clock)this.getSkinnable()).getAreas();
            this.redraw();
        } else if ("FINISHED".equals(EVENT_TYPE)) {
            // empty if block
        }
    }

    private void drawTicks() {
        double startAngle = 180.0;
        double angleStep = 6.0;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        Color hourTickMarkColor = ((Clock)this.getSkinnable()).getHourTickMarkColor();
        Color minuteTickMarkColor = ((Clock)this.getSkinnable()).getMinuteTickMarkColor();
        Color tickLabelColor = ((Clock)this.getSkinnable()).getTickLabelColor();
        boolean hourTickMarksVisible = ((Clock)this.getSkinnable()).isHourTickMarksVisible();
        boolean minuteTickMarksVisible = ((Clock)this.getSkinnable()).isMinuteTickMarksVisible();
        boolean tickLabelsVisible = ((Clock)this.getSkinnable()).isTickLabelsVisible();
        Font font = Fonts.robotoCondensedRegular(this.size * 0.075);
        this.ticksAndSections.setLineCap(StrokeLineCap.BUTT);
        this.ticksAndSections.setFont(font);
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 59.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.size * 0.44533333 * sinValue, center.getY() + this.size * 0.44533333 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + this.size * 0.47266667 * sinValue, center.getY() + this.size * 0.47266667 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.5 * sinValue, center.getY() + this.size * 0.5 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.size * 0.39 * sinValue, center.getY() + this.size * 0.39 * cosValue);
            if (counter % 5.0 == 0.0) {
                this.ticksAndSections.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.ticksAndSections.setLineWidth(this.size * 0.016);
                    this.ticksAndSections.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.ticksAndSections.setLineWidth(this.size * 0.005);
                    this.ticksAndSections.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
                if (tickLabelsVisible) {
                    this.ticksAndSections.save();
                    this.ticksAndSections.translate(textPoint.getX(), textPoint.getY());
                    Helper.rotateContextForText(this.ticksAndSections, startAngle, angle, TickLabelOrientation.HORIZONTAL);
                    this.ticksAndSections.setTextAlign(TextAlignment.CENTER);
                    this.ticksAndSections.setTextBaseline(VPos.CENTER);
                    this.ticksAndSections.setFill((Paint)tickLabelColor);
                    if (counter == 0.0) {
                        this.ticksAndSections.fillText("12", 0.0, 0.0);
                    } else {
                        this.ticksAndSections.fillText(Integer.toString((int)(counter / 5.0)), 0.0, 0.0);
                    }
                    this.ticksAndSections.restore();
                }
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.ticksAndSections.setLineWidth(this.size * 0.01066667);
                this.ticksAndSections.setStroke((Paint)minuteTickMarkColor);
                this.ticksAndSections.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= angleStep;
            counter += 1.0;
        }
    }

    private void createHourPointer() {
        double width = this.size * 0.09733333;
        double height = this.size * 0.42066667;
        this.hour.getElements().clear();
        this.hour.getElements().add((Object)new MoveTo(0.0, 0.0));
        this.hour.getElements().add((Object)new CubicCurveTo(0.0, 0.0, 0.0, 0.884310618066561 * height, 0.0, 0.884310618066561 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.0, 0.9477020602218701 * height, 0.22602739726027396 * width, height, 0.5 * width, height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.773972602739726 * width, height, width, 0.9477020602218701 * height, width, 0.884310618066561 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(width, 0.884310618066561 * height, width, 0.0, width, 0.0));
        this.hour.getElements().add((Object)new LineTo(0.0, 0.0));
        this.hour.getElements().add((Object)new ClosePath());
    }

    private void createMinutePointer() {
        double width = this.size * 0.09733333;
        double height = this.size * 0.548;
        this.minute.getElements().clear();
        this.minute.getElements().add((Object)new MoveTo(0.0, 0.0));
        this.minute.getElements().add((Object)new CubicCurveTo(0.0, 0.0, 0.0, 0.9111922141119222 * height, 0.0, 0.9111922141119222 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.0, 0.9598540145985401 * height, 0.22602739726027396 * width, height, 0.5 * width, height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.773972602739726 * width, height, width, 0.9598540145985401 * height, width, 0.9111922141119222 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(width, 0.9111922141119222 * height, width, 0.0, width, 0.0));
        this.minute.getElements().add((Object)new LineTo(0.0, 0.0));
        this.minute.getElements().add((Object)new ClosePath());
    }

    public void updateTime(ZonedDateTime TIME) {
        if (((Clock)this.getSkinnable()).isDiscreteMinutes()) {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6));
        } else {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6) + (double)TIME.getSecond() * 0.1);
        }
        if (((Clock)this.getSkinnable()).isDiscreteHours()) {
            this.hourRotate.setAngle((double)(TIME.getHour() * 30));
        } else {
            this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        }
        if (this.text.isVisible()) {
            this.text.setText(TIME_FORMATTER.format(TIME));
            Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        }
        if (this.dateText.isVisible()) {
            this.dateText.setText(DATE_FORMATER.format(TIME).toUpperCase());
            Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
            this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.45, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
        }
    }

    private void resize() {
        double height;
        double width = ((Clock)this.getSkinnable()).getWidth() - ((Clock)this.getSkinnable()).getInsets().getLeft() - ((Clock)this.getSkinnable()).getInsets().getRight();
        double d = this.size = width < (height = ((Clock)this.getSkinnable()).getHeight() - ((Clock)this.getSkinnable()).getInsets().getTop() - ((Clock)this.getSkinnable()).getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Clock)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Clock)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.ticksAndSectionsCanvas.setWidth(this.size);
            this.ticksAndSectionsCanvas.setHeight(this.size);
            this.createHourPointer();
            this.hour.setFill((Paint)((Clock)this.getSkinnable()).getHourNeedleColor());
            this.hour.relocate((this.size - this.hour.getLayoutBounds().getWidth()) * 0.5, this.size * 0.12733333);
            this.createMinutePointer();
            this.minute.setFill((Paint)((Clock)this.getSkinnable()).getMinuteNeedleColor());
            this.minute.relocate((this.size - this.minute.getLayoutBounds().getWidth()) * 0.5, 0.0);
            this.title.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
            this.title.setFont(Fonts.latoLight(this.size * 0.12));
            this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
            this.dateText.setFill((Paint)((Clock)this.getSkinnable()).getDateColor());
            this.dateText.setFont(Fonts.latoLight(this.size * 0.05));
            this.dateText.relocate((center - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.45, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
            this.text.setFill((Paint)((Clock)this.getSkinnable()).getTextColor());
            this.text.setFont(Fonts.latoLight(this.size * 0.12));
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
            this.minuteRotate.setPivotX(this.minute.getLayoutBounds().getWidth() * 0.5);
            this.minuteRotate.setPivotY(this.minute.getLayoutBounds().getHeight() * 0.91119221);
            this.hourRotate.setPivotX(this.hour.getLayoutBounds().getWidth() * 0.5);
            this.hourRotate.setPivotY(this.hour.getLayoutBounds().getHeight() * 0.88431062);
        }
    }

    private void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(((Clock)this.getSkinnable()).getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(1.0))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((Clock)this.getSkinnable()).getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.shadowGroup.setEffect((Effect)(((Clock)this.getSkinnable()).getShadowsEnabled() ? this.dropShadow : null));
        this.ticksAndSectionsCanvas.setCache(false);
        this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
        if (((Clock)this.getSkinnable()).getAreasVisible()) {
            Helper.drawTimeAreas((Clock)this.getSkinnable(), this.ticksAndSections, this.areas, this.size, 0.03, 0.03, 0.94, 0.94);
        }
        if (((Clock)this.getSkinnable()).getSectionsVisible()) {
            Helper.drawTimeSections((Clock)this.getSkinnable(), this.ticksAndSections, this.sections, this.size, 0.065, 0.065, 0.87, 0.87, 0.07);
        }
        this.drawTicks();
        this.ticksAndSectionsCanvas.setCache(true);
        this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
        ZonedDateTime time = ((Clock)this.getSkinnable()).getTime();
        this.updateTime(time);
        this.title.setText(((Clock)this.getSkinnable()).getTitle());
        Helper.adjustTextSize(this.title, 0.6 * this.size, this.size * 0.12);
        this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
        this.text.setText(TIME_FORMATTER.format(time));
        Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
        this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        this.dateText.setText(DATE_FORMATER.format(time).toUpperCase());
        Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
        this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.45, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
    }
}

