/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import java.time.LocalTime;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class TimeSection
implements Comparable<TimeSection> {
    public final TimeSectionEvent ENTERED_EVENT = new TimeSectionEvent(this, null, TimeSectionEvent.TIME_SECTION_ENTERED);
    public final TimeSectionEvent LEFT_EVENT = new TimeSectionEvent(this, null, TimeSectionEvent.TIME_SECTION_LEFT);
    private LocalTime _start;
    private ObjectProperty<LocalTime> start;
    private LocalTime _stop;
    private ObjectProperty<LocalTime> stop;
    private String _text;
    private StringProperty text;
    private Image _icon;
    private ObjectProperty<Image> icon;
    private Color _color;
    private ObjectProperty<Color> color;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private LocalTime checkedValue;
    private ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionEntered = new SimpleObjectProperty((Object)this, "onTimeSectionEntered");
    private ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionLeft = new SimpleObjectProperty((Object)this, "onTimeSectionLeft");

    public TimeSection() {
        this(LocalTime.now(), LocalTime.now(), "", null, Color.TRANSPARENT, Color.TRANSPARENT);
    }

    public TimeSection(LocalTime START, LocalTime STOP) {
        this(START, STOP, "", null, Color.TRANSPARENT, Color.TRANSPARENT);
    }

    public TimeSection(LocalTime START, LocalTime STOP, Color COLOR) {
        this(START, STOP, "", null, COLOR, Color.TRANSPARENT);
    }

    public TimeSection(LocalTime START, LocalTime STOP, Image ICON, Color COLOR) {
        this(START, STOP, "", ICON, COLOR, Color.WHITE);
    }

    public TimeSection(LocalTime START, LocalTime STOP, String TEXT, Color COLOR) {
        this(START, STOP, TEXT, null, COLOR, Color.WHITE);
    }

    public TimeSection(LocalTime START, LocalTime STOP, String TEXT, Color COLOR, Color TEXT_COLOR) {
        this(START, STOP, TEXT, null, COLOR, TEXT_COLOR);
    }

    public TimeSection(LocalTime START, LocalTime STOP, String TEXT, Image ICON, Color COLOR, Color TEXT_COLOR) {
        this._start = START;
        this._stop = STOP;
        this._text = TEXT;
        this._icon = ICON;
        this._color = COLOR;
        this._textColor = TEXT_COLOR;
        this.checkedValue = LocalTime.MIN;
    }

    public LocalTime getStart() {
        return null == this.start ? this._start : (LocalTime)this.start.get();
    }

    public void setStart(LocalTime START) {
        if (null == this.start) {
            this._start = START;
        } else {
            this.start.set((Object)START);
        }
    }

    public ObjectProperty<LocalTime> startProperty() {
        if (null == this.start) {
            this.start = new SimpleObjectProperty((Object)this, "start", (Object)this._start);
        }
        return this.start;
    }

    public LocalTime getStop() {
        return null == this.stop ? this._stop : (LocalTime)this.stop.get();
    }

    public void setStop(LocalTime STOP) {
        if (null == this.stop) {
            this._stop = STOP;
        } else {
            this.stop.set((Object)STOP);
        }
    }

    public ObjectProperty<LocalTime> stopProperty() {
        if (null == this.stop) {
            this.stop = new SimpleObjectProperty((Object)this, "stop", (Object)this._stop);
        }
        return this.stop;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public Image getImage() {
        return null == this.icon ? this._icon : (Image)this.icon.get();
    }

    public void setIcon(Image IMAGE) {
        if (null == this.icon) {
            this._icon = IMAGE;
        } else {
            this.icon.set((Object)IMAGE);
        }
    }

    public ObjectProperty<Image> iconProperty() {
        if (null == this.icon) {
            this.icon = new SimpleObjectProperty((Object)this, "icon", (Object)this._icon);
        }
        return this.icon;
    }

    public Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
        } else {
            this.color.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new SimpleObjectProperty((Object)this, "color", (Object)this._color);
        }
        return this.color;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new SimpleObjectProperty((Object)this, "textColor", (Object)this._textColor);
        }
        return this.textColor;
    }

    public boolean contains(LocalTime VALUE) {
        return VALUE.isAfter(this.getStart()) && VALUE.isBefore(this.getStop());
    }

    public void checkForValue(LocalTime VALUE) {
        boolean wasInSection = this.contains(this.checkedValue);
        boolean isInSection = this.contains(VALUE);
        if (!wasInSection && isInSection) {
            this.fireTimeSectionEvent(this.ENTERED_EVENT);
        } else if (wasInSection && !isInSection) {
            this.fireTimeSectionEvent(this.LEFT_EVENT);
        }
        this.checkedValue = VALUE;
    }

    public boolean equals(TimeSection SECTION) {
        return SECTION.getStart().equals(this.getStart()) && SECTION.getStop().equals(this.getStop()) && SECTION.getText().equals(this.getText());
    }

    @Override
    public int compareTo(TimeSection SECTION) {
        if (this.getStart().isBefore(SECTION.getStart())) {
            return -1;
        }
        if (this.getStart().isAfter(SECTION.getStart())) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Section   : " + "\n" + "text      : " + this.getText() + "\n" + "startValue: " + this.getStart() + "\n" + "stopValue : " + this.getStop() + "\n" + "color     : " + this.getColor().toString() + "textColor : " + this.getTextColor().toString();
    }

    public final ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionEnteredProperty() {
        return this.onTimeSectionEntered;
    }

    public final void setOnTimeSectionEntered(EventHandler<TimeSectionEvent> value) {
        this.onTimeSectionEnteredProperty().set(value);
    }

    public final EventHandler<TimeSectionEvent> getOnTimeSectionEntered() {
        return (EventHandler)this.onTimeSectionEnteredProperty().get();
    }

    public final ObjectProperty<EventHandler<TimeSectionEvent>> onTimeSectionLeftProperty() {
        return this.onTimeSectionLeft;
    }

    public final void setOnTimeSectionLeft(EventHandler<TimeSectionEvent> value) {
        this.onTimeSectionLeftProperty().set(value);
    }

    public final EventHandler<TimeSectionEvent> getOnTimeSectionLeft() {
        return (EventHandler)this.onTimeSectionLeftProperty().get();
    }

    public void fireTimeSectionEvent(TimeSectionEvent EVENT) {
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = TimeSectionEvent.TIME_SECTION_ENTERED == TYPE ? this.getOnTimeSectionEntered() : (TimeSectionEvent.TIME_SECTION_LEFT == TYPE ? this.getOnTimeSectionLeft() : null);
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle((Event)EVENT);
    }

    public static class TimeSectionEvent
    extends Event {
        public static final EventType<TimeSectionEvent> TIME_SECTION_ENTERED = new EventType(ANY, "TIME_SECTION_ENTERED");
        public static final EventType<TimeSectionEvent> TIME_SECTION_LEFT = new EventType(ANY, "TIME_SECTION_LEFT");

        public TimeSectionEvent(Object SOURCE, EventTarget TARGET, EventType<TimeSectionEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }
}

