/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.ClockBuilder;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.GaugeBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private Gauge gauge;
    private Clock clock;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.gauge = ((GaugeBuilder)GaugeBuilder.create().prefSize(400.0, 400.0)).build();
        this.clock = ((ClockBuilder)ClockBuilder.create().prefSize(400.0, 400.0)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 3000000000L) {
                    Test.this.gauge.setValue(RND.nextDouble() * Test.this.gauge.getRange() + Test.this.gauge.getMinValue());
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.gauge});
        pane.setPadding(new Insets(10.0));
        LinearGradient gradient = new LinearGradient(0.0, 0.0, 0.0, pane.getLayoutBounds().getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)15, (int)15, (int)15))});
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Medusa");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    public void stop() {
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

