/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class Section
implements Comparable<Section> {
    public final SectionEvent ENTERED_EVENT = new SectionEvent(this, null, SectionEvent.SECTION_ENTERED);
    public final SectionEvent LEFT_EVENT = new SectionEvent(this, null, SectionEvent.SECTION_LEFT);
    private double _start;
    private DoubleProperty start;
    private double _stop;
    private DoubleProperty stop;
    private String _text;
    private StringProperty text;
    private Image _icon;
    private ObjectProperty<Image> icon;
    private Color _color;
    private ObjectProperty<Color> color;
    private Color _textColor;
    private ObjectProperty<Color> textColor;
    private double checkedValue;
    private ObjectProperty<EventHandler<SectionEvent>> onSectionEntered = new SimpleObjectProperty((Object)this, "onSectionEntered");
    private ObjectProperty<EventHandler<SectionEvent>> onSectionLeft = new SimpleObjectProperty((Object)this, "onSectionLeft");

    public Section() {
        this(-1.0, -1.0, "", null, Color.TRANSPARENT, Color.TRANSPARENT);
    }

    public Section(double START, double STOP) {
        this(START, STOP, "", null, Color.TRANSPARENT, Color.TRANSPARENT);
    }

    public Section(double START, double STOP, Color COLOR) {
        this(START, STOP, "", null, COLOR, Color.TRANSPARENT);
    }

    public Section(double START, double STOP, Image ICON, Color COLOR) {
        this(START, STOP, "", ICON, COLOR, Color.WHITE);
    }

    public Section(double START, double STOP, String TEXT, Color COLOR) {
        this(START, STOP, TEXT, null, COLOR, Color.WHITE);
    }

    public Section(double START, double STOP, String TEXT, Color COLOR, Color TEXT_COLOR) {
        this(START, STOP, TEXT, null, COLOR, TEXT_COLOR);
    }

    public Section(double START, double STOP, String TEXT, Image ICON, Color COLOR, Color TEXT_COLOR) {
        this._start = START;
        this._stop = STOP;
        this._text = TEXT;
        this._icon = ICON;
        this._color = COLOR;
        this._textColor = TEXT_COLOR;
        this.checkedValue = -1.7976931348623157E308;
    }

    public double getStart() {
        return null == this.start ? this._start : this.start.get();
    }

    public void setStart(double START) {
        if (null == this.start) {
            this._start = START;
        } else {
            this.start.set(START);
        }
    }

    public DoubleProperty startProperty() {
        if (null == this.start) {
            this.start = new SimpleDoubleProperty((Object)this, "start", this._start);
        }
        return this.start;
    }

    public double getStop() {
        return null == this.stop ? this._stop : this.stop.get();
    }

    public void setStop(double STOP) {
        if (null == this.stop) {
            this._stop = STOP;
        } else {
            this.stop.set(STOP);
        }
    }

    public DoubleProperty stopProperty() {
        if (null == this.stop) {
            this.stop = new SimpleDoubleProperty((Object)this, "stop", this._stop);
        }
        return this.stop;
    }

    public String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public Image getImage() {
        return null == this.icon ? this._icon : (Image)this.icon.get();
    }

    public void setIcon(Image IMAGE) {
        if (null == this.icon) {
            this._icon = IMAGE;
        } else {
            this.icon.set((Object)IMAGE);
        }
    }

    public ObjectProperty<Image> iconProperty() {
        if (null == this.icon) {
            this.icon = new SimpleObjectProperty((Object)this, "icon", (Object)this._icon);
        }
        return this.icon;
    }

    public Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public void setColor(Color COLOR) {
        if (null == this.color) {
            this._color = COLOR;
        } else {
            this.color.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new SimpleObjectProperty((Object)this, "color", (Object)this._color);
        }
        return this.color;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
        } else {
            this.textColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new SimpleObjectProperty((Object)this, "textColor", (Object)this._textColor);
        }
        return this.textColor;
    }

    public boolean contains(double VALUE) {
        return Double.compare(VALUE, this.getStart()) >= 0 && Double.compare(VALUE, this.getStop()) <= 0;
    }

    public void checkForValue(double VALUE) {
        boolean wasInSection = this.contains(this.checkedValue);
        boolean isInSection = this.contains(VALUE);
        if (!wasInSection && isInSection) {
            this.fireSectionEvent(this.ENTERED_EVENT);
        } else if (wasInSection && !isInSection) {
            this.fireSectionEvent(this.LEFT_EVENT);
        }
        this.checkedValue = VALUE;
    }

    public boolean equals(Section SECTION) {
        return Double.compare(SECTION.getStart(), this.getStart()) == 0 && Double.compare(SECTION.getStop(), this.getStop()) == 0 && SECTION.getText().equals(this.getText());
    }

    @Override
    public int compareTo(Section SECTION) {
        if (Double.compare(this.getStart(), SECTION.getStart()) < 0) {
            return -1;
        }
        if (Double.compare(this.getStart(), SECTION.getStart()) > 0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "Section   : " + "\n" + "text      : " + this.getText() + "\n" + "startValue: " + this.getStart() + "\n" + "stopValue : " + this.getStop() + "\n" + "color     : " + this.getColor().toString() + "textColor : " + this.getTextColor().toString();
    }

    public final ObjectProperty<EventHandler<SectionEvent>> onSectionEnteredProperty() {
        return this.onSectionEntered;
    }

    public final void setOnSectionEntered(EventHandler<SectionEvent> value) {
        this.onSectionEnteredProperty().set(value);
    }

    public final EventHandler<SectionEvent> getOnSectionEntered() {
        return (EventHandler)this.onSectionEnteredProperty().get();
    }

    public final ObjectProperty<EventHandler<SectionEvent>> onSectionLeftProperty() {
        return this.onSectionLeft;
    }

    public final void setOnSectionLeft(EventHandler<SectionEvent> value) {
        this.onSectionLeftProperty().set(value);
    }

    public final EventHandler<SectionEvent> getOnSectionLeft() {
        return (EventHandler)this.onSectionLeftProperty().get();
    }

    public void fireSectionEvent(SectionEvent EVENT) {
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = SectionEvent.SECTION_ENTERED == TYPE ? this.getOnSectionEntered() : (SectionEvent.SECTION_LEFT == TYPE ? this.getOnSectionLeft() : null);
        if (null == HANDLER) {
            return;
        }
        HANDLER.handle((Event)EVENT);
    }

    public static class SectionEvent
    extends Event {
        public static final EventType<SectionEvent> SECTION_ENTERED = new EventType(ANY, "SECTION_ENTERED");
        public static final EventType<SectionEvent> SECTION_LEFT = new EventType(ANY, "SECTION_LEFT");

        public SectionEvent(Object SOURCE, EventTarget TARGET, EventType<SectionEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }
}

