/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.colors;

import eu.hansolo.colors.ColorHelper;
import eu.hansolo.colors.MaterialDesign;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class MaterialDesignColorPicker
extends Application {
    private static final Pattern PATTERN = Pattern.compile("(_[A]?[0-9]{2,3})");
    private static final Matcher MATCHER = PATTERN.matcher("");
    private static final int BOX_WIDTH = 70;
    private static final int BOX_HEIGHT = 50;
    private GridPane grid;

    public void init() {
        this.grid = new GridPane();
        Font font = Font.font((double)9.0);
        int col = 0;
        int row = 0;
        for (MaterialDesign color : MaterialDesign.values()) {
            String name = color.name().replace("_", " ");
            String strWeb = ColorHelper.web(color.get());
            String strRgb = ColorHelper.rgb(color.get());
            String text = name + "\n" + strWeb + "\n" + strRgb;
            MATCHER.reset(color.name());
            String brightness = "";
            while (MATCHER.find()) {
                brightness = MATCHER.group(1).replace("_", " ");
            }
            Label label = new Label(color.name().replace("_", " ").replace(brightness, "") + "\n" + brightness);
            label.setFont(font);
            label.setAlignment(Pos.CENTER_LEFT);
            label.setTextFill((Paint)Color.WHITE);
            label.setMouseTransparent(true);
            StackPane box = new StackPane(new Node[]{label});
            box.setPrefSize(70.0, 50.0);
            box.setAlignment(Pos.BOTTOM_LEFT);
            box.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color.get(), CornerRadii.EMPTY, Insets.EMPTY)}));
            box.setOnMousePressed(event -> {
                box.setScaleX(0.9);
                box.setScaleY(0.9);
                String clipboardContent = "Color.web(\"" + strWeb + "\");\n" + "Color." + strRgb + ";";
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(clipboardContent);
                clipboard.setContent((Map)content);
            });
            box.setOnMouseReleased(event -> {
                box.setScaleX(1.0);
                box.setScaleY(1.0);
            });
            Tooltip tooltip = new Tooltip(text);
            Tooltip.install((Node)box, (Tooltip)tooltip);
            this.grid.add((Node)box, col, row);
            ++row;
            if (col > 15) {
                if (row != 11) continue;
                row = 0;
                ++col;
                continue;
            }
            if (row != 15) continue;
            row = 0;
            ++col;
        }
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.getChildren().addAll((Object[])new Node[]{this.grid});
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("MaterialDesign Colors");
        stage.setScene(scene);
        stage.show();
    }

    public void stop() {
        System.exit(0);
    }

    public static void main(String[] args) {
        MaterialDesignColorPicker.launch((String[])args);
    }
}

