/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Alarm;
import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.TimeSection;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class PearClockSkin
extends ClockSkinBase {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("EEEE\ndd.MM.YYYY\nHH:mm:ss");
    private static final DateTimeFormatter DATE_TEXT_FORMATTER = DateTimeFormatter.ofPattern("EE");
    private static final DateTimeFormatter DATE_NUMBER_FORMATTER = DateTimeFormatter.ofPattern("d");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private Map<Alarm, Circle> alarmMap = new ConcurrentHashMap<Alarm, Circle>();
    private double size;
    private Canvas sectionsAndAreasCanvas;
    private GraphicsContext sectionsAndAreasCtx;
    private Canvas tickCanvas;
    private GraphicsContext tickCtx;
    private Path hour;
    private Path minute;
    private Path second;
    private Text title;
    private Text dateText;
    private Text dateNumber;
    private Text text;
    private Pane pane;
    private Pane alarmPane;
    private Rotate hourRotate;
    private Rotate minuteRotate = new Rotate();
    private Rotate secondRotate;
    private Group shadowGroupHour;
    private Group shadowGroupMinute;
    private Group shadowGroupSecond;
    private DropShadow dropShadow;
    private List<TimeSection> sections;
    private List<TimeSection> areas;
    private boolean sectionsVisible;
    private boolean highlightSections;
    private boolean areasVisible;
    private boolean highlightAreas;

    public PearClockSkin(Clock clock) {
        super(clock);
        this.hourRotate = new Rotate();
        this.secondRotate = new Rotate();
        this.sections = clock.getSections();
        this.areas = clock.getAreas();
        this.sections = clock.getSections();
        this.highlightSections = clock.isHighlightSections();
        this.sectionsVisible = clock.getSectionsVisible();
        this.areas = clock.getAreas();
        this.highlightAreas = clock.isHighlightAreas();
        this.areasVisible = clock.getAreasVisible();
        this.updateAlarms();
        this.initGraphics();
        this.registerListeners();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(250.0, 250.0);
            }
        }
        this.sectionsAndAreasCanvas = new Canvas(250.0, 250.0);
        this.sectionsAndAreasCtx = this.sectionsAndAreasCanvas.getGraphicsContext2D();
        this.tickCanvas = new Canvas(250.0, 250.0);
        this.tickCtx = this.tickCanvas.getGraphicsContext2D();
        this.alarmPane = new Pane();
        this.hour = new Path();
        this.hour.setFillRule(FillRule.EVEN_ODD);
        this.hour.setStroke(null);
        this.hour.getTransforms().setAll((Object[])new Transform[]{this.hourRotate});
        this.minute = new Path();
        this.minute.setFillRule(FillRule.EVEN_ODD);
        this.minute.setStroke(null);
        this.minute.getTransforms().setAll((Object[])new Transform[]{this.minuteRotate});
        this.second = new Path();
        this.second.setFillRule(FillRule.EVEN_ODD);
        this.second.setStroke(null);
        this.second.getTransforms().setAll((Object[])new Transform[]{this.secondRotate});
        this.second.setVisible(this.clock.isSecondsVisible());
        this.second.setManaged(this.clock.isSecondsVisible());
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.75);
        this.dropShadow.setOffsetY(3.75);
        this.shadowGroupHour = new Group(new Node[]{this.hour});
        this.shadowGroupMinute = new Group(new Node[]{this.minute});
        this.shadowGroupSecond = new Group(new Node[]{this.second});
        this.shadowGroupHour.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.title = new Text("");
        this.title.setVisible(this.clock.isTitleVisible());
        this.title.setManaged(this.clock.isTitleVisible());
        this.dateText = new Text("");
        this.dateText.setVisible(this.clock.isDateVisible());
        this.dateText.setManaged(this.clock.isDateVisible());
        this.dateNumber = new Text("");
        this.dateNumber.setVisible(this.clock.isDateVisible());
        this.dateNumber.setManaged(this.clock.isDateVisible());
        this.text = new Text("");
        this.text.setVisible(this.clock.isTextVisible());
        this.text.setManaged(this.clock.isTextVisible());
        this.pane = new Pane(new Node[]{this.sectionsAndAreasCanvas, this.tickCanvas, this.alarmPane, this.title, this.dateText, this.dateNumber, this.text, this.shadowGroupHour, this.shadowGroupMinute, this.shadowGroupSecond});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.title.setVisible(this.clock.isTitleVisible());
            this.title.setManaged(this.clock.isTitleVisible());
            this.text.setVisible(this.clock.isTextVisible());
            this.text.setManaged(this.clock.isTextVisible());
            this.dateText.setVisible(this.clock.isDateVisible());
            this.dateText.setManaged(this.clock.isDateVisible());
            this.dateNumber.setVisible(this.clock.isDateVisible());
            this.dateNumber.setManaged(this.clock.isDateVisible());
            this.second.setVisible(this.clock.isSecondsVisible());
            this.second.setManaged(this.clock.isSecondsVisible());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.clock.getSections();
            this.highlightSections = this.clock.isHighlightSections();
            this.sectionsVisible = this.clock.getSectionsVisible();
            this.areas = this.clock.getAreas();
            this.highlightAreas = this.clock.isHighlightAreas();
            this.areasVisible = this.clock.getAreasVisible();
            this.redraw();
        }
    }

    private void drawTicks() {
        double startAngle = 180.0;
        double angleStep = 1.5;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        Color hourTickMarkColor = this.clock.getHourTickMarkColor();
        Color minuteTickMarkColor = this.clock.getMinuteTickMarkColor();
        Color tickLabelColor = this.clock.getTickLabelColor();
        boolean hourTickMarksVisible = this.clock.isHourTickMarksVisible();
        boolean minuteTickMarksVisible = this.clock.isMinuteTickMarksVisible();
        boolean tickLabelsVisible = this.clock.isTickLabelsVisible();
        Font font = Fonts.robotoLight(this.size * 0.084);
        this.tickCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.tickCtx.setLineCap(StrokeLineCap.BUTT);
        this.tickCtx.setFont(font);
        this.tickCtx.setLineWidth(this.size * 0.005);
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 239.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + this.size * 0.45866667 * sinValue, center.getY() + this.size * 0.45866667 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + this.size * 0.47733333 * sinValue, center.getY() + this.size * 0.47733333 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.5 * sinValue, center.getY() + this.size * 0.5 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.size * 0.405 * sinValue, center.getY() + this.size * 0.405 * cosValue);
            if (counter % 20.0 == 0.0) {
                this.tickCtx.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.tickCtx.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
                if (tickLabelsVisible) {
                    this.tickCtx.save();
                    this.tickCtx.translate(textPoint.getX(), textPoint.getY());
                    Helper.rotateContextForText(this.tickCtx, startAngle, angle, TickLabelOrientation.HORIZONTAL);
                    this.tickCtx.setTextAlign(TextAlignment.CENTER);
                    this.tickCtx.setTextBaseline(VPos.CENTER);
                    this.tickCtx.setFill((Paint)tickLabelColor);
                    if (counter == 0.0) {
                        this.tickCtx.fillText("12", 0.0, 0.0);
                    } else {
                        this.tickCtx.fillText(Integer.toString((int)(counter / 20.0)), 0.0, 0.0);
                    }
                    this.tickCtx.restore();
                }
            } else if (counter % 4.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= angleStep;
            counter += 1.0;
        }
    }

    private void createHourPointer() {
        double width = this.size * 0.04533333;
        double height = this.size * 0.292;
        this.hour.setCache(false);
        this.hour.getElements().clear();
        this.hour.getElements().add((Object)new MoveTo(0.3235294117647059 * width, 0.9223744292237442 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.3235294117647059 * width, 0.906392694063927 * height, 0.39705882352941174 * width, 0.8949771689497716 * height, 0.5 * width, 0.8949771689497716 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.6029411764705882 * width, 0.8949771689497716 * height, 0.6764705882352942 * width, 0.906392694063927 * height, 0.6764705882352942 * width, 0.9223744292237442 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.6764705882352942 * width, 0.9383561643835616 * height, 0.6029411764705882 * width, 0.9497716894977168 * height, 0.5 * width, 0.9497716894977168 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.39705882352941174 * width, 0.9497716894977168 * height, 0.3235294117647059 * width, 0.9383561643835616 * height, 0.3235294117647059 * width, 0.9223744292237442 * height));
        this.hour.getElements().add((Object)new ClosePath());
        this.hour.getElements().add((Object)new MoveTo(0.22058823529411764 * width, 0.0639269406392694 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.22058823529411764 * width, 0.03881278538812785 * height, 0.3382352941176471 * width, 0.02054794520547945 * height, 0.5 * width, 0.02054794520547945 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.6617647058823529 * width, 0.02054794520547945 * height, 0.7794117647058824 * width, 0.03881278538812785 * height, 0.7794117647058824 * width, 0.0639269406392694 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.7794117647058824 * width, 0.0639269406392694 * height, 0.7794117647058824 * width, 0.6484018264840182 * height, 0.7794117647058824 * width, 0.6484018264840182 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.7794117647058824 * width, 0.6735159817351598 * height, 0.6617647058823529 * width, 0.6917808219178082 * height, 0.5 * width, 0.6917808219178082 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.3382352941176471 * width, 0.6917808219178082 * height, 0.22058823529411764 * width, 0.6735159817351598 * height, 0.22058823529411764 * width, 0.6484018264840182 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.22058823529411764 * width, 0.6484018264840182 * height, 0.22058823529411764 * width, 0.0639269406392694 * height, 0.22058823529411764 * width, 0.0639269406392694 * height));
        this.hour.getElements().add((Object)new ClosePath());
        this.hour.getElements().add((Object)new MoveTo(0.0, 0.9223744292237442 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.0, 0.9657534246575342 * height, 0.22058823529411764 * width, height, 0.5 * width, height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.7794117647058824 * width, height, width, 0.9657534246575342 * height, width, 0.9223744292237442 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(width, 0.8881278538812786 * height, 0.8529411764705882 * width, 0.8584474885844748 * height, 0.6617647058823529 * width, 0.8493150684931506 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.6617647058823529 * width, 0.8493150684931506 * height, 0.6617647058823529 * width, 0.7077625570776256 * height, 0.6617647058823529 * width, 0.7077625570776256 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.8088235294117647 * width, 0.6986301369863014 * height, 0.9117647058823529 * width, 0.6757990867579908 * height, 0.9117647058823529 * width, 0.6484018264840182 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.9117647058823529 * width, 0.6484018264840182 * height, 0.9117647058823529 * width, 0.0639269406392694 * height, 0.9117647058823529 * width, 0.0639269406392694 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.9117647058823529 * width, 0.0273972602739726 * height, 0.7352941176470589 * width, 0.0, 0.5 * width, 0.0));
        this.hour.getElements().add((Object)new CubicCurveTo(0.2647058823529412 * width, 0.0, 0.08823529411764706 * width, 0.0273972602739726 * height, 0.08823529411764706 * width, 0.0639269406392694 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.08823529411764706 * width, 0.0639269406392694 * height, 0.08823529411764706 * width, 0.6484018264840182 * height, 0.08823529411764706 * width, 0.6484018264840182 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.08823529411764706 * width, 0.6757990867579908 * height, 0.19117647058823528 * width, 0.6986301369863014 * height, 0.3382352941176471 * width, 0.7077625570776256 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.3382352941176471 * width, 0.7077625570776256 * height, 0.3382352941176471 * width, 0.8493150684931506 * height, 0.3382352941176471 * width, 0.8493150684931506 * height));
        this.hour.getElements().add((Object)new CubicCurveTo(0.14705882352941177 * width, 0.8584474885844748 * height, 0.0, 0.8881278538812786 * height, 0.0, 0.9223744292237442 * height));
        this.hour.getElements().add((Object)new ClosePath());
        this.hour.setCache(true);
        this.hour.setCacheHint(CacheHint.ROTATE);
    }

    private void createMinutePointer() {
        double width = this.size * 0.04533333;
        double height = this.size * 0.488;
        this.minute.setCache(false);
        this.minute.getElements().clear();
        this.minute.getElements().add((Object)new MoveTo(0.3235294117647059 * width, 0.953551912568306 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.3235294117647059 * width, 0.9439890710382514 * height, 0.39705882352941174 * width, 0.9371584699453552 * height, 0.5 * width, 0.9371584699453552 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.6029411764705882 * width, 0.9371584699453552 * height, 0.6764705882352942 * width, 0.9439890710382514 * height, 0.6764705882352942 * width, 0.953551912568306 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.6764705882352942 * width, 0.9631147540983607 * height, 0.6029411764705882 * width, 0.9699453551912568 * height, 0.5 * width, 0.9699453551912568 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.39705882352941174 * width, 0.9699453551912568 * height, 0.3235294117647059 * width, 0.9631147540983607 * height, 0.3235294117647059 * width, 0.953551912568306 * height));
        this.minute.getElements().add((Object)new ClosePath());
        this.minute.getElements().add((Object)new MoveTo(0.22058823529411764 * width, 0.03825136612021858 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.22058823529411764 * width, 0.02459016393442623 * height, 0.35294117647058826 * width, 0.012295081967213115 * height, 0.5 * width, 0.012295081967213115 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.6470588235294118 * width, 0.012295081967213115 * height, 0.7794117647058824 * width, 0.02459016393442623 * height, 0.7794117647058824 * width, 0.03825136612021858 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.7794117647058824 * width, 0.03825136612021858 * height, 0.7794117647058824 * width, 0.7896174863387978 * height, 0.7794117647058824 * width, 0.7896174863387978 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.7794117647058824 * width, 0.8032786885245902 * height, 0.6470588235294118 * width, 0.8155737704918032 * height, 0.5 * width, 0.8155737704918032 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.35294117647058826 * width, 0.8155737704918032 * height, 0.22058823529411764 * width, 0.8032786885245902 * height, 0.22058823529411764 * width, 0.7896174863387978 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.22058823529411764 * width, 0.7896174863387978 * height, 0.22058823529411764 * width, 0.03825136612021858 * height, 0.22058823529411764 * width, 0.03825136612021858 * height));
        this.minute.getElements().add((Object)new ClosePath());
        this.minute.getElements().add((Object)new MoveTo(0.0, 0.953551912568306 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.0, 0.9795081967213115 * height, 0.22058823529411764 * width, height, 0.5 * width, height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.7794117647058824 * width, height, width, 0.9795081967213115 * height, width, 0.953551912568306 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(width, 0.9330601092896175 * height, 0.8529411764705882 * width, 0.9153005464480874 * height, 0.6617647058823529 * width, 0.9098360655737705 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.6617647058823529 * width, 0.9098360655737705 * height, 0.6617647058823529 * width, 0.825136612021858 * height, 0.6617647058823529 * width, 0.825136612021858 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.8088235294117647 * width, 0.8183060109289617 * height, 0.9117647058823529 * width, 0.8060109289617486 * height, 0.9117647058823529 * width, 0.7896174863387978 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.9117647058823529 * width, 0.7896174863387978 * height, 0.9117647058823529 * width, 0.03825136612021858 * height, 0.9117647058823529 * width, 0.03825136612021858 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.9117647058823529 * width, 0.017759562841530054 * height, 0.7205882352941176 * width, 0.0, 0.5 * width, 0.0));
        this.minute.getElements().add((Object)new CubicCurveTo(0.27941176470588236 * width, 0.0, 0.08823529411764706 * width, 0.017759562841530054 * height, 0.08823529411764706 * width, 0.03825136612021858 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.08823529411764706 * width, 0.03825136612021858 * height, 0.08823529411764706 * width, 0.7896174863387978 * height, 0.08823529411764706 * width, 0.7896174863387978 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.08823529411764706 * width, 0.8060109289617486 * height, 0.19117647058823528 * width, 0.8183060109289617 * height, 0.3382352941176471 * width, 0.825136612021858 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.3382352941176471 * width, 0.825136612021858 * height, 0.3382352941176471 * width, 0.9098360655737705 * height, 0.3382352941176471 * width, 0.9098360655737705 * height));
        this.minute.getElements().add((Object)new CubicCurveTo(0.14705882352941177 * width, 0.9153005464480874 * height, 0.0, 0.9330601092896175 * height, 0.0, 0.953551912568306 * height));
        this.minute.getElements().add((Object)new ClosePath());
        this.minute.setCache(true);
        this.minute.setCacheHint(CacheHint.ROTATE);
    }

    private void createSecondPointer() {
        double width = this.size * 0.02933333;
        double height = this.size * 0.58133333;
        this.second.setCache(false);
        this.second.getElements().clear();
        this.second.getElements().add((Object)new MoveTo(0.22727272727272727 * width, 0.8600917431192661 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.22727272727272727 * width, 0.8520642201834863 * height, 0.3409090909090909 * width, 0.8463302752293578 * height, 0.5 * width, 0.8463302752293578 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.6590909090909091 * width, 0.8463302752293578 * height, 0.7727272727272727 * width, 0.8520642201834863 * height, 0.7727272727272727 * width, 0.8600917431192661 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.7727272727272727 * width, 0.8681192660550459 * height, 0.6590909090909091 * width, 0.8738532110091743 * height, 0.5 * width, 0.8738532110091743 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.3409090909090909 * width, 0.8738532110091743 * height, 0.22727272727272727 * width, 0.8681192660550459 * height, 0.22727272727272727 * width, 0.8600917431192661 * height));
        this.second.getElements().add((Object)new ClosePath());
        this.second.getElements().add((Object)new MoveTo(0.0, 0.8600917431192661 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.0, 0.8715596330275229 * height, 0.1590909090909091 * width, 0.8818807339449541 * height, 0.38636363636363635 * width, 0.8841743119266054 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.38636363636363635 * width, 0.8841743119266054 * height, 0.38636363636363635 * width, height, 0.38636363636363635 * width, height));
        this.second.getElements().add((Object)new LineTo(0.6136363636363636 * width, height));
        this.second.getElements().add((Object)new CubicCurveTo(0.6136363636363636 * width, height, 0.6136363636363636 * width, 0.8841743119266054 * height, 0.6136363636363636 * width, 0.8841743119266054 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.8409090909090909 * width, 0.8818807339449541 * height, width, 0.8715596330275229 * height, width, 0.8600917431192661 * height));
        this.second.getElements().add((Object)new CubicCurveTo(width, 0.8486238532110092 * height, 0.8409090909090909 * width, 0.838302752293578 * height, 0.6136363636363636 * width, 0.8360091743119266 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.6136363636363636 * width, 0.8360091743119266 * height, 0.6136363636363636 * width, 0.0, 0.6136363636363636 * width, 0.0));
        this.second.getElements().add((Object)new LineTo(0.38636363636363635 * width, 0.0));
        this.second.getElements().add((Object)new CubicCurveTo(0.38636363636363635 * width, 0.0, 0.38636363636363635 * width, 0.8360091743119266 * height, 0.38636363636363635 * width, 0.8360091743119266 * height));
        this.second.getElements().add((Object)new CubicCurveTo(0.1590909090909091 * width, 0.838302752293578 * height, 0.0, 0.8486238532110092 * height, 0.0, 0.8600917431192661 * height));
        this.second.getElements().add((Object)new ClosePath());
        this.second.setCache(true);
        this.second.setCacheHint(CacheHint.ROTATE);
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        if (this.clock.isDiscreteMinutes()) {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6));
        } else {
            this.minuteRotate.setAngle((double)(TIME.getMinute() * 6) + (double)TIME.getSecond() * 0.1);
        }
        if (this.second.isVisible()) {
            if (this.clock.isDiscreteSeconds()) {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6));
            } else {
                this.secondRotate.setAngle((double)(TIME.getSecond() * 6) + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 0.006);
            }
        }
        if (this.clock.isDiscreteHours()) {
            this.hourRotate.setAngle((double)(TIME.getHour() * 30));
        } else {
            this.hourRotate.setAngle(0.5 * (double)(60 * TIME.getHour() + TIME.getMinute()));
        }
        if (this.text.isVisible()) {
            this.text.setText(TIME_FORMATTER.format(TIME));
            Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        }
        if (this.dateText.isVisible()) {
            this.dateText.setText(DATE_TEXT_FORMATTER.format(TIME).toUpperCase());
            Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
            this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.4, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
        }
        if (this.dateNumber.isVisible()) {
            this.dateNumber.setText(DATE_NUMBER_FORMATTER.format(TIME).toUpperCase());
            Helper.adjustTextSize(this.dateNumber, 0.3 * this.size, this.size * 0.05);
            this.dateNumber.relocate((this.size * 0.5 - this.dateNumber.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.51, (this.size - this.dateNumber.getLayoutBounds().getHeight()) * 0.5);
        }
        if (TIME.getMinute() == 0 && TIME.getSecond() == 0) {
            Helper.drawAlarms(this.clock, this.size, 0.0225, 0.4775, this.alarmMap, DATE_TIME_FORMATTER, TIME);
        }
        if (this.highlightAreas | this.highlightSections) {
            this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
            if (this.areasVisible) {
                Helper.drawTimeAreas(this.clock, this.sectionsAndAreasCtx, this.areas, this.size, 0.0, 0.0, 1.0, 1.0);
            }
            if (this.sectionsVisible) {
                Helper.drawTimeSections(this.clock, this.sectionsAndAreasCtx, this.sections, this.size, 0.02, 0.02, 0.96, 0.96, 0.04);
            }
        }
    }

    @Override
    public void updateAlarms() {
        this.alarmMap.clear();
        for (Alarm alarm : this.clock.getAlarms()) {
            this.alarmMap.put(alarm, new Circle());
        }
    }

    @Override
    protected void resize() {
        double height;
        double width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        double d = this.size = width < (height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            double center = this.size * 0.5;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.clock.getWidth() - this.size) * 0.5, (this.clock.getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.sectionsAndAreasCanvas.setWidth(this.size);
            this.sectionsAndAreasCanvas.setHeight(this.size);
            this.tickCanvas.setWidth(this.size);
            this.tickCanvas.setHeight(this.size);
            this.alarmPane.setMaxSize(this.size, this.size);
            this.createHourPointer();
            this.hour.setFill((Paint)this.clock.getHourColor());
            this.hour.relocate((this.size - this.hour.getLayoutBounds().getWidth()) * 0.5, this.size * 0.23066667);
            this.createMinutePointer();
            this.minute.setFill((Paint)this.clock.getMinuteColor());
            this.minute.relocate((this.size - this.minute.getLayoutBounds().getWidth()) * 0.5, this.size * 0.03466667);
            this.createSecondPointer();
            this.second.setFill((Paint)this.clock.getSecondColor());
            this.second.relocate((this.size - this.second.getLayoutBounds().getWidth()) * 0.5, 0.0);
            this.title.setFill((Paint)this.clock.getTextColor());
            this.title.setFont(Fonts.latoLight(this.size * 0.12));
            this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
            this.dateText.setFill((Paint)this.clock.getDateColor());
            this.dateText.setFont(Fonts.latoLight(this.size * 0.06666667));
            this.dateText.relocate((center - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.4, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
            this.dateNumber.setFill((Paint)this.clock.getSecondColor());
            this.dateNumber.setFont(Fonts.latoLight(this.size * 0.06666667));
            this.dateNumber.relocate((center - this.dateNumber.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.51, (this.size - this.dateNumber.getLayoutBounds().getHeight()) * 0.5);
            this.text.setFill((Paint)this.clock.getTextColor());
            this.text.setFont(Fonts.latoLight(this.size * 0.12));
            this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
            this.hourRotate.setPivotX(this.hour.getLayoutBounds().getWidth() * 0.5);
            this.hourRotate.setPivotY(this.hour.getLayoutBounds().getHeight() * 0.92237443);
            this.minuteRotate.setPivotX(this.minute.getLayoutBounds().getWidth() * 0.5);
            this.minuteRotate.setPivotY(this.minute.getLayoutBounds().getHeight() * 0.95355191);
            this.secondRotate.setPivotX(this.second.getLayoutBounds().getWidth() * 0.5);
            this.secondRotate.setPivotY(this.second.getLayoutBounds().getHeight() * 0.86009174);
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.hour.setFill((Paint)this.clock.getHourColor());
        this.minute.setFill((Paint)this.clock.getMinuteColor());
        this.second.setFill((Paint)this.clock.getSecondColor());
        this.title.setFill((Paint)this.clock.getTitleColor());
        this.dateText.setFill((Paint)this.clock.getDateColor());
        this.text.setFill((Paint)this.clock.getTextColor());
        this.shadowGroupHour.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupMinute.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.shadowGroupSecond.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.sectionsAndAreasCtx.clearRect(0.0, 0.0, this.size, this.size);
        if (this.areasVisible) {
            Helper.drawTimeAreas(this.clock, this.sectionsAndAreasCtx, this.areas, this.size, 0.0, 0.0, 1.0, 1.0);
        }
        if (this.sectionsVisible) {
            Helper.drawTimeSections(this.clock, this.sectionsAndAreasCtx, this.sections, this.size, 0.02, 0.02, 0.96, 0.96, 0.04);
        }
        this.tickCanvas.setCache(false);
        this.drawTicks();
        this.tickCanvas.setCache(true);
        this.tickCanvas.setCacheHint(CacheHint.QUALITY);
        ZonedDateTime time = this.clock.getTime();
        this.updateTime(time);
        this.title.setText(this.clock.getTitle());
        Helper.adjustTextSize(this.title, 0.6 * this.size, this.size * 0.12);
        this.title.relocate((this.size - this.title.getLayoutBounds().getWidth()) * 0.5, this.size * 0.25);
        this.text.setText(TIME_FORMATTER.format(time));
        Helper.adjustTextSize(this.text, 0.6 * this.size, this.size * 0.12);
        this.text.relocate((this.size - this.text.getLayoutBounds().getWidth()) * 0.5, this.size * 0.6);
        this.dateText.setText(DATE_TEXT_FORMATTER.format(time).toUpperCase());
        Helper.adjustTextSize(this.dateText, 0.3 * this.size, this.size * 0.05);
        this.dateText.relocate((this.size * 0.5 - this.dateText.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.4, (this.size - this.dateText.getLayoutBounds().getHeight()) * 0.5);
        this.dateNumber.setText(DATE_NUMBER_FORMATTER.format(time).toUpperCase());
        Helper.adjustTextSize(this.dateNumber, 0.3 * this.size, this.size * 0.05);
        this.dateNumber.relocate((this.size * 0.5 - this.dateNumber.getLayoutBounds().getWidth()) * 0.5 + this.size * 0.51, (this.size - this.dateNumber.getLayoutBounds().getHeight()) * 0.5);
        this.alarmPane.getChildren().setAll(this.alarmMap.values());
        Helper.drawAlarms(this.clock, this.size, 0.0225, 0.4775, this.alarmMap, DATE_TIME_FORMATTER, time);
    }
}

