/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Alarm;
import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.events.UpdateEventListener;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;

public abstract class ClockSkinBase
extends SkinBase<Clock>
implements Skin<Clock> {
    protected static final double PREFERRED_WIDTH = 250.0;
    protected static final double PREFERRED_HEIGHT = 250.0;
    protected static final double MINIMUM_WIDTH = 50.0;
    protected static final double MINIMUM_HEIGHT = 50.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    protected Clock clock;
    protected InvalidationListener sizeListener;
    protected UpdateEventListener updateEventListener;
    protected InvalidationListener currentTimeListener;
    protected InvalidationListener timeListener;
    protected ListChangeListener<Alarm> alarmListener;

    public ClockSkinBase(Clock CLOCK) {
        super((Control)CLOCK);
        this.clock = CLOCK;
        this.sizeListener = o -> this.handleEvents("RESIZE");
        this.updateEventListener = e -> this.handleEvents(e.eventType.name());
        this.currentTimeListener = o -> this.updateTime(ZonedDateTime.ofInstant(Instant.ofEpochSecond(this.clock.getCurrentTime()), ZoneId.of(ZoneId.systemDefault().getId())));
        this.timeListener = o -> this.updateTime(this.clock.getTime());
        this.alarmListener = c -> {
            this.updateAlarms();
            this.redraw();
        };
    }

    protected abstract void initGraphics();

    protected void registerListeners() {
        this.clock.widthProperty().addListener(this.sizeListener);
        this.clock.heightProperty().addListener(this.sizeListener);
        this.clock.setOnUpdate(this.updateEventListener);
        if (this.clock.isAnimated()) {
            this.clock.currentTimeProperty().addListener(this.currentTimeListener);
        } else {
            this.clock.timeProperty().addListener(this.timeListener);
        }
        this.clock.getAlarms().addListener(this.alarmListener);
    }

    protected double computeMinWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computeMinHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 50.0;
    }

    protected double computePrefWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefWidth(HEIGHT, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computePrefHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return super.computePrefHeight(WIDTH, TOP, RIGHT, BOTTOM, LEFT);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH, double TOP, double RIGHT, double BOTTOM, double LEFT) {
        return 1024.0;
    }

    protected void handleEvents(String EVENT_TYPE) {
        if ("RESIZE".equals(EVENT_TYPE)) {
            this.resize();
            this.redraw();
        } else if ("REDRAW".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    public void dispose() {
        this.clock.widthProperty().removeListener(this.sizeListener);
        this.clock.heightProperty().removeListener(this.sizeListener);
        this.clock.removeUpdateEventListener(this.updateEventListener);
        if (this.clock.isAnimated()) {
            this.clock.currentTimeProperty().removeListener(this.currentTimeListener);
        } else {
            this.clock.timeProperty().removeListener(this.timeListener);
        }
        this.clock.getAlarms().removeListener(this.alarmListener);
        this.clock = null;
    }

    public abstract void updateTime(ZonedDateTime var1);

    public abstract void updateAlarms();

    protected abstract void resize();

    protected abstract void redraw();
}

