/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.Marker;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class PlainAmpSkin
extends GaugeSkinBase {
    protected static final double PREFERRED_WIDTH = 310.0;
    protected static final double PREFERRED_HEIGHT = 260.0;
    protected static final double MINIMUM_WIDTH = 31.0;
    protected static final double MINIMUM_HEIGHT = 26.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 858.0;
    private static final double ASPECT_RATIO = 0.5;
    private static final double START_ANGLE = 225.0;
    private static final double ANGLE_RANGE = 90.0;
    private Map<Marker, Shape> markerMap = new ConcurrentHashMap<Marker, Shape>();
    private double oldValue;
    private double width;
    private double height;
    private Pane pane;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Pane markerPane;
    private Path threshold;
    private Path average;
    private double ledSize;
    private InnerShadow ledOnShadow;
    private InnerShadow ledOffShadow;
    private LinearGradient frameGradient;
    private LinearGradient ledOnGradient;
    private LinearGradient ledOffGradient;
    private RadialGradient highlightGradient;
    private Canvas ledCanvas;
    private GraphicsContext led;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private LineTo needleLineTo5;
    private CubicCurveTo needleCubicCurveTo6;
    private ClosePath needleClosePath7;
    private Rotate needleRotate;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private Text unitText;
    private Rectangle lcd;
    private Label lcdText;
    private double angleStep;
    private Tooltip thresholdTooltip;
    private String formatString;
    private Locale locale;
    private ListChangeListener<Section> sectionListener;
    private InvalidationListener currentValueListener;
    private InvalidationListener needleRotateListener;
    private ListChangeListener<Marker> markerListener;

    public PlainAmpSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleStep = gauge.getAngleRange() / gauge.getRange();
        this.oldValue = gauge.getValue();
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sectionListener = c -> this.redraw();
        this.currentValueListener = o -> this.rotateNeedle();
        this.needleRotateListener = o -> this.handleEvents("ANGLE");
        this.markerListener = c -> {
            this.updateMarkers();
            this.redraw();
        };
        this.updateMarkers();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(310.0, 260.0);
            }
        }
        this.ticksAndSectionsCanvas = new Canvas(310.0, 260.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.ledCanvas = new Canvas();
        this.led = this.ledCanvas.getGraphicsContext2D();
        this.thresholdTooltip = new Tooltip("Threshold\n(" + String.format(this.locale, this.formatString, this.gauge.getThreshold()) + ")");
        this.thresholdTooltip.setTextAlignment(TextAlignment.CENTER);
        this.threshold = new Path();
        Helper.enableNode((Node)this.threshold, this.gauge.isThresholdVisible());
        Tooltip.install((Node)this.threshold, (Tooltip)this.thresholdTooltip);
        this.average = new Path();
        Helper.enableNode((Node)this.average, this.gauge.isAverageVisible());
        this.markerPane = new Pane();
        this.needleRotate = new Rotate(-45.0);
        this.needleRotate.setAngle(this.needleRotate.getAngle() + (this.gauge.getValue() - this.oldValue - this.gauge.getMinValue()) * this.angleStep);
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleLineTo5 = new LineTo();
        this.needleCubicCurveTo6 = new CubicCurveTo();
        this.needleClosePath7 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleLineTo5, this.needleCubicCurveTo6, this.needleClosePath7});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(4.6499999999999995);
        this.dropShadow.setOffsetY(4.6499999999999995);
        this.shadowGroup = new Group(new Node[]{this.needle});
        this.shadowGroup.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.dropShadow : null));
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setMouseTransparent(true);
        this.unitText.setTextOrigin(VPos.CENTER);
        this.lcd = new Rectangle(93.0, 26.0);
        this.lcd.setArcWidth(3.25);
        this.lcd.setArcHeight(3.25);
        this.lcd.relocate((310.0 - this.lcd.getWidth()) * 0.5, 171.6);
        Helper.enableNode((Node)this.lcd, this.gauge.isLcdVisible() && this.gauge.isValueVisible());
        this.lcdText = new Label(String.format(this.locale, "%." + this.gauge.getDecimals() + "f", this.gauge.getValue()));
        this.lcdText.setAlignment(Pos.CENTER_RIGHT);
        this.lcdText.setVisible(this.gauge.isValueVisible());
        this.angleStep = 90.0 / this.gauge.getRange();
        double targetAngle = -45.0 + (this.gauge.getValue() - this.gauge.getMinValue()) * this.angleStep;
        targetAngle = this.clamp(-45.0, 45.0, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.ticksAndSectionsCanvas, this.markerPane, this.ledCanvas, this.unitText, this.lcd, this.lcdText, this.shadowGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.getMarkers().addListener(this.markerListener);
        this.gauge.getSections().addListener(this.sectionListener);
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
        this.needleRotate.angleProperty().addListener(this.needleRotateListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("FINISHED".equals(EVENT_TYPE)) {
            if (this.gauge.isHighlightSections()) {
                this.redraw();
            }
        } else if ("ANGLE".equals(EVENT_TYPE)) {
            double currentValue = (this.needleRotate.getAngle() + 225.0 - 180.0) / this.angleStep + this.gauge.getMinValue();
            this.lcdText.setText(String.format(this.locale, this.formatString, currentValue));
            if (this.gauge.isLcdVisible()) {
                this.lcdText.setAlignment(Pos.CENTER_RIGHT);
                this.lcdText.setTranslateX((this.width - this.lcdText.getPrefWidth()) * 0.5);
            } else {
                this.lcdText.setAlignment(Pos.CENTER);
                this.lcdText.setTranslateX((this.width - this.lcdText.getLayoutBounds().getWidth()) * 0.5);
            }
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.ledCanvas, this.gauge.isLedVisible());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            Helper.enableNode((Node)this.lcd, this.gauge.isLcdVisible());
            Helper.enableNode((Node)this.lcdText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.threshold, this.gauge.isThresholdVisible());
            Helper.enableNode((Node)this.average, this.gauge.isAverageVisible());
            boolean markersVisible = this.gauge.getMarkersVisible();
            for (Shape shape : this.markerMap.values()) {
                Helper.enableNode((Node)shape, markersVisible);
            }
            this.resize();
            this.redraw();
        } else if ("LED".equals(EVENT_TYPE)) {
            if (this.gauge.isLedVisible()) {
                this.drawLed(this.led);
            }
        } else if ("LCD".equals(EVENT_TYPE)) {
            if (this.gauge.isLcdVisible()) {
                this.redraw();
            }
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.angleStep = this.gauge.getAngleStep();
            if (this.gauge.getValue() < this.gauge.getMinValue()) {
                this.oldValue = this.gauge.getMinValue();
            }
            if (this.gauge.getValue() > this.gauge.getMaxValue()) {
                this.oldValue = this.gauge.getMaxValue();
            }
            this.redraw();
            this.rotateNeedle();
        }
    }

    private void rotateNeedle() {
        this.angleStep = 90.0 / this.gauge.getRange();
        double targetAngle = -45.0 + (this.gauge.getCurrentValue() - this.gauge.getMinValue()) * this.angleStep;
        targetAngle = this.clamp(-45.0, 45.0, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        if (this.gauge.isAverageVisible()) {
            this.drawAverage();
        }
    }

    private void drawMarkers() {
        this.markerPane.getChildren().setAll(this.markerMap.values());
        this.markerPane.getChildren().addAll((Object[])new Node[]{this.average, this.threshold});
        double minValue = this.gauge.getMinValue();
        double markerSize = 0.0125 * this.width;
        double pathHalf = markerSize * 0.3;
        double scaledWidth = this.width * 1.106;
        double centerX = this.width * 0.5;
        double centerY = this.height * 1.4;
        if (this.gauge.getMarkersVisible()) {
            for (Map.Entry<Marker, Shape> entry : this.markerMap.entrySet()) {
                Marker marker = entry.getKey();
                Shape shape = entry.getValue();
                double valueAngle = 225.0 - (marker.getValue() - minValue) * this.angleStep;
                double sinValue = Math.sin(Math.toRadians(valueAngle));
                double cosValue = Math.cos(Math.toRadians(valueAngle));
                switch (marker.getMarkerType()) {
                    case TRIANGLE: {
                        Path triangle = (Path)shape;
                        triangle.getElements().clear();
                        triangle.getElements().add((Object)new MoveTo(centerX + scaledWidth * 0.38 * sinValue, centerY + scaledWidth * 0.38 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                        triangle.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.4075 * sinValue, centerY + scaledWidth * 0.4075 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                        triangle.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.4075 * sinValue, centerY + scaledWidth * 0.4075 * cosValue));
                        triangle.getElements().add((Object)new ClosePath());
                        break;
                    }
                    case DOT: {
                        Circle dot = (Circle)shape;
                        dot.setRadius(markerSize);
                        dot.setCenterX(centerX + scaledWidth * 0.3945 * sinValue);
                        dot.setCenterY(centerY + scaledWidth * 0.3945 * cosValue);
                        break;
                    }
                    default: {
                        Path standard = (Path)shape;
                        standard.getElements().clear();
                        standard.getElements().add((Object)new MoveTo(centerX + scaledWidth * 0.38 * sinValue, centerY + scaledWidth * 0.38 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle - pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle - pathHalf));
                        standard.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.4075 * sinValue, centerY + scaledWidth * 0.4075 * cosValue));
                        standard.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.43 * sinValue, centerY + scaledWidth * 0.43 * cosValue));
                        sinValue = Math.sin(Math.toRadians(valueAngle + pathHalf));
                        cosValue = Math.cos(Math.toRadians(valueAngle + pathHalf));
                        standard.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.43 * sinValue, centerY + scaledWidth * 0.43 * cosValue));
                        standard.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.4075 * sinValue, centerY + scaledWidth * 0.4075 * cosValue));
                        standard.getElements().add((Object)new ClosePath());
                    }
                }
                Color markerColor = marker.getColor();
                shape.setFill((Paint)markerColor);
                shape.setStroke((Paint)markerColor.darker());
                shape.setPickOnBounds(false);
                Tooltip markerTooltip = marker.getText().isEmpty() ? new Tooltip(Double.toString(marker.getValue())) : new Tooltip(marker.getText() + "\n(" + Double.toString(marker.getValue()) + ")");
                markerTooltip.setTextAlignment(TextAlignment.CENTER);
                Tooltip.install((Node)shape, (Tooltip)markerTooltip);
                shape.setOnMousePressed(e -> marker.fireMarkerEvent(marker.MARKER_PRESSED_EVENT));
                shape.setOnMouseReleased(e -> marker.fireMarkerEvent(marker.MARKER_RELEASED_EVENT));
            }
        }
        if (this.gauge.isThresholdVisible()) {
            this.threshold.getElements().clear();
            double thresholdAngle = 225.0 - (this.gauge.getThreshold() - minValue) * this.angleStep;
            double thresholdSize = Helper.clamp(2.0, 2.5, 0.01 * scaledWidth);
            double sinValue = Math.sin(Math.toRadians(thresholdAngle));
            double cosValue = Math.cos(Math.toRadians(thresholdAngle));
            this.threshold.getElements().add((Object)new MoveTo(centerX + scaledWidth * 0.38 * sinValue, centerY + scaledWidth * 0.38 * cosValue));
            sinValue = Math.sin(Math.toRadians(thresholdAngle - thresholdSize));
            cosValue = Math.cos(Math.toRadians(thresholdAngle - thresholdSize));
            this.threshold.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.35 * sinValue, centerY + scaledWidth * 0.35 * cosValue));
            sinValue = Math.sin(Math.toRadians(thresholdAngle + thresholdSize));
            cosValue = Math.cos(Math.toRadians(thresholdAngle + thresholdSize));
            this.threshold.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.35 * sinValue, centerY + scaledWidth * 0.35 * cosValue));
            this.threshold.getElements().add((Object)new ClosePath());
            this.threshold.setFill((Paint)this.gauge.getThresholdColor());
            this.threshold.setStroke((Paint)this.gauge.getTickMarkColor());
        }
    }

    private void drawAverage() {
        double scaledWidth = this.width * 1.106;
        double centerX = this.width * 0.5;
        double centerY = this.height * 1.4;
        double minValue = this.gauge.getMinValue();
        this.average.getElements().clear();
        double averageAngle = 225.0 - (this.gauge.getAverage() - minValue) * this.angleStep;
        double averageSize = Helper.clamp(2.0, 2.5, 0.01 * scaledWidth);
        double sinValue = Math.sin(Math.toRadians(averageAngle));
        double cosValue = Math.cos(Math.toRadians(averageAngle));
        this.average.getElements().add((Object)new MoveTo(centerX + scaledWidth * 0.38 * sinValue, centerY + scaledWidth * 0.38 * cosValue));
        sinValue = Math.sin(Math.toRadians(averageAngle - averageSize));
        cosValue = Math.cos(Math.toRadians(averageAngle - averageSize));
        this.average.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.35 * sinValue, centerY + scaledWidth * 0.35 * cosValue));
        sinValue = Math.sin(Math.toRadians(averageAngle + averageSize));
        cosValue = Math.cos(Math.toRadians(averageAngle + averageSize));
        this.average.getElements().add((Object)new LineTo(centerX + scaledWidth * 0.35 * sinValue, centerY + scaledWidth * 0.35 * cosValue));
        this.average.getElements().add((Object)new ClosePath());
        this.average.setFill((Paint)this.gauge.getAverageColor());
        this.average.setStroke((Paint)this.gauge.getTickMarkColor());
    }

    private void updateMarkers() {
        this.markerMap.clear();
        block4: for (Marker marker : this.gauge.getMarkers()) {
            switch (marker.getMarkerType()) {
                case TRIANGLE: {
                    this.markerMap.put(marker, (Shape)new Path());
                    continue block4;
                }
                case DOT: {
                    this.markerMap.put(marker, (Shape)new Circle());
                    continue block4;
                }
            }
            this.markerMap.put(marker, (Shape)new Path());
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        double orthText = TickLabelOrientation.ORTHOGONAL == this.gauge.getTickLabelOrientation() ? 0.61 : 0.62;
        Point2D center = new Point2D(this.width * 0.5, this.height * 1.4);
        double minorTickSpace = this.gauge.getMinorTickSpace();
        double minValue = this.gauge.getMinValue();
        double tmpAngleStep = this.angleStep * minorTickSpace;
        int decimals = this.gauge.getTickLabelDecimals();
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(this.gauge.getMajorTickSpace());
        BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
        BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
        BigDecimal counterBD = BigDecimal.valueOf(minValue);
        double counter = minValue;
        Font tickLabelFont = Fonts.robotoCondensedRegular((decimals == 0 ? 0.07 : 0.068) * this.height);
        CTX.setFont(tickLabelFont);
        double angle = 0.0;
        while (Double.compare(-90.0 - tmpAngleStep, angle) < 0) {
            double sinValue = Math.sin(Math.toRadians(angle + 225.0));
            double cosValue = Math.cos(Math.toRadians(angle + 225.0));
            Point2D innerPoint = new Point2D(center.getX() + this.width * 0.51987097 * sinValue, center.getY() + this.width * 0.51987097 * cosValue);
            Point2D outerMinorPoint = new Point2D(center.getX() + this.width * 0.55387097 * sinValue, center.getY() + this.width * 0.55387097 * cosValue);
            Point2D outerMediumPoint = new Point2D(center.getX() + this.width * 0.56387097 * sinValue, center.getY() + this.width * 0.56387097 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.width * 0.58387097 * sinValue, center.getY() + this.width * 0.58387097 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.width * orthText * sinValue, center.getY() + this.width * orthText * cosValue);
            CTX.setStroke((Paint)this.gauge.getTickMarkColor());
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                CTX.setLineWidth(this.height * 0.0055);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (this.gauge.getTickLabelOrientation()) {
                    case ORTHOGONAL: {
                        if ((135.0 - angle) % 360.0 > 90.0 && (135.0 - angle) % 360.0 < 270.0) {
                            CTX.rotate((-45.0 - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((135.0 - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((135.0 - angle - 90.0) % 360.0 > 90.0 && (135.0 - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((-135.0 - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((45.0 - angle) % 360.0);
                        break;
                    }
                }
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.setFill((Paint)this.gauge.getTickLabelColor());
                CTX.fillText(String.format(this.locale, "%." + decimals + "f", counter), 0.0, 0.0);
                CTX.restore();
            } else if (this.gauge.getMediumTickMarksVisible() && (double)Double.compare(minorTickSpaceBD.remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                CTX.setLineWidth(this.height * 0.0035);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerMediumPoint.getX(), outerMediumPoint.getY());
            } else if (this.gauge.getMinorTickMarksVisible() && Double.compare(counterBD.remainder(minorTickSpaceBD).doubleValue(), 0.0) == 0) {
                CTX.setLineWidth(this.height * 0.00225);
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerMinorPoint.getX(), outerMinorPoint.getY());
            }
            counterBD = counterBD.add(minorTickSpaceBD);
            counter = counterBD.doubleValue();
            angle -= tmpAngleStep;
        }
    }

    private void drawSections(GraphicsContext CTX) {
        double x = this.width * 0.06;
        double y = this.width * 0.21;
        double w = this.width * 0.88;
        double h = this.height * 1.05;
        double MIN_VALUE = this.gauge.getMinValue();
        double MAX_VALUE = this.gauge.getMaxValue();
        double OFFSET = -135.0;
        ObservableList<Section> sections = this.gauge.getSections();
        boolean highlightSections = this.gauge.isHighlightSections();
        double value = this.gauge.getCurrentValue();
        int listSize = sections.size();
        for (int i = 0; i < listSize; ++i) {
            Section SECTION = (Section)sections.get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE) > 0 || Double.compare(SECTION.getStop(), MIN_VALUE) < 0) continue;
            double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? 0.0 : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
            double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? (MAX_VALUE - SECTION.getStart()) * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
            CTX.save();
            if (highlightSections) {
                CTX.setStroke((Paint)(SECTION.contains(value) ? SECTION.getHighlightColor() : SECTION.getColor()));
            } else {
                CTX.setStroke((Paint)SECTION.getColor());
            }
            CTX.setLineWidth(this.height * 0.0415);
            CTX.setLineCap(StrokeLineCap.BUTT);
            CTX.strokeArc(x, y, w, h, -(-135.0 + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
            CTX.restore();
        }
    }

    private void drawLed(GraphicsContext CTX) {
        CTX.clearRect(0.0, 0.0, this.ledSize, this.ledSize);
        CTX.setFill((Paint)this.frameGradient);
        CTX.fillOval(0.0, 0.0, this.ledSize, this.ledSize);
        CTX.save();
        if (this.gauge.isLedOn()) {
            CTX.setEffect((Effect)this.ledOnShadow);
            CTX.setFill((Paint)this.ledOnGradient);
        } else {
            CTX.setEffect((Effect)this.ledOffShadow);
            CTX.setFill((Paint)this.ledOffGradient);
        }
        CTX.fillOval(0.14 * this.ledSize, 0.14 * this.ledSize, 0.72 * this.ledSize, 0.72 * this.ledSize);
        CTX.restore();
        CTX.setFill((Paint)this.highlightGradient);
        CTX.fillOval(0.21 * this.ledSize, 0.21 * this.ledSize, 0.58 * this.ledSize, 0.58 * this.ledSize);
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private void resizeStaticText() {
        double maxWidth = this.width * 0.3;
        double fontSize = this.height * 0.15;
        this.unitText.setFont(Fonts.robotoMedium(fontSize));
        this.unitText.setText(this.gauge.getUnit());
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.setTranslateX((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5);
        this.unitText.setTranslateY(this.height * 0.55);
    }

    private void resizeText() {
        this.resizeStaticText();
        if (this.gauge.isLcdVisible()) {
            this.lcdText.setPadding(new Insets(0.0, 0.005 * this.width, 0.0, 0.005 * this.width));
            switch (this.gauge.getLcdFont()) {
                case LCD: {
                    this.lcdText.setFont(Fonts.digital(0.216 * this.height));
                    this.lcdText.setTranslateY(0.715 * this.height);
                    break;
                }
                case DIGITAL: {
                    this.lcdText.setFont(Fonts.digitalReadout(0.21 * this.height));
                    this.lcdText.setTranslateY(0.7 * this.height);
                    break;
                }
                case DIGITAL_BOLD: {
                    this.lcdText.setFont(Fonts.digitalReadoutBold(0.21 * this.height));
                    this.lcdText.setTranslateY(0.695 * this.height);
                    break;
                }
                case ELEKTRA: {
                    this.lcdText.setFont(Fonts.elektra(0.2232 * this.height));
                    this.lcdText.setTranslateY(0.685 * this.height);
                    break;
                }
                default: {
                    this.lcdText.setFont(Fonts.robotoMedium(0.18 * this.height));
                    this.lcdText.setTranslateY(0.675 * this.height);
                }
            }
            this.lcdText.setAlignment(Pos.CENTER_RIGHT);
            this.lcdText.setPrefSize(0.3 * this.width, 0.014 * this.height);
            this.lcdText.setTranslateX((this.width - this.lcdText.getPrefWidth()) * 0.5);
        } else {
            this.lcdText.setAlignment(Pos.CENTER);
            this.lcdText.setFont(Fonts.robotoMedium(this.height * 0.1));
            this.lcdText.setPrefSize(0.3 * this.width, 0.014 * this.height);
            this.lcdText.setTranslateY(0.59 * this.height);
            this.lcdText.setTranslateX((this.width - this.lcdText.getLayoutBounds().getWidth()) * 0.5);
        }
    }

    @Override
    public void dispose() {
        this.gauge.getMarkers().removeListener(this.markerListener);
        this.gauge.getSections().removeListener(this.sectionListener);
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        this.needleRotate.angleProperty().removeListener(this.needleRotateListener);
        super.dispose();
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        if (0.5 * this.width > this.height) {
            this.width = 1.0 / (0.5 / this.height);
        } else if (1.0 / (0.5 / this.height) > this.width) {
            this.height = 0.5 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.dropShadow.setRadius(0.01 * this.height);
            this.dropShadow.setOffsetY(0.01 * this.height);
            this.ticksAndSectionsCanvas.setWidth(this.width);
            this.ticksAndSectionsCanvas.setHeight(this.height);
            this.markerPane.setPrefSize(this.width, this.width);
            this.lcd.setWidth(0.3 * this.width);
            this.lcd.setHeight(0.2 * this.height);
            this.lcd.setArcWidth(0.0125 * this.height);
            this.lcd.setArcHeight(0.0125 * this.height);
            this.lcd.relocate((this.width - this.lcd.getWidth()) * 0.5, 0.7 * this.height);
            this.ledSize = 0.1 * this.height;
            Color LED_COLOR = this.gauge.getLedColor();
            this.frameGradient = new LinearGradient(0.14 * this.ledSize, 0.14 * this.ledSize, 0.84 * this.ledSize, 0.84 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
            this.ledOnGradient = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 1.2, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, LED_COLOR)});
            this.ledOffGradient = new LinearGradient(0.25 * this.ledSize, 0.25 * this.ledSize, 0.74 * this.ledSize, 0.74 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, LED_COLOR.deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, LED_COLOR.deriveColor(0.0, 1.0, 0.2, 1.0))});
            this.highlightGradient = new RadialGradient(0.0, 0.0, 0.3 * this.ledSize, 0.3 * this.ledSize, 0.29 * this.ledSize, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
            this.ledCanvas.setWidth(this.ledSize);
            this.ledCanvas.setHeight(this.ledSize);
            this.ledCanvas.relocate(0.05 * this.width, 0.1 * this.height);
            this.ledOffShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
            this.ledOnShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.ledSize, 0.0, 0.0, 0.0);
            this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, this.gauge.getLedColor(), 0.36 * this.ledSize, 0.0, 0.0, 0.0));
            double needleWidth = this.height * 0.02;
            double needleHeight = this.height * 1.175;
            this.needle.setCache(false);
            this.needleMoveTo1.setX(0.25 * needleWidth);
            this.needleMoveTo1.setY(0.025423728813559324 * needleHeight);
            this.needleCubicCurveTo2.setControlX1(0.25 * needleWidth);
            this.needleCubicCurveTo2.setControlY1(0.00847457627118644 * needleHeight);
            this.needleCubicCurveTo2.setControlX2(0.375 * needleWidth);
            this.needleCubicCurveTo2.setControlY2(0.0);
            this.needleCubicCurveTo2.setX(0.5 * needleWidth);
            this.needleCubicCurveTo2.setY(0.0);
            this.needleCubicCurveTo3.setControlX1(0.625 * needleWidth);
            this.needleCubicCurveTo3.setControlY1(0.0);
            this.needleCubicCurveTo3.setControlX2(0.75 * needleWidth);
            this.needleCubicCurveTo3.setControlY2(0.00847457627118644 * needleHeight);
            this.needleCubicCurveTo3.setX(0.75 * needleWidth);
            this.needleCubicCurveTo3.setY(0.025423728813559324 * needleHeight);
            this.needleCubicCurveTo4.setControlX1(0.75 * needleWidth);
            this.needleCubicCurveTo4.setControlY1(0.025423728813559324 * needleHeight);
            this.needleCubicCurveTo4.setControlX2(needleWidth);
            this.needleCubicCurveTo4.setControlY2(needleHeight);
            this.needleCubicCurveTo4.setX(needleWidth);
            this.needleCubicCurveTo4.setY(needleHeight);
            this.needleLineTo5.setX(0.0);
            this.needleLineTo5.setY(needleHeight);
            this.needleCubicCurveTo6.setControlX1(0.0);
            this.needleCubicCurveTo6.setControlY1(needleHeight);
            this.needleCubicCurveTo6.setControlX2(0.25 * needleWidth);
            this.needleCubicCurveTo6.setControlY2(0.025423728813559324 * needleHeight);
            this.needleCubicCurveTo6.setX(0.25 * needleWidth);
            this.needleCubicCurveTo6.setY(0.025423728813559324 * needleHeight);
            this.needle.setCache(true);
            this.needle.setCacheHint(CacheHint.ROTATE);
            LinearGradient needleGradient = new LinearGradient(this.needle.getLayoutBounds().getMinX(), 0.0, this.needle.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.gauge.getNeedleColor()), new Stop(0.5, this.gauge.getNeedleColor()), new Stop(0.5, this.gauge.getNeedleColor().brighter().brighter()), new Stop(1.0, this.gauge.getNeedleColor().brighter().brighter())});
            this.needle.setFill((Paint)needleGradient);
            this.needle.setStrokeWidth(0.0);
            this.needle.setStroke((Paint)Color.TRANSPARENT);
            this.needle.relocate((this.width - this.needle.getLayoutBounds().getWidth()) * 0.5, this.height * 1.4 - this.needle.getLayoutBounds().getHeight());
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight());
            this.shadowGroup.setClip((Node)new Rectangle(this.width, this.height));
            this.resizeText();
        }
    }

    @Override
    protected void redraw() {
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        Color backgroundColor = this.gauge.getBackgroundPaint() instanceof Color ? (Color)this.gauge.getBackgroundPaint() : Color.WHITE;
        this.ticksAndSectionsCanvas.setCache(false);
        this.ticksAndSections.clearRect(0.0, 0.0, this.width, this.height);
        this.ticksAndSections.setFill((Paint)backgroundColor);
        this.ticksAndSections.fillRect(0.0, 0.0, this.width, this.height);
        if (this.gauge.getSectionsVisible()) {
            this.drawSections(this.ticksAndSections);
        }
        this.drawTickMarks(this.ticksAndSections);
        this.ticksAndSectionsCanvas.setCache(true);
        this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.unitText.setText(this.gauge.getUnit());
        if (this.gauge.isLcdVisible()) {
            LcdDesign lcdDesign = this.gauge.getLcdDesign();
            Color[] lcdColors = lcdDesign.getColors();
            LinearGradient lcdGradient = new LinearGradient(0.0, 1.0, 0.0, this.lcd.getHeight() - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
            Object lcdFramePaint = lcdDesign.name().startsWith("FLAT") ? Color.WHITE : new LinearGradient(0.0, 0.0, 0.0, this.lcd.getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.01, Color.rgb((int)77, (int)77, (int)77)), new Stop(0.99, Color.rgb((int)77, (int)77, (int)77)), new Stop(1.0, Color.rgb((int)221, (int)221, (int)221))});
            this.lcd.setFill((Paint)lcdGradient);
            this.lcd.setStroke((Paint)lcdFramePaint);
            this.lcdText.setTextFill((Paint)lcdColors[5]);
        }
        if (this.gauge.isLedVisible()) {
            this.drawLed(this.led);
        }
        this.shadowGroup.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.dropShadow : null));
        this.drawMarkers();
        this.thresholdTooltip.setText("Threshold\n(" + String.format(this.locale, this.formatString, this.gauge.getThreshold()) + ")");
    }
}

