/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class DesignClockSkin
extends ClockSkinBase {
    private double size;
    private double rotationRadius;
    private Canvas tickCanvas;
    private GraphicsContext tickCtx;
    private Circle clip;
    private Line needle;
    private Pane pane;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private InnerShadow innerShadow;

    public DesignClockSkin(Clock clock) {
        super(clock);
        this.initGraphics();
        this.registerListeners();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(250.0, 250.0);
            }
        }
        this.rotationRadius = 312.5;
        this.clip = new Circle(125.0, 125.0, 125.0);
        this.tickCanvas = new Canvas(250.0, 250.0);
        this.tickCanvas.setClip((Node)this.clip);
        this.tickCtx = this.tickCanvas.getGraphicsContext2D();
        this.needle = new Line(125.0, 0.0, 125.0, 250.0);
        this.needle.setFill(null);
        this.needle.setStrokeLineCap(StrokeLineCap.BUTT);
        this.needle.setStroke((Paint)this.clock.getHourColor());
        this.dropShadow = new DropShadow();
        this.dropShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.25), 3.75, 0.0, 0.0, 3.75);
        this.shadowGroup = new Group(new Node[]{this.needle});
        this.shadowGroup.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 4.0, 0.0, 0.0, 1.0);
        this.pane = new Pane(new Node[]{this.tickCanvas, this.shadowGroup});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setEffect((Effect)this.innerShadow);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (!"VISIBILITY".equals(EVENT_TYPE) && "SECTION".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    private void drawTicks() {
        double ticksSize = this.size * 2.5;
        double startAngle = 180.0;
        double angleStep = 5.0;
        Point2D center = new Point2D(ticksSize * 0.5, ticksSize * 0.5);
        Color hourTickMarkColor = this.clock.getHourTickMarkColor();
        Color minuteTickMarkColor = this.clock.getMinuteTickMarkColor();
        Color tickLabelColor = this.clock.getTickLabelColor();
        boolean hourTickMarksVisible = this.clock.isHourTickMarksVisible();
        boolean minuteTickMarksVisible = this.clock.isMinuteTickMarksVisible();
        boolean tickLabelsVisible = this.clock.isTickLabelsVisible();
        Font font = Fonts.robotoRegular(ticksSize * 0.084);
        this.tickCtx.clearRect(0.0, 0.0, ticksSize, ticksSize);
        this.tickCtx.setLineCap(StrokeLineCap.ROUND);
        this.tickCtx.setFont(font);
        this.tickCtx.setLineWidth(ticksSize * 0.007);
        double angle = 0.0;
        double counter = 0.0;
        while (Double.compare(counter, 72.0) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerPoint = new Point2D(center.getX() + ticksSize * 0.45 * sinValue, center.getY() + ticksSize * 0.45 * cosValue);
            Point2D innerFiveMinutePoint = new Point2D(center.getX() + ticksSize * 0.47 * sinValue, center.getY() + ticksSize * 0.47 * cosValue);
            Point2D innerMinutePoint = new Point2D(center.getX() + ticksSize * 0.49 * sinValue, center.getY() + ticksSize * 0.49 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + ticksSize * 0.495 * sinValue, center.getY() + ticksSize * 0.495 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + ticksSize * 0.385 * sinValue, center.getY() + ticksSize * 0.385 * cosValue);
            if (counter % 6.0 == 0.0) {
                this.tickCtx.setStroke((Paint)hourTickMarkColor);
                if (hourTickMarksVisible) {
                    this.tickCtx.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
                } else if (minuteTickMarksVisible) {
                    this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
                }
                if (tickLabelsVisible) {
                    this.tickCtx.save();
                    this.tickCtx.translate(textPoint.getX(), textPoint.getY());
                    Helper.rotateContextForText(this.tickCtx, startAngle, angle, TickLabelOrientation.HORIZONTAL);
                    this.tickCtx.setTextAlign(TextAlignment.CENTER);
                    this.tickCtx.setTextBaseline(VPos.CENTER);
                    this.tickCtx.setFill((Paint)tickLabelColor);
                    if (counter == 0.0) {
                        this.tickCtx.fillText("12", 0.0, 0.0);
                    } else {
                        this.tickCtx.fillText(Integer.toString((int)(counter / 6.0)), 0.0, 0.0);
                    }
                    this.tickCtx.restore();
                }
            } else if (counter % 3.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerFiveMinutePoint.getX(), innerFiveMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % 1.0 == 0.0 && minuteTickMarksVisible) {
                this.tickCtx.setStroke((Paint)minuteTickMarkColor);
                this.tickCtx.strokeLine(innerMinutePoint.getX(), innerMinutePoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= angleStep;
            counter += 1.0;
        }
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        double rotationAngle = 0.5 * ((double)(60 * TIME.getHour() + TIME.getMinute()) + (double)TIME.getSecond() * 0.0166666667 + (double)TIME.get(ChronoField.MILLI_OF_SECOND) * 1.66667E-5);
        double rotationX = this.size * 0.5 + this.rotationRadius * Math.sin(Math.toRadians(rotationAngle + 180.0));
        double rotationY = this.size * 0.5 - this.rotationRadius * Math.cos(Math.toRadians(rotationAngle + 180.0));
        this.tickCanvas.relocate(rotationX - this.tickCanvas.getHeight() * 0.5, rotationY - this.tickCanvas.getHeight() * 0.5);
        this.needle.setRotate(rotationAngle);
        double canvasCenterX = this.tickCanvas.getWidth() * 0.5;
        double canvasCenterY = this.tickCanvas.getHeight() * 0.5;
        double radius = this.tickCanvas.getHeight() * 0.372;
        double rotX = canvasCenterX + radius * Math.sin(Math.toRadians(rotationAngle));
        double rotY = canvasCenterY - radius * Math.cos(Math.toRadians(rotationAngle));
        this.clip.setCenterX(rotX);
        this.clip.setCenterY(rotY);
    }

    @Override
    public void updateAlarms() {
    }

    @Override
    protected void resize() {
        double height;
        double width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        double d = this.size = width < (height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.rotationRadius = this.size * 0.93;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.clock.getWidth() - this.size) * 0.5, (this.clock.getHeight() - this.size) * 0.5);
            this.dropShadow.setRadius(0.008 * this.size);
            this.dropShadow.setOffsetY(0.008 * this.size);
            this.innerShadow.setRadius(0.016 * this.size);
            this.innerShadow.setOffsetY(0.004 * this.size);
            this.clip.setRadius(this.size * 0.5);
            this.tickCanvas.setWidth(this.size * 2.5);
            this.tickCanvas.setHeight(this.size * 2.5);
            this.tickCanvas.setClip((Node)this.clip);
            this.needle.setStrokeWidth(this.size * 0.008);
            this.needle.setStartX(this.size * 0.5);
            this.needle.setEndX(this.size * 0.5);
            this.needle.setStartY(0.0);
            this.needle.setEndY(this.size);
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.shadowGroup.setEffect((Effect)(this.clock.getShadowsEnabled() ? this.dropShadow : null));
        this.tickCanvas.setCache(false);
        this.drawTicks();
        this.tickCanvas.setCache(true);
        this.tickCanvas.setCacheHint(CacheHint.QUALITY);
        this.needle.setStroke((Paint)this.clock.getHourColor());
        ZonedDateTime time = this.clock.getTime();
        this.updateTime(time);
    }
}

