/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class KpiSkin
extends GaugeSkinBase {
    private double size;
    private double oldValue;
    private Arc barBackground;
    private Arc thresholdBar;
    private Path needle;
    private Rotate needleRotate;
    private Text titleText;
    private Text valueText;
    private Text minValueText;
    private Text maxValueText;
    private Text thresholdText;
    private Pane pane;
    private double angleRange;
    private double minValue;
    private double range;
    private double angleStep;
    private Locale locale;
    private InvalidationListener currentValueListener;

    public KpiSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleRange = Helper.clamp(90.0, 180.0, gauge.getAngleRange());
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = this.angleRange / this.range;
        this.locale = gauge.getLocale();
        this.currentValueListener = o -> this.rotateNeedle(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
        this.rotateNeedle(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.gauge.getBarColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.thresholdBar = new Arc(125.0, 174.0, 68.75, 68.75, -this.angleRange * 0.5 + 90.0, 0.0);
        this.thresholdBar.setType(ArcType.OPEN);
        this.thresholdBar.setStroke((Paint)this.gauge.getThresholdColor());
        this.thresholdBar.setStrokeWidth(14.097745);
        this.thresholdBar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.thresholdBar.setFill(null);
        this.needleRotate = new Rotate((this.gauge.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.needle.setStrokeWidth(0.0);
        this.needle.setStroke((Paint)Color.TRANSPARENT);
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getCurrentValue()));
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.minValueText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMinValue()));
        this.minValueText.setFill((Paint)this.gauge.getTitleColor());
        this.maxValueText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.maxValueText.setFill((Paint)this.gauge.getTitleColor());
        this.thresholdText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getThreshold()));
        this.thresholdText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.thresholdText, Double.compare(this.gauge.getThreshold(), this.gauge.getMinValue()) != 0 && Double.compare(this.gauge.getThreshold(), this.gauge.getMaxValue()) != 0);
        this.pane = new Pane(new Node[]{this.barBackground, this.thresholdBar, this.needle, this.titleText, this.valueText, this.minValueText, this.maxValueText, this.thresholdText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.angleRange = Helper.clamp(90.0, 180.0, this.gauge.getAngleRange());
            this.minValue = this.gauge.getMinValue();
            this.range = this.gauge.getRange();
            this.angleStep = this.angleRange / this.range;
            this.redraw();
        }
    }

    private void rotateNeedle(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.valueText.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.resizeValueText();
    }

    private void drawNeedle() {
        double needleWidth = this.size * 0.064;
        double needleHeight = this.size * 0.44;
        this.needle.setCache(false);
        this.needle.getElements().clear();
        this.needle.getElements().add((Object)new MoveTo(0.1875 * needleWidth, 0.0));
        this.needle.getElements().add((Object)new CubicCurveTo(0.1875 * needleWidth, 0.0, 0.1875 * needleWidth, 0.8727272727272727 * needleHeight, 0.1875 * needleWidth, 0.8727272727272727 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.0625 * needleWidth, 0.8818181818181818 * needleHeight, 0.0, 0.9 * needleHeight, 0.0, 0.9272727272727272 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.0, 0.9636363636363636 * needleHeight, 0.25 * needleWidth, needleHeight, 0.5 * needleWidth, needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.75 * needleWidth, needleHeight, needleWidth, 0.9636363636363636 * needleHeight, needleWidth, 0.9272727272727272 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth, 0.9 * needleHeight, 0.9375 * needleWidth, 0.8818181818181818 * needleHeight, 0.8125 * needleWidth, 0.8727272727272727 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.8125 * needleWidth, 0.8727272727272727 * needleHeight, 0.8125 * needleWidth, 0.0, 0.8125 * needleWidth, 0.0));
        this.needle.getElements().add((Object)new LineTo(0.1875 * needleWidth, 0.0));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.setCache(true);
        this.needle.setCacheHint(CacheHint.ROTATE);
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void resizeValueText() {
        double maxWidth = 0.86466165 * this.size;
        double fontSize = 0.192 * this.size;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.744);
    }

    private void resizeStaticText() {
        double maxWidth = 0.98 * this.size;
        double fontSize = this.size * 0.104;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.02, this.size * 0.02);
        maxWidth = this.size * 0.144;
        fontSize = this.size * 0.048;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        double textRadius = this.size * 0.45;
        double sinValue = Math.sin(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double cosValue = Math.cos(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double textX = this.size * 0.5 + textRadius * sinValue;
        double textY = this.size * 0.672 + textRadius * cosValue;
        this.maxValueText.setTranslateX(-this.maxValueText.getLayoutBounds().getWidth() * 0.5);
        this.maxValueText.setTranslateY(-this.maxValueText.getLayoutBounds().getHeight() * 0.5);
        this.maxValueText.relocate(textX, textY);
        this.minValueText.setFont(Fonts.latoRegular(this.maxValueText.getFont().getSize()));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        sinValue = Math.sin(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        cosValue = Math.cos(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        textX = this.size * 0.5 + textRadius * sinValue;
        textY = this.size * 0.672 + textRadius * cosValue;
        this.minValueText.setTranslateX(-this.minValueText.getLayoutBounds().getWidth() * 0.5);
        this.minValueText.setTranslateY(-this.minValueText.getLayoutBounds().getHeight() * 0.5);
        this.minValueText.relocate(textX, textY);
        fontSize = this.size * 0.08;
        this.thresholdText.setFont(Fonts.latoRegular(fontSize));
        if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
        }
        textRadius = this.size * 0.5;
        double textAngle = (this.gauge.getThreshold() - this.minValue) * this.angleStep;
        sinValue = Math.sin(Math.toRadians(180.0 + this.angleRange * 0.5 - textAngle));
        cosValue = Math.cos(Math.toRadians(180.0 + this.angleRange * 0.5 - textAngle));
        textX = this.size * 0.5 + textRadius * sinValue;
        textY = this.size * 0.72 + textRadius * cosValue;
        this.thresholdText.setTranslateX(-this.thresholdText.getLayoutBounds().getWidth() * 0.5);
        this.thresholdText.setTranslateY(-this.thresholdText.getLayoutBounds().getHeight() * 0.5);
        this.thresholdText.relocate(textX, textY);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            double centerX = this.size * 0.5;
            double centerY = this.size * 0.696;
            double barRadius = this.size * 0.275;
            double barWidth = this.size * 0.216;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY - this.size * 0.008);
            this.barBackground.setRadiusX(barRadius);
            this.barBackground.setRadiusY(barRadius);
            this.barBackground.setStrokeWidth(barWidth);
            this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.barBackground.setLength(-this.angleRange);
            this.thresholdBar.setCenterX(centerX);
            this.thresholdBar.setCenterY(centerY - this.size * 0.008);
            this.thresholdBar.setRadiusX(barRadius);
            this.thresholdBar.setRadiusY(barRadius);
            this.thresholdBar.setStrokeWidth(barWidth);
            this.thresholdBar.setStartAngle(90.0 - this.angleRange * 0.5);
            this.thresholdBar.setLength((this.gauge.getMaxValue() - this.gauge.getThreshold()) * this.angleStep);
            this.drawNeedle();
            this.needle.relocate((this.size - this.needle.getLayoutBounds().getWidth()) * 0.5, centerY - this.needle.getLayoutBounds().getHeight() + this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getWidth() * 0.5);
            this.resizeStaticText();
            this.resizeValueText();
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.locale = this.gauge.getLocale();
        this.titleText.setText(this.gauge.getTitle());
        this.minValueText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMinValue()));
        this.maxValueText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.thresholdText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getThreshold()));
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)this.gauge.getBarColor());
        this.thresholdBar.setStroke((Paint)this.gauge.getThresholdColor());
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.minValueText.setFill((Paint)this.gauge.getTitleColor());
        this.maxValueText.setFill((Paint)this.gauge.getTitleColor());
        this.thresholdText.setFill((Paint)this.gauge.getTitleColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.thresholdText.setVisible(Double.compare(this.gauge.getThreshold(), this.gauge.getMinValue()) != 0 && Double.compare(this.gauge.getThreshold(), this.gauge.getMaxValue()) != 0);
    }
}

