/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class TileKpiSkin
extends GaugeSkinBase {
    public static final Color GRAY = Color.rgb((int)139, (int)144, (int)146);
    private double size;
    private double oldValue;
    private Arc barBackground;
    private Arc thresholdBar;
    private Rectangle needleRect;
    private Path needle;
    private Rotate needleRotate;
    private Rotate needleRectRotate;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Text minValueText;
    private Text maxValueText;
    private Rectangle thresholdRect;
    private Text thresholdText;
    private Pane sectionPane;
    private Path alertIcon;
    private Tooltip alertTooltip;
    private Pane pane;
    private double angleRange;
    private double minValue;
    private double threshold;
    private Color thresholdColor;
    private double range;
    private double angleStep;
    private String formatString;
    private Locale locale;
    private boolean sectionsVisible;
    private boolean highlightSections;
    private List<Section> sections;
    private Map<Section, Arc> sectionMap;
    private InvalidationListener currentValueListener;

    public TileKpiSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleRange = Helper.clamp(90.0, 180.0, gauge.getAngleRange());
        this.oldValue = gauge.getValue();
        this.minValue = gauge.getMinValue();
        this.threshold = gauge.getThreshold();
        this.thresholdColor = gauge.getThresholdColor();
        this.range = gauge.getRange();
        this.angleStep = this.angleRange / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.highlightSections = gauge.isHighlightSections();
        this.sections = gauge.getSections();
        this.sectionMap = new HashMap<Section, Arc>(this.sections.size());
        this.currentValueListener = o -> this.rotateNeedle(gauge.getCurrentValue());
        for (Section section : this.sections) {
            this.sectionMap.put(section, new Arc());
        }
        this.initGraphics();
        this.registerListeners();
        this.rotateNeedle(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.gauge.getBarColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.thresholdBar = new Arc(125.0, 174.0, 68.75, 68.75, -this.angleRange * 0.5 + 90.0, 0.0);
        this.thresholdBar.setType(ArcType.OPEN);
        this.thresholdBar.setStroke((Paint)this.gauge.getThresholdColor());
        this.thresholdBar.setStrokeWidth(14.097745);
        this.thresholdBar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.thresholdBar.setFill(null);
        Helper.enableNode((Node)this.thresholdBar, !this.gauge.getSectionsVisible());
        this.sectionPane = new Pane();
        Helper.enableNode((Node)this.sectionPane, this.gauge.getSectionsVisible());
        if (this.sectionsVisible) {
            this.drawSections();
        }
        this.alertIcon = new Path();
        this.alertIcon.setFillRule(FillRule.EVEN_ODD);
        this.alertIcon.setFill((Paint)Color.YELLOW);
        this.alertIcon.setStroke(null);
        Helper.enableNode((Node)this.alertIcon, this.gauge.isAlert());
        this.alertTooltip = new Tooltip(this.gauge.getAlertMessage());
        Tooltip.install((Node)this.alertIcon, (Tooltip)this.alertTooltip);
        this.needleRotate = new Rotate((this.gauge.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleRectRotate = new Rotate((this.gauge.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleRect = new Rectangle();
        this.needleRect.setFill(this.gauge.getBackgroundPaint());
        this.needleRect.getTransforms().setAll((Object[])new Transform[]{this.needleRectRotate});
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.needle.setStrokeWidth(0.0);
        this.needle.setStroke((Paint)Color.TRANSPARENT);
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.gauge.getCurrentValue()));
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible() && !this.gauge.isAlert());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, this.gauge.isValueVisible() && !this.gauge.isAlert());
        this.minValueText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMinValue()));
        this.minValueText.setFill((Paint)this.gauge.getTitleColor());
        this.maxValueText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.maxValueText.setFill((Paint)this.gauge.getTitleColor());
        this.thresholdRect = new Rectangle();
        this.thresholdRect.setFill((Paint)(this.sectionsVisible ? GRAY : this.gauge.getThresholdColor()));
        Helper.enableNode((Node)this.thresholdRect, this.gauge.isThresholdVisible());
        this.thresholdText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getThreshold()));
        this.thresholdText.setFill((Paint)(this.sectionsVisible ? Color.TRANSPARENT : this.gauge.getBackgroundPaint()));
        Helper.enableNode((Node)this.thresholdText, this.gauge.isThresholdVisible());
        this.pane = new Pane(new Node[]{this.barBackground, this.thresholdBar, this.sectionPane, this.alertIcon, this.needleRect, this.needle, this.titleText, this.valueText, this.unitText, this.minValueText, this.maxValueText, this.thresholdRect, this.thresholdText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(6.25), new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(6.25), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.angleRange = Helper.clamp(90.0, 180.0, this.gauge.getAngleRange());
            this.minValue = this.gauge.getMinValue();
            this.threshold = this.gauge.getThreshold();
            this.range = this.gauge.getRange();
            this.angleStep = this.angleRange / this.range;
            this.highlightSections = this.gauge.isHighlightSections();
            this.redraw();
            this.rotateNeedle(this.gauge.getCurrentValue());
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.sectionPane, this.gauge.getSectionsVisible());
            Helper.enableNode((Node)this.thresholdRect, this.gauge.isThresholdVisible());
            Helper.enableNode((Node)this.thresholdText, this.gauge.isThresholdVisible());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            this.sectionsVisible = this.gauge.getSectionsVisible();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
            this.sectionMap.clear();
            for (Section section : this.sections) {
                this.sectionMap.put(section, new Arc());
            }
        } else if ("ALERT".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible() && !this.gauge.isAlert());
            Helper.enableNode((Node)this.unitText, this.gauge.isValueVisible() && !this.gauge.isAlert());
            Helper.enableNode((Node)this.alertIcon, this.gauge.isAlert());
            this.alertTooltip.setText(this.gauge.getAlertMessage());
        }
    }

    private void rotateNeedle(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.needleRectRotate.setAngle(targetAngle);
        this.valueText.setText(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.thresholdRect.setFill((Paint)(VALUE > this.threshold ? this.thresholdColor : GRAY));
        this.resizeDynamicText();
        this.highlightSections(VALUE);
    }

    private void highlightSections(double VALUE) {
        if (!this.sectionsVisible || this.sections.isEmpty()) {
            return;
        }
        if (this.highlightSections) {
            this.sections.forEach(section -> this.sectionMap.get(section).setVisible(section.contains(VALUE)));
        } else {
            this.sections.forEach(section -> this.sectionMap.get(section).setOpacity(section.contains(VALUE) ? 1.0 : 0.25));
        }
    }

    private void drawSections() {
        if (!this.sectionsVisible || this.sections.isEmpty()) {
            return;
        }
        this.sectionPane.getChildren().clear();
        double centerX = this.size * 0.5;
        double centerY = this.size * 0.7825;
        double innerRadius = this.size * 0.2775;
        double outerRadius = this.size * 0.3225;
        int noOfSections = this.sections.size();
        ArrayList<Line> sectionLines = new ArrayList<Line>(noOfSections);
        for (int i = 0; i < noOfSections - 1; ++i) {
            Section section = this.sections.get(i);
            double angle = Helper.clamp(90.0, 270.0, (section.getStop() - this.minValue) * this.angleStep + 90.0);
            Line line = new Line(centerX + innerRadius * Math.sin(-Math.toRadians(angle)), centerY + innerRadius * Math.cos(-Math.toRadians(angle)), centerX + outerRadius * Math.sin(-Math.toRadians(angle)), centerY + outerRadius * Math.cos(-Math.toRadians(angle)));
            line.setStroke(this.gauge.getBackgroundPaint());
            sectionLines.add(line);
        }
        this.sectionPane.getChildren().addAll(sectionLines);
        double barRadius = this.size * 0.3;
        double barWidth = this.size * 0.045;
        double maxValue = this.gauge.getMaxValue();
        for (Section section : this.sections) {
            double startAngle = (section.getStart() - this.minValue) * this.angleStep - this.angleRange;
            double length = section.getStop() > maxValue ? (maxValue - section.getStart()) * this.angleStep : (Double.compare(section.getStart(), this.minValue) < 0 ? (section.getStop() - this.minValue) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep);
            Arc sectionArc = new Arc(centerX, centerY, barRadius, barRadius, -startAngle, -length);
            sectionArc.setType(ArcType.OPEN);
            sectionArc.setStroke((Paint)section.getColor());
            sectionArc.setStrokeWidth(barWidth);
            sectionArc.setStrokeLineCap(StrokeLineCap.BUTT);
            sectionArc.setFill(null);
            sectionArc.setVisible(!this.highlightSections);
            sectionArc.setOpacity(this.highlightSections ? 1.0 : 0.25);
            Tooltip sectionTooltip = new Tooltip(section.getText());
            sectionTooltip.setTextAlignment(TextAlignment.CENTER);
            Tooltip.install((Node)sectionArc, (Tooltip)sectionTooltip);
            this.sectionMap.put(section, sectionArc);
        }
        this.sectionPane.getChildren().addAll(this.sectionMap.values());
    }

    private void drawNeedle() {
        double needleWidth = this.size * 0.05;
        double needleHeight = this.size * 0.3325;
        this.needle.setCache(false);
        this.needle.getElements().clear();
        this.needle.getElements().add((Object)new MoveTo(0.25 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.25 * needleWidth, 0.9022556390977443 * needleHeight, 0.35 * needleWidth, 0.8872180451127819 * needleHeight, 0.5 * needleWidth, 0.8872180451127819 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.65 * needleWidth, 0.8872180451127819 * needleHeight, 0.75 * needleWidth, 0.9022556390977443 * needleHeight, 0.75 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.75 * needleWidth, 0.9473684210526315 * needleHeight, 0.65 * needleWidth, 0.9624060150375939 * needleHeight, 0.5 * needleWidth, 0.9624060150375939 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.35 * needleWidth, 0.9624060150375939 * needleHeight, 0.25 * needleWidth, 0.9473684210526315 * needleHeight, 0.25 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.getElements().add((Object)new MoveTo(0.0, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.0, 0.9699248120300752 * needleHeight, 0.2 * needleWidth, needleHeight, 0.5 * needleWidth, needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.8 * needleWidth, needleHeight, needleWidth, 0.9699248120300752 * needleHeight, needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(needleWidth, 0.8947368421052632 * needleHeight, 0.85 * needleWidth, 0.8646616541353384 * needleHeight, 0.65 * needleWidth, 0.849624060150376 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.65 * needleWidth, 0.849624060150376 * needleHeight, 0.65 * needleWidth, 0.022556390977443608 * needleHeight, 0.65 * needleWidth, 0.022556390977443608 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.65 * needleWidth, 0.007518796992481203 * needleHeight, 0.6 * needleWidth, 0.0, 0.5 * needleWidth, 0.0));
        this.needle.getElements().add((Object)new CubicCurveTo(0.4 * needleWidth, 0.0, 0.35 * needleWidth, 0.007518796992481203 * needleHeight, 0.35 * needleWidth, 0.022556390977443608 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.35 * needleWidth, 0.022556390977443608 * needleHeight, 0.35 * needleWidth, 0.849624060150376 * needleHeight, 0.35 * needleWidth, 0.849624060150376 * needleHeight));
        this.needle.getElements().add((Object)new CubicCurveTo(0.15 * needleWidth, 0.8646616541353384 * needleHeight, 0.0, 0.8947368421052632 * needleHeight, 0.0, 0.924812030075188 * needleHeight));
        this.needle.getElements().add((Object)new ClosePath());
        this.needle.setCache(true);
        this.needle.setCacheHint(CacheHint.ROTATE);
    }

    private void drawAlertIcon() {
        this.alertIcon.setCache(false);
        double iconWidth = this.size * 0.155;
        double iconHeight = this.size * 0.135;
        this.alertIcon.getElements().clear();
        this.alertIcon.getElements().add((Object)new MoveTo(0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4411764705882353 * iconWidth, 0.3 * iconHeight, 0.4684873949579832 * iconWidth, 0.2714285714285714 * iconHeight, 0.5 * iconWidth, 0.2714285714285714 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5315126050420168 * iconWidth, 0.2714285714285714 * iconHeight, 0.5588235294117647 * iconWidth, 0.3 * iconHeight, 0.5588235294117647 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5588235294117647 * iconWidth, 0.3380952380952381 * iconHeight, 0.5588235294117647 * iconWidth, 0.6 * iconHeight, 0.5588235294117647 * iconWidth, 0.6 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5588235294117647 * iconWidth, 0.6357142857142857 * iconHeight, 0.5315126050420168 * iconWidth, 0.6666666666666666 * iconHeight, 0.5 * iconWidth, 0.6666666666666666 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4684873949579832 * iconWidth, 0.6666666666666666 * iconHeight, 0.4411764705882353 * iconWidth, 0.6357142857142857 * iconHeight, 0.4411764705882353 * iconWidth, 0.6 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4411764705882353 * iconWidth, 0.6 * iconHeight, 0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight, 0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add((Object)new ClosePath());
        this.alertIcon.getElements().add((Object)new MoveTo(0.4411764705882353 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4411764705882353 * iconWidth, 0.7642857142857142 * iconHeight, 0.4684873949579832 * iconWidth, 0.7333333333333333 * iconHeight, 0.5 * iconWidth, 0.7333333333333333 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5315126050420168 * iconWidth, 0.7333333333333333 * iconHeight, 0.5588235294117647 * iconWidth, 0.7642857142857142 * iconHeight, 0.5588235294117647 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.5588235294117647 * iconWidth, 0.8380952380952381 * iconHeight, 0.5315126050420168 * iconWidth, 0.8666666666666667 * iconHeight, 0.5 * iconWidth, 0.8666666666666667 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4684873949579832 * iconWidth, 0.8666666666666667 * iconHeight, 0.4411764705882353 * iconWidth, 0.8380952380952381 * iconHeight, 0.4411764705882353 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add((Object)new ClosePath());
        this.alertIcon.getElements().add((Object)new MoveTo(0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.523109243697479 * iconWidth, -0.011904761904761904 * iconHeight, 0.47689075630252103 * iconWidth, -0.011904761904761904 * iconHeight, 0.4495798319327731 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.4495798319327731 * iconWidth, 0.04285714285714286 * iconHeight, 0.012605042016806723 * iconWidth, 0.9 * iconHeight, 0.012605042016806723 * iconWidth, 0.9 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(-0.014705882352941176 * iconWidth, 0.9547619047619048 * iconHeight, 0.0063025210084033615 * iconWidth, iconHeight, 0.06302521008403361 * iconWidth, iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.06302521008403361 * iconWidth, iconHeight, 0.9369747899159664 * iconWidth, iconHeight, 0.9369747899159664 * iconWidth, iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.9936974789915967 * iconWidth, iconHeight, 1.0147058823529411 * iconWidth, 0.9547619047619048 * iconHeight, 0.9873949579831933 * iconWidth, 0.9 * iconHeight));
        this.alertIcon.getElements().add((Object)new CubicCurveTo(0.9873949579831933 * iconWidth, 0.9 * iconHeight, 0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight, 0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add((Object)new ClosePath());
        this.alertIcon.setCache(true);
        this.alertIcon.setCacheHint(CacheHint.SPEED);
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void resizeDynamicText() {
        double maxWidth = this.unitText.isManaged() ? this.size * 0.725 : this.size * 0.9;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        maxWidth = this.size * 0.15;
        fontSize = this.size * 0.06;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth() - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.15);
            this.unitText.relocate(this.valueText.getLayoutX() + this.valueText.getLayoutBounds().getWidth() + this.size * 0.025, this.size * 0.3275);
        } else {
            this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.15);
        }
        if (this.sectionsVisible) {
            fontSize = this.size * 0.08;
            this.thresholdText.setFont(Fonts.latoRegular(fontSize));
            this.thresholdText.setTextOrigin(VPos.CENTER);
            if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
            }
            this.thresholdText.setX((this.size - this.thresholdText.getLayoutBounds().getWidth()) * 0.5);
            this.thresholdText.setY(this.thresholdRect.getLayoutBounds().getMinY() + this.thresholdRect.getHeight() * 0.5);
        }
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.9;
        double fontSize = this.size * 0.06;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.05, this.size * 0.05);
        maxWidth = this.size * 0.15;
        fontSize = this.size * 0.07;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        double textRadius = this.size * 0.3;
        double sinValue = Math.sin(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double cosValue = Math.cos(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double textX = this.size * 0.5 + textRadius * sinValue;
        double textY = this.size * 0.83 + textRadius * cosValue;
        this.maxValueText.setTranslateX(-this.maxValueText.getLayoutBounds().getWidth() * 0.5);
        this.maxValueText.setTranslateY(-this.maxValueText.getLayoutBounds().getHeight() * 0.5);
        this.maxValueText.relocate(textX, textY);
        this.minValueText.setFont(Fonts.latoRegular(this.maxValueText.getFont().getSize()));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        sinValue = Math.sin(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        cosValue = Math.cos(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        textX = this.size * 0.5 + textRadius * sinValue;
        textY = this.size * 0.83 + textRadius * cosValue;
        this.minValueText.setTranslateX(-this.minValueText.getLayoutBounds().getWidth() * 0.5);
        this.minValueText.setTranslateY(-this.minValueText.getLayoutBounds().getHeight() * 0.5);
        this.minValueText.relocate(textX, textY);
        if (!this.sectionsVisible) {
            fontSize = this.size * 0.08;
            this.thresholdText.setFont(Fonts.latoRegular(fontSize));
            this.thresholdText.setTextOrigin(VPos.CENTER);
            if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
            }
            this.thresholdText.setX((this.size - this.thresholdText.getLayoutBounds().getWidth()) * 0.5);
            this.thresholdText.setY(this.thresholdRect.getLayoutBounds().getMinY() + this.thresholdRect.getHeight() * 0.5);
        }
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            double centerX = this.size * 0.5;
            double centerY = this.size * 0.7825;
            double barRadius = this.size * 0.3;
            double barWidth = this.size * 0.045;
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.sectionPane.setMaxSize(this.size, this.size);
            this.barBackground.setCenterX(centerX);
            this.barBackground.setCenterY(centerY);
            this.barBackground.setRadiusX(barRadius);
            this.barBackground.setRadiusY(barRadius);
            this.barBackground.setStrokeWidth(barWidth);
            this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
            this.barBackground.setLength(-this.angleRange);
            this.thresholdBar.setCenterX(centerX);
            this.thresholdBar.setCenterY(centerY);
            this.thresholdBar.setRadiusX(barRadius);
            this.thresholdBar.setRadiusY(barRadius);
            this.thresholdBar.setStrokeWidth(barWidth);
            this.thresholdBar.setStartAngle(90.0 - this.angleRange * 0.5);
            this.thresholdBar.setLength((this.gauge.getMaxValue() - this.gauge.getThreshold()) * this.angleStep);
            if (this.sectionsVisible) {
                this.drawSections();
            }
            this.drawAlertIcon();
            this.alertIcon.relocate((this.size - this.alertIcon.getLayoutBounds().getWidth()) * 0.5, this.size * 0.244);
            this.needleRect.setWidth(this.size * 0.035);
            this.needleRect.setHeight(this.size * 0.05);
            this.needleRect.relocate((this.size - this.needleRect.getWidth()) * 0.5, this.size * 0.4575);
            this.needleRectRotate.setPivotX(this.needleRect.getLayoutBounds().getWidth() * 0.5);
            this.needleRectRotate.setPivotY(this.size * 0.325);
            this.drawNeedle();
            this.needle.relocate((this.size - this.needle.getLayoutBounds().getWidth()) * 0.5, this.size * 0.475);
            this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getWidth() * 0.5);
            this.resizeStaticText();
            this.resizeDynamicText();
            this.thresholdRect.setWidth(this.thresholdText.getLayoutBounds().getWidth() + this.size * 0.05);
            this.thresholdRect.setHeight(this.thresholdText.getLayoutBounds().getHeight());
            this.thresholdRect.setX((this.size - this.thresholdRect.getWidth()) * 0.5);
            this.thresholdRect.setY(this.size * 0.845);
            this.thresholdRect.setArcWidth(this.size * 0.025);
            this.thresholdRect.setArcHeight(this.size * 0.025);
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(this.size * 0.025), new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(this.size * 0.025), Insets.EMPTY)}));
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.thresholdColor = this.gauge.getThresholdColor();
        this.sectionsVisible = this.gauge.getSectionsVisible();
        Helper.enableNode((Node)this.sectionPane, this.sectionsVisible);
        this.titleText.setText(this.gauge.getTitle());
        this.unitText.setText(this.gauge.getUnit());
        this.minValueText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMinValue()));
        this.maxValueText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.thresholdText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getThreshold()));
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)this.gauge.getBarColor());
        this.thresholdBar.setStroke((Paint)this.gauge.getThresholdColor());
        this.needleRect.setFill(this.gauge.getBackgroundPaint());
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.minValueText.setFill((Paint)this.gauge.getTitleColor());
        this.maxValueText.setFill((Paint)this.gauge.getTitleColor());
        this.thresholdRect.setFill((Paint)(this.sectionsVisible ? Color.TRANSPARENT : (this.gauge.getValue() > this.gauge.getThreshold() ? this.gauge.getThresholdColor() : GRAY)));
        this.thresholdText.setFill((Paint)(this.sectionsVisible ? Color.TRANSPARENT : this.gauge.getBackgroundPaint()));
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.highlightSections(this.gauge.getValue());
    }
}

