/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;

public class SpaceXSkin
extends GaugeSkinBase {
    protected static final double PREFERRED_WIDTH = 250.0;
    protected static final double PREFERRED_HEIGHT = 290.0;
    protected static final double MINIMUM_WIDTH = 50.0;
    protected static final double MINIMUM_HEIGHT = 50.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 1.1625;
    private static final double ANGLE_RANGE = 270.0;
    private double size;
    private double width;
    private double height;
    private double centerX;
    private double centerY;
    private double range;
    private double angleStep;
    private double currentValueAngle;
    private double thresholdAngle;
    private double barWidth;
    private Pane pane;
    private Text unitText;
    private Text titleText;
    private Text valueText;
    private Path barBackground;
    private MoveTo barBackgroundStart;
    private ArcTo barBackgroundOuterArc;
    private LineTo barBackgroundLineToInnerArc;
    private ArcTo barBackgroundInnerArc;
    private Path thresholdBar;
    private MoveTo thresholdBarStart;
    private ArcTo thresholdBarOuterArc;
    private LineTo thresholdBarLineToInnerArc;
    private ArcTo thresholdBarInnerArc;
    private Path dataBar;
    private MoveTo dataBarStart;
    private ArcTo dataBarOuterArc;
    private LineTo dataBarLineToInnerArc;
    private ArcTo dataBarInnerArc;
    private Path dataBarThreshold;
    private MoveTo dataBarThresholdStart;
    private ArcTo dataBarThresholdOuterArc;
    private LineTo dataBarThresholdLineToInnerArc;
    private ArcTo dataBarThresholdInnerArc;
    private Color barColor;
    private Color thresholdColor;
    private Color barBackgroundColor;
    private Color thresholdBackgroundColor;
    private double minValue;
    private InvalidationListener currentValueListener;

    public SpaceXSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.range = gauge.getRange();
        this.angleStep = 270.0 / this.range;
        this.minValue = gauge.getMinValue();
        this.currentValueAngle = 0.0;
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 290.0);
            }
        }
        this.barColor = this.gauge.getBarColor();
        this.thresholdColor = this.gauge.getThresholdColor();
        this.barBackgroundColor = this.gauge.getBarBackgroundColor();
        this.thresholdBackgroundColor = Color.color((double)this.thresholdColor.getRed(), (double)this.thresholdColor.getGreen(), (double)this.thresholdColor.getBlue(), (double)0.25);
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getValue()));
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.barBackgroundStart = new MoveTo();
        this.barBackgroundOuterArc = new ArcTo(195.75, 195.75, 0.0, 250.0, 195.75, true, true);
        this.barBackgroundLineToInnerArc = new LineTo();
        this.barBackgroundInnerArc = new ArcTo(87.0, 87.0, 0.0, 69.44500000000001, 195.75, true, false);
        this.barBackground = new Path();
        this.barBackground.setFillRule(FillRule.EVEN_ODD);
        this.barBackground.getElements().add((Object)this.barBackgroundStart);
        this.barBackground.getElements().add((Object)this.barBackgroundOuterArc);
        this.barBackground.getElements().add((Object)this.barBackgroundLineToInnerArc);
        this.barBackground.getElements().add((Object)this.barBackgroundInnerArc);
        this.barBackground.getElements().add((Object)new ClosePath());
        this.barBackground.setFill((Paint)this.barBackgroundColor);
        this.barBackground.setStroke((Paint)Color.TRANSPARENT);
        this.thresholdBarStart = new MoveTo();
        this.thresholdBarOuterArc = new ArcTo(195.75, 195.75, 0.0, 250.0, 195.75, false, true);
        this.thresholdBarLineToInnerArc = new LineTo();
        this.thresholdBarInnerArc = new ArcTo(87.0, 87.0, 0.0, 69.44500000000001, 195.75, false, false);
        this.thresholdBar = new Path();
        this.thresholdBar.setFillRule(FillRule.EVEN_ODD);
        this.thresholdBar.getElements().add((Object)this.thresholdBarStart);
        this.thresholdBar.getElements().add((Object)this.thresholdBarOuterArc);
        this.thresholdBar.getElements().add((Object)this.thresholdBarLineToInnerArc);
        this.thresholdBar.getElements().add((Object)this.thresholdBarInnerArc);
        this.thresholdBar.getElements().add((Object)new ClosePath());
        this.thresholdBar.setFill((Paint)this.thresholdBackgroundColor);
        this.thresholdBar.setStroke((Paint)Color.TRANSPARENT);
        this.dataBarStart = new MoveTo();
        this.dataBarOuterArc = new ArcTo(250.0, 145.0, 0.0, 0.0, 0.0, true, true);
        this.dataBarLineToInnerArc = new LineTo();
        this.dataBarInnerArc = new ArcTo(125.0, 274.375, 0.0, 0.0, 0.0, true, false);
        this.dataBar = new Path();
        this.dataBar.setFillRule(FillRule.EVEN_ODD);
        this.dataBar.getElements().add((Object)this.dataBarStart);
        this.dataBar.getElements().add((Object)this.dataBarOuterArc);
        this.dataBar.getElements().add((Object)this.dataBarLineToInnerArc);
        this.dataBar.getElements().add((Object)this.dataBarInnerArc);
        this.dataBar.getElements().add((Object)new ClosePath());
        this.dataBar.setFill((Paint)this.barColor);
        this.dataBar.setStroke(this.gauge.getBorderPaint());
        this.dataBarThresholdStart = new MoveTo();
        this.dataBarThresholdOuterArc = new ArcTo(250.0, 145.0, 0.0, 0.0, 0.0, false, true);
        this.dataBarThresholdLineToInnerArc = new LineTo();
        this.dataBarThresholdInnerArc = new ArcTo(125.0, 274.375, 0.0, 0.0, 0.0, false, false);
        this.dataBarThreshold = new Path();
        this.dataBarThreshold.setFillRule(FillRule.EVEN_ODD);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdStart);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdOuterArc);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdLineToInnerArc);
        this.dataBarThreshold.getElements().add((Object)this.dataBarThresholdInnerArc);
        this.dataBarThreshold.getElements().add((Object)new ClosePath());
        this.dataBarThreshold.setFill((Paint)this.thresholdColor);
        this.dataBarThreshold.setStroke(this.gauge.getBorderPaint());
        this.pane = new Pane(new Node[]{this.titleText, this.valueText, this.unitText, this.barBackground, this.thresholdBar, this.dataBar, this.dataBarThreshold});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.range = this.gauge.getRange();
            this.angleStep = 270.0 / this.range;
            this.minValue = this.gauge.getMinValue();
            this.resize();
            this.redraw();
            this.setBar(this.gauge.getCurrentValue());
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void setBar(double VALUE) {
        this.currentValueAngle = (VALUE - this.minValue) * this.angleStep;
        this.thresholdAngle = (this.gauge.getThreshold() - this.minValue) * this.angleStep;
        double valueAngle = this.currentValueAngle > this.thresholdAngle ? this.thresholdAngle : this.currentValueAngle;
        this.dataBarOuterArc.setLargeArcFlag(valueAngle > 180.0);
        this.dataBarInnerArc.setLargeArcFlag(valueAngle > 180.0);
        this.dataBarOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(valueAngle)));
        this.dataBarOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(valueAngle)));
        this.dataBarLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(valueAngle)));
        this.dataBarLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(valueAngle)));
        double dataBarThresholdAngle = VALUE > this.gauge.getThreshold() ? this.currentValueAngle : this.thresholdAngle;
        this.dataBarThresholdOuterArc.setLargeArcFlag(dataBarThresholdAngle > 180.0 + this.thresholdAngle);
        this.dataBarThresholdInnerArc.setLargeArcFlag(dataBarThresholdAngle > 180.0 + this.thresholdAngle);
        this.dataBarThresholdOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
        this.dataBarThresholdInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
        this.dataBarThresholdInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
        this.valueText.setText(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        if (this.valueText.getLayoutBounds().getWidth() > 0.64 * this.width) {
            Helper.adjustTextSize(this.valueText, this.width, 0.21 * this.width);
        }
        this.valueText.relocate(this.width - this.valueText.getLayoutBounds().getWidth(), 0.58064516 * this.height);
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (1.1625 * this.width > this.height) {
            this.width = 1.0 / (1.1625 / this.height);
        } else if (1.0 / (1.1625 / this.height) > this.width) {
            this.height = 1.1625 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.centerX = 0.5 * this.width;
            this.centerY = 0.56989247 * this.height;
            this.barWidth = 0.125 * this.width;
            this.titleText.setFont(Fonts.robotoMedium(0.13 * this.width));
            if (this.titleText.getLayoutBounds().getWidth() > this.width) {
                Helper.adjustTextSize(this.titleText, this.width, 0.13 * this.width);
            }
            this.titleText.relocate(0.0, 0.0);
            this.valueText.setFont(Fonts.robotoRegular(0.21 * this.width));
            if (this.valueText.getLayoutBounds().getWidth() > 0.64 * this.width) {
                Helper.adjustTextSize(this.valueText, this.width, 0.21 * this.width);
            }
            this.valueText.relocate(this.width - this.valueText.getLayoutBounds().getWidth(), 0.58064516 * this.height);
            this.unitText.setFont(Fonts.robotoLight(0.11 * this.width));
            if (this.unitText.getLayoutBounds().getWidth() > 0.4 * this.width) {
                Helper.adjustTextSize(this.unitText, this.width, 0.11 * this.width);
            }
            this.unitText.relocate(this.width - this.unitText.getLayoutBounds().getWidth(), 0.79 * this.height);
            this.thresholdAngle = (this.gauge.getThreshold() - this.minValue) * this.angleStep;
            this.currentValueAngle = (this.gauge.getCurrentValue() - this.minValue) * this.angleStep;
            this.barBackgroundOuterArc.setLargeArcFlag(this.thresholdAngle > 180.0);
            this.barBackgroundInnerArc.setLargeArcFlag(this.thresholdAngle > 180.0);
            this.barBackgroundStart.setX(this.centerX);
            this.barBackgroundStart.setY(this.height);
            this.barBackgroundOuterArc.setRadiusX(this.centerX);
            this.barBackgroundOuterArc.setRadiusY(this.centerX);
            this.barBackgroundOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.barBackgroundInnerArc.setRadiusX(0.375 * this.width);
            this.barBackgroundInnerArc.setRadiusY(0.375 * this.width);
            this.barBackgroundInnerArc.setX(this.centerX);
            this.barBackgroundInnerArc.setY(this.height - this.barWidth);
            this.thresholdBarOuterArc.setLargeArcFlag(this.thresholdAngle < 180.0);
            this.thresholdBarInnerArc.setLargeArcFlag(this.thresholdAngle < 180.0);
            this.thresholdBarStart.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.thresholdBarStart.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.thresholdBarOuterArc.setRadiusX(this.centerX);
            this.thresholdBarOuterArc.setRadiusY(this.centerX);
            this.thresholdBarOuterArc.setX(this.width);
            this.thresholdBarOuterArc.setY(this.centerY);
            this.thresholdBarLineToInnerArc.setX(this.width - this.barWidth);
            this.thresholdBarLineToInnerArc.setY(this.centerY);
            this.thresholdBarInnerArc.setRadiusX(0.375 * this.width);
            this.thresholdBarInnerArc.setRadiusY(0.375 * this.width);
            this.thresholdBarInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.thresholdBarInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.dataBarOuterArc.setLargeArcFlag(this.currentValueAngle > 180.0);
            this.dataBarInnerArc.setLargeArcFlag(this.currentValueAngle > 180.0);
            this.dataBarStart.setX(this.centerX);
            this.dataBarStart.setY(this.height);
            this.dataBarOuterArc.setRadiusX(this.centerX);
            this.dataBarOuterArc.setRadiusY(this.centerX);
            this.dataBarOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarInnerArc.setRadiusX(0.375 * this.width);
            this.dataBarInnerArc.setRadiusY(0.375 * this.width);
            this.dataBarInnerArc.setX(this.centerX);
            this.dataBarInnerArc.setY(this.height - this.barWidth);
            double dataBarThresholdAngle = this.gauge.getCurrentValue() > this.gauge.getThreshold() ? this.currentValueAngle : this.thresholdAngle;
            this.dataBarThresholdStart.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.dataBarThresholdStart.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(this.thresholdAngle)));
            this.dataBarThresholdOuterArc.setRadiusX(this.centerX);
            this.dataBarThresholdOuterArc.setRadiusY(this.centerX);
            this.dataBarThresholdOuterArc.setX(this.centerX + this.centerX * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdOuterArc.setY(this.centerY + this.centerX * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdLineToInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdLineToInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(dataBarThresholdAngle)));
            this.dataBarThresholdInnerArc.setRadiusX(0.375 * this.width);
            this.dataBarThresholdInnerArc.setRadiusY(0.375 * this.width);
            this.dataBarThresholdInnerArc.setX(this.centerX + (this.centerX - this.barWidth) * Math.sin(-Math.toRadians(this.thresholdAngle)));
            this.dataBarThresholdInnerArc.setY(this.centerY + (this.centerX - this.barWidth) * Math.cos(-Math.toRadians(this.thresholdAngle)));
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.width))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.barColor = this.gauge.getBarColor();
        this.thresholdColor = this.gauge.getThresholdColor();
        this.barBackgroundColor = this.gauge.getBarBackgroundColor();
        this.thresholdBackgroundColor = Color.color((double)this.thresholdColor.getRed(), (double)this.thresholdColor.getGreen(), (double)this.thresholdColor.getBlue(), (double)0.25);
        this.barBackground.setFill((Paint)this.barBackgroundColor);
        this.thresholdBar.setFill((Paint)this.thresholdBackgroundColor);
        this.dataBar.setFill((Paint)this.barColor);
        this.dataBarThreshold.setFill((Paint)this.thresholdColor);
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.titleText.setText(this.gauge.getTitle());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.valueText.setText(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getCurrentValue()));
        this.valueText.relocate(this.width - this.valueText.getLayoutBounds().getWidth(), 0.58064516 * this.height);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.unitText.setText(this.gauge.getUnit());
        this.unitText.relocate(this.width - this.unitText.getLayoutBounds().getWidth(), 0.79 * this.height);
    }
}

