/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;

public class SlimSkin
extends GaugeSkinBase {
    private static final double ANGLE_RANGE = 360.0;
    private double size;
    private Arc barBackground;
    private Arc bar;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Pane pane;
    private double minValue;
    private double range;
    private double angleStep;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private boolean sectionsVisible;
    private List<Section> sections;
    private InvalidationListener currentValueListener;

    public SlimSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.range = gauge.getRange();
        this.angleStep = 360.0 / this.range;
        this.colorGradientEnabled = gauge.isGradientBarEnabled();
        this.noOfGradientStops = gauge.getGradientBarStops().size();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.barBackground = new Arc(125.0, 125.0, 121.47556499999999, 121.47556499999999, 90.0, 360.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.ROUND);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 121.47556499999999, 121.47556499999999, 90.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke((Paint)this.gauge.getBarColor());
        this.bar.setStrokeWidth(14.097745);
        this.bar.setStrokeLineCap(StrokeLineCap.ROUND);
        this.bar.setFill(null);
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getCurrentValue()));
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.pane = new Pane(new Node[]{this.barBackground, this.bar, this.titleText, this.valueText, this.unitText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.gauge.getMinValue();
            this.range = this.gauge.getRange();
            this.angleStep = 360.0 / this.range;
            this.sections = this.gauge.getSections();
            this.redraw();
            this.setBar(this.gauge.getCurrentValue());
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        }
    }

    private void setBar(double VALUE) {
        double barLength = 0.0;
        double min = this.gauge.getMinValue();
        double max = this.gauge.getMaxValue();
        double clampedValue = Helper.clamp(min, max, VALUE);
        if (this.gauge.isStartFromZero()) {
            if ((VALUE > min || min < 0.0) && (VALUE < max || max > 0.0)) {
                barLength = max < 0.0 ? (max - clampedValue) * this.angleStep : (min > 0.0 ? (min - clampedValue) * this.angleStep : -clampedValue * this.angleStep);
            }
        } else {
            barLength = (min - clampedValue) * this.angleStep;
        }
        this.bar.setLength(barLength);
        this.setBarColor(VALUE);
        this.valueText.setText(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.resizeValueText();
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.bar.setStroke((Paint)this.gauge.getBarColor());
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.bar.setStroke((Paint)this.gauge.getGradientLookup().getColorAt((VALUE - this.minValue) / this.range));
        } else {
            this.bar.setStroke((Paint)this.gauge.getBarColor());
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke((Paint)section.getColor());
                break;
            }
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void resizeValueText() {
        double maxWidth = this.size * 0.86466165;
        double fontSize = this.size * 0.2556391;
        this.valueText.setFont(Fonts.latoLight(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.valueText.relocate((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5, (this.size - this.valueText.getLayoutBounds().getHeight()) * 0.5);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.69548872;
        double fontSize = this.size * 0.08082707;
        this.titleText.setFont(Fonts.latoBold(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.22180451);
        this.unitText.setFont(Fonts.latoBold(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.68984962);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.barBackground.setCenterX(this.size * 0.5);
            this.barBackground.setCenterY(this.size * 0.5);
            this.barBackground.setRadiusX(this.size * 0.48590226);
            this.barBackground.setRadiusY(this.size * 0.48590226);
            this.barBackground.setStrokeWidth(this.size * 0.02819549);
            this.bar.setCenterX(this.size * 0.5);
            this.bar.setCenterY(this.size * 0.5);
            this.bar.setRadiusX(this.size * 0.48590226);
            this.bar.setRadiusY(this.size * 0.48590226);
            this.bar.setStrokeWidth(this.size * 0.02819549);
            this.resizeStaticText();
            this.resizeValueText();
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.colorGradientEnabled = this.gauge.isGradientBarEnabled();
        this.noOfGradientStops = this.gauge.getGradientBarStops().size();
        this.sectionsVisible = this.gauge.getSectionsVisible();
        this.titleText.setText(this.gauge.getTitle());
        this.unitText.setText(this.gauge.getUnit());
        this.resizeStaticText();
        this.barBackground.setStroke((Paint)this.gauge.getBarBackgroundColor());
        this.setBarColor(this.gauge.getCurrentValue());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
    }
}

