/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class ModernSkin
extends GaugeSkinBase {
    private double START_ANGLE = 300.0;
    private double ANGLE_RANGE = 240.0;
    private double BAR_START_ANGLE = -150.0;
    private double size;
    private Pane pane;
    private Circle background;
    private Path mask;
    private Circle centerKnob;
    private Path needle;
    private MoveTo needleMoveTo1;
    private CubicCurveTo needleCubicCurveTo2;
    private CubicCurveTo needleCubicCurveTo3;
    private CubicCurveTo needleCubicCurveTo4;
    private LineTo needleLineTo5;
    private LineTo needleLineTo6;
    private LineTo needleLineTo7;
    private LineTo needleLineTo8;
    private ClosePath needleClosePath9;
    private Rotate needleRotate;
    private Canvas mainCanvas;
    private GraphicsContext mainCtx;
    private Canvas tickMarkCanvas;
    private GraphicsContext tickMarkCtx;
    private InnerShadow innerShadow0;
    private InnerShadow innerShadow1;
    private InnerShadow innerShadow2;
    private InnerShadow innerShadow3;
    private DropShadow dropShadow4;
    private DropShadow glow1;
    private DropShadow glow2;
    private DropShadow bigGlow;
    private Text valueText;
    private Text titleText;
    private Text subTitleText;
    private Text unitText;
    private double angleStep;
    private EventHandler<MouseEvent> mouseHandler;
    private Tooltip buttonTooltip;
    private Locale locale;
    private boolean sectionsVisible;
    private List<Section> sections;
    private Color barColor;
    private Color thresholdColor;
    private InvalidationListener animatedListener;
    private ListChangeListener<Section> sectionListener;
    private InvalidationListener currentValueListener;

    public ModernSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.angleStep = this.ANGLE_RANGE / gauge.getRange();
        this.mouseHandler = event -> this.handleMouseEvent((MouseEvent)event);
        this.buttonTooltip = new Tooltip();
        this.locale = gauge.getLocale();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.barColor = gauge.getBarColor();
        this.thresholdColor = gauge.getThresholdColor();
        this.animatedListener = o -> this.handleEvents("ANIMATED");
        this.sectionListener = c -> this.handleEvents("RESIZE");
        this.currentValueListener = o -> this.rotateNeedle(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.innerShadow0 = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 1.0, 0.0, 0.0, 1.0);
        this.innerShadow1 = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)255, (int)255, (int)255, (double)0.65), 1.0, 0.0, 0.0, -1.0);
        this.innerShadow1.setInput((Effect)this.innerShadow0);
        this.background = new Circle(125.0, 125.0, 125.0);
        this.background.setFill((Paint)Color.rgb((int)32, (int)32, (int)32));
        this.background.setStroke(null);
        this.background.setEffect((Effect)this.innerShadow1);
        this.innerShadow2 = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)255, (int)255, (int)255, (double)0.65), 1.0, 0.0, 0.0, 1.0);
        this.innerShadow3 = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 1.0, 0.0, 0.0, -1.0);
        this.innerShadow3.setInput((Effect)this.innerShadow2);
        this.dropShadow4 = new DropShadow();
        this.dropShadow4.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow4.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        this.dropShadow4.setOffsetX(0.0);
        this.dropShadow4.setInput((Effect)this.innerShadow3);
        this.mask = new Path();
        this.mask.setFillRule(FillRule.EVEN_ODD);
        this.mask.setFill((Paint)Color.rgb((int)32, (int)32, (int)32));
        this.mask.setStroke(null);
        this.mask.setEffect((Effect)this.dropShadow4);
        this.needleRotate = new Rotate(180.0 - this.START_ANGLE);
        double targetAngle = 180.0 - this.START_ANGLE + (this.gauge.getCurrentValue() - this.gauge.getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.glow1 = new DropShadow(BlurType.TWO_PASS_BOX, this.barColor, 21.25, 0.0, 0.0, 0.0);
        this.glow2 = new DropShadow(BlurType.TWO_PASS_BOX, this.barColor, 21.25, 0.0, 0.0, 0.0);
        this.bigGlow = new DropShadow(BlurType.TWO_PASS_BOX, this.barColor, 62.5, 0.0, 0.0, 0.0);
        this.needleMoveTo1 = new MoveTo();
        this.needleCubicCurveTo2 = new CubicCurveTo();
        this.needleCubicCurveTo3 = new CubicCurveTo();
        this.needleCubicCurveTo4 = new CubicCurveTo();
        this.needleLineTo5 = new LineTo();
        this.needleLineTo6 = new LineTo();
        this.needleLineTo7 = new LineTo();
        this.needleLineTo8 = new LineTo();
        this.needleClosePath9 = new ClosePath();
        this.needle = new Path(new PathElement[]{this.needleMoveTo1, this.needleCubicCurveTo2, this.needleCubicCurveTo3, this.needleCubicCurveTo4, this.needleLineTo5, this.needleLineTo6, this.needleLineTo7, this.needleLineTo8, this.needleClosePath9});
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.setEffect((Effect)this.glow1);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.needle.setStroke(null);
        this.needle.setStrokeLineCap(StrokeLineCap.ROUND);
        this.needle.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        this.mainCanvas = new Canvas(250.0, 250.0);
        this.mainCtx = this.mainCanvas.getGraphicsContext2D();
        this.tickMarkCanvas = new Canvas(250.0, 250.0);
        this.tickMarkCtx = this.tickMarkCanvas.getGraphicsContext2D();
        this.centerKnob = new Circle(125.0, 125.0, 57.291667499999996);
        this.centerKnob.setPickOnBounds(false);
        this.titleText = new Text(this.gauge.getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.titleText.setEffect((Effect)this.glow1);
        this.titleText.setMouseTransparent(true);
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.subTitleText = new Text(this.gauge.getSubTitle());
        this.subTitleText.setTextOrigin(VPos.CENTER);
        this.subTitleText.setFill((Paint)this.gauge.getSubTitleColor());
        this.subTitleText.setEffect((Effect)this.glow1);
        this.subTitleText.setMouseTransparent(true);
        Helper.enableNode((Node)this.subTitleText, !this.gauge.getSubTitle().isEmpty());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.unitText.setEffect((Effect)this.glow1);
        this.unitText.setMouseTransparent(true);
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.valueText = new Text(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getCurrentValue()));
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.valueText.setEffect((Effect)this.bigGlow);
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.pane = new Pane(new Node[]{this.background, this.mainCanvas, this.tickMarkCanvas, this.mask, this.needle, this.centerKnob, this.titleText, this.subTitleText, this.unitText, this.valueText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.animatedProperty().addListener(this.animatedListener);
        this.gauge.getSections().addListener(this.sectionListener);
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
        this.handleEvents("INTERACTIVITY");
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.subTitleText, !this.gauge.getSubTitle().isEmpty());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            this.sectionsVisible = this.gauge.getSectionsVisible();
            this.redraw();
        } else if ("RECALC".equals(EVENT_TYPE)) {
            this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
            this.redraw();
            this.rotateNeedle(this.gauge.getCurrentValue());
        } else if ("INTERACTIVITY".equals(EVENT_TYPE)) {
            if (this.gauge.isInteractive()) {
                this.centerKnob.setOnMousePressed(this.mouseHandler);
                this.centerKnob.setOnMouseReleased(this.mouseHandler);
                this.buttonTooltip.setText(this.gauge.getButtonTooltipText());
                Tooltip.install((Node)this.centerKnob, (Tooltip)this.buttonTooltip);
            } else {
                this.centerKnob.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
                this.centerKnob.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
                Tooltip.uninstall((Node)this.centerKnob, (Tooltip)this.buttonTooltip);
            }
        } else if ("SECTIONS".equals(EVENT_TYPE)) {
            this.sectionsVisible = this.gauge.getSectionsVisible();
            this.sections = this.gauge.getSections();
        }
    }

    public void handleMouseEvent(MouseEvent EVENT) {
        if (this.gauge.isDisabled()) {
            return;
        }
        EventType TYPE = EVENT.getEventType();
        if (MouseEvent.MOUSE_PRESSED.equals(TYPE)) {
            this.gauge.fireEvent(this.gauge.BTN_PRESSED_EVENT);
            this.centerKnob.setFill((Paint)new LinearGradient(0.5 * this.size, 0.2708333333333333 * this.size, 0.5 * this.size, 0.7291666666666666 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)31, (int)31, (int)31)), new Stop(1.0, Color.rgb((int)69, (int)70, (int)73))}));
            this.valueText.setTranslateY(this.size * 0.501);
            this.subTitleText.setTranslateY(this.size * 0.3525);
            this.unitText.setTranslateY(this.size * 0.6675);
        } else if (MouseEvent.MOUSE_RELEASED.equals(TYPE)) {
            this.gauge.fireEvent(this.gauge.BTN_RELEASED_EVENT);
            this.centerKnob.setFill((Paint)new LinearGradient(0.5 * this.size, 0.2708333333333333 * this.size, 0.5 * this.size, 0.7291666666666666 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)69, (int)70, (int)73)), new Stop(1.0, Color.rgb((int)31, (int)31, (int)31))}));
            this.valueText.setTranslateY(this.size * 0.5);
            this.subTitleText.setTranslateY(this.size * 0.35);
            this.unitText.setTranslateY(this.size * 0.67);
        }
    }

    @Override
    public void dispose() {
        this.gauge.animatedProperty().removeListener(this.animatedListener);
        this.gauge.getSections().removeListener(this.sectionListener);
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        if (this.gauge.isInteractive()) {
            this.centerKnob.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
            this.centerKnob.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
        }
        super.dispose();
    }

    private void rotateNeedle(double VALUE) {
        this.angleStep = this.ANGLE_RANGE / this.gauge.getRange();
        double targetAngle = 180.0 - this.START_ANGLE + (VALUE - this.gauge.getMinValue()) * this.angleStep;
        this.needleRotate.setAngle(Helper.clamp(180.0 - this.START_ANGLE, 180.0 - this.START_ANGLE + this.ANGLE_RANGE, targetAngle));
        this.valueText.setText(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        if (this.valueText.getLayoutBounds().getWidth() > 0.395 * this.size) {
            this.resizeText();
            this.placeTextVerticaly();
        }
        if (this.gauge.isThresholdVisible() && VALUE > this.gauge.getThreshold()) {
            this.glow2.setColor(this.thresholdColor);
            this.bigGlow.setColor(this.thresholdColor);
        } else {
            this.glow2.setColor(this.barColor);
            this.bigGlow.setColor(this.barColor);
        }
        this.highlightValue(this.tickMarkCtx, VALUE);
    }

    private void highlightValue(GraphicsContext CTX, double CURRENT_VALUE) {
        CTX.clearRect(0.0, 0.0, this.size, this.size);
        double centerX = this.size * 0.5;
        double centerY = this.size * 0.5;
        double minorTickSpace = this.gauge.getMinorTickSpace();
        double minValue = this.gauge.getMinValue();
        double maxValue = this.gauge.getMaxValue();
        double tmpAngleStep = this.angleStep * minorTickSpace;
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(this.gauge.getMajorTickSpace());
        BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
        BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
        BigDecimal counterBD = BigDecimal.valueOf(minValue);
        double counter = minValue;
        boolean majorTickMarksVisible = this.gauge.getMajorTickMarksVisible();
        boolean mediumTickMarksVisible = this.gauge.getMediumTickMarksVisible();
        double threshold = this.gauge.getThreshold();
        Color tickMarkColor = Color.TRANSPARENT;
        Color highlightColor = !this.gauge.isThresholdVisible() || CURRENT_VALUE <= this.gauge.getThreshold() ? this.barColor : this.thresholdColor;
        boolean startFromZero = this.gauge.isStartFromZero();
        CTX.setLineCap(StrokeLineCap.BUTT);
        CTX.setLineWidth(this.size * 0.0035);
        double angle = 0.0;
        while (Double.compare(-this.ANGLE_RANGE - tmpAngleStep, angle) < 0) {
            double sinValue = Math.sin(Math.toRadians(angle + this.START_ANGLE));
            double cosValue = Math.cos(Math.toRadians(angle + this.START_ANGLE));
            double innerPointX = centerX + this.size * 0.375 * sinValue;
            double innerPointY = centerY + this.size * 0.375 * cosValue;
            double outerPointX = centerX + this.size * 0.425 * sinValue;
            double outerPointY = centerY + this.size * 0.425 * cosValue;
            double innerMediumPointX = centerX + this.size * 0.35 * sinValue;
            double innerMediumPointY = centerY + this.size * 0.35 * cosValue;
            double outerMediumPointX = centerX + this.size * 0.4 * sinValue;
            double outerMediumPointY = centerY + this.size * 0.4 * cosValue;
            boolean shouldHighlight = false;
            if (startFromZero) {
                if ((CURRENT_VALUE > minValue || minValue < 0.0) && (CURRENT_VALUE < maxValue || maxValue > 0.0)) {
                    shouldHighlight = maxValue < 0.0 ? counter >= CURRENT_VALUE : (minValue > 0.0 ? counter <= CURRENT_VALUE : (CURRENT_VALUE > 0.0 ? counter >= 0.0 && counter <= CURRENT_VALUE : counter <= 0.0 && counter >= CURRENT_VALUE));
                }
            } else {
                boolean bl = shouldHighlight = counter <= CURRENT_VALUE;
            }
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                if (majorTickMarksVisible) {
                    CTX.setStroke((Paint)(shouldHighlight ? highlightColor : tickMarkColor));
                    CTX.strokeLine(innerPointX, innerPointY, outerPointX, outerPointY);
                }
            } else if (mediumTickMarksVisible && (double)Double.compare(minorTickSpaceBD.remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                CTX.setStroke((Paint)(shouldHighlight ? highlightColor : tickMarkColor));
                CTX.strokeLine(innerMediumPointX, innerMediumPointY, outerMediumPointX, outerMediumPointY);
            }
            counterBD = counterBD.add(minorTickSpaceBD);
            counter = counterBD.doubleValue();
            angle -= tmpAngleStep;
        }
        double barXY = (this.size - 0.75 * this.size) * 0.5;
        double barWH = this.size * 0.75;
        CTX.save();
        CTX.setEffect((Effect)this.glow2);
        CTX.setStroke((Paint)highlightColor);
        CTX.setLineWidth(this.size * 0.01666667);
        CTX.setLineCap(StrokeLineCap.BUTT);
        double barLength = 0.0;
        double barStart = 0.0;
        double clampedValue = Helper.clamp(minValue, maxValue, CURRENT_VALUE);
        if (startFromZero) {
            if ((CURRENT_VALUE > minValue || minValue < 0.0) && (CURRENT_VALUE < maxValue || maxValue > 0.0)) {
                if (maxValue < 0.0) {
                    barStart = this.BAR_START_ANGLE - this.ANGLE_RANGE;
                    barLength = (maxValue - clampedValue) * this.angleStep;
                } else if (minValue > 0.0) {
                    barStart = this.BAR_START_ANGLE;
                    barLength = (minValue - clampedValue) * this.angleStep;
                } else {
                    barStart = this.BAR_START_ANGLE + minValue * this.angleStep;
                    barLength = -clampedValue * this.angleStep;
                }
            }
        } else {
            barStart = this.BAR_START_ANGLE;
            barLength = (minValue - clampedValue) * this.angleStep;
        }
        CTX.strokeArc(barXY, barXY, barWH, barWH, barStart, barLength, ArcType.OPEN);
        CTX.restore();
        this.valueText.setText(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), CURRENT_VALUE));
    }

    private void drawMainCanvas() {
        this.mainCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.mainCtx.setFillRule(FillRule.EVEN_ODD);
        double sectionsXY = (this.size - 0.75 * this.size) * 0.5;
        double sectionsWH = this.size * 0.75;
        double minValue = this.gauge.getMinValue();
        double maxValue = this.gauge.getMaxValue();
        double offset = 90.0 - this.START_ANGLE;
        double sectionWidth = this.size * 0.06;
        if (this.sectionsVisible) {
            int listSize = this.sections.size();
            for (int i = 0; i < listSize; ++i) {
                Section SECTION = this.sections.get(i);
                if (Double.compare(SECTION.getStart(), maxValue) > 0 || Double.compare(SECTION.getStop(), minValue) < 0) continue;
                double SECTION_START_ANGLE = Double.compare(SECTION.getStart(), minValue) < 0 && Double.compare(SECTION.getStop(), maxValue) < 0 ? 0.0 : (SECTION.getStart() - minValue) * this.angleStep;
                double SECTION_ANGLE_EXTEND = Double.compare(SECTION.getStop(), maxValue) > 0 ? (maxValue - SECTION.getStart()) * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
                this.mainCtx.save();
                this.mainCtx.setStroke((Paint)SECTION.getColor());
                this.mainCtx.setLineWidth(sectionWidth);
                this.mainCtx.setLineCap(StrokeLineCap.BUTT);
                this.mainCtx.strokeArc(sectionsXY, sectionsXY, sectionsWH, sectionsWH, -(offset + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                this.mainCtx.restore();
            }
        }
        this.mainCtx.save();
        this.drawTickMarks(this.mainCtx);
        this.mainCtx.restore();
        this.mainCtx.save();
        this.mainCtx.setStroke((Paint)Color.rgb((int)23, (int)23, (int)23));
        this.mainCtx.setLineWidth(this.size * 0.025);
        this.mainCtx.setLineCap(StrokeLineCap.BUTT);
        this.mainCtx.strokeArc(sectionsXY, sectionsXY, sectionsWH, sectionsWH, this.BAR_START_ANGLE, -this.ANGLE_RANGE, ArcType.OPEN);
        this.mainCtx.restore();
        double barXY = (this.size - 0.75 * this.size) * 0.5;
        double barWH = this.size * 0.75;
        this.mainCtx.save();
        this.mainCtx.setStroke((Paint)Color.rgb((int)57, (int)57, (int)57, (double)0.75));
        this.mainCtx.setLineWidth(this.size * 0.01666667);
        this.mainCtx.setLineCap(StrokeLineCap.BUTT);
        this.mainCtx.strokeArc(barXY, barXY, barWH, barWH, this.BAR_START_ANGLE, -this.ANGLE_RANGE, ArcType.OPEN);
        this.mainCtx.restore();
        if (this.gauge.isThresholdVisible()) {
            this.mainCtx.save();
            this.mainCtx.translate(this.size * 0.5, this.size * 0.5);
            this.mainCtx.rotate((this.gauge.getThreshold() - minValue) * this.angleStep - 120.0);
            this.mainCtx.beginPath();
            this.mainCtx.moveTo(0.0, -this.size * 0.33);
            this.mainCtx.lineTo(-this.size * 0.0125, -this.size * 0.30833333);
            this.mainCtx.lineTo(this.size * 0.0125, -this.size * 0.30833333);
            this.mainCtx.closePath();
            this.mainCtx.setFill((Paint)this.gauge.getNeedleColor());
            this.mainCtx.fill();
            this.mainCtx.restore();
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        Color tickMarkColor;
        double centerX = this.size * 0.5;
        double centerY = this.size * 0.5;
        double minorTickSpace = this.gauge.getMinorTickSpace();
        double minValue = this.gauge.getMinValue();
        double maxValue = this.gauge.getMaxValue();
        double tmpAngleStep = this.angleStep * minorTickSpace;
        int decimals = this.gauge.getTickLabelDecimals();
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(this.gauge.getMajorTickSpace());
        BigDecimal mediumCheck2 = BigDecimal.valueOf(2.0 * minorTickSpace);
        BigDecimal mediumCheck5 = BigDecimal.valueOf(5.0 * minorTickSpace);
        BigDecimal counterBD = BigDecimal.valueOf(minValue);
        double counter = minValue;
        boolean majorTickMarksVisible = this.gauge.getMajorTickMarksVisible();
        boolean mediumTickMarksVisible = this.gauge.getMediumTickMarksVisible();
        boolean tickLabelsVisible = this.gauge.getTickLabelsVisible();
        TickLabelOrientation tickLabelOrientation = this.gauge.getTickLabelOrientation();
        Color majorTickMarkColor = tickMarkColor = this.gauge.getTickMarkColor();
        Color mediumTickMarkColor = tickMarkColor;
        Color tickLabelColor = this.gauge.getTickLabelColor();
        double orthTextFactor = 0.46;
        Font tickLabelFont = Fonts.robotoCondensedLight((decimals == 0 ? 0.047 : 0.04) * this.size);
        CTX.setFont(tickLabelFont);
        CTX.setTextAlign(TextAlignment.CENTER);
        CTX.setTextBaseline(VPos.CENTER);
        CTX.setLineCap(StrokeLineCap.BUTT);
        CTX.setLineWidth(this.size * 0.0035);
        double angle = 0.0;
        while (Double.compare(-this.ANGLE_RANGE - tmpAngleStep, angle) < 0) {
            double sinValue = Math.sin(Math.toRadians(angle + this.START_ANGLE));
            double cosValue = Math.cos(Math.toRadians(angle + this.START_ANGLE));
            double innerPointX = centerX + this.size * 0.375 * sinValue;
            double innerPointY = centerY + this.size * 0.375 * cosValue;
            double outerPointX = centerX + this.size * 0.425 * sinValue;
            double outerPointY = centerY + this.size * 0.425 * cosValue;
            double innerMediumPointX = centerX + this.size * 0.35 * sinValue;
            double innerMediumPointY = centerY + this.size * 0.35 * cosValue;
            double outerMediumPointX = centerX + this.size * 0.4 * sinValue;
            double outerMediumPointY = centerY + this.size * 0.4 * cosValue;
            double textPointX = centerX + this.size * orthTextFactor * sinValue;
            double textPointY = centerY + this.size * orthTextFactor * cosValue;
            CTX.setStroke((Paint)tickMarkColor);
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                if (majorTickMarksVisible) {
                    CTX.setFill((Paint)majorTickMarkColor);
                    CTX.setStroke((Paint)majorTickMarkColor);
                    CTX.strokeLine(innerPointX, innerPointY, outerPointX, outerPointY);
                }
                if (tickLabelsVisible) {
                    CTX.save();
                    CTX.translate(textPointX, textPointY);
                    Helper.rotateContextForText(CTX, this.START_ANGLE, angle, tickLabelOrientation);
                    CTX.setFill((Paint)tickLabelColor);
                    if (TickLabelOrientation.HORIZONTAL == tickLabelOrientation && (Double.compare(counter, minValue) == 0 || Double.compare(counter, maxValue) == 0)) {
                        CTX.setFill((Paint)Color.TRANSPARENT);
                    }
                    CTX.fillText(String.format(this.locale, "%." + decimals + "f", counter), 0.0, 0.0);
                    CTX.restore();
                }
            } else if (mediumTickMarksVisible && (double)Double.compare(minorTickSpaceBD.remainder(mediumCheck2).doubleValue(), 0.0) != 0.0 && (double)Double.compare(counterBD.remainder(mediumCheck5).doubleValue(), 0.0) == 0.0) {
                CTX.setFill((Paint)mediumTickMarkColor);
                CTX.setStroke((Paint)mediumTickMarkColor);
                CTX.strokeLine(innerMediumPointX, innerMediumPointY, outerMediumPointX, outerMediumPointY);
            }
            counterBD = counterBD.add(minorTickSpaceBD);
            counter = counterBD.doubleValue();
            angle -= tmpAngleStep;
        }
    }

    private void resizeText() {
        double maxWidth = 0.405 * this.size;
        this.valueText.setFont(Fonts.latoRegular(this.size * 0.22));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, this.size * 0.22);
        }
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setFont(Fonts.robotoCondensedRegular(this.size * 0.062));
        this.titleText.setText(this.gauge.getTitle());
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, this.size * 0.062);
        }
        this.titleText.setTranslateX((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        maxWidth = 0.28 * this.size;
        this.subTitleText.setFont(Fonts.robotoCondensedLight(this.size * 0.047));
        this.subTitleText.setText(this.gauge.getSubTitle());
        if (this.subTitleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.subTitleText, maxWidth, this.size * 0.047);
        }
        this.subTitleText.setTranslateX((this.size - this.subTitleText.getLayoutBounds().getWidth()) * 0.5);
        this.unitText.setFont(Fonts.robotoCondensedRegular(this.size * 0.047));
        this.unitText.setText(this.gauge.getUnit());
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, this.size * 0.047);
        }
        this.unitText.setTranslateX((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5);
    }

    private void placeTextVerticaly() {
        this.valueText.setTranslateY(this.size * 0.5);
        this.titleText.setTranslateY(this.size * 0.83);
        this.subTitleText.setTranslateY(this.size * 0.35);
        this.unitText.setTranslateY(this.size * 0.67);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.gauge.getWidth() - this.size) * 0.5, (this.gauge.getHeight() - this.size) * 0.5);
            this.background.setRadius(this.size * 0.5);
            this.background.setCenterX(this.size * 0.5);
            this.background.setCenterY(this.size * 0.5);
            this.mask.getElements().clear();
            this.mask.getElements().add((Object)new MoveTo(0.23333333333333334 * this.size, 0.5 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.23333333333333334 * this.size, 0.3525 * this.size, 0.3525 * this.size, 0.23333333333333334 * this.size, 0.5 * this.size, 0.23333333333333334 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.6475 * this.size, 0.23333333333333334 * this.size, 0.7666666666666667 * this.size, 0.3525 * this.size, 0.7666666666666667 * this.size, 0.5 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.7666666666666667 * this.size, 0.6475 * this.size, 0.6475 * this.size, 0.7666666666666667 * this.size, 0.5 * this.size, 0.7666666666666667 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.3525 * this.size, 0.7666666666666667 * this.size, 0.23333333333333334 * this.size, 0.6475 * this.size, 0.23333333333333334 * this.size, 0.5 * this.size));
            this.mask.getElements().add((Object)new ClosePath());
            this.mask.getElements().add((Object)new MoveTo(0.2 * this.size, 0.5 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.2 * this.size, 0.555 * this.size, 0.215 * this.size, 0.6058333333333333 * this.size, 0.24 * this.size, 0.65 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.24 * this.size, 0.65 * this.size, 0.12583333333333332 * this.size, 0.7166666666666667 * this.size, 0.12583333333333332 * this.size, 0.7166666666666667 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.205 * this.size, 0.8541666666666666 * this.size, 0.3408333333333333 * this.size, 0.9333333333333333 * this.size, 0.5 * this.size, 0.9333333333333333 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.6591666666666667 * this.size, 0.9333333333333333 * this.size, 0.795 * this.size, 0.8541666666666666 * this.size, 0.8741666666666666 * this.size, 0.7166666666666667 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.8741666666666666 * this.size, 0.7166666666666667 * this.size, 0.76 * this.size, 0.65 * this.size, 0.76 * this.size, 0.65 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.785 * this.size, 0.6058333333333333 * this.size, 0.8 * this.size, 0.555 * this.size, 0.8 * this.size, 0.5 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.8 * this.size, 0.33416666666666667 * this.size, 0.6658333333333334 * this.size, 0.2 * this.size, 0.5 * this.size, 0.2 * this.size));
            this.mask.getElements().add((Object)new CubicCurveTo(0.33416666666666667 * this.size, 0.2 * this.size, 0.2 * this.size, 0.33416666666666667 * this.size, 0.2 * this.size, 0.5 * this.size));
            this.mask.getElements().add((Object)new ClosePath());
            this.dropShadow4.setOffsetY(0.014 * this.size);
            this.dropShadow4.setRadius(0.014 * this.size);
            this.needleMoveTo1.setX(0.5008333333333334 * this.size);
            this.needleMoveTo1.setY(0.0775 * this.size);
            this.needleCubicCurveTo2.setControlX1(0.5008333333333334 * this.size);
            this.needleCubicCurveTo2.setControlY1(0.0775 * this.size);
            this.needleCubicCurveTo2.setControlX2(0.5416666666666666 * this.size);
            this.needleCubicCurveTo2.setControlY2(0.0025 * this.size);
            this.needleCubicCurveTo2.setX(0.5416666666666666 * this.size);
            this.needleCubicCurveTo2.setY(0.0025 * this.size);
            this.needleCubicCurveTo3.setControlX1(0.5125 * this.size);
            this.needleCubicCurveTo3.setControlY1(0.0);
            this.needleCubicCurveTo3.setControlX2(0.4875 * this.size);
            this.needleCubicCurveTo3.setControlY2(0.0);
            this.needleCubicCurveTo3.setX(0.4583333333333333 * this.size);
            this.needleCubicCurveTo3.setY(0.0025 * this.size);
            this.needleCubicCurveTo4.setControlX1(0.4583333333333333 * this.size);
            this.needleCubicCurveTo4.setControlY1(0.0025 * this.size);
            this.needleCubicCurveTo4.setControlX2(0.49833333333333335 * this.size);
            this.needleCubicCurveTo4.setControlY2(0.0775 * this.size);
            this.needleCubicCurveTo4.setX(0.49833333333333335 * this.size);
            this.needleCubicCurveTo4.setY(0.0775 * this.size);
            this.needleLineTo5.setX(0.49833333333333335 * this.size);
            this.needleLineTo5.setY(0.0775 * this.size);
            this.needleLineTo6.setX(0.49833333333333335 * this.size);
            this.needleLineTo6.setY(0.17916666666666667 * this.size);
            this.needleLineTo7.setX(0.5008333333333334 * this.size);
            this.needleLineTo7.setY(0.17916666666666667 * this.size);
            this.needleLineTo8.setX(0.5008333333333334 * this.size);
            this.needleLineTo8.setY(0.0775 * this.size);
            this.needle.relocate(this.needle.getLayoutBounds().getMinX(), this.needle.getLayoutBounds().getMinY());
            this.needleRotate.setPivotX(this.size * 0.5);
            this.needleRotate.setPivotY(this.size * 0.5);
            this.mainCanvas.setCache(false);
            this.mainCanvas.setWidth(this.size);
            this.mainCanvas.setHeight(this.size);
            this.drawMainCanvas();
            this.mainCanvas.setCache(true);
            this.mainCanvas.setCacheHint(CacheHint.QUALITY);
            this.tickMarkCanvas.setWidth(this.size);
            this.tickMarkCanvas.setHeight(this.size);
            this.highlightValue(this.tickMarkCtx, this.gauge.getValue());
            this.centerKnob.setRadius(0.22916667 * this.size);
            this.centerKnob.setCenterX(0.5 * this.size);
            this.centerKnob.setCenterY(0.5 * this.size);
            this.centerKnob.setFill((Paint)new LinearGradient(0.5 * this.size, 0.2708333333333333 * this.size, 0.5 * this.size, 0.7291666666666666 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)69, (int)70, (int)73)), new Stop(1.0, Color.rgb((int)31, (int)31, (int)31))}));
            this.centerKnob.setEffect((Effect)this.dropShadow4);
            this.glow1.setRadius(0.085 * this.size);
            this.glow2.setRadius(0.085 * this.size);
            this.bigGlow.setRadius(0.25 * this.size);
            this.resizeText();
            this.placeTextVerticaly();
        }
    }

    @Override
    protected void redraw() {
        this.sectionsVisible = this.gauge.getSectionsVisible();
        this.locale = this.gauge.getLocale();
        this.barColor = this.gauge.getBarColor();
        this.thresholdColor = this.gauge.getThresholdColor();
        this.needle.setFill((Paint)this.gauge.getNeedleColor());
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.subTitleText.setFill((Paint)this.gauge.getSubTitleColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.buttonTooltip.setText(this.gauge.getButtonTooltipText());
        this.mainCanvas.setCache(false);
        this.mainCanvas.setWidth(this.size);
        this.mainCanvas.setHeight(this.size);
        this.drawMainCanvas();
        this.mainCanvas.setCache(true);
        this.mainCanvas.setCacheHint(CacheHint.QUALITY);
        this.resizeText();
    }
}

