/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelOrientation;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class DigitalSkin
extends GaugeSkinBase {
    private static final double START_ANGLE = -30.0;
    private static final double ANGLE_RANGE = 300.0;
    private double size;
    private double center;
    private Pane pane;
    private Canvas backgroundCanvas;
    private GraphicsContext backgroundCtx;
    private Canvas barCanvas;
    private GraphicsContext barCtx;
    private Text valueBkgText;
    private Text valueText;
    private Color barColor;
    private Color valueColor;
    private Color titleColor;
    private Color subTitleColor;
    private Color unitColor;
    private double minValue;
    private double maxValue;
    private double range;
    private double angleStep;
    private boolean isStartFromZero;
    private double barWidth;
    private Locale locale;
    private boolean sectionsVisible;
    private List<Section> sections;
    private boolean thresholdVisible;
    private Color thresholdColor;
    private InvalidationListener currentValueListener;

    public DigitalSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.range = gauge.getRange();
        this.angleStep = 300.0 / this.range;
        this.locale = gauge.getLocale();
        this.barColor = gauge.getBarColor();
        this.valueColor = gauge.getValueColor();
        this.titleColor = gauge.getTitleColor();
        this.subTitleColor = gauge.getSubTitleColor();
        this.unitColor = gauge.getUnitColor();
        this.isStartFromZero = gauge.isStartFromZero();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.sections = gauge.getSections();
        this.thresholdVisible = gauge.isThresholdVisible();
        this.thresholdColor = gauge.getThresholdColor();
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.backgroundCanvas = new Canvas(250.0, 250.0);
        this.backgroundCtx = this.backgroundCanvas.getGraphicsContext2D();
        this.barCanvas = new Canvas(250.0, 250.0);
        this.barCtx = this.barCanvas.getGraphicsContext2D();
        this.valueBkgText = new Text();
        this.valueBkgText.setStroke(null);
        this.valueBkgText.setFill((Paint)Helper.getTranslucentColorFrom(this.valueColor, 0.1));
        this.valueText = new Text();
        this.valueText.setStroke(null);
        this.valueText.setFill((Paint)this.valueColor);
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.pane = new Pane(new Node[]{this.backgroundCanvas, this.barCanvas, this.valueBkgText, this.valueText});
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.gauge.getBorderWidth()))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.gauge.getMinValue();
            this.maxValue = this.gauge.getMaxValue();
            this.range = this.gauge.getRange();
            this.angleStep = 300.0 / this.range;
            this.redraw();
            this.setBar(this.gauge.getCurrentValue());
        } else if ("SECTIONS".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            this.sectionsVisible = this.gauge.getSectionsVisible();
            this.thresholdVisible = this.gauge.isThresholdVisible();
            this.thresholdVisible = this.gauge.isThresholdVisible();
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void setBar(double VALUE) {
        this.barCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.barCtx.setLineCap(StrokeLineCap.BUTT);
        this.barCtx.setStroke((Paint)this.barColor);
        this.barCtx.setLineWidth(this.barWidth);
        if (this.sectionsVisible) {
            int listSize = this.sections.size();
            for (int i = 0; i < listSize; ++i) {
                Section section = this.sections.get(i);
                if (!section.contains(VALUE)) continue;
                this.barCtx.setStroke((Paint)section.getColor());
                break;
            }
        }
        if (this.thresholdVisible && VALUE > this.gauge.getThreshold()) {
            this.barCtx.setStroke((Paint)this.thresholdColor);
        }
        double v = (VALUE - this.minValue) * this.angleStep;
        int minValueAngle = (int)(-this.minValue * this.angleStep);
        if (!this.isStartFromZero) {
            for (int i = 0; i < 300; ++i) {
                if (i % 6 != 0 || !((double)i < v)) continue;
                this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(-i - 125), 4.6, ArcType.OPEN);
            }
        } else if (Double.compare(VALUE, 0.0) != 0) {
            if (VALUE < 0.0) {
                for (int i = Math.min(minValueAngle, 300) - 1; i >= 0; --i) {
                    if (i % 6 != 0 || !((double)i > v - 6.0)) continue;
                    this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(-i - 125), 4.6, ArcType.OPEN);
                }
            } else {
                for (int i = Math.max(minValueAngle, 0) - 3; i < 300; ++i) {
                    if (i % 6 != 0 || !((double)i < v)) continue;
                    this.barCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(-i - 125), 4.6, ArcType.OPEN);
                }
            }
        }
        this.valueText.setText(Helper.formatNumber(this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.valueText.setLayoutX(this.valueBkgText.getLayoutBounds().getMaxX() - this.valueText.getLayoutBounds().getWidth());
    }

    private void drawBackground() {
        this.backgroundCanvas.setCache(false);
        double outerBarWidth = this.size * 0.006;
        this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
        this.backgroundCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.backgroundCtx.setStroke((Paint)Color.rgb((int)0, (int)12, (int)6, (double)0.1));
        Color bColor = Helper.getTranslucentColorFrom(this.barColor, 0.1);
        for (int i = -60; i < 240; ++i) {
            this.backgroundCtx.save();
            if (i % 6 == 0) {
                this.backgroundCtx.setStroke((Paint)bColor);
                this.backgroundCtx.setLineWidth(this.barWidth);
                this.backgroundCtx.strokeArc(this.barWidth * 0.5 + this.barWidth * 0.3, this.barWidth * 0.5 + this.barWidth * 0.3, this.size - this.barWidth - this.barWidth * 0.6, this.size - this.barWidth - this.barWidth * 0.6, (double)(i + 1), 4.6, ArcType.OPEN);
                this.backgroundCtx.setStroke((Paint)this.barColor);
                this.backgroundCtx.setLineWidth(outerBarWidth);
                this.backgroundCtx.strokeArc(outerBarWidth, outerBarWidth, this.size - 2.0 * outerBarWidth, this.size - 2.0 * outerBarWidth, (double)(i + 1), 4.6, ArcType.OPEN);
            }
            this.backgroundCtx.restore();
        }
        if (!this.gauge.getTitle().isEmpty()) {
            String title = this.gauge.getTitle();
            char[] bkgTitleChrs = new char[title.length()];
            Arrays.fill(bkgTitleChrs, '8');
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.titleColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digitalReadoutBold(0.09 * this.size));
            this.backgroundCtx.setTextBaseline(VPos.CENTER);
            this.backgroundCtx.setTextAlign(TextAlignment.CENTER);
            this.backgroundCtx.fillText(new String(bkgTitleChrs), this.center, this.size * 0.35, this.size * 0.55);
            this.backgroundCtx.setFill((Paint)this.titleColor);
            this.backgroundCtx.fillText(title, this.center, this.size * 0.35, this.size * 0.55);
        }
        if (!this.gauge.getSubTitle().isEmpty()) {
            String subTitle = this.gauge.getSubTitle();
            char[] bkgSubTitleChrs = new char[subTitle.length()];
            Arrays.fill(bkgSubTitleChrs, '8');
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.subTitleColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digital(0.09 * this.size));
            this.backgroundCtx.fillText(new String(bkgSubTitleChrs), this.center, this.size * 0.66);
            this.backgroundCtx.setFill((Paint)this.subTitleColor);
            this.backgroundCtx.fillText(subTitle, this.center, this.size * 0.66);
        }
        if (!this.gauge.getUnit().isEmpty()) {
            String unit = this.gauge.getUnit();
            char[] bkgUnitChrs = new char[unit.length()];
            Arrays.fill(bkgUnitChrs, '8');
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.unitColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digital(0.09 * this.size));
            this.backgroundCtx.fillText(new String(bkgUnitChrs), this.center, this.size * 0.88);
            this.backgroundCtx.setFill((Paint)this.unitColor);
            this.backgroundCtx.fillText(unit, this.center, this.size * 0.88);
        }
        this.drawTickMarks();
        this.backgroundCanvas.setCache(true);
        this.backgroundCanvas.setCacheHint(CacheHint.QUALITY);
        if (this.gauge.isValueVisible()) {
            int i;
            StringBuilder valueBkg = new StringBuilder();
            int len = String.valueOf((int)this.gauge.getMaxValue()).length();
            if (this.gauge.getMinValue() < 0.0) {
                ++len;
            }
            for (i = 0; i < len; ++i) {
                valueBkg.append("8");
            }
            if (this.gauge.getDecimals() > 0) {
                valueBkg.append(".");
                len = this.gauge.getDecimals();
                for (i = 0; i < len; ++i) {
                    valueBkg.append("8");
                }
            }
            this.valueBkgText.setText(valueBkg.toString());
            this.valueBkgText.setX((this.size - this.valueBkgText.getLayoutBounds().getWidth()) * 0.5);
        }
    }

    private void drawTickMarks() {
        double centerX = this.center;
        double centerY = this.center;
        int tickLabelDecimals = this.gauge.getTickLabelDecimals();
        String tickLabelFormatString = "%." + tickLabelDecimals + "f";
        double minorTickSpace = this.gauge.getMinorTickSpace();
        double tmpAngleStep = this.angleStep * minorTickSpace;
        BigDecimal minorTickSpaceBD = BigDecimal.valueOf(minorTickSpace);
        BigDecimal majorTickSpaceBD = BigDecimal.valueOf(this.gauge.getMajorTickSpace());
        BigDecimal counterBD = BigDecimal.valueOf(this.minValue);
        double counter = this.minValue;
        Color tickMarkColor = this.gauge.getTickMarkColor();
        Color majorTickMarkColor = this.gauge.getMajorTickMarkColor().equals((Object)tickMarkColor) ? tickMarkColor : this.gauge.getMajorTickMarkColor();
        Color tickLabelColor = this.gauge.getTickLabelColor();
        Color zeroColor = this.gauge.getZeroColor();
        boolean isNotZero = true;
        boolean majorTickMarksVisible = this.gauge.getMajorTickMarksVisible();
        boolean tickLabelsVisible = this.gauge.getTickLabelsVisible();
        boolean onlyFirstAndLastLabelVisible = this.gauge.isOnlyFirstAndLastTickLabelVisible();
        double customFontSizeFactor = this.gauge.getCustomTickLabelFontSize() / 400.0;
        boolean fullRange = this.minValue < 0.0 && this.maxValue > 0.0;
        double tickLabelOrientationFactor = 0.8;
        double tickLabelFontSize = tickLabelDecimals == 0 ? 0.051 * this.size : 0.048 * this.size;
        tickLabelFontSize = this.gauge.getCustomTickLabelsEnabled() ? customFontSizeFactor * this.size : tickLabelFontSize;
        Font tickLabelFont = Fonts.robotoCondensedRegular(tickLabelFontSize * tickLabelOrientationFactor);
        Font tickLabelZeroFont = fullRange ? Fonts.robotoCondensedBold(tickLabelFontSize * tickLabelOrientationFactor) : tickLabelFont;
        this.backgroundCtx.setStroke((Paint)tickMarkColor);
        this.backgroundCtx.strokeArc(0.0875 * this.size, 0.0875 * this.size, 0.825 * this.size, 0.825 * this.size, 300.0, 300.0, ArcType.OPEN);
        BigDecimal tmpStepBD = new BigDecimal(tmpAngleStep);
        tmpStepBD = tmpStepBD.setScale(3, 4);
        double tmpStep = tmpStepBD.doubleValue();
        double angle = 0.0;
        double i = 0.0;
        while (Double.compare(-300.0 - tmpStep, i) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + -30.0));
            double cosValue = Math.cos(Math.toRadians(angle + -30.0));
            double innerPointX = centerX + this.size * 0.395 * sinValue;
            double innerPointY = centerY + this.size * 0.395 * cosValue;
            double triangleOuterAngle1 = Math.toRadians(angle - 1.2 + -30.0);
            double triangleOuterAngle2 = Math.toRadians(angle + 1.2 + -30.0);
            double triangleOuterPoint1X = centerX + this.size * 0.4125 * Math.sin(triangleOuterAngle1);
            double triangleOuterPoint1Y = centerY + this.size * 0.4125 * Math.cos(triangleOuterAngle1);
            double triangleOuterPoint2X = centerX + this.size * 0.4125 * Math.sin(triangleOuterAngle2);
            double triangleOuterPoint2Y = centerY + this.size * 0.4125 * Math.cos(triangleOuterAngle2);
            double textPointX = centerX + this.size * 0.365 * sinValue;
            double textPointY = centerY + this.size * 0.365 * cosValue;
            this.backgroundCtx.setStroke((Paint)tickMarkColor);
            this.backgroundCtx.setFill((Paint)tickMarkColor);
            this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
            if (Double.compare(counterBD.remainder(majorTickSpaceBD).doubleValue(), 0.0) == 0) {
                boolean bl = isNotZero = Double.compare(0.0, counter) != 0;
                if (majorTickMarksVisible) {
                    this.backgroundCtx.setFill((Paint)majorTickMarkColor);
                    this.backgroundCtx.setStroke((Paint)majorTickMarkColor);
                    this.backgroundCtx.setLineWidth(this.size * 0.0055);
                    this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
                }
                if (fullRange && !isNotZero) {
                    this.backgroundCtx.setFill((Paint)zeroColor);
                    this.backgroundCtx.setStroke((Paint)zeroColor);
                }
                if (majorTickMarksVisible) {
                    Helper.drawTriangle(this.backgroundCtx, innerPointX, innerPointY, triangleOuterPoint1X, triangleOuterPoint1Y, triangleOuterPoint2X, triangleOuterPoint2Y);
                }
                if (tickLabelsVisible) {
                    this.backgroundCtx.save();
                    this.backgroundCtx.translate(textPointX, textPointY);
                    Helper.rotateContextForText(this.backgroundCtx, -30.0, angle, TickLabelOrientation.HORIZONTAL);
                    this.backgroundCtx.setFont(isNotZero ? tickLabelFont : tickLabelZeroFont);
                    this.backgroundCtx.setTextAlign(TextAlignment.CENTER);
                    this.backgroundCtx.setTextBaseline(VPos.CENTER);
                    if (!onlyFirstAndLastLabelVisible) {
                        if (isNotZero) {
                            this.backgroundCtx.setFill((Paint)tickLabelColor);
                        } else {
                            this.backgroundCtx.setFill((Paint)(fullRange ? zeroColor : tickLabelColor));
                        }
                    } else if (Double.compare(counter, this.minValue) == 0 || Double.compare(counter, this.maxValue) == 0) {
                        if (isNotZero) {
                            this.backgroundCtx.setFill((Paint)tickLabelColor);
                        } else {
                            this.backgroundCtx.setFill((Paint)(fullRange ? zeroColor : tickLabelColor));
                        }
                    } else {
                        this.backgroundCtx.setFill((Paint)Color.TRANSPARENT);
                    }
                    this.backgroundCtx.fillText(String.format(this.locale, tickLabelFormatString, counter), 0.0, 0.0);
                    this.backgroundCtx.restore();
                }
            }
            if ((counter = (counterBD = counterBD.add(minorTickSpaceBD)).doubleValue()) > this.maxValue) break;
            angle -= tmpAngleStep;
            i -= tmpStep;
        }
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        double d = this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.center = this.size * 0.5;
            this.barWidth = this.size * 0.06;
            this.backgroundCanvas.setWidth(this.size);
            this.backgroundCanvas.setHeight(this.size);
            this.barCanvas.setWidth(this.size);
            this.barCanvas.setHeight(this.size);
            this.valueBkgText.setFont(Fonts.digital(0.18 * this.size));
            this.valueBkgText.setY(this.center + this.valueBkgText.getLayoutBounds().getHeight() * 0.5);
            this.valueText.setFont(Fonts.digital(0.18 * this.size));
            this.valueText.setY(this.center + this.valueText.getLayoutBounds().getHeight() * 0.5);
            this.drawBackground();
            this.setBar(this.gauge.getCurrentValue());
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.locale = this.gauge.getLocale();
        this.barColor = this.gauge.getBarColor();
        this.valueColor = this.gauge.getValueColor();
        this.titleColor = this.gauge.getTitleColor();
        this.subTitleColor = this.gauge.getSubTitleColor();
        this.unitColor = this.gauge.getUnitColor();
        this.sectionsVisible = this.gauge.getSectionsVisible();
        this.drawBackground();
        this.setBar(this.gauge.getCurrentValue());
        this.valueBkgText.setFill((Paint)Helper.getTranslucentColorFrom(this.valueColor, 0.1));
        this.valueText.setFill((Paint)this.valueColor);
    }
}

