/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.ClockBuilder;
import eu.hansolo.medusa.FGauge;
import eu.hansolo.medusa.FGaugeBuilder;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.GaugeBuilder;
import eu.hansolo.medusa.GaugeDesign;
import eu.hansolo.medusa.LcdFont;
import eu.hansolo.medusa.Marker;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.TickLabelLocation;
import eu.hansolo.medusa.events.UpdateEvent;
import java.time.Instant;
import java.util.Locale;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private FGauge fgauge;
    private Gauge gauge;
    private Clock clock;
    private long lastTimerCall;
    private AnimationTimer timer;
    private DoubleProperty value;
    private long epochSeconds;
    private BooleanProperty toggle;

    public void init() {
        this.value = new SimpleDoubleProperty(0.0);
        this.toggle = new SimpleBooleanProperty(false);
        this.fgauge = ((FGaugeBuilder)FGaugeBuilder.create().gaugeDesign(GaugeDesign.NONE)).build();
        this.gauge = ((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)GaugeBuilder.create().skinType(Gauge.SkinType.DASHBOARD)).knobPosition(Pos.BOTTOM_LEFT)).tickLabelLocation(TickLabelLocation.OUTSIDE)).decimals(2)).minValue(-20.0)).maxValue(120.0)).startFromZero(true)).animated(true)).lcdVisible(true)).lcdFont(LcdFont.LCD)).title("Very Large Title")).unit("\u00b0C")).subTitle("Only")).sections(new Section(-20.0, 0.0, Color.rgb((int)0, (int)0, (int)255), Color.rgb((int)0, (int)0, (int)255)), new Section(0.0, 25.0, Color.rgb((int)255, (int)255, (int)0), Color.rgb((int)255, (int)255, (int)0)), new Section(75.0, 100.0, Color.rgb((int)255, (int)0, (int)0), Color.rgb((int)255, (int)255, (int)0)))).sectionsVisible(false)).highlightSections(true)).autoScale(true)).averagingEnabled(true)).averagingPeriod(10)).averageVisible(true)).markers(new Marker(0.0, "M1", Color.rgb((int)0, (int)0, (int)255, (double)0.95), Marker.MarkerType.DOT), new Marker(25.0, "M2", Color.rgb((int)255, (int)255, (int)0, (double)0.95), Marker.MarkerType.STANDARD), new Marker(50.0, "M3", Color.rgb((int)255, (int)255, (int)0, (double)0.95), Marker.MarkerType.TRIANGLE))).markersVisible(true)).ledVisible(true)).thresholdVisible(true)).threshold(40.0)).checkThreshold(true)).onThresholdExceeded((EventHandler<Gauge.ThresholdEvent>)((EventHandler)e -> this.gauge.setLedBlinking(true)))).onThresholdUnderrun((EventHandler<Gauge.ThresholdEvent>)((EventHandler)e -> this.gauge.setLedBlinking(false)))).build();
        this.gauge.valueProperty().bindBidirectional((Property)this.value);
        this.gauge.getSections().forEach(section -> section.setOnSectionUpdate((EventHandler<Section.SectionEvent>)((EventHandler)sectionEvent -> this.gauge.fireUpdateEvent(new UpdateEvent((Object)this, UpdateEvent.EventType.REDRAW)))));
        this.epochSeconds = Instant.now().getEpochSecond();
        this.clock = ((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().skinType(Clock.ClockSkinType.LCD)).locale(Locale.GERMANY)).shadowsEnabled(false)).running(true)).lcdFont(LcdFont.DIGITAL)).secondsVisible(true)).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){
            private int counter = 0;
            private boolean changed = false;

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 3000000000L) {
                    double v = Test.this.gauge.getRange() * (RND.nextDouble() * 1.3 - 0.15) + Test.this.gauge.getMinValue();
                    Test.this.value.set(v);
                    if (this.counter++ >= 1 && !this.changed) {
                        this.changed = true;
                        Test.this.clock.setSecondsVisible(false);
                        Test.this.gauge.setTitle("LONG TITLE");
                        System.out.println("*** CHANGED");
                    }
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.gauge});
        pane.setPadding(new Insets(20.0));
        pane.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        LinearGradient gradient = new LinearGradient(0.0, 0.0, 0.0, pane.getLayoutBounds().getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)38, (int)38, (int)38)), new Stop(1.0, Color.rgb((int)15, (int)15, (int)15))});
        Scene scene = new Scene((Parent)pane);
        scene.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
        stage.setTitle("Medusa");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    public void stop() {
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

